/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mspdi;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.UUID;
import org.mpxj.AccrueType;
import org.mpxj.BookingType;
import org.mpxj.ConstraintType;
import org.mpxj.CurrencySymbolPosition;
import org.mpxj.DataType;
import org.mpxj.Duration;
import org.mpxj.EarnedValueMethod;
import org.mpxj.FieldContainer;
import org.mpxj.FieldType;
import org.mpxj.Priority;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Rate;
import org.mpxj.Resource;
import org.mpxj.ResourceType;
import org.mpxj.TaskType;
import org.mpxj.TimeUnit;
import org.mpxj.TimeUnitDefaultsContainer;
import org.mpxj.WorkContour;
import org.mpxj.WorkGroup;
import org.mpxj.common.DayOfWeekHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.RateHelper;
import org.mpxj.common.XmlHelper;
import org.mpxj.mpp.MPPUtility;
import org.mpxj.mpp.TaskTypeHelper;
import org.mpxj.mpp.WorkContourHelper;
import org.mpxj.mspdi.MSPDIWriter;
import org.mpxj.mspdi.XsdDuration;

public final class DatatypeConverter {
    private static final DateTimeFormatter DATE_FORMAT = new DateTimeFormatterBuilder().parseLenient().appendPattern("yyyy-MM-dd'T'HH:mm:ss").toFormatter();
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final ThreadLocal<NumberFormat> NUMBER_FORMAT = ThreadLocal.withInitial(() -> {
        DecimalFormat format = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.US));
        format.setGroupingUsed(false);
        return format;
    });
    private static final ThreadLocal<NumberFormat> UNITS_NUMBER_FORMAT = ThreadLocal.withInitial(() -> {
        DecimalFormat format = new DecimalFormat("#.####", new DecimalFormatSymbols(Locale.US));
        format.setGroupingUsed(false);
        return format;
    });
    private static final ThreadLocal<NumberFormat> RATE_NUMBER_FORMAT = ThreadLocal.withInitial(() -> {
        DecimalFormat format = new DecimalFormat("#.####", new DecimalFormatSymbols(Locale.US));
        format.setGroupingUsed(false);
        return format;
    });
    private static final ThreadLocal<NumberFormat> CURRENCY_NUMBER_FORMAT = ThreadLocal.withInitial(() -> {
        DecimalFormat format = new DecimalFormat("#.####", new DecimalFormatSymbols(Locale.US));
        format.setGroupingUsed(false);
        return format;
    });
    private static final ThreadLocal<ProjectFile> PARENT_FILE = new ThreadLocal();
    private static final ThreadLocal<Boolean> IGNORE_ERRORS = new ThreadLocal();
    private static final BigDecimal BIGDECIMAL_ZERO = BigDecimal.valueOf(0L);
    private static final BigDecimal BIGDECIMAL_ONE = BigDecimal.valueOf(1L);

    public static final String printCustomFieldCurrency(Number value) {
        return value == null ? null : NUMBER_FORMAT.get().format(value.doubleValue() * 100.0);
    }

    public static final Number parseCustomFieldCurrency(String value) {
        Double result = value == null || value.isEmpty() ? null : NumberHelper.getDouble(Double.parseDouble(DatatypeConverter.correctNumberFormat(value)) / 100.0);
        return result;
    }

    public static final String printCustomFieldNumber(Number value) {
        return NUMBER_FORMAT.get().format(value.doubleValue());
    }

    public static final Number parseCustomFieldNumber(String value) {
        return Double.valueOf(DatatypeConverter.correctNumberFormat(value));
    }

    public static final String printCustomFieldBoolean(Boolean value) {
        return value != false ? "1" : "0";
    }

    public static final Boolean parseCustomFieldBoolean(String value) {
        return value.equals("1") ? Boolean.TRUE : Boolean.FALSE;
    }

    public static final String printCustomFieldDate(LocalDateTime value) {
        return value == null ? null : DATE_FORMAT.format(value);
    }

    public static final String printOutlineCodeValueDate(LocalDateTime value) {
        if (value == null) {
            return null;
        }
        long dateComponent = MPPUtility.EPOCH_DATE.until(value, ChronoUnit.DAYS) * 65536L;
        long timeComponent = value.toLocalTime().toSecondOfDay() / 6;
        return String.valueOf(dateComponent + timeComponent);
    }

    public static final LocalDateTime parseOutlineCodeValueDate(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        long rawValue = Long.parseLong(value);
        long days = rawValue / 65536L;
        long seconds = rawValue % 65536L * 6L;
        return MPPUtility.EPOCH_DATE.plusDays(days).plusSeconds(seconds);
    }

    public static final LocalDateTime parseCustomFieldDate(String value) {
        LocalDateTime result = null;
        if (value != null) {
            try {
                result = LocalDateTime.parse(value, DATE_FORMAT);
            }
            catch (DateTimeParseException ex) {
                if (IGNORE_ERRORS.get().booleanValue()) {
                    PARENT_FILE.get().addIgnoredError(ex);
                }
                throw ex;
            }
        }
        return result;
    }

    public static final String printCustomField(MSPDIWriter writer, Object value, DataType type) {
        String result = type == DataType.DATE ? DatatypeConverter.printCustomFieldDate((LocalDateTime)value) : (value instanceof Boolean ? DatatypeConverter.printCustomFieldBoolean((Boolean)value) : (value instanceof Duration ? DatatypeConverter.printDuration(writer, (Duration)value) : (type == DataType.CURRENCY ? DatatypeConverter.printCustomFieldCurrency((Number)value) : (value instanceof Number ? DatatypeConverter.printCustomFieldNumber((Number)value) : value.toString()))));
        return result;
    }

    public static final void parseCustomField(ProjectFile file, FieldContainer mpx, String value, FieldType mpxFieldID, TimeUnit durationFormat) {
        if (mpxFieldID != null) {
            switch (mpxFieldID.getDataType()) {
                case STRING: {
                    mpx.set(mpxFieldID, value);
                    break;
                }
                case DATE: {
                    mpx.set(mpxFieldID, DatatypeConverter.parseCustomFieldDate(value));
                    break;
                }
                case CURRENCY: {
                    mpx.set(mpxFieldID, DatatypeConverter.parseCustomFieldCurrency(value));
                    break;
                }
                case BOOLEAN: {
                    mpx.set(mpxFieldID, DatatypeConverter.parseCustomFieldBoolean(value));
                    break;
                }
                case NUMERIC: {
                    mpx.set(mpxFieldID, DatatypeConverter.parseCustomFieldNumber(value));
                    break;
                }
                case DURATION: {
                    mpx.set(mpxFieldID, DatatypeConverter.parseDuration(file, durationFormat, value));
                    break;
                }
            }
        }
    }

    public static final String printOutlineCodeValue(Object value, DataType type) {
        String result = type == DataType.DATE ? DatatypeConverter.printOutlineCodeValueDate((LocalDateTime)value) : (value instanceof Duration ? DatatypeConverter.printDurationInIntegerTenthsOfMinutes((Duration)value).toString() : (type == DataType.CURRENCY ? DatatypeConverter.printCustomFieldCurrency((Number)value) : (value instanceof Number ? DatatypeConverter.printCustomFieldNumber((Number)value) : value.toString())));
        return result;
    }

    public static final Object parseOutlineCodeValue(String value, DataType type) {
        Object result;
        switch (type) {
            case DATE: {
                result = DatatypeConverter.parseOutlineCodeValueDate(value);
                break;
            }
            case DURATION: {
                result = DatatypeConverter.parseDurationInIntegerTenthsOfMinutes(value);
                break;
            }
            case CURRENCY: {
                result = DatatypeConverter.parseCustomFieldCurrency(value);
                break;
            }
            case NUMERIC: {
                result = DatatypeConverter.parseCustomFieldNumber(value);
                break;
            }
            default: {
                result = value;
            }
        }
        return result;
    }

    public static final String printCurrencySymbolPosition(CurrencySymbolPosition value) {
        String result;
        switch (value) {
            case AFTER: {
                result = "1";
                break;
            }
            case BEFORE_WITH_SPACE: {
                result = "2";
                break;
            }
            case AFTER_WITH_SPACE: {
                result = "3";
                break;
            }
            default: {
                result = "0";
            }
        }
        return result;
    }

    public static final CurrencySymbolPosition parseCurrencySymbolPosition(String value) {
        CurrencySymbolPosition result = CurrencySymbolPosition.BEFORE;
        switch (NumberHelper.getInt(value)) {
            case 0: {
                result = CurrencySymbolPosition.BEFORE;
                break;
            }
            case 1: {
                result = CurrencySymbolPosition.AFTER;
                break;
            }
            case 2: {
                result = CurrencySymbolPosition.BEFORE_WITH_SPACE;
                break;
            }
            case 3: {
                result = CurrencySymbolPosition.AFTER_WITH_SPACE;
            }
        }
        return result;
    }

    public static final String printAccrueType(AccrueType value) {
        return Integer.toString(value == null ? AccrueType.PRORATED.getValue() : value.getValue());
    }

    public static final AccrueType parseAccrueType(String value) {
        return AccrueType.getInstance(NumberHelper.getInt(value));
    }

    public static final String printResourceType(ResourceType value) {
        return Integer.toString(value == null ? ResourceType.WORK.getValue() : value.getValue());
    }

    public static final ResourceType parseResourceType(String value) {
        return ResourceType.getInstance(NumberHelper.getInt(value));
    }

    public static final String printWorkGroup(WorkGroup value) {
        return Integer.toString(value == null ? WorkGroup.DEFAULT.getValue() : value.getValue());
    }

    public static final WorkGroup parseWorkGroup(String value) {
        return WorkGroup.getInstance(NumberHelper.getInt(value));
    }

    public static final String printWorkContour(WorkContour value) {
        Integer result = WorkContourHelper.getID(value);
        return (result == null ? WorkContourHelper.getID(WorkContour.FLAT) : result).toString();
    }

    public static final WorkContour parseWorkContour(String value) {
        return WorkContourHelper.getInstance(PARENT_FILE.get(), NumberHelper.getInt(value));
    }

    public static final String printBookingType(BookingType value) {
        return Integer.toString(value == null ? BookingType.COMMITTED.getValue() : value.getValue());
    }

    public static final BookingType parseBookingType(String value) {
        return BookingType.getInstance(NumberHelper.getInt(value));
    }

    public static final String printTaskType(TaskType value) {
        return Integer.toString(TaskTypeHelper.getValue(value));
    }

    public static final TaskType parseTaskType(String value) {
        return TaskTypeHelper.getInstance(NumberHelper.getInt(value));
    }

    public static final BigInteger printEarnedValueMethod(EarnedValueMethod value) {
        return value == null ? BigInteger.valueOf(EarnedValueMethod.PERCENT_COMPLETE.getValue()) : BigInteger.valueOf(value.getValue());
    }

    public static final EarnedValueMethod parseEarnedValueMethod(Number value) {
        return EarnedValueMethod.getInstance(NumberHelper.getInt(value));
    }

    public static final BigDecimal printUnits(Number value) {
        BigDecimal result = value == null ? BIGDECIMAL_ONE : new BigDecimal(UNITS_NUMBER_FORMAT.get().format(value.doubleValue() / 100.0));
        return result;
    }

    public static final Number parseUnits(Number value) {
        return value == null ? null : NumberHelper.getDouble(value.doubleValue() * 100.0);
    }

    public static final BigInteger printTimeUnit(TimeUnit value) {
        return BigInteger.valueOf(value == null ? (long)(TimeUnit.DAYS.getValue() + 1) : (long)(value.getValue() + 1));
    }

    public static final BigInteger printTimeUnit(Rate rate) {
        return DatatypeConverter.printTimeUnit(rate == null ? null : rate.getUnits());
    }

    public static final BigInteger printOvertimeRateFormat(Resource resource, Rate rate) {
        if (NumberHelper.getInt(resource.getUniqueID()) != 0 && resource.getType() != ResourceType.WORK) {
            return DatatypeConverter.printTimeUnit(TimeUnit.HOURS);
        }
        return DatatypeConverter.printTimeUnit(rate);
    }

    public static final BigInteger printStandardRateFormat(Resource resource, Rate rate) {
        if (NumberHelper.getInt(resource.getUniqueID()) != 0 && resource.getType() != ResourceType.WORK) {
            return DatatypeConverter.printTimeUnit(TimeUnit.ELAPSED_MINUTES);
        }
        return DatatypeConverter.printTimeUnit(rate);
    }

    public static final TimeUnit parseTimeUnit(Number value) {
        return TimeUnit.getInstance(NumberHelper.getInt(value) - 1);
    }

    public static final String printTime(LocalTime value) {
        String result = null;
        if (value != null) {
            result = TIME_FORMAT.format(value);
        }
        return result;
    }

    public static final TimeUnit parseWorkUnits(BigInteger value) {
        TimeUnit result = TimeUnit.HOURS;
        if (value != null) {
            switch (value.intValue()) {
                case 1: {
                    result = TimeUnit.MINUTES;
                    break;
                }
                case 3: {
                    result = TimeUnit.DAYS;
                    break;
                }
                case 4: {
                    result = TimeUnit.WEEKS;
                    break;
                }
                case 5: {
                    result = TimeUnit.MONTHS;
                    break;
                }
                case 7: {
                    result = TimeUnit.YEARS;
                    break;
                }
                default: {
                    result = TimeUnit.HOURS;
                }
            }
        }
        return result;
    }

    public static final BigInteger printWorkUnits(TimeUnit value) {
        int result;
        if (value == null) {
            value = TimeUnit.HOURS;
        }
        switch (value) {
            case MINUTES: {
                result = 1;
                break;
            }
            case DAYS: {
                result = 3;
                break;
            }
            case WEEKS: {
                result = 4;
                break;
            }
            case MONTHS: {
                result = 5;
                break;
            }
            case YEARS: {
                result = 7;
                break;
            }
            default: {
                result = 2;
            }
        }
        return BigInteger.valueOf(result);
    }

    public static final Duration parseDuration(ProjectFile file, TimeUnit defaultUnits, String value) {
        Duration result = null;
        XsdDuration xsd = null;
        if (value != null && !value.isEmpty()) {
            try {
                xsd = new XsdDuration(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (xsd != null) {
            TimeUnit units = TimeUnit.DAYS;
            if (xsd.getSeconds() != 0.0 || xsd.getMinutes() != 0L) {
                units = TimeUnit.MINUTES;
            }
            if (xsd.getHours() != 0L) {
                units = TimeUnit.HOURS;
            }
            if (xsd.getDays() != 0L) {
                units = TimeUnit.DAYS;
            }
            if (xsd.getMonths() != 0L) {
                units = TimeUnit.MONTHS;
            }
            if (xsd.getYears() != 0L) {
                units = TimeUnit.YEARS;
            }
            double duration = 0.0;
            switch (units) {
                case YEARS: {
                    duration += (double)xsd.getYears();
                    duration += (double)xsd.getMonths() / 12.0;
                    duration += (double)xsd.getDays() / 365.0;
                    duration += (double)xsd.getHours() / 8760.0;
                    duration += (double)xsd.getMinutes() / 525600.0;
                    duration += xsd.getSeconds() / 3.1536E7;
                    break;
                }
                case MONTHS: {
                    duration += (double)(xsd.getYears() * 12L);
                    duration += (double)xsd.getMonths();
                    duration += (double)xsd.getDays() / 30.0;
                    duration += (double)xsd.getHours() / 720.0;
                    duration += (double)xsd.getMinutes() / 43200.0;
                    duration += xsd.getSeconds() / 2592000.0;
                    break;
                }
                case DAYS: {
                    duration += (double)(xsd.getYears() * 365L);
                    duration += (double)(xsd.getMonths() * 30L);
                    duration += (double)xsd.getDays();
                    duration += (double)xsd.getHours() / 24.0;
                    duration += (double)xsd.getMinutes() / 1440.0;
                    duration += xsd.getSeconds() / 86400.0;
                    break;
                }
                case HOURS: {
                    duration += (double)(xsd.getYears() * 8760L);
                    duration += (double)(xsd.getMonths() * 720L);
                    duration += (double)(xsd.getDays() * 24L);
                    duration += (double)xsd.getHours();
                    duration += (double)xsd.getMinutes() / 60.0;
                    duration += xsd.getSeconds() / 3600.0;
                    break;
                }
                case MINUTES: 
                case ELAPSED_MINUTES: {
                    duration += (double)(xsd.getYears() * 525600L);
                    duration += (double)(xsd.getMonths() * 43200L);
                    duration += (double)(xsd.getDays() * 1440L);
                    duration += (double)(xsd.getHours() * 60L);
                    duration += (double)xsd.getMinutes();
                    duration += xsd.getSeconds() / 60.0;
                    break;
                }
            }
            ProjectProperties properties = file.getProjectProperties();
            if (defaultUnits == null) {
                defaultUnits = properties.getDefaultDurationUnits();
            }
            result = Duration.convertUnits(duration, units, defaultUnits, properties);
        }
        return result;
    }

    public static final String printDuration(MSPDIWriter writer, Duration duration) {
        String result = null;
        if (duration != null && duration.getDuration() != 0.0) {
            result = DatatypeConverter.printDurationMandatory(writer, duration);
        }
        return result;
    }

    public static final String printDurationMandatory(MSPDIWriter writer, Duration duration) {
        String result;
        if (duration == null) {
            result = "PT0H0M0S";
        } else {
            TimeUnit durationType = duration.getUnits();
            if (durationType != TimeUnit.HOURS && durationType != TimeUnit.ELAPSED_HOURS) {
                duration = duration.convertUnits(TimeUnit.HOURS, writer.getProjectFile().getProjectProperties());
            }
            result = new XsdDuration(duration).print(writer.getMicrosoftProjectCompatibleOutput());
        }
        return result;
    }

    public static final BigInteger printDurationTimeUnits(Duration duration, boolean estimated) {
        TimeUnit units = duration == null ? PARENT_FILE.get().getProjectProperties().getDefaultDurationUnits() : duration.getUnits();
        return DatatypeConverter.printDurationTimeUnits(units, estimated);
    }

    public static final Double parseCurrency(Number value) {
        return value == null ? null : NumberHelper.getDouble(value.doubleValue() / 100.0);
    }

    public static final BigDecimal printCurrency(Number value) {
        return value == null || value.doubleValue() == 0.0 ? null : DatatypeConverter.printCurrencyMandatory(value);
    }

    public static final BigDecimal printCurrencyMandatory(Number value) {
        BigDecimal result = value == null || value.doubleValue() == 0.0 ? BIGDECIMAL_ZERO : new BigDecimal(CURRENCY_NUMBER_FORMAT.get().format(value.doubleValue() * 100.0));
        return result;
    }

    public static final TimeUnit parseDurationTimeUnits(BigInteger value) {
        return DatatypeConverter.parseDurationTimeUnits(value, TimeUnit.HOURS);
    }

    public static final TimeUnit parseDurationTimeUnits(BigInteger value, TimeUnit defaultValue) {
        TimeUnit result = defaultValue;
        if (value != null) {
            switch (value.intValue()) {
                case 3: 
                case 35: {
                    result = TimeUnit.MINUTES;
                    break;
                }
                case 4: 
                case 36: {
                    result = TimeUnit.ELAPSED_MINUTES;
                    break;
                }
                case 5: 
                case 37: {
                    result = TimeUnit.HOURS;
                    break;
                }
                case 6: 
                case 38: {
                    result = TimeUnit.ELAPSED_HOURS;
                    break;
                }
                case 7: 
                case 39: 
                case 53: {
                    result = TimeUnit.DAYS;
                    break;
                }
                case 8: 
                case 40: {
                    result = TimeUnit.ELAPSED_DAYS;
                    break;
                }
                case 9: 
                case 41: {
                    result = TimeUnit.WEEKS;
                    break;
                }
                case 10: 
                case 42: {
                    result = TimeUnit.ELAPSED_WEEKS;
                    break;
                }
                case 11: 
                case 43: {
                    result = TimeUnit.MONTHS;
                    break;
                }
                case 12: 
                case 44: {
                    result = TimeUnit.ELAPSED_MONTHS;
                    break;
                }
                case 19: 
                case 51: {
                    result = TimeUnit.PERCENT;
                    break;
                }
                case 20: 
                case 52: {
                    result = TimeUnit.ELAPSED_PERCENT;
                    break;
                }
                default: {
                    result = PARENT_FILE.get().getProjectProperties().getDefaultDurationUnits();
                }
            }
        }
        return result;
    }

    public static final BigInteger printDurationTimeUnits(TimeUnit value, boolean estimated) {
        int result;
        if (value == null) {
            value = TimeUnit.HOURS;
        }
        switch (value) {
            case MINUTES: {
                result = estimated ? 35 : 3;
                break;
            }
            case ELAPSED_MINUTES: {
                result = estimated ? 36 : 4;
                break;
            }
            case ELAPSED_HOURS: {
                result = estimated ? 38 : 6;
                break;
            }
            case DAYS: {
                result = estimated ? 39 : 7;
                break;
            }
            case ELAPSED_DAYS: {
                result = estimated ? 40 : 8;
                break;
            }
            case WEEKS: {
                result = estimated ? 41 : 9;
                break;
            }
            case ELAPSED_WEEKS: {
                result = estimated ? 42 : 10;
                break;
            }
            case MONTHS: {
                result = estimated ? 43 : 11;
                break;
            }
            case ELAPSED_MONTHS: {
                result = estimated ? 44 : 12;
                break;
            }
            case PERCENT: {
                result = estimated ? 51 : 19;
                break;
            }
            case ELAPSED_PERCENT: {
                result = estimated ? 52 : 20;
                break;
            }
            default: {
                result = estimated ? 37 : 5;
            }
        }
        return BigInteger.valueOf(result);
    }

    public static final Priority parsePriority(BigInteger priority) {
        return priority == null ? null : Priority.getInstance(priority.intValue());
    }

    public static final BigInteger printPriority(Priority priority) {
        int result = 500;
        if (priority != null) {
            result = priority.getValue();
        }
        return BigInteger.valueOf(result);
    }

    public static final Duration parseDurationInThousanthsOfMinutes(Number value) {
        return DatatypeConverter.parseDurationInFractionsOfMinutes(null, value, TimeUnit.MINUTES, 1000);
    }

    public static final Duration parseDurationInTenthsOfMinutes(Number value) {
        return DatatypeConverter.parseDurationInFractionsOfMinutes(null, value, TimeUnit.MINUTES, 10);
    }

    public static final Duration parseDurationInThousanthsOfMinutes(ProjectProperties properties, Number value, TimeUnit targetTimeUnit) {
        return DatatypeConverter.parseDurationInFractionsOfMinutes(properties, value, targetTimeUnit, 1000);
    }

    public static final Duration parseDurationInTenthsOfMinutes(ProjectProperties properties, Number value, TimeUnit targetTimeUnit) {
        return DatatypeConverter.parseDurationInFractionsOfMinutes(properties, value, targetTimeUnit, 10);
    }

    public static final BigInteger printDurationInIntegerThousandthsOfMinutes(Duration duration) {
        BigInteger result = null;
        if (duration != null && duration.getDuration() != 0.0) {
            result = BigInteger.valueOf((long)DatatypeConverter.printDurationFractionsOfMinutes(duration, 1000));
        }
        return result;
    }

    public static final BigDecimal printDurationInDecimalThousandthsOfMinutes(Duration duration) {
        BigDecimal result = null;
        if (duration != null && duration.getDuration() != 0.0) {
            result = BigDecimal.valueOf((double)Math.round(DatatypeConverter.printDurationFractionsOfMinutes(duration, 1000) / 1000.0) * 1000.0);
        }
        return result;
    }

    public static final BigInteger printDurationInIntegerTenthsOfMinutes(Duration duration) {
        BigInteger result = null;
        if (duration != null && duration.getDuration() != 0.0) {
            result = BigInteger.valueOf((long)DatatypeConverter.printDurationFractionsOfMinutes(duration, 10));
        }
        return result;
    }

    public static final Duration parseDurationInIntegerTenthsOfMinutes(String value) {
        Duration result = null;
        if (value != null) {
            result = DatatypeConverter.parseDurationInTenthsOfMinutes(new BigInteger(value));
        }
        return result;
    }

    public static final UUID parseUUID(String value) {
        return value == null || value.isEmpty() ? null : UUID.fromString(value);
    }

    public static String printUUID(UUID guid) {
        return guid == null ? null : guid.toString().toUpperCase();
    }

    private static Duration parseDurationInFractionsOfMinutes(ProjectProperties properties, Number value, TimeUnit targetTimeUnit, int factor) {
        Duration result = null;
        if (value != null && targetTimeUnit != (result = Duration.getInstance(value.doubleValue() / (double)factor, TimeUnit.MINUTES)).getUnits()) {
            result = result.convertUnits(targetTimeUnit, properties);
        }
        return result;
    }

    private static double printDurationFractionsOfMinutes(Duration duration, int factor) {
        double result = 0.0;
        if (duration != null) {
            result = duration.getDuration();
            switch (duration.getUnits()) {
                case HOURS: 
                case ELAPSED_HOURS: {
                    result *= 60.0;
                    break;
                }
                case DAYS: {
                    result *= 480.0;
                    break;
                }
                case ELAPSED_DAYS: {
                    result *= 1440.0;
                    break;
                }
                case WEEKS: {
                    result *= 2400.0;
                    break;
                }
                case ELAPSED_WEEKS: {
                    result *= 10080.0;
                    break;
                }
                case MONTHS: {
                    result *= 9600.0;
                    break;
                }
                case ELAPSED_MONTHS: {
                    result *= 43200.0;
                    break;
                }
                case YEARS: {
                    result *= 124800.0;
                    break;
                }
                case ELAPSED_YEARS: {
                    result *= 525600.0;
                    break;
                }
            }
        }
        return result *= (double)factor;
    }

    public static final BigDecimal printRate(Rate rate) {
        return rate == null || rate.getAmount() == 0.0 ? null : DatatypeConverter.printRateMandatory(rate);
    }

    public static final BigDecimal printRateMandatory(Rate rate) {
        if (rate == null || rate.getAmount() == 0.0) {
            return BIGDECIMAL_ZERO;
        }
        return new BigDecimal(RATE_NUMBER_FORMAT.get().format(RateHelper.convertToHours(PARENT_FILE.get().getProjectProperties(), rate)));
    }

    public static final Rate parseRate(BigDecimal originalValue, TimeUnit targetUnits) {
        Rate result = null;
        if (originalValue != null) {
            if (targetUnits == TimeUnit.ELAPSED_MINUTES) {
                targetUnits = TimeUnit.HOURS;
            }
            result = RateHelper.convertFromHours((TimeUnitDefaultsContainer)PARENT_FILE.get().getProjectProperties(), originalValue, targetUnits);
        }
        return result;
    }

    public static final BigInteger printDay(DayOfWeek day) {
        return day == null ? null : BigInteger.valueOf(DayOfWeekHelper.getValue(day) - 1);
    }

    public static final DayOfWeek parseDay(Number value) {
        return DayOfWeekHelper.getInstance(NumberHelper.getInt(value) + 1);
    }

    public static final ConstraintType parseConstraintType(Number value) {
        return ConstraintType.getInstance(value);
    }

    public static final BigInteger printConstraintType(ConstraintType value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case START_ON: {
                value = ConstraintType.MUST_START_ON;
                break;
            }
            case FINISH_ON: {
                value = ConstraintType.MUST_FINISH_ON;
                break;
            }
        }
        return BigInteger.valueOf(value.getValue());
    }

    public static final String printTaskUID(Integer value) {
        ProjectFile file = PARENT_FILE.get();
        if (file != null) {
            file.getEventManager().fireTaskWrittenEvent(file.getTaskByUniqueID(value));
        }
        return value.toString();
    }

    public static final Integer parseTaskUID(String value) {
        return Integer.valueOf(value);
    }

    public static final String printResourceUID(Integer value) {
        ProjectFile file = PARENT_FILE.get();
        if (file != null) {
            file.getEventManager().fireResourceWrittenEvent(file.getResourceByUniqueID(value));
        }
        return value.toString();
    }

    public static final Integer parseResourceUID(String value) {
        return Integer.valueOf(value);
    }

    public static final String printBoolean(Boolean value) {
        return value == null || value == false ? "0" : "1";
    }

    public static final Boolean parseBoolean(String value) {
        return value == null || value.charAt(0) != '1' ? Boolean.FALSE : Boolean.TRUE;
    }

    public static final LocalTime parseTime(String value) {
        LocalTime result = null;
        if (value != null && !value.isEmpty()) {
            try {
                if (value.equals("24:00:00")) {
                    value = "00:00:00";
                }
                result = LocalTime.parse(value, TIME_FORMAT);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return result;
    }

    public static final String printDateTime(LocalDateTime value) {
        return value == null ? null : DATE_FORMAT.format(value);
    }

    public static final LocalDateTime parseDateTime(String value) {
        LocalDateTime result = null;
        if (value != null && !value.isEmpty()) {
            try {
                result = LocalDateTime.from(DATE_FORMAT.parse((CharSequence)value, new ParsePosition(0)));
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return result;
    }

    public static final String printString(String value) {
        return XmlHelper.replaceInvalidXmlChars(value);
    }

    public static final String parseString(String value) {
        return value;
    }

    public static final Number parsePercentComplete(String value) {
        Number result = value.contains(".") ? (Number)Double.valueOf(value) : (Number)Integer.valueOf(value);
        return result;
    }

    public static final String printPercentComplete(Number value) {
        return Integer.toString((int)Math.round(value.doubleValue()));
    }

    public static final void setContext(ProjectFile file, boolean ignoreErrors) {
        PARENT_FILE.set(file);
        IGNORE_ERRORS.set(ignoreErrors);
    }

    private static String correctNumberFormat(String value) {
        String result;
        int index = value.indexOf(44);
        if (index == -1) {
            result = value;
        } else {
            char[] chars = value.toCharArray();
            chars[index] = 46;
            result = new String(chars);
        }
        return result;
    }
}

