/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mspdi;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.mpxj.Availability;
import org.mpxj.AvailabilityTable;
import org.mpxj.CalendarType;
import org.mpxj.ChildTaskContainer;
import org.mpxj.CostRateTable;
import org.mpxj.CostRateTableEntry;
import org.mpxj.CustomField;
import org.mpxj.CustomFieldLookupTable;
import org.mpxj.CustomFieldValueDataType;
import org.mpxj.CustomFieldValueMask;
import org.mpxj.DayType;
import org.mpxj.Duration;
import org.mpxj.EventManager;
import org.mpxj.FieldType;
import org.mpxj.HasCharset;
import org.mpxj.LocalDateRange;
import org.mpxj.LocalTimeRange;
import org.mpxj.MPXJException;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectCalendarWeek;
import org.mpxj.ProjectConfig;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Rate;
import org.mpxj.RecurrenceType;
import org.mpxj.RecurringData;
import org.mpxj.Relation;
import org.mpxj.RelationType;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceType;
import org.mpxj.ScheduleFrom;
import org.mpxj.Task;
import org.mpxj.TaskField;
import org.mpxj.TaskMode;
import org.mpxj.TimePeriodEntity;
import org.mpxj.TimeUnit;
import org.mpxj.TimephasedCost;
import org.mpxj.TimephasedCostContainer;
import org.mpxj.TimephasedItem;
import org.mpxj.TimephasedWork;
import org.mpxj.TimephasedWorkContainer;
import org.mpxj.UserDefinedField;
import org.mpxj.common.BooleanHelper;
import org.mpxj.common.CharsetHelper;
import org.mpxj.common.DayOfWeekHelper;
import org.mpxj.common.DefaultTimephasedCostContainer;
import org.mpxj.common.DefaultTimephasedWorkContainer;
import org.mpxj.common.FieldTypeHelper;
import org.mpxj.common.LocalDateHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.ObjectSequence;
import org.mpxj.common.Pair;
import org.mpxj.common.SplitTaskFactory;
import org.mpxj.common.UnmarshalHelper;
import org.mpxj.mpp.CustomFieldValueItem;
import org.mpxj.mpp.MPPTimephasedBaselineCostNormaliser;
import org.mpxj.mspdi.DatatypeConverter;
import org.mpxj.mspdi.MSPDITimephasedWorkNormaliser;
import org.mpxj.mspdi.NamespaceFilter;
import org.mpxj.mspdi.schema.Project;
import org.mpxj.mspdi.schema.TimephasedDataType;
import org.mpxj.reader.AbstractProjectStreamReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class MSPDIReader
extends AbstractProjectStreamReader
implements HasCharset {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private boolean m_compatibleInput = true;
    private boolean m_ignoreErrors = true;
    private Charset m_charset = CharsetHelper.UTF8;
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private Map<UUID, FieldType> m_lookupTableMap;
    private Map<FieldType, Map<BigInteger, CustomFieldValueItem>> m_customFieldValueItems;
    private Map<Task, Project> m_externalProjects;
    private static final RecurrenceType[] RECURRENCE_TYPES;
    private static final boolean[] RELATIVE_MAP;
    private static final int[] DAY_MASKS;
    private static final Map<Integer, TimephasedWorkAssignmentFunction> TIMEPHASED_BASELINE_WORK_MAP;
    private static final Map<Integer, TimephasedCostAssignmentFunction> TIMEPHASED_BASELINE_COST_MAP;

    @Override
    public void setCharset(Charset charset) {
        this.m_charset = charset;
    }

    @Override
    public Charset getCharset() {
        return this.m_charset;
    }

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            ProjectFile projectFile = new ProjectFile();
            DatatypeConverter.setContext(projectFile, this.m_ignoreErrors);
            Project project = (Project)((JAXBElement)UnmarshalHelper.unmarshal(CONTEXT, new InputSource(new InputStreamReader(stream, this.getCharset())), new NamespaceFilter(), !this.m_compatibleInput)).getValue();
            this.read(projectFile, project);
            return projectFile;
        }
        catch (JAXBException | IOException | ParserConfigurationException | SAXException ex) {
            throw new MPXJException("Failed to parse file", (Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(ProjectFile projectFile, Project project) {
        try {
            this.m_projectFile = projectFile;
            this.m_eventManager = this.m_projectFile.getEventManager();
            this.m_lookupTableMap = new HashMap<UUID, FieldType>();
            this.m_customFieldValueItems = new HashMap<FieldType, Map<BigInteger, CustomFieldValueItem>>();
            this.m_externalProjects = new HashMap<Task, Project>();
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoTaskID(false);
            config.setAutoTaskUniqueID(false);
            config.setAutoResourceID(false);
            config.setAutoResourceUniqueID(false);
            config.setAutoOutlineLevel(false);
            config.setAutoOutlineNumber(false);
            config.setAutoWBS(false);
            config.setAutoCalendarUniqueID(false);
            config.setAutoAssignmentUniqueID(false);
            this.addListenersToProject(this.m_projectFile);
            HashMap<BigInteger, ProjectCalendar> calendarMap = new HashMap<BigInteger, ProjectCalendar>();
            this.readProjectProperties(project);
            this.readExtendedAttributeDefinitions(project);
            this.readOutlineCodeDefinitions(project);
            this.readCalendars(project, calendarMap);
            this.readResources(project, calendarMap);
            this.readTasks(project);
            this.readAssignments(project);
            Map<Integer, List<Resource>> resourceCalendarMap = projectFile.getResources().stream().filter(r -> r.getCalendarUniqueID() != null).collect(Collectors.groupingBy(Resource::getCalendarUniqueID));
            HashSet<Integer> calendarReferences = new HashSet<Integer>();
            calendarReferences.add(projectFile.getProjectProperties().getDefaultCalendarUniqueID());
            projectFile.getCalendars().stream().map(ProjectCalendar::getParentUniqueID).filter(Objects::nonNull).forEach(calendarReferences::add);
            projectFile.getTasks().stream().map(Task::getCalendarUniqueID).filter(Objects::nonNull).forEach(calendarReferences::add);
            calendarReferences.addAll(resourceCalendarMap.keySet());
            this.m_projectFile.getCalendars().removeIf(c -> c.isDerived() && !calendarReferences.contains(c.getUniqueID()));
            for (Resource resource : this.m_projectFile.getResources()) {
                ProjectCalendar calendar = resource.getCalendar();
                if (calendar == null) continue;
                if (calendar.isDerived()) {
                    calendar.setType(CalendarType.RESOURCE);
                    calendar.setPersonal(resourceCalendarMap.computeIfAbsent(calendar.getUniqueID(), k -> Collections.emptyList()).size() == 1);
                }
                if (calendar.getName() != null && !calendar.getName().isEmpty()) continue;
                String name = resource.getName();
                if (name == null || name.isEmpty()) {
                    name = "Unnamed Resource";
                }
                calendar.setName(name);
            }
            this.m_projectFile.readComplete();
            for (Map.Entry entry : this.m_externalProjects.entrySet()) {
                MSPDIReader reader = new MSPDIReader();
                ProjectFile file = new ProjectFile();
                reader.read(file, (Project)entry.getValue());
                ((Task)entry.getKey()).setSubprojectObject(file);
            }
        }
        finally {
            this.m_projectFile = null;
            this.m_lookupTableMap = null;
            this.m_customFieldValueItems = null;
            this.m_externalProjects = null;
        }
    }

    private void readProjectProperties(Project project) {
        ProjectProperties properties = this.m_projectFile.getProjectProperties();
        properties.setActualsInSync(BooleanHelper.getBoolean(project.isActualsInSync()));
        properties.setAdminProject(BooleanHelper.getBoolean(project.isAdminProject()));
        properties.setApplicationVersion(NumberHelper.getInteger(project.getSaveVersion()));
        properties.setAuthor(project.getAuthor());
        properties.setAutoAddNewResourcesAndTasks(BooleanHelper.getBoolean(project.isAutoAddNewResourcesAndTasks()));
        properties.setAutolink(BooleanHelper.getBoolean(project.isAutolink()));
        properties.setBaselineCalendarName(project.getBaselineCalendar());
        properties.setBaselineForEarnedValue(NumberHelper.getInteger(project.getBaselineForEarnedValue()));
        properties.setCategory(project.getCategory());
        properties.setCompany(project.getCompany());
        properties.setCreationDate(project.getCreationDate());
        properties.setCriticalSlackLimit(Duration.getInstance(NumberHelper.getInt(project.getCriticalSlackLimit()), TimeUnit.DAYS));
        properties.setCurrencyDigits(NumberHelper.getInteger(project.getCurrencyDigits()));
        properties.setCurrencyCode(project.getCurrencyCode());
        properties.setCurrencySymbol(project.getCurrencySymbol());
        properties.setCurrentDate(project.getCurrentDate());
        properties.setDaysPerMonth(NumberHelper.getInteger(project.getDaysPerMonth()));
        properties.setDefaultDurationUnits(DatatypeConverter.parseDurationTimeUnits(project.getDurationFormat()));
        properties.setDefaultEndTime(project.getDefaultFinishTime());
        properties.setDefaultFixedCostAccrual(project.getDefaultFixedCostAccrual());
        properties.setDefaultOvertimeRate(DatatypeConverter.parseRate(project.getDefaultOvertimeRate(), TimeUnit.HOURS));
        properties.setDefaultStandardRate(DatatypeConverter.parseRate(project.getDefaultStandardRate(), TimeUnit.HOURS));
        properties.setDefaultStartTime(project.getDefaultStartTime());
        properties.setDefaultTaskEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(project.getDefaultTaskEVMethod()));
        properties.setDefaultTaskType(project.getDefaultTaskType());
        properties.setDefaultWorkUnits(DatatypeConverter.parseWorkUnits(project.getWorkFormat()));
        properties.setEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(project.getEarnedValueMethod()));
        properties.setEditableActualCosts(BooleanHelper.getBoolean(project.isEditableActualCosts()));
        properties.setExtendedCreationDate(project.getExtendedCreationDate());
        properties.setFinishDate(project.getFinishDate());
        properties.setFiscalYearStart(BooleanHelper.getBoolean(project.isFiscalYearStart()));
        properties.setFiscalYearStartMonth(NumberHelper.getInteger(project.getFYStartDate()));
        properties.setGUID(project.getGUID());
        properties.setHonorConstraints(BooleanHelper.getBoolean(project.isHonorConstraints()));
        properties.setInsertedProjectsLikeSummary(BooleanHelper.getBoolean(project.isInsertedProjectsLikeSummary()));
        properties.setLastSaved(project.getLastSaved());
        properties.setManager(project.getManager());
        properties.setMicrosoftProjectServerURL(BooleanHelper.getBoolean(project.isMicrosoftProjectServerURL()));
        properties.setMinutesPerDay(NumberHelper.getInteger(project.getMinutesPerDay()));
        properties.setMinutesPerWeek(NumberHelper.getInteger(project.getMinutesPerWeek()));
        properties.setMoveCompletedEndsBack(BooleanHelper.getBoolean(project.isMoveCompletedEndsBack()));
        properties.setMoveCompletedEndsForward(BooleanHelper.getBoolean(project.isMoveCompletedEndsForward()));
        properties.setMoveRemainingStartsBack(BooleanHelper.getBoolean(project.isMoveRemainingStartsBack()));
        properties.setMoveRemainingStartsForward(BooleanHelper.getBoolean(project.isMoveRemainingStartsForward()));
        properties.setMultipleCriticalPaths(BooleanHelper.getBoolean(project.isMultipleCriticalPaths()));
        properties.setName(project.getName());
        properties.setNewTasksEffortDriven(BooleanHelper.getBoolean(project.isNewTasksEffortDriven()));
        properties.setNewTasksEstimated(BooleanHelper.getBoolean(project.isNewTasksEstimated()));
        properties.setNewTaskStartIsProjectStart(NumberHelper.getInt(project.getNewTaskStartDate()) == 0);
        properties.setNewTasksAreManual(BooleanHelper.getBoolean(project.isNewTasksAreManual()));
        properties.setProjectExternallyEdited(BooleanHelper.getBoolean(project.isProjectExternallyEdited()));
        properties.setProjectTitle(project.getTitle());
        properties.setRemoveFileProperties(BooleanHelper.getBoolean(project.isRemoveFileProperties()));
        properties.setRevision(NumberHelper.getInteger(project.getRevision()));
        properties.setScheduleFrom(BooleanHelper.getBoolean(project.isScheduleFromStart()) ? ScheduleFrom.START : ScheduleFrom.FINISH);
        properties.setSubject(project.getSubject());
        properties.setSplitInProgressTasks(BooleanHelper.getBoolean(project.isSplitsInProgressTasks()));
        properties.setSpreadActualCost(BooleanHelper.getBoolean(project.isSpreadActualCost()));
        properties.setSpreadPercentComplete(BooleanHelper.getBoolean(project.isSpreadPercentComplete()));
        properties.setStartDate(project.getStartDate());
        properties.setStatusDate(project.getStatusDate());
        properties.setSymbolPosition(project.getCurrencySymbolPosition());
        properties.setUpdatingTaskStatusUpdatesResourceStatus(BooleanHelper.getBoolean(project.isTaskUpdatesResource()));
        properties.setWeekStartDay(DatatypeConverter.parseDay(project.getWeekStartDay()));
        this.updateScheduleSource(properties);
    }

    private void updateScheduleSource(ProjectProperties properties) {
        if (properties.getCompany() != null && properties.getCompany().equals("Synchro Software Ltd")) {
            properties.setFileApplication("Synchro");
        } else if (properties.getAuthor() != null && properties.getAuthor().equals("SG Project")) {
            properties.setFileApplication("Simple Genius");
        } else {
            properties.setFileApplication("Microsoft");
        }
        properties.setFileType("MSPDI");
    }

    private void readCalendars(Project project, HashMap<BigInteger, ProjectCalendar> map) {
        ProjectCalendar defaultCalendar;
        Project.Calendars calendars = project.getCalendars();
        if (calendars != null) {
            ArrayList<Pair<ProjectCalendar, BigInteger>> baseCalendars = new ArrayList<Pair<ProjectCalendar, BigInteger>>();
            for (Project.Calendars.Calendar cal : calendars.getCalendar()) {
                this.readCalendar(cal, map, baseCalendars);
            }
            MSPDIReader.updateBaseCalendarNames(baseCalendars, map);
        }
        if ((defaultCalendar = map.get(project.getCalendarUID())) == null) {
            defaultCalendar = this.m_projectFile.getCalendars().findOrCreateDefaultCalendar();
        }
        this.m_projectFile.setDefaultCalendar(defaultCalendar);
    }

    private static void updateBaseCalendarNames(List<Pair<ProjectCalendar, BigInteger>> baseCalendars, HashMap<BigInteger, ProjectCalendar> map) {
        for (Pair<ProjectCalendar, BigInteger> pair : baseCalendars) {
            ProjectCalendar cal = pair.getFirst();
            BigInteger baseCalendarID = pair.getSecond();
            ProjectCalendar baseCal = map.get(baseCalendarID);
            if (baseCal == null) continue;
            cal.setParent(baseCal);
        }
    }

    private void readCalendar(Project.Calendars.Calendar calendar, HashMap<BigInteger, ProjectCalendar> map, List<Pair<ProjectCalendar, BigInteger>> baseCalendars) {
        ProjectCalendar bc = this.m_projectFile.addCalendar();
        bc.setUniqueID(NumberHelper.getInteger(calendar.getUID()));
        bc.setGUID(calendar.getGUID());
        bc.setName(calendar.getName());
        BigInteger baseCalendarID = calendar.getBaseCalendarUID();
        if (baseCalendarID != null) {
            baseCalendars.add(new Pair<ProjectCalendar, BigInteger>(bc, baseCalendarID));
        }
        this.readExceptions(calendar, bc);
        boolean readExceptionsFromDays = bc.getCalendarExceptions().isEmpty();
        Project.Calendars.Calendar.WeekDays days = calendar.getWeekDays();
        if (days != null) {
            for (Project.Calendars.Calendar.WeekDays.WeekDay weekDay : days.getWeekDay()) {
                this.readDay(bc, weekDay, readExceptionsFromDays);
            }
        } else {
            bc.setCalendarDayType(DayOfWeek.SUNDAY, DayType.DEFAULT);
            bc.setCalendarDayType(DayOfWeek.MONDAY, DayType.DEFAULT);
            bc.setCalendarDayType(DayOfWeek.TUESDAY, DayType.DEFAULT);
            bc.setCalendarDayType(DayOfWeek.WEDNESDAY, DayType.DEFAULT);
            bc.setCalendarDayType(DayOfWeek.THURSDAY, DayType.DEFAULT);
            bc.setCalendarDayType(DayOfWeek.FRIDAY, DayType.DEFAULT);
            bc.setCalendarDayType(DayOfWeek.SATURDAY, DayType.DEFAULT);
        }
        this.readWorkWeeks(calendar, bc);
        map.put(calendar.getUID(), bc);
        this.m_eventManager.fireCalendarReadEvent(bc);
    }

    private void readDay(ProjectCalendar calendar, Project.Calendars.Calendar.WeekDays.WeekDay day, boolean readExceptionsFromDays) {
        BigInteger dayType = day.getDayType();
        if (dayType != null) {
            if (dayType.intValue() == 0) {
                if (readExceptionsFromDays) {
                    this.readExceptionDay(calendar, day);
                }
            } else {
                this.readNormalDay(calendar, day);
            }
        }
    }

    private void readNormalDay(ProjectCalendar calendar, Project.Calendars.Calendar.WeekDays.WeekDay weekDay) {
        int dayNumber = weekDay.getDayType().intValue();
        DayOfWeek day = DayOfWeekHelper.getInstance(dayNumber);
        calendar.setWorkingDay(day, BooleanHelper.getBoolean(weekDay.isDayWorking()));
        ProjectCalendarHours hours = calendar.addCalendarHours(day);
        Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes times = weekDay.getWorkingTimes();
        if (times != null) {
            for (Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime period : times.getWorkingTime()) {
                LocalTime startTime = period.getFromTime();
                LocalTime endTime = period.getToTime();
                if (startTime == null || endTime == null) continue;
                hours.add(new LocalTimeRange(startTime, endTime));
            }
        }
    }

    private void readExceptionDay(ProjectCalendar calendar, Project.Calendars.Calendar.WeekDays.WeekDay day) {
        Project.Calendars.Calendar.WeekDays.WeekDay.TimePeriod timePeriod = day.getTimePeriod();
        LocalDate fromDate = LocalDateHelper.getLocalDate(timePeriod.getFromDate());
        LocalDate toDate = LocalDateHelper.getLocalDate(timePeriod.getToDate());
        Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes times = day.getWorkingTimes();
        ProjectCalendarException exception = calendar.addCalendarException(fromDate, toDate);
        if (times != null) {
            List<Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime> time = times.getWorkingTime();
            for (Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime period : time) {
                LocalTime startTime = period.getFromTime();
                LocalTime endTime = period.getToTime();
                if (startTime == null || endTime == null) continue;
                exception.add(new LocalTimeRange(startTime, endTime));
            }
        }
    }

    private void readExceptions(Project.Calendars.Calendar calendar, ProjectCalendar bc) {
        Project.Calendars.Calendar.Exceptions exceptions = calendar.getExceptions();
        if (exceptions != null) {
            for (Project.Calendars.Calendar.Exceptions.Exception exception : exceptions.getException()) {
                this.readException(bc, exception);
            }
        }
    }

    private void readException(ProjectCalendar bc, Project.Calendars.Calendar.Exceptions.Exception exception) {
        LocalDate fromDate = LocalDateHelper.getLocalDate(exception.getTimePeriod().getFromDate());
        LocalDate toDate = LocalDateHelper.getLocalDate(exception.getTimePeriod().getToDate());
        if (fromDate == null && toDate == null) {
            return;
        }
        RecurringData recurringData = this.readRecurringData(exception, fromDate, toDate);
        if (recurringData != null && !recurringData.isValid()) {
            return;
        }
        ProjectCalendarException bce = recurringData == null ? bc.addCalendarException(fromDate, toDate) : bc.addCalendarException(recurringData);
        bce.setName(exception.getName());
        Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes times = exception.getWorkingTimes();
        if (times != null) {
            List<Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes.WorkingTime> time = times.getWorkingTime();
            for (Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes.WorkingTime period : time) {
                LocalTime startTime = period.getFromTime();
                LocalTime endTime = period.getToTime();
                if (startTime == null || endTime == null) continue;
                bce.add(new LocalTimeRange(startTime, endTime));
            }
        }
    }

    private RecurringData readRecurringData(Project.Calendars.Calendar.Exceptions.Exception exception, LocalDate fromDate, LocalDate toDate) {
        RecurringData rd = null;
        RecurrenceType rt = this.getRecurrenceType(NumberHelper.getInt(exception.getType()));
        if (rt != null) {
            rd = new RecurringData();
            rd.setStartDate(fromDate);
            rd.setFinishDate(toDate);
            rd.setRecurrenceType(rt);
            rd.setRelative(this.getRelative(NumberHelper.getInt(exception.getType())));
            rd.setOccurrences(NumberHelper.getInteger(exception.getOccurrences()));
            switch (rd.getRecurrenceType()) {
                case DAILY: {
                    rd.setFrequency(this.getFrequency(exception));
                    break;
                }
                case WEEKLY: {
                    rd.setWeeklyDaysFromBitmap(NumberHelper.getInteger(exception.getDaysOfWeek()), DAY_MASKS);
                    rd.setFrequency(this.getFrequency(exception));
                    break;
                }
                case MONTHLY: {
                    if (rd.getRelative()) {
                        rd.setDayOfWeek(DayOfWeekHelper.getInstance(NumberHelper.getInt(exception.getMonthItem()) - 2));
                        rd.setDayNumber(NumberHelper.getInt(exception.getMonthPosition()) + 1);
                    } else {
                        rd.setDayNumber(NumberHelper.getInteger(exception.getMonthDay()));
                    }
                    rd.setFrequency(this.getFrequency(exception));
                    break;
                }
                case YEARLY: {
                    if (rd.getRelative()) {
                        rd.setDayOfWeek(DayOfWeekHelper.getInstance(NumberHelper.getInt(exception.getMonthItem()) - 2));
                        rd.setDayNumber(NumberHelper.getInt(exception.getMonthPosition()) + 1);
                    } else {
                        rd.setDayNumber(NumberHelper.getInteger(exception.getMonthDay()));
                    }
                    rd.setMonthNumber(NumberHelper.getInt(exception.getMonth()) + 1);
                }
            }
            if (rd.getRecurrenceType() == RecurrenceType.DAILY && NumberHelper.getInt(rd.getFrequency()) == 1) {
                rd = null;
            }
        }
        return rd;
    }

    private RecurrenceType getRecurrenceType(int value) {
        RecurrenceType result = value < 0 || value >= RECURRENCE_TYPES.length ? null : RECURRENCE_TYPES[value];
        return result;
    }

    private boolean getRelative(int value) {
        boolean result = value < 0 || value >= RELATIVE_MAP.length ? false : RELATIVE_MAP[value];
        return result;
    }

    private Integer getFrequency(Project.Calendars.Calendar.Exceptions.Exception exception) {
        Integer period = NumberHelper.getInteger(exception.getPeriod());
        if (period == null) {
            period = 1;
        }
        return period;
    }

    private void readWorkWeeks(Project.Calendars.Calendar xmlCalendar, ProjectCalendar mpxjCalendar) {
        Project.Calendars.Calendar.WorkWeeks ww = xmlCalendar.getWorkWeeks();
        if (ww != null) {
            for (Project.Calendars.Calendar.WorkWeeks.WorkWeek xmlWeek : ww.getWorkWeek()) {
                this.readWorkWeek(mpxjCalendar, xmlWeek);
            }
        }
    }

    private void readWorkWeek(ProjectCalendar mpxjCalendar, Project.Calendars.Calendar.WorkWeeks.WorkWeek xmlWeek) {
        ProjectCalendarWeek week = mpxjCalendar.addWorkWeek();
        week.setName(xmlWeek.getName());
        week.setDateRange(new LocalDateRange(LocalDateHelper.getLocalDate(xmlWeek.getTimePeriod().getFromDate()), LocalDateHelper.getLocalDate(xmlWeek.getTimePeriod().getToDate())));
        Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays xmlWeekDays = xmlWeek.getWeekDays();
        if (xmlWeekDays != null) {
            Map<DayOfWeek, Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay> map = xmlWeekDays.getWeekDay().stream().collect(Collectors.toMap(d -> DayOfWeekHelper.getInstance(d.getDayType().intValue()), d -> d));
            for (DayOfWeek day : DayOfWeek.values()) {
                Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay xmlWeekDay = map.get(day);
                if (xmlWeekDay == null) {
                    week.setWorkingDay(day, false);
                    continue;
                }
                this.readWorkWeekDay(week, day, xmlWeekDay);
            }
        }
    }

    private void readWorkWeekDay(ProjectCalendarWeek week, DayOfWeek day, Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay xmlWeekDay) {
        week.setWorkingDay(day, BooleanHelper.getBoolean(xmlWeekDay.isDayWorking()));
        ProjectCalendarHours hours = week.addCalendarHours(day);
        Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes times = xmlWeekDay.getWorkingTimes();
        if (times != null) {
            for (Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes.WorkingTime period : times.getWorkingTime()) {
                LocalTime startTime = period.getFromTime();
                LocalTime endTime = period.getToTime();
                if (startTime == null || endTime == null) continue;
                hours.add(new LocalTimeRange(startTime, endTime));
            }
        }
    }

    private void readExtendedAttributeDefinitions(Project project) {
        Project.ExtendedAttributes attributes = project.getExtendedAttributes();
        if (attributes != null) {
            for (Project.ExtendedAttributes.ExtendedAttribute ea : attributes.getExtendedAttribute()) {
                this.readExtendedAttributeDefinition(ea);
            }
        }
    }

    private void readExtendedAttributeDefinition(Project.ExtendedAttributes.ExtendedAttribute attribute) {
        FieldType field = FieldTypeHelper.getInstance(this.m_projectFile, Integer.parseInt(attribute.getFieldID()));
        this.m_lookupTableMap.put(attribute.getLtuid(), field);
        String alias = attribute.getAlias();
        if ((alias == null || alias.isEmpty()) && field instanceof UserDefinedField) {
            alias = attribute.getFieldName();
        }
        if (alias != null && !alias.isEmpty()) {
            this.m_projectFile.getCustomFields().getOrCreate(field).setAlias(alias);
        }
    }

    private void readResources(Project project, HashMap<BigInteger, ProjectCalendar> calendarMap) {
        Project.Resources resources = project.getResources();
        if (resources != null) {
            for (Project.Resources.Resource resource : resources.getResource()) {
                this.readResource(resource, calendarMap);
            }
        }
    }

    private void readResource(Project.Resources.Resource xml, HashMap<BigInteger, ProjectCalendar> calendarMap) {
        Resource mpx = this.m_projectFile.addResource();
        mpx.setAccrueAt(xml.getAccrueAt());
        mpx.setActiveDirectoryGUID(xml.getActiveDirectoryGUID());
        mpx.setActualCost(DatatypeConverter.parseCurrency(xml.getActualCost()));
        mpx.setActualOvertimeCost(DatatypeConverter.parseCurrency(xml.getActualOvertimeCost()));
        mpx.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualOvertimeWork()));
        mpx.setActualOvertimeWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualOvertimeWorkProtected()));
        mpx.setActualWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualWorkProtected()));
        mpx.setACWP(DatatypeConverter.parseCurrency(xml.getACWP()));
        mpx.setBCWS(DatatypeConverter.parseCurrency(xml.getBCWS()));
        mpx.setBCWP(DatatypeConverter.parseCurrency(xml.getBCWP()));
        mpx.setBookingType(xml.getBookingType());
        mpx.setBudget(BooleanHelper.getBoolean(xml.isIsBudget()));
        mpx.setCanLevel(BooleanHelper.getBoolean(xml.isCanLevel()));
        mpx.setCode(xml.getCode());
        mpx.setCost(DatatypeConverter.parseCurrency(xml.getCost()));
        mpx.setCostCenter(xml.getCostCenter());
        mpx.setCostVariance(DatatypeConverter.parseCurrency(xml.getCostVariance()));
        mpx.setCreationDate(xml.getCreationDate());
        mpx.setCV(DatatypeConverter.parseCurrency(xml.getCV()));
        mpx.setEmailAddress(xml.getEmailAddress());
        mpx.setGroup(xml.getGroup());
        mpx.setGUID(xml.getGUID());
        mpx.setHyperlink(xml.getHyperlink());
        mpx.setHyperlinkAddress(xml.getHyperlinkAddress());
        mpx.setHyperlinkSubAddress(xml.getHyperlinkSubAddress());
        mpx.setID(NumberHelper.getInteger(xml.getID()));
        mpx.setInitials(xml.getInitials());
        mpx.setEnterprise(BooleanHelper.getBoolean(xml.isIsEnterprise()));
        mpx.setGeneric(BooleanHelper.getBoolean(xml.isIsGeneric()));
        mpx.setActive(!BooleanHelper.getBoolean(xml.isIsInactive()));
        mpx.setIsNull(BooleanHelper.getBoolean(xml.isIsNull()));
        mpx.setUnitOfMeasure(this.m_projectFile.getUnitsOfMeasure().getOrCreateByAbbreviation(xml.getMaterialLabel()));
        mpx.setName(xml.getName());
        if (xml.getNotes() != null && !xml.getNotes().isEmpty()) {
            mpx.setNotes(xml.getNotes());
        }
        mpx.setNtAccount(xml.getNTAccount());
        mpx.setOvertimeCost(DatatypeConverter.parseCurrency(xml.getOvertimeCost()));
        mpx.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getOvertimeWork()));
        mpx.setPeakUnits(DatatypeConverter.parseUnits(xml.getPeakUnits()));
        mpx.setPhonetics(xml.getPhonetics());
        mpx.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getRegularWork()));
        mpx.setRemainingCost(DatatypeConverter.parseCurrency(xml.getRemainingCost()));
        mpx.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(xml.getRemainingOvertimeCost()));
        mpx.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getRemainingOvertimeWork()));
        mpx.setSV(DatatypeConverter.parseCurrency(xml.getSV()));
        mpx.setType(xml.getType());
        mpx.setUniqueID(NumberHelper.getInteger(xml.getUID()));
        mpx.setWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getWork()));
        mpx.setWorkGroup(xml.getWorkGroup());
        mpx.setWorkVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(xml.getWorkVariance()));
        if (mpx.getType() == ResourceType.MATERIAL && BooleanHelper.getBoolean(xml.isIsCostResource())) {
            mpx.setType(ResourceType.COST);
        }
        mpx.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualWork()));
        mpx.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getRemainingWork()));
        mpx.setPercentWorkComplete(xml.getPercentWorkComplete());
        this.readResourceExtendedAttributes(xml, mpx);
        this.readResourceOutlineCodes(xml, mpx);
        this.readResourceBaselines(xml, mpx);
        mpx.setCalendar(calendarMap.get(xml.getCalendarUID()));
        Rate standardRate = DatatypeConverter.parseRate(xml.getStandardRate(), DatatypeConverter.parseTimeUnit(xml.getStandardRateFormat()));
        Rate overtimeRate = DatatypeConverter.parseRate(xml.getOvertimeRate(), DatatypeConverter.parseTimeUnit(xml.getOvertimeRateFormat()));
        Double costPerUse = DatatypeConverter.parseCurrency(xml.getCostPerUse());
        this.readCostRateTables(mpx, standardRate, overtimeRate, costPerUse, xml.getRates());
        this.readAvailabilityTable(mpx, xml);
        mpx.setOverAllocated(BooleanHelper.getBoolean(xml.isOverAllocated()));
        this.m_eventManager.fireResourceReadEvent(mpx);
    }

    private void readResourceBaselines(Project.Resources.Resource xmlResource, Resource mpxjResource) {
        for (Project.Resources.Resource.Baseline baseline : xmlResource.getBaseline()) {
            int number = NumberHelper.getInt(baseline.getNumber());
            Double cost = DatatypeConverter.parseCurrency(baseline.getCost());
            Duration work = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, baseline.getWork());
            if (number == 0) {
                mpxjResource.setBaselineCost(cost);
                mpxjResource.setBaselineWork(work);
                continue;
            }
            mpxjResource.setBaselineCost(number, cost);
            mpxjResource.setBaselineWork(number, work);
        }
    }

    private void readResourceExtendedAttributes(Project.Resources.Resource xml, Resource mpx) {
        for (Project.Resources.Resource.ExtendedAttribute attrib : xml.getExtendedAttribute()) {
            FieldType mpxFieldID = FieldTypeHelper.getInstance(this.m_projectFile, Integer.parseInt(attrib.getFieldID()));
            TimeUnit durationFormat = DatatypeConverter.parseDurationTimeUnits(attrib.getDurationFormat(), null);
            DatatypeConverter.parseCustomField(this.m_projectFile, mpx, attrib.getValue(), mpxFieldID, durationFormat);
        }
    }

    private void readResourceOutlineCodes(Project.Resources.Resource xml, Resource mpx) {
        for (Project.Resources.Resource.OutlineCode attrib : xml.getOutlineCode()) {
            if (attrib.getFieldID() == null) continue;
            FieldType mpxFieldID = FieldTypeHelper.getInstance(this.m_projectFile, Integer.parseInt(attrib.getFieldID()));
            mpx.set(mpxFieldID, this.getOutlineCodeValue(mpxFieldID, attrib.getValueID()));
        }
    }

    private void readCostRateTables(Resource resource, Rate defaultStandardRate, Rate defaultOvertimeRate, Number defaultCostPerUse, Project.Resources.Resource.Rates rates) {
        if (rates == null) {
            for (int index = 0; index < 5; ++index) {
                CostRateTable table = new CostRateTable();
                if (index == 0) {
                    LocalDateTime startDate = CostRateTableEntry.DEFAULT_ENTRY.getStartDate();
                    LocalDateTime endDate = CostRateTableEntry.DEFAULT_ENTRY.getEndDate();
                    table.add(new CostRateTableEntry(startDate, endDate, defaultCostPerUse, defaultStandardRate, defaultOvertimeRate));
                } else {
                    table.add(CostRateTableEntry.DEFAULT_ENTRY);
                }
                resource.setCostRateTable(index, table);
            }
        } else {
            CostRateTable[] tables = new CostRateTable[5];
            for (Project.Resources.Resource.Rates.Rate rate : rates.getRate()) {
                int minutes;
                int tableIndex;
                if (rate.getRateTable() == null || (tableIndex = rate.getRateTable().intValue()) < 0 || tableIndex >= 5) continue;
                TimeUnit standardRateFormat = DatatypeConverter.parseTimeUnit(rate.getStandardRateFormat());
                Rate standardRate = DatatypeConverter.parseRate(rate.getStandardRate(), standardRateFormat);
                TimeUnit overtimeRateFormat = DatatypeConverter.parseTimeUnit(rate.getOvertimeRateFormat());
                Rate overtimeRate = DatatypeConverter.parseRate(rate.getOvertimeRate(), overtimeRateFormat);
                Double costPerUse = DatatypeConverter.parseCurrency(rate.getCostPerUse());
                LocalDateTime startDate = rate.getRatesFrom();
                LocalDateTime endDate = rate.getRatesTo();
                if (startDate.isBefore(LocalDateTimeHelper.START_DATE_NA)) {
                    startDate = LocalDateTimeHelper.START_DATE_NA;
                }
                if (endDate.isAfter(LocalDateTimeHelper.END_DATE_NA)) {
                    endDate = LocalDateTimeHelper.END_DATE_NA;
                }
                if ((minutes = endDate.getMinute()) % 5 == 0) {
                    endDate = endDate.minusMinutes(1L);
                }
                CostRateTableEntry entry = new CostRateTableEntry(startDate, endDate, (Number)costPerUse, standardRate, overtimeRate);
                CostRateTable table = tables[tableIndex];
                if (table == null) {
                    tables[tableIndex] = table = new CostRateTable();
                }
                table.add(entry);
            }
            for (int tableIndex = 0; tableIndex < tables.length; ++tableIndex) {
                CostRateTable table = tables[tableIndex];
                if (table == null) continue;
                Collections.sort(table);
                resource.setCostRateTable(tableIndex, table);
            }
        }
    }

    private void readAvailabilityTable(Resource resource, Project.Resources.Resource xml) {
        Project.Resources.Resource.AvailabilityPeriods periods = xml.getAvailabilityPeriods();
        if (periods == null || periods.getAvailabilityPeriod().isEmpty()) {
            LocalDateTime availableFrom = xml.getAvailableFrom();
            LocalDateTime availableTo = xml.getAvailableTo();
            availableFrom = availableFrom == null ? LocalDateTimeHelper.START_DATE_NA : availableFrom;
            availableTo = availableTo == null ? LocalDateTimeHelper.END_DATE_NA : availableTo;
            resource.getAvailability().add(new Availability(availableFrom, availableTo, DatatypeConverter.parseUnits(xml.getMaxUnits())));
        } else {
            AvailabilityTable table = resource.getAvailability();
            List<Project.Resources.Resource.AvailabilityPeriods.AvailabilityPeriod> list = periods.getAvailabilityPeriod();
            for (Project.Resources.Resource.AvailabilityPeriods.AvailabilityPeriod period : list) {
                LocalDateTime start = period.getAvailableFrom();
                LocalDateTime end = period.getAvailableTo();
                Number units = DatatypeConverter.parseUnits(period.getAvailableUnits());
                if (start == null || start.isBefore(LocalDateTimeHelper.START_DATE_NA)) {
                    start = LocalDateTimeHelper.START_DATE_NA;
                }
                if (end == null || end.isAfter(LocalDateTimeHelper.END_DATE_NA)) {
                    end = LocalDateTimeHelper.END_DATE_NA;
                }
                Availability availability = new Availability(start, end, units);
                table.add(availability);
            }
            Collections.sort(table);
        }
    }

    private void readTasks(Project project) {
        Project.Tasks tasks = project.getTasks();
        if (tasks != null) {
            int tasksWithoutIDCount = 0;
            for (Project.Tasks.Task task : tasks.getTask()) {
                Task mpxjTask = this.readTask(task);
                if (mpxjTask.getID() != null) continue;
                ++tasksWithoutIDCount;
            }
            for (Project.Tasks.Task task : tasks.getTask()) {
                this.readPredecessors(task);
            }
            if (tasksWithoutIDCount == tasks.getTask().size()) {
                this.m_projectFile.getTasks().renumberIDs();
            }
        }
        this.m_projectFile.updateStructure();
    }

    private Task readTask(Project.Tasks.Task xml) {
        Task mpx = this.m_projectFile.addTask();
        mpx.setNull(BooleanHelper.getBoolean(xml.isIsNull()));
        mpx.setID(NumberHelper.getInteger(xml.getID()));
        mpx.setUniqueID(NumberHelper.getInteger(xml.getUID()));
        if (!mpx.getNull()) {
            double duration;
            TimeUnit durationFormat = DatatypeConverter.parseDurationTimeUnits(xml.getDurationFormat());
            if (BooleanHelper.getBoolean(xml.isIsSubproject())) {
                mpx.setSubprojectFile(xml.getSubprojectName());
                mpx.setSubprojectReadOnly(BooleanHelper.getBoolean(xml.isIsSubprojectReadOnly()));
            }
            mpx.setActive(xml.isActive() == null || BooleanHelper.getBoolean(xml.isActive()));
            mpx.setActualCost(DatatypeConverter.parseCurrency(xml.getActualCost()));
            mpx.setActualDuration(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getActualDuration()));
            mpx.setActualFinish(xml.getActualFinish());
            mpx.setActualOvertimeCost(DatatypeConverter.parseCurrency(xml.getActualOvertimeCost()));
            mpx.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getActualOvertimeWork()));
            mpx.setActualOvertimeWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getActualOvertimeWorkProtected()));
            mpx.setActualStart(xml.getActualStart());
            mpx.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getActualWork()));
            mpx.setActualWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getActualWorkProtected()));
            mpx.setACWP(DatatypeConverter.parseCurrency(xml.getACWP()));
            mpx.setCalendar(this.getTaskCalendar(xml));
            mpx.setConstraintDate(xml.getConstraintDate());
            mpx.setConstraintType(DatatypeConverter.parseConstraintType(xml.getConstraintType()));
            mpx.setContact(xml.getContact());
            mpx.setCost(DatatypeConverter.parseCurrency(xml.getCost()));
            mpx.setCreateDate(xml.getCreateDate());
            mpx.setCV(DatatypeConverter.parseCurrency(xml.getCV()));
            mpx.setDeadline(xml.getDeadline());
            mpx.setDuration(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getDuration()));
            mpx.setDurationText(xml.getDurationText());
            mpx.setEarlyFinish(xml.getEarlyFinish());
            mpx.setEarlyStart(xml.getEarlyStart());
            mpx.setEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(xml.getEarnedValueMethod()));
            mpx.setEffortDriven(BooleanHelper.getBoolean(xml.isEffortDriven()));
            mpx.setEstimated(BooleanHelper.getBoolean(xml.isEstimated()));
            mpx.setExternalTask(BooleanHelper.getBoolean(xml.isExternalTask()));
            mpx.setProject(xml.getExternalTaskProject());
            mpx.setFinish(xml.getFinish());
            mpx.setFinishText(xml.getFinishText());
            mpx.setFinishVariance(DatatypeConverter.parseDurationInTenthsOfMinutes(xml.getFinishVariance()));
            mpx.setFixedCost(DatatypeConverter.parseCurrency(xml.getFixedCost()));
            mpx.setFixedCostAccrual(xml.getFixedCostAccrual());
            mpx.setGUID(xml.getGUID());
            mpx.setHideBar(BooleanHelper.getBoolean(xml.isHideBar()));
            mpx.setHyperlink(xml.getHyperlink());
            mpx.setHyperlinkAddress(xml.getHyperlinkAddress());
            mpx.setHyperlinkSubAddress(xml.getHyperlinkSubAddress());
            mpx.setIgnoreResourceCalendar(BooleanHelper.getBoolean(xml.isIgnoreResourceCalendar()));
            mpx.setLateFinish(xml.getLateFinish());
            mpx.setLateStart(xml.getLateStart());
            mpx.setLevelAssignments(BooleanHelper.getBoolean(xml.isLevelAssignments()));
            mpx.setLevelingCanSplit(BooleanHelper.getBoolean(xml.isLevelingCanSplit()));
            mpx.setLevelingDelayFormat(DatatypeConverter.parseDurationTimeUnits(xml.getLevelingDelayFormat()));
            if (xml.getLevelingDelay() != null && mpx.getLevelingDelayFormat() != null && (duration = xml.getLevelingDelay().doubleValue()) != 0.0) {
                mpx.setLevelingDelay(Duration.convertUnits(duration / 10.0, TimeUnit.MINUTES, mpx.getLevelingDelayFormat(), this.m_projectFile.getProjectProperties()));
            }
            mpx.setMilestone(BooleanHelper.getBoolean(xml.isMilestone()));
            mpx.setName(xml.getName());
            if (xml.getNotes() != null && !xml.getNotes().isEmpty()) {
                mpx.setNotes(xml.getNotes());
            }
            mpx.setOutlineLevel(NumberHelper.getInteger(xml.getOutlineLevel()));
            mpx.setOutlineNumber(xml.getOutlineNumber());
            mpx.setOverAllocated(BooleanHelper.getBoolean(xml.isOverAllocated()));
            mpx.setOvertimeCost(DatatypeConverter.parseCurrency(xml.getOvertimeCost()));
            mpx.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getOvertimeWork()));
            mpx.setPercentageComplete(xml.getPercentComplete());
            mpx.setPercentageWorkComplete(xml.getPercentWorkComplete());
            mpx.setPhysicalPercentComplete(NumberHelper.getInteger(xml.getPhysicalPercentComplete()));
            mpx.setPreleveledFinish(xml.getPreLeveledFinish());
            mpx.setPreleveledStart(xml.getPreLeveledStart());
            mpx.setPriority(DatatypeConverter.parsePriority(xml.getPriority()));
            mpx.setRecurring(BooleanHelper.getBoolean(xml.isRecurring()));
            mpx.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getRegularWork()));
            mpx.setRemainingCost(DatatypeConverter.parseCurrency(xml.getRemainingCost()));
            mpx.setRemainingDuration(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getRemainingDuration()));
            mpx.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(xml.getRemainingOvertimeCost()));
            mpx.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getRemainingOvertimeWork()));
            mpx.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getRemainingWork()));
            mpx.setResume(xml.getResume());
            mpx.setResumeValid(BooleanHelper.getBoolean(xml.isResumeValid()));
            mpx.setRollup(BooleanHelper.getBoolean(xml.isRollup()));
            mpx.setStart(xml.getStart());
            mpx.setStartText(xml.getStartText());
            mpx.setStartVariance(DatatypeConverter.parseDurationInTenthsOfMinutes(xml.getStartVariance()));
            mpx.setStop(xml.getStop());
            mpx.setTaskMode(BooleanHelper.getBoolean(xml.isManual()) ? TaskMode.MANUALLY_SCHEDULED : TaskMode.AUTO_SCHEDULED);
            mpx.setType(xml.getType());
            mpx.setWBS(xml.getWBS());
            mpx.setWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getWork()));
            mpx.setWorkVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(xml.getWorkVariance()));
            this.validateFinishDate(mpx);
            mpx.setStartSlack(DatatypeConverter.parseDurationInTenthsOfMinutes(xml.getStartSlack()));
            mpx.setFinishSlack(DatatypeConverter.parseDurationInTenthsOfMinutes(xml.getFinishSlack()));
            mpx.setFreeSlack(DatatypeConverter.parseDurationInTenthsOfMinutes(xml.getFreeSlack()));
            mpx.setTotalSlack(DatatypeConverter.parseDurationInTenthsOfMinutes(xml.getTotalSlack()));
            mpx.setCritical(BooleanHelper.getBoolean(xml.isCritical()));
            this.readTaskExtendedAttributes(xml, mpx);
            this.readTaskOutlineCodes(xml, mpx);
            this.readTaskBaselines(xml, mpx, durationFormat);
            if (mpx.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) {
                mpx.setManualDuration(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getManualDuration()));
            }
            if (mpx.getActualDuration() != null) {
                mpx.set((FieldType)TaskField.ACTUAL_DURATION_UNITS, mpx.getActualDuration().getUnits());
            }
            if (NumberHelper.getInt(mpx.getUniqueID()) == 0) {
                mpx.setSummary(true);
                this.updateProjectProperties(mpx);
            }
            if (xml.getProject() != null) {
                this.m_externalProjects.put(mpx, xml.getProject());
            }
        }
        this.m_eventManager.fireTaskReadEvent(mpx);
        return mpx;
    }

    private void updateProjectProperties(Task task) {
        ProjectProperties props = this.m_projectFile.getProjectProperties();
        props.setComments(task.getNotes());
    }

    private void validateFinishDate(Task task) {
        LocalDateTime startDate;
        if (task.getFinish() == null && (startDate = task.getStart()) != null) {
            if (task.getMilestone()) {
                task.setFinish(startDate);
            } else {
                Duration duration = task.getDuration();
                if (duration != null) {
                    ProjectCalendar calendar = task.getEffectiveCalendar();
                    task.setFinish(calendar.getDate(startDate, duration));
                }
            }
        }
    }

    private void readTaskBaselines(Project.Tasks.Task xmlTask, Task mpxjTask, TimeUnit durationFormat) {
        for (Project.Tasks.Task.Baseline baseline : xmlTask.getBaseline()) {
            int number = NumberHelper.getInt(baseline.getNumber());
            if (number < 0 || number > 10) continue;
            Double cost = DatatypeConverter.parseCurrency(baseline.getCost());
            Duration duration = DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, baseline.getDuration());
            LocalDateTime finish = baseline.getFinish();
            LocalDateTime start = baseline.getStart();
            Duration work = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, baseline.getWork());
            if (number == 0) {
                mpxjTask.setBaselineCost(cost);
                mpxjTask.setBaselineDuration(duration);
                mpxjTask.setBaselineFinish(finish);
                mpxjTask.setBaselineStart(start);
                mpxjTask.setBaselineWork(work);
                continue;
            }
            mpxjTask.setBaselineCost(number, cost);
            mpxjTask.setBaselineDuration(number, duration);
            mpxjTask.setBaselineFinish(number, finish);
            mpxjTask.setBaselineStart(number, start);
            mpxjTask.setBaselineWork(number, work);
        }
    }

    private void readTaskExtendedAttributes(Project.Tasks.Task xml, Task mpx) {
        for (Project.Tasks.Task.ExtendedAttribute attrib : xml.getExtendedAttribute()) {
            FieldType mpxFieldID = FieldTypeHelper.getInstance(this.m_projectFile, Integer.parseInt(attrib.getFieldID()));
            TimeUnit durationFormat = DatatypeConverter.parseDurationTimeUnits(attrib.getDurationFormat(), null);
            DatatypeConverter.parseCustomField(this.m_projectFile, mpx, attrib.getValue(), mpxFieldID, durationFormat);
        }
    }

    private void readTaskOutlineCodes(Project.Tasks.Task xml, Task mpx) {
        for (Project.Tasks.Task.OutlineCode attrib : xml.getOutlineCode()) {
            if (attrib.getFieldID() == null) continue;
            FieldType mpxFieldID = FieldTypeHelper.getInstance(this.m_projectFile, Integer.parseInt(attrib.getFieldID()));
            mpx.set(mpxFieldID, this.getOutlineCodeValue(mpxFieldID, attrib.getValueID()));
        }
    }

    private String getOutlineCodeValue(FieldType mpxFieldID, BigInteger valueID) {
        String result = null;
        CustomFieldValueItem item = this.getValueItem(mpxFieldID, valueID);
        if (item != null && item.getValue() != null) {
            String parentResult;
            result = item.getValue().toString();
            Integer parentID = item.getParentUniqueID();
            if (parentID != null && (parentResult = this.getOutlineCodeValue(mpxFieldID, BigInteger.valueOf(parentID.longValue()))) != null) {
                result = parentResult + "." + result;
            }
        }
        return result;
    }

    private CustomFieldValueItem getValueItem(FieldType fieldType, BigInteger valueID) {
        return (CustomFieldValueItem)this.m_customFieldValueItems.computeIfAbsent(fieldType, k -> this.getCustomFieldValueItemMap(fieldType)).get(valueID);
    }

    private Map<BigInteger, CustomFieldValueItem> getCustomFieldValueItemMap(FieldType fieldType) {
        CustomField field = this.m_projectFile.getCustomFields().get(fieldType);
        if (field == null) {
            return Collections.emptyMap();
        }
        return field.getLookupTable().stream().collect(Collectors.toMap(i -> BigInteger.valueOf(i.getUniqueID().intValue()), i -> i));
    }

    private ProjectCalendar getTaskCalendar(Project.Tasks.Task task) {
        ProjectCalendar calendar = null;
        BigInteger calendarID = task.getCalendarUID();
        if (calendarID != null) {
            calendar = this.m_projectFile.getCalendarByUniqueID(calendarID.intValue());
        }
        return calendar;
    }

    private void readPredecessors(Project.Tasks.Task task) {
        Task currTask;
        Integer uid = task.getUID();
        if (uid != null && (currTask = this.m_projectFile.getTaskByUniqueID(uid)) != null) {
            for (Project.Tasks.Task.PredecessorLink link : task.getPredecessorLink()) {
                this.readPredecessor(currTask, link);
            }
        }
    }

    private void readPredecessor(Task currTask, Project.Tasks.Task.PredecessorLink link) {
        BigInteger uid = link.getPredecessorUID();
        if (uid == null) {
            return;
        }
        Task prevTask = BooleanHelper.getBoolean(link.isCrossProject()) ? this.createExternalTaskPlaceholder(currTask, link) : this.m_projectFile.getTaskByUniqueID(uid.intValue());
        if (prevTask == null) {
            return;
        }
        RelationType type = link.getType() != null ? RelationType.getInstance(link.getType().intValue()) : RelationType.FINISH_START;
        TimeUnit lagUnits = DatatypeConverter.parseDurationTimeUnits(link.getLagFormat());
        int lag = NumberHelper.getInt(link.getLinkLag());
        Duration lagDuration = lag == 0 ? Duration.getInstance(0, lagUnits) : (lagUnits == TimeUnit.PERCENT || lagUnits == TimeUnit.ELAPSED_PERCENT ? Duration.getInstance(lag, lagUnits) : Duration.convertUnits((double)lag / 10.0, TimeUnit.MINUTES, lagUnits, this.m_projectFile.getProjectProperties()));
        Relation relation = currTask.addPredecessor(new Relation.Builder().predecessorTask(prevTask).type(type).lag(lagDuration));
        this.m_eventManager.fireRelationReadEvent(relation);
    }

    private Task createExternalTaskPlaceholder(Task currTask, Project.Tasks.Task.PredecessorLink link) {
        String crossProjectName = link.getCrossProjectName();
        if (crossProjectName == null || crossProjectName.isEmpty()) {
            return null;
        }
        int splitIndex = crossProjectName.lastIndexOf(92);
        String subprojectFile = splitIndex == -1 ? crossProjectName : crossProjectName.substring(0, splitIndex);
        Integer subprojectTaskID = splitIndex + 1 >= crossProjectName.length() ? null : Integer.valueOf(crossProjectName.substring(splitIndex + 1));
        Integer taskUniqueID = NumberHelper.getInteger(link.getPredecessorUID());
        Task task = this.m_projectFile.getTaskByUniqueID(taskUniqueID);
        if (task == null) {
            task = this.m_projectFile.addTask();
            task.setName("External Task");
            task.setExternalTask(true);
            task.setSubprojectFile(subprojectFile);
            task.setSubprojectTaskID(subprojectTaskID);
            task.setOutlineLevel(currTask.getOutlineLevel());
            task.setUniqueID(NumberHelper.getInteger(link.getPredecessorUID()));
            task.setID(currTask.getID());
            currTask.setID(currTask.getID() + 1);
            ChildTaskContainer container = currTask.getParentTask() == null ? this.m_projectFile : currTask.getParentTask();
            int insertionIndex = container.getChildTasks().indexOf(currTask);
            container.getChildTasks().add(insertionIndex, task);
        }
        return task;
    }

    private void readAssignments(Project project) {
        Project.Assignments assignments = project.getAssignments();
        if (assignments != null) {
            for (Project.Assignments.Assignment assignment : assignments.getAssignment()) {
                this.readAssignment(assignment);
            }
        }
    }

    private void readOutlineCodeDefinitions(Project project) {
        Project.OutlineCodes outlineCodes = project.getOutlineCodes();
        if (outlineCodes != null) {
            for (Project.OutlineCodes.OutlineCode outlineCode : outlineCodes.getOutlineCode()) {
                this.readOutlineCodeDefinition(outlineCode);
            }
        }
    }

    private void readOutlineCodeDefinition(Project.OutlineCodes.OutlineCode outlineCode) {
        String fieldID = outlineCode.getFieldID();
        FieldType fieldType = fieldID == null ? this.m_lookupTableMap.get(outlineCode.getGuid()) : FieldTypeHelper.getInstance(this.m_projectFile, NumberHelper.getInt(outlineCode.getFieldID()));
        if (fieldType != null) {
            String newAlias = outlineCode.getAlias();
            if (newAlias != null && !newAlias.isEmpty()) {
                String currentAlias;
                CustomField field = this.m_projectFile.getCustomFields().get(fieldType);
                String string = currentAlias = field == null ? null : field.getAlias();
                if (currentAlias == null || currentAlias.isEmpty()) {
                    if (field == null) {
                        field = this.m_projectFile.getCustomFields().getOrCreate(fieldType);
                    }
                    field.setAlias(newAlias);
                }
            }
            this.readOutlineCodeValues(outlineCode, fieldType);
            this.readOutlineCodeMasks(outlineCode, fieldType);
        }
    }

    private void readOutlineCodeValues(Project.OutlineCodes.OutlineCode outlineCode, FieldType fieldType) {
        Project.OutlineCodes.OutlineCode.Values values = outlineCode.getValues();
        if (values == null) {
            return;
        }
        ObjectSequence uniqueIdSequence = this.m_projectFile.getUniqueIdObjectSequence(CustomFieldValueItem.class);
        values.getValue().forEach(v -> uniqueIdSequence.sync(NumberHelper.getInteger(v.getValueID())));
        CustomField field = this.m_projectFile.getCustomFields().getOrCreate(fieldType);
        CustomFieldLookupTable table = field.getLookupTable();
        table.setEnterprise(BooleanHelper.getBoolean(outlineCode.isEnterprise()));
        table.setAllLevelsRequired(BooleanHelper.getBoolean(outlineCode.isAllLevelsRequired()));
        table.setGUID(outlineCode.getGuid());
        table.setLeafOnly(BooleanHelper.getBoolean(outlineCode.isLeafOnly()));
        table.setOnlyTableValuesAllowed(BooleanHelper.getBoolean(outlineCode.isOnlyTableValuesAllowed()));
        table.setResourceSubstitutionEnabled(BooleanHelper.getBoolean(outlineCode.isResourceSubstitutionEnabled()));
        table.setShowIndent(BooleanHelper.getBoolean(outlineCode.isShowIndent()));
        HashSet<Integer> uniqueIdValues = new HashSet<Integer>();
        for (Project.OutlineCodes.OutlineCode.Values.Value value : values.getValue()) {
            Integer uniqueID = NumberHelper.getInteger(value.getValueID());
            if (uniqueIdValues.contains(uniqueID)) {
                uniqueID = uniqueIdSequence.getNext();
            }
            uniqueIdValues.add(uniqueID);
            CustomFieldValueItem item = new CustomFieldValueItem(uniqueID);
            item.setDescription(value.getDescription());
            item.setGUID(value.getFieldGUID());
            item.setCollapsed(BooleanHelper.getBoolean(value.isIsCollapsed()));
            item.setParentUniqueID(NumberHelper.getInteger(value.getParentValueID()));
            item.setType(CustomFieldValueDataType.getInstance(NumberHelper.getInt(value.getType())));
            item.setValue(DatatypeConverter.parseOutlineCodeValue(value.getValue(), field.getFieldType().getDataType()));
            table.add(item);
        }
    }

    private void readOutlineCodeMasks(Project.OutlineCodes.OutlineCode outlineCode, FieldType fieldType) {
        Project.OutlineCodes.OutlineCode.Masks masks = outlineCode.getMasks();
        if (masks != null && !masks.getMask().isEmpty()) {
            CustomField field = this.m_projectFile.getCustomFields().getOrCreate(fieldType);
            List<CustomFieldValueMask> maskList = field.getMasks();
            for (Project.OutlineCodes.OutlineCode.Masks.Mask mask : masks.getMask()) {
                int length = NumberHelper.getInt(mask.getLength());
                int level = NumberHelper.getInt(mask.getLevel());
                String separator = mask.getSeparator();
                CustomFieldValueDataType type = CustomFieldValueDataType.getInstanceByMaskValue(NumberHelper.getInt(mask.getType()));
                if (type == null) {
                    type = CustomFieldValueDataType.TEXT;
                }
                CustomFieldValueMask item = new CustomFieldValueMask(length, level, separator, type);
                maskList.add(item);
            }
        }
    }

    private void readAssignment(Project.Assignments.Assignment assignment) {
        Task task;
        BigInteger taskUID = assignment.getTaskUID();
        BigInteger resourceUID = assignment.getResourceUID();
        if (taskUID != null && resourceUID != null && (task = this.m_projectFile.getTaskByUniqueID(taskUID.intValue())) != null) {
            List<TimephasedItem> timephasedData;
            ResourceAssignment mpx = task.addResourceAssignment(this.m_projectFile.getResourceByUniqueID(resourceUID.intValue()));
            ProjectCalendar calendar = mpx.getEffectiveCalendar();
            List<TimephasedWork> timephasedComplete = this.readTimephasedWork(assignment, 2);
            List<TimephasedWork> timephasedPlanned = this.readTimephasedWork(assignment, 1);
            boolean raw = true;
            if (this.isSplit(calendar, timephasedComplete) || this.isSplit(calendar, timephasedPlanned)) {
                MSPDITimephasedWorkNormaliser.INSTANCE.normalise(calendar, (TimePeriodEntity)mpx, timephasedComplete);
                MSPDITimephasedWorkNormaliser.INSTANCE.normalise(calendar, (TimePeriodEntity)mpx, timephasedPlanned);
                SplitTaskFactory.processSplitData(mpx, timephasedComplete, timephasedPlanned);
                raw = false;
            }
            DefaultTimephasedWorkContainer timephasedCompleteData = new DefaultTimephasedWorkContainer(mpx, MSPDITimephasedWorkNormaliser.INSTANCE, timephasedComplete, raw);
            DefaultTimephasedWorkContainer timephasedPlannedData = new DefaultTimephasedWorkContainer(mpx, MSPDITimephasedWorkNormaliser.INSTANCE, timephasedPlanned, raw);
            mpx.setActualCost(DatatypeConverter.parseCurrency(assignment.getActualCost()));
            mpx.setActualFinish(assignment.getActualFinish());
            mpx.setActualOvertimeCost(DatatypeConverter.parseCurrency(assignment.getActualOvertimeCost()));
            mpx.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getActualOvertimeWork()));
            mpx.setActualStart(assignment.getActualStart());
            mpx.setACWP(DatatypeConverter.parseCurrency(assignment.getACWP()));
            mpx.setBCWP(DatatypeConverter.parseCurrency(assignment.getBCWP()));
            mpx.setBCWS(DatatypeConverter.parseCurrency(assignment.getBCWS()));
            mpx.setBudgetCost(DatatypeConverter.parseCurrency(assignment.getBudgetCost()));
            mpx.setBudgetWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getBudgetWork()));
            mpx.setCost(DatatypeConverter.parseCurrency(assignment.getCost()));
            mpx.setCostRateTableIndex(NumberHelper.getInt(assignment.getCostRateTable()));
            mpx.setCreateDate(assignment.getCreationDate());
            mpx.setCV(DatatypeConverter.parseCurrency(assignment.getCV()));
            mpx.setDelay(DatatypeConverter.parseDurationInTenthsOfMinutes(assignment.getDelay()));
            mpx.setFinish(assignment.getFinish());
            mpx.setVariableRateUnits(BooleanHelper.getBoolean(assignment.isHasFixedRateUnits()) ? null : DatatypeConverter.parseTimeUnit(assignment.getRateScale()));
            mpx.setGUID(assignment.getGUID());
            mpx.setHyperlink(assignment.getHyperlink());
            mpx.setHyperlinkAddress(assignment.getHyperlinkAddress());
            mpx.setHyperlinkSubAddress(assignment.getHyperlinkSubAddress());
            mpx.setLevelingDelay(DatatypeConverter.parseDurationInTenthsOfMinutes(this.m_projectFile.getProjectProperties(), assignment.getLevelingDelay(), DatatypeConverter.parseDurationTimeUnits(assignment.getLevelingDelayFormat())));
            mpx.setNotes(assignment.getNotes());
            mpx.setOvertimeCost(DatatypeConverter.parseCurrency(assignment.getOvertimeCost()));
            mpx.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getOvertimeWork()));
            mpx.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getRegularWork()));
            mpx.setRemainingCost(DatatypeConverter.parseCurrency(assignment.getRemainingCost()));
            mpx.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(assignment.getRemainingOvertimeCost()));
            mpx.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getRemainingOvertimeWork()));
            mpx.setResume(assignment.getResume());
            mpx.setStart(assignment.getStart());
            mpx.setStop(assignment.getStop());
            mpx.setSV(DatatypeConverter.parseCurrency(assignment.getSV()));
            mpx.setUniqueID(NumberHelper.getInteger(assignment.getUID()));
            mpx.setUnits(DatatypeConverter.parseUnits(assignment.getUnits()));
            mpx.setVAC(DatatypeConverter.parseCurrency(assignment.getVAC()));
            mpx.setWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getWork()));
            mpx.setWorkContour(assignment.getWorkContour());
            mpx.setTimephasedActualWork(timephasedCompleteData);
            mpx.setTimephasedWork(timephasedPlannedData);
            this.readAssignmentExtendedAttributes(assignment, mpx);
            this.readAssignmentBaselines(assignment, mpx);
            mpx.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getActualWork()));
            mpx.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getRemainingWork()));
            mpx.setPercentageWorkComplete(assignment.getPercentWorkComplete());
            mpx.setCostVariance(DatatypeConverter.parseCurrency(assignment.getCostVariance()));
            mpx.setWorkVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(this.m_projectFile.getProjectProperties(), assignment.getWorkVariance(), TimeUnit.HOURS));
            mpx.setStartVariance(DatatypeConverter.parseDurationInTenthsOfMinutes(this.m_projectFile.getProjectProperties(), assignment.getStartVariance(), TimeUnit.DAYS));
            mpx.setFinishVariance(DatatypeConverter.parseDurationInTenthsOfMinutes(this.m_projectFile.getProjectProperties(), assignment.getFinishVariance(), TimeUnit.DAYS));
            for (Map.Entry<Integer, TimephasedWorkAssignmentFunction> entry : TIMEPHASED_BASELINE_WORK_MAP.entrySet()) {
                timephasedData = this.readTimephasedWork(assignment, entry.getKey());
                if (timephasedData.isEmpty()) continue;
                entry.getValue().apply(mpx, new DefaultTimephasedWorkContainer(mpx, MSPDITimephasedWorkNormaliser.INSTANCE, timephasedData, true));
            }
            for (Map.Entry<Integer, Object> entry : TIMEPHASED_BASELINE_COST_MAP.entrySet()) {
                timephasedData = this.readTimephasedCost(assignment, entry.getKey());
                if (timephasedData.isEmpty()) continue;
                ((TimephasedCostAssignmentFunction)entry.getValue()).apply(mpx, new DefaultTimephasedCostContainer(mpx, MPPTimephasedBaselineCostNormaliser.INSTANCE, timephasedData, true));
            }
            this.m_eventManager.fireAssignmentReadEvent(mpx);
        }
    }

    private void readAssignmentBaselines(Project.Assignments.Assignment assignment, ResourceAssignment mpx) {
        for (Project.Assignments.Assignment.Baseline baseline : assignment.getBaseline()) {
            int number = NumberHelper.getInt(baseline.getNumber());
            Number cost = DatatypeConverter.parseCustomFieldCurrency(baseline.getCost());
            LocalDateTime finish = DatatypeConverter.parseCustomFieldDate(baseline.getFinish());
            LocalDateTime start = DatatypeConverter.parseCustomFieldDate(baseline.getStart());
            Duration work = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, baseline.getWork());
            if (number == 0) {
                mpx.setBaselineCost(cost);
                mpx.setBaselineFinish(finish);
                mpx.setBaselineStart(start);
                mpx.setBaselineWork(work);
                continue;
            }
            mpx.setBaselineCost(number, cost);
            mpx.setBaselineWork(number, work);
            mpx.setBaselineStart(number, start);
            mpx.setBaselineFinish(number, finish);
        }
    }

    private void readAssignmentExtendedAttributes(Project.Assignments.Assignment xml, ResourceAssignment mpx) {
        for (Project.Assignments.Assignment.ExtendedAttribute attrib : xml.getExtendedAttribute()) {
            FieldType mpxFieldID = FieldTypeHelper.getInstance(this.m_projectFile, Integer.parseInt(attrib.getFieldID()));
            TimeUnit durationFormat = DatatypeConverter.parseDurationTimeUnits(attrib.getDurationFormat(), null);
            DatatypeConverter.parseCustomField(this.m_projectFile, mpx, attrib.getValue(), mpxFieldID, durationFormat);
        }
    }

    private boolean isSplit(ProjectCalendar calendar, List<TimephasedWork> list) {
        boolean result = false;
        for (TimephasedWork assignment : list) {
            Duration calendarWork;
            if (calendar == null || ((Duration)assignment.getTotalAmount()).getDuration() != 0.0 || (calendarWork = calendar.getWork(assignment.getStart(), assignment.getFinish(), TimeUnit.MINUTES)).getDuration() == 0.0) continue;
            result = true;
            break;
        }
        return result;
    }

    private List<TimephasedWork> readTimephasedWork(Project.Assignments.Assignment assignment, int type) {
        return assignment.getTimephasedData().stream().filter(i -> NumberHelper.getInt(i.getType()) == type && i.getStart() != null && i.getFinish() != null).map(this::readTimephasedWork).collect(Collectors.toList());
    }

    private List<TimephasedCost> readTimephasedCost(Project.Assignments.Assignment assignment, int type) {
        return assignment.getTimephasedData().stream().filter(i -> NumberHelper.getInt(i.getType()) == type && i.getStart() != null && i.getFinish() != null).map(this::readTimephasedCost).collect(Collectors.toList());
    }

    private TimephasedWork readTimephasedWork(TimephasedDataType item) {
        Duration work = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.MINUTES, item.getValue());
        work = work == null ? Duration.getInstance(0, TimeUnit.MINUTES) : Duration.getInstance(NumberHelper.round(work.getDuration(), 2.0), TimeUnit.MINUTES);
        TimephasedWork timephasedWork = new TimephasedWork();
        timephasedWork.setStart(item.getStart());
        timephasedWork.setFinish(item.getFinish());
        timephasedWork.setTotalAmount(work);
        return timephasedWork;
    }

    private TimephasedCost readTimephasedCost(TimephasedDataType item) {
        String value = item.getValue();
        Double currency = value == null || value.isEmpty() ? NumberHelper.DOUBLE_ZERO : Double.valueOf(item.getValue());
        TimephasedCost timephasedCost = new TimephasedCost();
        timephasedCost.setStart(item.getStart());
        timephasedCost.setFinish(item.getFinish());
        timephasedCost.setTotalAmount(DatatypeConverter.parseCurrency(currency));
        return timephasedCost;
    }

    public void setMicrosoftProjectCompatibleInput(boolean flag) {
        this.m_compatibleInput = flag;
    }

    public boolean getMicrosoftProjectCompatibleInput() {
        return this.m_compatibleInput;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.m_ignoreErrors = ignoreErrors;
    }

    public boolean getIgnoreErrors() {
        return this.m_ignoreErrors;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"org.mpxj.mspdi.schema", (ClassLoader)MSPDIReader.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
        RECURRENCE_TYPES = new RecurrenceType[]{null, RecurrenceType.DAILY, RecurrenceType.YEARLY, RecurrenceType.YEARLY, RecurrenceType.MONTHLY, RecurrenceType.MONTHLY, RecurrenceType.WEEKLY, RecurrenceType.DAILY};
        RELATIVE_MAP = new boolean[]{false, false, false, true, false, true};
        DAY_MASKS = new int[]{0, 1, 2, 4, 8, 16, 32, 64};
        TIMEPHASED_BASELINE_WORK_MAP = new HashMap<Integer, TimephasedWorkAssignmentFunction>();
        TIMEPHASED_BASELINE_WORK_MAP.put(4, (a, c) -> a.setTimephasedBaselineWork(0, c));
        TIMEPHASED_BASELINE_WORK_MAP.put(16, (a, c) -> a.setTimephasedBaselineWork(1, c));
        TIMEPHASED_BASELINE_WORK_MAP.put(22, (a, c) -> a.setTimephasedBaselineWork(2, c));
        TIMEPHASED_BASELINE_WORK_MAP.put(28, (a, c) -> a.setTimephasedBaselineWork(3, c));
        TIMEPHASED_BASELINE_WORK_MAP.put(34, (a, c) -> a.setTimephasedBaselineWork(4, c));
        TIMEPHASED_BASELINE_WORK_MAP.put(40, (a, c) -> a.setTimephasedBaselineWork(5, c));
        TIMEPHASED_BASELINE_WORK_MAP.put(46, (a, c) -> a.setTimephasedBaselineWork(6, c));
        TIMEPHASED_BASELINE_WORK_MAP.put(52, (a, c) -> a.setTimephasedBaselineWork(7, c));
        TIMEPHASED_BASELINE_WORK_MAP.put(58, (a, c) -> a.setTimephasedBaselineWork(8, c));
        TIMEPHASED_BASELINE_WORK_MAP.put(64, (a, c) -> a.setTimephasedBaselineWork(9, c));
        TIMEPHASED_BASELINE_WORK_MAP.put(70, (a, c) -> a.setTimephasedBaselineWork(10, c));
        TIMEPHASED_BASELINE_COST_MAP = new HashMap<Integer, TimephasedCostAssignmentFunction>();
        TIMEPHASED_BASELINE_COST_MAP.put(5, (a, c) -> a.setTimephasedBaselineCost(0, c));
        TIMEPHASED_BASELINE_COST_MAP.put(17, (a, c) -> a.setTimephasedBaselineCost(1, c));
        TIMEPHASED_BASELINE_COST_MAP.put(23, (a, c) -> a.setTimephasedBaselineCost(2, c));
        TIMEPHASED_BASELINE_COST_MAP.put(29, (a, c) -> a.setTimephasedBaselineCost(3, c));
        TIMEPHASED_BASELINE_COST_MAP.put(35, (a, c) -> a.setTimephasedBaselineCost(4, c));
        TIMEPHASED_BASELINE_COST_MAP.put(41, (a, c) -> a.setTimephasedBaselineCost(5, c));
        TIMEPHASED_BASELINE_COST_MAP.put(47, (a, c) -> a.setTimephasedBaselineCost(6, c));
        TIMEPHASED_BASELINE_COST_MAP.put(53, (a, c) -> a.setTimephasedBaselineCost(7, c));
        TIMEPHASED_BASELINE_COST_MAP.put(59, (a, c) -> a.setTimephasedBaselineCost(8, c));
        TIMEPHASED_BASELINE_COST_MAP.put(65, (a, c) -> a.setTimephasedBaselineCost(9, c));
        TIMEPHASED_BASELINE_COST_MAP.put(71, (a, c) -> a.setTimephasedBaselineCost(10, c));
    }

    static interface TimephasedCostAssignmentFunction {
        public void apply(ResourceAssignment var1, TimephasedCostContainer var2);
    }

    static interface TimephasedWorkAssignmentFunction {
        public void apply(ResourceAssignment var1, TimephasedWorkContainer var2);
    }
}

