/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.openplan;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.mpxj.ActivityCodeValue;
import org.mpxj.ActivityStatus;
import org.mpxj.ActivityType;
import org.mpxj.ConstraintType;
import org.mpxj.Priority;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectFile;
import org.mpxj.Task;
import org.mpxj.common.HierarchyHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.openplan.OpenPlanHierarchyHelper;
import org.mpxj.openplan.Row;
import org.mpxj.openplan.TableReader;

class ActivityReader {
    private final ProjectFile m_file;
    private final DirectoryEntry m_root;
    private static final Map<String, ConstraintType> TARGET_FINISH_TYPE_MAP = new HashMap<String, ConstraintType>();
    private static final Map<String, ConstraintType> TARGET_START_MAP;

    public ActivityReader(DirectoryEntry root, ProjectFile file) {
        this.m_root = root;
        this.m_file = file;
    }

    public void read(Map<String, Map<String, ActivityCodeValue>> codeMap, Map<String, ProjectCalendar> calendarMap) {
        HashMap<String, Task> map = new HashMap<String, Task>();
        List<Row> rows = new TableReader(this.m_root, "ACT").read();
        HierarchyHelper.sortHierarchy(rows, r -> r.getString("ACT_ID"), r -> OpenPlanHierarchyHelper.getParentID(r.getString("ACT_ID")), Comparator.comparing(o -> o.getString("ACT_ID")));
        for (Row row : rows) {
            String activityID = row.getString("ACT_ID");
            Task parentTask = (Task)map.get(OpenPlanHierarchyHelper.getParentID(activityID));
            Task task = parentTask == null ? this.m_file.addTask() : parentTask.addTask();
            task.setActivityID(activityID);
            task.setGUID(row.getUuid("ACT_UID"));
            task.setACWP(this.sum(row, "ACWP_LAB", "ACWP_MAT", "ACWP_ODC", "ACWP_SUB"));
            task.setActualFinish(row.getDate("AFDATE"));
            task.setActualStart(row.getDate("ASDATE"));
            task.setBaselineCost(this.sum(row, "BAC_LAB", "BAC_MAT", "BAC_ODC", "BAC_SUB"));
            task.setBCWP(this.sum(row, "BCWP_LAB", "BCWP_MAT", "BCWP_ODC", "BCWP_SUB"));
            task.setBCWS(this.sum(row, "BCWS_LAB", "BCWS_MAT", "BCWS_ODC", "BCWS_SUB"));
            task.setBaselineFinish(row.getDate("BFDATE"));
            task.setBaselineStart(row.getDate("BSDATE"));
            task.setCalendar(calendarMap.get(row.getString("CLH_ID")));
            task.setCritical(NumberHelper.getInt(row.getInteger("CRITICAL")) == 0);
            task.setName(row.getString("DESCRIPTION"));
            task.setEarlyFinish(row.getDate("EFDATE"));
            task.setEarlyStart(row.getDate("ESDATE"));
            task.setCost(this.sum(row, "ETC_LAB", "ETC_MAT", "ETC_ODC", "ETC_SUB"));
            task.setFreeSlack(row.getDuration("FREEFLOAT"));
            task.setLateFinish(row.getDate("LFDATE"));
            task.setLateStart(row.getDate("LSDATE"));
            task.setPlannedDuration(row.getDuration("ORIG_DUR"));
            task.setRemainingDuration(row.getDuration("REM_DUR"));
            task.setDuration(row.getDuration("SCHED_DUR"));
            task.setPlannedFinish(row.getDate("SFDATE"));
            task.setPlannedStart(row.getDate("SSDATE"));
            task.setTotalSlack(row.getDuration("TOTALFLOAT"));
            task.setConstraintType(this.getConstraintType(row));
            task.setConstraintDate(this.getConstraintDate(task, row));
            task.setSecondaryConstraintType(this.getSecondaryConstraintType(task, row));
            task.setSecondaryConstraintDate(this.getSecondaryConstraintDate(task, row));
            task.setActivityStatus(this.getActivityStatus(row));
            task.setStart(task.getActualStart() == null ? task.getEarlyStart() : task.getActualStart());
            task.setFinish(task.getActualFinish() == null ? task.getEarlyFinish() : task.getActualFinish());
            task.setActivityType(ActivityType.TASK_DEPENDENT);
            task.setPriority(Priority.getInstance(500));
            for (Map.Entry<String, Map<String, ActivityCodeValue>> entry : codeMap.entrySet()) {
                String columnValue = row.getString(entry.getKey());
                ActivityCodeValue acv = entry.getValue().get(columnValue);
                if (acv == null) continue;
                task.addActivityCodeValue(acv);
            }
            map.put(task.getActivityID(), task);
        }
    }

    private ConstraintType getConstraintType(Row row) {
        if ("L".equals(row.getString("ACT_TYPE"))) {
            return ConstraintType.AS_LATE_AS_POSSIBLE;
        }
        String targetStartType = row.getString("TARGSTYPE");
        return targetStartType == null ? TARGET_FINISH_TYPE_MAP.get(row.getString("TARGFTYPE")) : TARGET_START_MAP.get(targetStartType);
    }

    private LocalDateTime getConstraintDate(Task task, Row row) {
        ConstraintType type = task.getConstraintType();
        if (type == null) {
            return null;
        }
        switch (task.getConstraintType()) {
            case START_NO_EARLIER_THAN: 
            case START_NO_LATER_THAN: 
            case MUST_START_ON: {
                return row.getDate("TSDATE");
            }
            case FINISH_NO_LATER_THAN: 
            case FINISH_NO_EARLIER_THAN: 
            case MUST_FINISH_ON: {
                return row.getDate("TFDATE");
            }
        }
        return null;
    }

    private ConstraintType getSecondaryConstraintType(Task task, Row row) {
        ConstraintType primaryConstraintType = task.getConstraintType();
        if (primaryConstraintType == ConstraintType.START_NO_EARLIER_THAN || primaryConstraintType == ConstraintType.START_NO_LATER_THAN || primaryConstraintType == ConstraintType.MUST_START_ON) {
            return TARGET_FINISH_TYPE_MAP.get(row.getString("TARGFTYPE"));
        }
        return null;
    }

    private LocalDateTime getSecondaryConstraintDate(Task task, Row row) {
        return task.getSecondaryConstraintType() == null ? null : row.getDate("TFDATE");
    }

    private ActivityStatus getActivityStatus(Row row) {
        switch (row.getInteger("COMPSTAT")) {
            case 2: {
                return ActivityStatus.COMPLETED;
            }
            case 1: {
                return ActivityStatus.IN_PROGRESS;
            }
        }
        return null;
    }

    private Double sum(Row row, String ... keys) {
        return Arrays.stream(keys).map(row::getDouble).filter(Objects::nonNull).mapToDouble(Double::doubleValue).sum();
    }

    static {
        TARGET_FINISH_TYPE_MAP.put("NE", ConstraintType.FINISH_NO_EARLIER_THAN);
        TARGET_FINISH_TYPE_MAP.put("NL", ConstraintType.FINISH_NO_LATER_THAN);
        TARGET_FINISH_TYPE_MAP.put("ON", ConstraintType.MUST_FINISH_ON);
        TARGET_FINISH_TYPE_MAP.put("FX", ConstraintType.MUST_FINISH_ON);
        TARGET_START_MAP = new HashMap<String, ConstraintType>();
        TARGET_START_MAP.put("NE", ConstraintType.START_NO_EARLIER_THAN);
        TARGET_START_MAP.put("NL", ConstraintType.START_NO_LATER_THAN);
        TARGET_START_MAP.put("ON", ConstraintType.MUST_START_ON);
        TARGET_START_MAP.put("FX", ConstraintType.MUST_START_ON);
    }
}

