/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.openplan;

import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.mpxj.Duration;
import org.mpxj.ProjectFile;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.Task;
import org.mpxj.TimeUnit;
import org.mpxj.openplan.Row;
import org.mpxj.openplan.TableReader;

class AssignmentReader {
    private final ProjectFile m_file;
    private final DirectoryEntry m_root;

    public AssignmentReader(DirectoryEntry root, ProjectFile file) {
        this.m_root = root;
        this.m_file = file;
    }

    public void read() {
        Map<UUID, Task> taskMap = this.m_file.getTasks().stream().collect(Collectors.toMap(Task::getGUID, t -> t));
        Map<UUID, Resource> resourceMap = this.m_file.getResources().stream().collect(Collectors.toMap(Resource::getGUID, r -> r));
        for (Row row : new TableReader(this.m_root, "ASG").read()) {
            Resource resource;
            Task task = taskMap.get(row.getUuid("ACT_UID"));
            if (task == null || (resource = resourceMap.get(row.getUuid("RES_UID"))) == null) continue;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            Double resLevel = row.getDouble("RES_LEVEL");
            double units = resLevel / 8.0;
            assignment.setUnits(units * 100.0);
            Duration taskWork = assignment.getEffectiveCalendar().getWork(task.getStart(), task.getFinish(), TimeUnit.HOURS);
            Duration assignmentWork = Duration.getInstance(taskWork.getDuration() * units, TimeUnit.HOURS);
            assignment.setWork(assignmentWork);
            assignment.setRemainingWork(assignmentWork);
            Duration totalWork = task.getWork();
            if (totalWork == null) {
                totalWork = Duration.getInstance(0, TimeUnit.HOURS);
            }
            totalWork = Duration.getInstance(totalWork.getDuration() + taskWork.getDuration(), TimeUnit.HOURS);
            task.setWork(totalWork);
            task.setRemainingWork(totalWork);
        }
    }
}

