/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.openplan;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.mpxj.DayType;
import org.mpxj.LocalTimeRange;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectFile;
import org.mpxj.RecurrenceType;
import org.mpxj.RecurringData;
import org.mpxj.common.HierarchyHelper;
import org.mpxj.openplan.DirectoryReader;
import org.mpxj.openplan.OpenPlanHierarchyHelper;
import org.mpxj.openplan.Row;
import org.mpxj.openplan.TableReader;

class CalendarDirectoryReader
extends DirectoryReader {
    private final ProjectFile m_file;
    private final DirectoryEntry m_root;
    private final Map<String, ProjectCalendar> m_map = new HashMap<String, ProjectCalendar>();
    private static final DateTimeFormatter DATE_FORMAT = new DateTimeFormatterBuilder().parseLenient().appendPattern("yyyyMMdd").toFormatter();
    private static final Map<String, DayOfWeek> DAY_OF_WEEK_MAP = new HashMap<String, DayOfWeek>();

    public CalendarDirectoryReader(DirectoryEntry root, ProjectFile file) {
        this.m_root = root;
        this.m_file = file;
    }

    public void read(String name) {
        ProjectCalendar calendar;
        DirectoryEntry dir = this.getDirectoryEntry(this.m_root, name);
        List<Row> rows = new TableReader(dir, "CLH").read();
        HierarchyHelper.sortHierarchy(rows, r -> r.getString("CLH_ID"), r -> OpenPlanHierarchyHelper.getParentID(r.getString("CLH_ID")), Comparator.comparing(o -> o.getString("CLH_ID")));
        for (Row row : rows) {
            String calendarName;
            calendar = this.m_file.addCalendar();
            ProjectCalendar parentCalendar = this.m_map.get(OpenPlanHierarchyHelper.getParentID(row.getString("CLH_ID")));
            if (parentCalendar != null) {
                calendar.setParent(parentCalendar);
            }
            if ((calendarName = row.getString("DESCRIPTION")) == null || calendarName.isEmpty()) {
                calendarName = row.getString("CLH_ID");
            }
            calendar.setGUID(row.getUuid("CLH_UID"));
            calendar.setName(calendarName);
            Arrays.stream(DayOfWeek.values()).forEach(d -> calendar.setCalendarDayType((DayOfWeek)d, DayType.NON_WORKING));
            this.m_map.put(row.getString("CLH_ID"), calendar);
        }
        rows = new TableReader(dir, "CLR").read();
        for (Row row : rows) {
            calendar = this.m_map.get(row.getString("CLH_ID"));
            if (calendar == null) continue;
            if (this.isDayOfWeek(row)) {
                this.readDayOfWeek(calendar, row);
                continue;
            }
            if (this.isDate(row)) {
                this.readExceptionDate(calendar, row);
            }
            if (!this.isDayAndMonth(row)) continue;
            this.readDayAndMonth(calendar, row);
        }
    }

    public Map<String, ProjectCalendar> getMap() {
        return this.m_map;
    }

    private void readDayOfWeek(ProjectCalendar calendar, Row row) {
        if (!row.getBoolean("OPWORK").booleanValue()) {
            return;
        }
        DayOfWeek day = DAY_OF_WEEK_MAP.get(row.getString("DATESPEC"));
        calendar.setCalendarDayType(day, DayType.WORKING);
        ProjectCalendarHours hours = calendar.getHours(day);
        if (hours == null) {
            hours = calendar.addCalendarHours(day);
        }
        hours.add(new LocalTimeRange(row.getTime("OPSTART"), row.getTime("OPFINISH")));
    }

    private void readExceptionDate(ProjectCalendar calendar, Row row) {
        LocalDate date = LocalDate.parse(row.getString("DATESPEC"), DATE_FORMAT);
        ProjectCalendarException exception = null;
        List<ProjectCalendarException> exceptions = calendar.getCalendarExceptions();
        for (ProjectCalendarException ex : exceptions) {
            if (ex.getFromDate().equals(date)) {
                exception = ex;
                break;
            }
            if (!date.isBefore(ex.getFromDate())) continue;
            break;
        }
        if (exception == null) {
            exception = calendar.addCalendarException(date);
        }
        if (!row.getBoolean("OPWORK").booleanValue()) {
            return;
        }
        exception.add(new LocalTimeRange(row.getTime("OPSTART"), row.getTime("OPFINISH")));
    }

    private void readDayAndMonth(ProjectCalendar calendar, Row row) {
        String dateSpec = row.getString("DATESPEC");
        Integer day = Integer.valueOf(dateSpec.substring(dateSpec.length() - 2));
        Integer month = Integer.valueOf(dateSpec.substring(0, dateSpec.length() - 2));
        RecurringData recurrence = new RecurringData();
        recurrence.setStartDate(this.m_file.getProjectProperties().getStartDate().toLocalDate());
        recurrence.setFinishDate(this.m_file.getProjectProperties().getFinishDate().toLocalDate());
        recurrence.setRecurrenceType(RecurrenceType.YEARLY);
        recurrence.setDayNumber(day);
        recurrence.setMonthNumber(month);
        if (!recurrence.isValid()) {
            return;
        }
        ProjectCalendarException exception = calendar.addCalendarException(recurrence);
        if (!row.getBoolean("OPWORK").booleanValue()) {
            return;
        }
        exception.add(new LocalTimeRange(row.getTime("OPSTART"), row.getTime("OPFINISH")));
    }

    private boolean isDayOfWeek(Row row) {
        return DAY_OF_WEEK_MAP.containsKey(row.getString("DATESPEC"));
    }

    private boolean isDate(Row row) {
        String dateSpec = row.getString("DATESPEC");
        if (dateSpec.length() != 8) {
            return false;
        }
        for (char c : dateSpec.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public boolean isDayAndMonth(Row row) {
        String dateSpec = row.getString("DATESPEC");
        if (dateSpec.length() < 3 || dateSpec.length() > 4) {
            return false;
        }
        for (char c : dateSpec.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    static {
        DAY_OF_WEEK_MAP.put("monday", DayOfWeek.MONDAY);
        DAY_OF_WEEK_MAP.put("tuesday", DayOfWeek.TUESDAY);
        DAY_OF_WEEK_MAP.put("wednesday", DayOfWeek.WEDNESDAY);
        DAY_OF_WEEK_MAP.put("thursday", DayOfWeek.THURSDAY);
        DAY_OF_WEEK_MAP.put("friday", DayOfWeek.FRIDAY);
        DAY_OF_WEEK_MAP.put("saturday", DayOfWeek.SATURDAY);
        DAY_OF_WEEK_MAP.put("sunday", DayOfWeek.SUNDAY);
    }
}

