/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.openplan;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.mpxj.openplan.Code;
import org.mpxj.openplan.CodeValue;
import org.mpxj.openplan.DirectoryReader;
import org.mpxj.openplan.OpenPlanException;
import org.mpxj.openplan.Row;
import org.mpxj.openplan.TableReader;

class CodeDirectoryReader
extends DirectoryReader {
    private final DirectoryEntry m_root;
    private final Map<String, Code> m_map = new HashMap<String, Code>();

    public CodeDirectoryReader(DirectoryEntry root) {
        this.m_root = root;
    }

    public void read(String name) {
        DirectoryEntry dir = this.getDirectoryEntry(this.m_root, name);
        List<Row> codeRows = new TableReader(dir, "COD").read();
        if (codeRows.isEmpty()) {
            return;
        }
        Row codeRow = codeRows.get(0);
        if (codeRows.size() != 1) {
            throw new OpenPlanException("Expecting 1 code row, found " + codeRows.size());
        }
        List<Row> valueRows = new TableReader(dir, "CDR").read();
        this.m_map.put(codeRow.getString("DIR_ID"), new Code(codeRow.getString("DIR_ID"), codeRow.getString("PROMPT_TEXT"), codeRow.getString("DESCRIPTION"), valueRows.stream().map(r -> new CodeValue(r.getString("CDR_ID"), r.getString("CDR_UID"), r.getString("DESCRIPTION"))).collect(Collectors.toList())));
    }

    public Map<String, Code> getCodes() {
        return this.m_map;
    }
}

