/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.openplan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.mpxj.openplan.AbstractReader;

public class DependenciesReader
extends AbstractReader {
    private final List<String> m_calendars = new ArrayList<String>();
    private final List<String> m_resources = new ArrayList<String>();
    private final List<String> m_codes = new ArrayList<String>();
    private static final Map<String, StoreDirectoryName> TYPE_MAP = new HashMap<String, StoreDirectoryName>();

    public DependenciesReader(DirectoryEntry dir) {
        super(dir, "Dependencies");
    }

    public DependenciesReader read() {
        int count = this.getInt();
        for (int index = 0; index < count; ++index) {
            String type;
            String name = this.getString();
            while ((type = this.getString()) != null) {
                String path = name + "_" + type;
                StoreDirectoryName x = TYPE_MAP.get(type);
                if (x == null) continue;
                x.add(this, path);
            }
        }
        return this;
    }

    public List<String> getCodes() {
        return this.m_codes;
    }

    public List<String> getResources() {
        return this.m_resources;
    }

    public List<String> getCalendars() {
        return this.m_calendars;
    }

    static {
        TYPE_MAP.put("CLD", (d, c) -> d.m_calendars.add(c));
        TYPE_MAP.put("RDS", (d, c) -> d.m_resources.add(c));
        TYPE_MAP.put("COD", (d, c) -> d.m_codes.add(c));
    }

    private static interface StoreDirectoryName {
        public void add(DependenciesReader var1, String var2);
    }
}

