/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.openplan;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.mpxj.MPXJException;
import org.mpxj.ProjectFile;
import org.mpxj.common.AutoCloseableHelper;
import org.mpxj.openplan.OpenPlanException;
import org.mpxj.openplan.ProjectDirectoryReader;
import org.mpxj.reader.AbstractProjectStreamReader;

public final class OpenPlanReader
extends AbstractProjectStreamReader {
    @Override
    public ProjectFile read(InputStream is) throws MPXJException {
        try {
            return this.read(new POIFSFileSystem(is));
        }
        catch (IOException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        List<ProjectFile> projects = this.readAll(file);
        return projects.isEmpty() ? null : projects.get(0);
    }

    @Override
    public List<ProjectFile> readAll(File file) throws MPXJException {
        List<ProjectFile> list;
        POIFSFileSystem fs = null;
        try {
            fs = new POIFSFileSystem(file);
            list = this.readAll(fs);
        }
        catch (IOException ex) {
            try {
                throw new MPXJException("Error reading file", ex);
            }
            catch (Throwable throwable) {
                AutoCloseableHelper.closeQuietly(fs);
                throw throwable;
            }
        }
        AutoCloseableHelper.closeQuietly((AutoCloseable)fs);
        return list;
    }

    public ProjectFile read(POIFSFileSystem fs) throws MPXJException {
        List<ProjectFile> projects = this.readAll(fs);
        return projects.isEmpty() ? null : projects.get(0);
    }

    public List<ProjectFile> readAll(POIFSFileSystem fs) throws MPXJException {
        try {
            return this.processProjects((DirectoryEntry)fs.getRoot());
        }
        catch (OpenPlanException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    private List<ProjectFile> processProjects(DirectoryEntry root) {
        return root.getEntryNames().stream().filter(s -> s.toUpperCase().endsWith("_PRJ")).map(s -> this.processProject(root, (String)s)).collect(Collectors.toList());
    }

    private ProjectFile processProject(DirectoryEntry root, String name) {
        return new ProjectDirectoryReader(root).read(name);
    }
}

