/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.openplan;

import java.util.Arrays;
import java.util.UUID;

final class UuidHelper {
    private static final char PADDING = ' ';
    private static final int PADDING_VALUE = 127;
    private static final char[] ENCODE_MAP = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '{', '|', '}', '~', '!', '#', '$', '%', '&', '(', ')', '*', '+', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@'};
    private static final byte[] DECODE_MAP = new byte[255];

    private UuidHelper() {
    }

    public static String print(UUID value) {
        byte[] data = new byte[16];
        long lsb = value.getLeastSignificantBits();
        long msb = value.getMostSignificantBits();
        data[15] = (byte)(lsb & 0xFFL);
        data[14] = (byte)(lsb >> 8 & 0xFFL);
        data[13] = (byte)(lsb >> 16 & 0xFFL);
        data[12] = (byte)(lsb >> 24 & 0xFFL);
        data[11] = (byte)(lsb >> 32 & 0xFFL);
        data[10] = (byte)(lsb >> 40 & 0xFFL);
        data[9] = (byte)(lsb >> 48 & 0xFFL);
        data[8] = (byte)(lsb >> 56 & 0xFFL);
        data[6] = (byte)(msb & 0xFFL);
        data[7] = (byte)(msb >> 8 & 0xFFL);
        data[4] = (byte)(msb >> 16 & 0xFFL);
        data[5] = (byte)(msb >> 24 & 0xFFL);
        data[0] = (byte)(msb >> 32 & 0xFFL);
        data[1] = (byte)(msb >> 40 & 0xFFL);
        data[2] = (byte)(msb >> 48 & 0xFFL);
        data[3] = (byte)(msb >> 56 & 0xFFL);
        char[] buf = new char[24];
        int remaining = data.length;
        int ptr = 0;
        int i = 0;
        while (remaining >= 3) {
            buf[ptr++] = UuidHelper.encode(data[i] >> 2);
            buf[ptr++] = UuidHelper.encode((data[i] & 3) << 4 | data[i + 1] >> 4 & 0xF);
            buf[ptr++] = UuidHelper.encode((data[i + 1] & 0xF) << 2 | data[i + 2] >> 6 & 3);
            buf[ptr++] = UuidHelper.encode(data[i + 2] & 0x3F);
            remaining -= 3;
            i += 3;
        }
        if (remaining == 1) {
            buf[ptr++] = UuidHelper.encode(data[i] >> 2);
            buf[ptr++] = UuidHelper.encode((data[i] & 3) << 4);
            buf[ptr++] = 32;
            buf[ptr] = 32;
        } else if (remaining == 2) {
            buf[ptr++] = UuidHelper.encode(data[i] >> 2);
            buf[ptr++] = UuidHelper.encode((data[i] & 3) << 4 | data[i + 1] >> 4 & 0xF);
            buf[ptr++] = UuidHelper.encode((data[i + 1] & 0xF) << 2);
            buf[ptr] = 32;
        }
        return new String(buf);
    }

    public static UUID parse(String text) {
        byte[] data = new byte[16];
        int o = 0;
        int len = text.length();
        byte[] quadruplet = new byte[4];
        int q = 0;
        for (int i = 0; i < len; ++i) {
            char ch = text.charAt(i);
            byte v = DECODE_MAP[ch];
            if (v != -1) {
                quadruplet[q++] = v;
            }
            if (q != 4) continue;
            data[o++] = (byte)(quadruplet[0] << 2 | quadruplet[1] >> 4);
            if (quadruplet[2] != 127) {
                data[o++] = (byte)(quadruplet[1] << 4 | quadruplet[2] >> 2);
            }
            if (quadruplet[3] != 127) {
                data[o++] = (byte)(quadruplet[2] << 6 | quadruplet[3]);
            }
            q = 0;
        }
        long msb = data[3] & 0xFF;
        msb = msb << 8 | (long)(data[2] & 0xFF);
        msb = msb << 8 | (long)(data[1] & 0xFF);
        msb = msb << 8 | (long)(data[0] & 0xFF);
        msb = msb << 8 | (long)(data[5] & 0xFF);
        msb = msb << 8 | (long)(data[4] & 0xFF);
        msb = msb << 8 | (long)(data[7] & 0xFF);
        msb = msb << 8 | (long)(data[6] & 0xFF);
        long lsb = 0L;
        for (int i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    private static char encode(int i) {
        return ENCODE_MAP[i & 0x3F];
    }

    static {
        Arrays.fill(DECODE_MAP, (byte)-1);
        for (int loop = 0; loop < ENCODE_MAP.length; loop = (int)((byte)(loop + 1))) {
            UuidHelper.DECODE_MAP[UuidHelper.ENCODE_MAP[loop]] = loop;
        }
        UuidHelper.DECODE_MAP[32] = 127;
    }
}

