/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.phoenix;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.mpxj.Duration;
import org.mpxj.RelationType;
import org.mpxj.ResourceType;
import org.mpxj.TimeUnit;
import org.mpxj.common.LocalDateTimeHelper;

public final class DatatypeConverter {
    private static final Map<String, ResourceType> STRING_TO_RESOURCE_TYPE_MAP = new HashMap<String, ResourceType>();
    private static final Map<ResourceType, String> RESOURCE_TYPE_TO_STRING_MAP;
    private static final Map<String, TimeUnit> STRING_TO_TIME_UNITS_MAP;
    private static final Map<TimeUnit, String> TIME_UNITS_TO_STRING_MAP;
    private static final Map<String, RelationType> NAME_TO_RELATION_TYPE;
    private static final Map<RelationType, String> RELATION_TYPE_TO_NAME;
    private static final Map<String, DayOfWeek> NAME_TO_DAY;
    private static final Map<DayOfWeek, String> DAY_TO_NAME;
    private static final String NOT_A_DATE_TIME = "not-a-date-time";
    private static final String PLUS_INFINITY = "+infinity";
    private static final DateTimeFormatter DATE_FORMAT;

    public static final UUID parseUUID(String value) {
        return UUID.fromString(value);
    }

    public static String printUUID(UUID guid) {
        return guid.toString();
    }

    public static final String printInteger(Integer value) {
        return value == null ? null : value.toString();
    }

    public static final Integer parseInteger(String value) {
        return Integer.valueOf(value);
    }

    public static final ResourceType parseResourceType(String value) {
        return STRING_TO_RESOURCE_TYPE_MAP.get(value);
    }

    public static final String printResourceType(ResourceType type) {
        return RESOURCE_TYPE_TO_STRING_MAP.get(type);
    }

    public static final RelationType parseRelationType(String value) {
        return NAME_TO_RELATION_TYPE.get(value);
    }

    public static final String printRelationType(RelationType type) {
        return RELATION_TYPE_TO_NAME.get(type);
    }

    public static final TimeUnit parseTimeUnits(String value) {
        return STRING_TO_TIME_UNITS_MAP.get(value);
    }

    public static final String printTimeUnits(TimeUnit type) {
        return TIME_UNITS_TO_STRING_MAP.get(type);
    }

    public static final String printDateTime(LocalDateTime value) {
        return value == null ? null : DATE_FORMAT.format(value);
    }

    public static final LocalDateTime parseDateTime(String value) {
        if (value == null || value.isEmpty() || value.equals(NOT_A_DATE_TIME)) {
            return null;
        }
        if (value.equals(PLUS_INFINITY)) {
            return LocalDateTimeHelper.END_DATE_NA;
        }
        LocalDateTime result = null;
        try {
            result = LocalDateTime.parse(value, DATE_FORMAT);
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        return result;
    }

    public static final Duration parseDuration(String value) {
        int split;
        Duration result = null;
        if (value != null && (split = value.indexOf(32)) != -1) {
            double durationValue = Double.parseDouble(value.substring(0, split));
            TimeUnit durationUnits = DatatypeConverter.parseTimeUnits(value.substring(split + 1));
            result = Duration.getInstance(durationValue, durationUnits);
        }
        return result;
    }

    public static final String printDuration(Duration duration) {
        String result = null;
        if (duration != null) {
            result = duration.getDuration() + " " + DatatypeConverter.printTimeUnits(duration.getUnits());
        }
        return result;
    }

    public static final DayOfWeek parseDay(String value) {
        return NAME_TO_DAY.get(value);
    }

    public static final String printFinishDateTime(LocalDateTime value) {
        if (value != null) {
            value = value.plusDays(1L);
        }
        return value == null ? null : DATE_FORMAT.format(value);
    }

    public static final LocalDateTime parseFinishDateTime(String value) {
        LocalDateTime result = DatatypeConverter.parseDateTime(value);
        if (result != null) {
            result = result.minusDays(1L);
        }
        return result;
    }

    public static final String printDay(DayOfWeek value) {
        return DAY_TO_NAME.get(value);
    }

    static {
        STRING_TO_RESOURCE_TYPE_MAP.put("Labor", ResourceType.WORK);
        STRING_TO_RESOURCE_TYPE_MAP.put("Non-Labor", ResourceType.MATERIAL);
        RESOURCE_TYPE_TO_STRING_MAP = new EnumMap<ResourceType, String>(ResourceType.class);
        RESOURCE_TYPE_TO_STRING_MAP.put(ResourceType.WORK, "Labor");
        RESOURCE_TYPE_TO_STRING_MAP.put(ResourceType.MATERIAL, "Non-Labor");
        RESOURCE_TYPE_TO_STRING_MAP.put(ResourceType.COST, "Non-Labor");
        STRING_TO_TIME_UNITS_MAP = new HashMap<String, TimeUnit>();
        STRING_TO_TIME_UNITS_MAP.put("Days", TimeUnit.DAYS);
        STRING_TO_TIME_UNITS_MAP.put("days", TimeUnit.DAYS);
        STRING_TO_TIME_UNITS_MAP.put("day", TimeUnit.DAYS);
        TIME_UNITS_TO_STRING_MAP = new EnumMap<TimeUnit, String>(TimeUnit.class);
        TIME_UNITS_TO_STRING_MAP.put(TimeUnit.DAYS, "Days");
        NAME_TO_RELATION_TYPE = new HashMap<String, RelationType>();
        NAME_TO_RELATION_TYPE.put("FinishToFinish", RelationType.FINISH_FINISH);
        NAME_TO_RELATION_TYPE.put("FinishToStart", RelationType.FINISH_START);
        NAME_TO_RELATION_TYPE.put("StartToFinish", RelationType.START_FINISH);
        NAME_TO_RELATION_TYPE.put("StartToStart", RelationType.START_START);
        RELATION_TYPE_TO_NAME = new HashMap<RelationType, String>();
        RELATION_TYPE_TO_NAME.put(RelationType.FINISH_FINISH, "FinishToFinish");
        RELATION_TYPE_TO_NAME.put(RelationType.FINISH_START, "FinishToStart");
        RELATION_TYPE_TO_NAME.put(RelationType.START_FINISH, "StartToFinish");
        RELATION_TYPE_TO_NAME.put(RelationType.START_START, "StartToStart");
        NAME_TO_DAY = new HashMap<String, DayOfWeek>();
        NAME_TO_DAY.put("Mon", DayOfWeek.MONDAY);
        NAME_TO_DAY.put("Tue", DayOfWeek.TUESDAY);
        NAME_TO_DAY.put("Wed", DayOfWeek.WEDNESDAY);
        NAME_TO_DAY.put("Thu", DayOfWeek.THURSDAY);
        NAME_TO_DAY.put("Fri", DayOfWeek.FRIDAY);
        NAME_TO_DAY.put("Sat", DayOfWeek.SATURDAY);
        NAME_TO_DAY.put("Sun", DayOfWeek.SUNDAY);
        DAY_TO_NAME = new HashMap<DayOfWeek, String>();
        DAY_TO_NAME.put(DayOfWeek.MONDAY, "Mon");
        DAY_TO_NAME.put(DayOfWeek.TUESDAY, "Tue");
        DAY_TO_NAME.put(DayOfWeek.WEDNESDAY, "Wed");
        DAY_TO_NAME.put(DayOfWeek.THURSDAY, "Thu");
        DAY_TO_NAME.put(DayOfWeek.FRIDAY, "Fri");
        DAY_TO_NAME.put(DayOfWeek.SATURDAY, "Sat");
        DAY_TO_NAME.put(DayOfWeek.SUNDAY, "Sun");
        DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss[.SSSSSS]");
    }
}

