/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.phoenix;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.mpxj.MPXJException;
import org.mpxj.ProjectFile;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.UnmarshalHelper;
import org.mpxj.phoenix.Phoenix4ProjectReader;
import org.mpxj.phoenix.SkipNulInputStream;
import org.mpxj.phoenix.schema.phoenix4.Project;
import org.mpxj.reader.AbstractProjectStreamReader;
import org.xml.sax.SAXException;

final class Phoenix4Reader
extends AbstractProjectStreamReader {
    private final boolean m_useActivityCodesForTaskHierarchy;
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;

    public Phoenix4Reader(boolean useActivityCodesForTaskHierarchy) {
        this.m_useActivityCodesForTaskHierarchy = useActivityCodesForTaskHierarchy;
    }

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            Project phoenixProject = (Project)UnmarshalHelper.unmarshal(CONTEXT, new SkipNulInputStream(stream));
            Project.Layouts.Layout activeLayout = this.getActiveLayout(phoenixProject);
            Project.Storepoints.Storepoint storepoint = this.getCurrentStorepoint(phoenixProject);
            return new Phoenix4ProjectReader(this.m_useActivityCodesForTaskHierarchy).read(phoenixProject, activeLayout, storepoint);
        }
        catch (JAXBException | ParserConfigurationException | SAXException ex) {
            throw new MPXJException("Failed to parse file", (Exception)ex);
        }
    }

    private Project.Storepoints.Storepoint getCurrentStorepoint(Project phoenixProject) {
        List<Project.Storepoints.Storepoint> storepoints = phoenixProject.getStorepoints().getStorepoint();
        storepoints.sort((o1, o2) -> LocalDateTimeHelper.compare(o2.getCreationTime(), o1.getCreationTime()));
        return storepoints.get(0);
    }

    private Project.Layouts.Layout getActiveLayout(Project phoenixProject) {
        Project.Layouts.Layout activeLayout = phoenixProject.getLayouts().getLayout().get(0);
        if (!activeLayout.isActive().booleanValue()) {
            for (Project.Layouts.Layout layout : phoenixProject.getLayouts().getLayout()) {
                if (!layout.isActive().booleanValue()) continue;
                activeLayout = layout;
                break;
            }
        }
        return activeLayout;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"org.mpxj.phoenix.schema.phoenix4", (ClassLoader)Phoenix4Reader.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
    }
}

