/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.phoenix;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mpxj.MPXJException;
import org.mpxj.ProjectFile;
import org.mpxj.common.CharsetHelper;
import org.mpxj.common.SemVer;
import org.mpxj.phoenix.Phoenix4Reader;
import org.mpxj.phoenix.Phoenix5Reader;
import org.mpxj.reader.AbstractProjectStreamReader;

public final class PhoenixReader
extends AbstractProjectStreamReader {
    private boolean m_useActivityCodesForTaskHierarchy = true;
    private static final int BUFFER_SIZE = 512;
    private static final Pattern VERSION_PATTERN = Pattern.compile(".*<project.* version=\"((?:\\d\\.)*\\d*)\".*", 32);
    private static final SemVer VERSION_4 = new SemVer(4);
    private static final SemVer VERSION_5 = new SemVer(5);

    public boolean getUseActivityCodesForTaskHierarchy() {
        return this.m_useActivityCodesForTaskHierarchy;
    }

    public void setUseActivityCodesForTaskHierarchy(boolean useActivityCodesForTaskHierarchy) {
        this.m_useActivityCodesForTaskHierarchy = useActivityCodesForTaskHierarchy;
    }

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            BufferedInputStream bis = new BufferedInputStream(stream);
            bis.mark(512);
            byte[] buffer = new byte[512];
            int bytesRead = bis.read(buffer);
            bis.reset();
            if (bytesRead != 512) {
                return null;
            }
            Matcher matcher = VERSION_PATTERN.matcher(new String(buffer, CharsetHelper.UTF8));
            SemVer version = matcher.find() ? new SemVer(matcher.group(1)) : VERSION_4;
            return (version.before(VERSION_5) ? new Phoenix4Reader(this.m_useActivityCodesForTaskHierarchy) : new Phoenix5Reader(this.m_useActivityCodesForTaskHierarchy)).read(bis);
        }
        catch (Exception ex) {
            throw new MPXJException("Invalid file format", ex);
        }
    }
}

