/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.planner;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.InputStream;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import org.mpxj.ConstraintType;
import org.mpxj.DayType;
import org.mpxj.Duration;
import org.mpxj.EventManager;
import org.mpxj.LocalTimeRange;
import org.mpxj.MPXJException;
import org.mpxj.Priority;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectConfig;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Relation;
import org.mpxj.RelationType;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceType;
import org.mpxj.TaskType;
import org.mpxj.TimeUnit;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.UnmarshalHelper;
import org.mpxj.planner.schema.Allocation;
import org.mpxj.planner.schema.Allocations;
import org.mpxj.planner.schema.Calendar;
import org.mpxj.planner.schema.Calendars;
import org.mpxj.planner.schema.Constraint;
import org.mpxj.planner.schema.Day;
import org.mpxj.planner.schema.Days;
import org.mpxj.planner.schema.DefaultWeek;
import org.mpxj.planner.schema.Interval;
import org.mpxj.planner.schema.OverriddenDayType;
import org.mpxj.planner.schema.Predecessor;
import org.mpxj.planner.schema.Predecessors;
import org.mpxj.planner.schema.Project;
import org.mpxj.planner.schema.Resources;
import org.mpxj.planner.schema.Task;
import org.mpxj.planner.schema.Tasks;
import org.mpxj.reader.AbstractProjectStreamReader;
import org.xml.sax.SAXException;

public final class PlannerReader
extends AbstractProjectStreamReader {
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private ProjectCalendar m_defaultCalendar;
    private final DateTimeFormatter m_timeFormat = DateTimeFormatter.ofPattern("HHmm");
    private final DateTimeFormatter m_dateFormat = DateTimeFormatter.ofPattern("yyyyMMdd");
    private final DateTimeFormatter m_dateTimeFormat = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'");
    private static final Map<String, RelationType> RELATIONSHIP_TYPES = new HashMap<String, RelationType>();
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoTaskUniqueID(false);
            config.setAutoResourceUniqueID(false);
            config.setAutoOutlineLevel(false);
            config.setAutoOutlineNumber(false);
            config.setAutoWBS(false);
            config.setAutoCalendarUniqueID(false);
            this.m_projectFile.getProjectProperties().setFileApplication("Planner");
            this.m_projectFile.getProjectProperties().setFileType("XML");
            this.addListenersToProject(this.m_projectFile);
            Project plannerProject = (Project)UnmarshalHelper.unmarshal(CONTEXT, stream);
            this.readProjectProperties(plannerProject);
            this.readCalendars(plannerProject);
            this.readResources(plannerProject);
            this.readTasks(plannerProject);
            this.readAssignments(plannerProject);
            this.m_projectFile.readComplete();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (JAXBException | ParserConfigurationException | SAXException ex) {
            throw new MPXJException("Failed to parse file", (Exception)ex);
        }
        finally {
            this.m_projectFile = null;
            this.m_defaultCalendar = null;
        }
    }

    private void readProjectProperties(Project project) {
        ProjectProperties properties = this.m_projectFile.getProjectProperties();
        properties.setCompany(project.getCompany());
        properties.setManager(project.getManager());
        properties.setName(project.getName());
        properties.setStartDate(this.getDateTime(project.getProjectStart()));
    }

    private void readCalendars(Project project) {
        Calendars calendars = project.getCalendars();
        if (calendars != null) {
            for (Calendar cal : calendars.getCalendar()) {
                this.readCalendar(cal, null);
            }
        }
        Integer defaultCalendarID = this.getInteger(project.getCalendar());
        this.m_defaultCalendar = this.m_projectFile.getCalendarByUniqueID(defaultCalendarID);
        if (this.m_defaultCalendar == null) {
            this.m_defaultCalendar = this.m_projectFile.addDefaultBaseCalendar();
            this.m_defaultCalendar.setUniqueID(this.m_projectFile.getUniqueIdObjectSequence(ProjectCalendar.class).getNext());
        }
        this.m_projectFile.getProjectProperties().setDefaultCalendar(this.m_defaultCalendar);
    }

    private void readCalendar(Calendar plannerCalendar, ProjectCalendar parentMpxjCalendar) {
        ProjectCalendar mpxjCalendar = this.m_projectFile.addCalendar();
        mpxjCalendar.setUniqueID(this.getInteger(plannerCalendar.getId()));
        mpxjCalendar.setName(plannerCalendar.getName());
        mpxjCalendar.setParent(parentMpxjCalendar);
        Map<String, List<LocalTimeRange>> map = this.getHoursMap(plannerCalendar);
        DefaultWeek dw = plannerCalendar.getDefaultWeek();
        this.setHours(map, mpxjCalendar, DayOfWeek.MONDAY, dw.getMon());
        this.setHours(map, mpxjCalendar, DayOfWeek.TUESDAY, dw.getTue());
        this.setHours(map, mpxjCalendar, DayOfWeek.WEDNESDAY, dw.getWed());
        this.setHours(map, mpxjCalendar, DayOfWeek.THURSDAY, dw.getThu());
        this.setHours(map, mpxjCalendar, DayOfWeek.FRIDAY, dw.getFri());
        this.setHours(map, mpxjCalendar, DayOfWeek.SATURDAY, dw.getSat());
        this.setHours(map, mpxjCalendar, DayOfWeek.SUNDAY, dw.getSun());
        this.processExceptionDays(map, mpxjCalendar, plannerCalendar);
        this.m_eventManager.fireCalendarReadEvent(mpxjCalendar);
        List<Calendar> calendarList = plannerCalendar.getCalendar();
        for (Calendar cal : calendarList) {
            this.readCalendar(cal, mpxjCalendar);
        }
    }

    private Map<String, List<LocalTimeRange>> getHoursMap(Calendar plannerCalendar) {
        HashMap<String, List<LocalTimeRange>> result = new HashMap<String, List<LocalTimeRange>>();
        for (OverriddenDayType type : plannerCalendar.getOverriddenDayTypes().getOverriddenDayType()) {
            ArrayList<LocalTimeRange> hours = new ArrayList<LocalTimeRange>();
            for (Interval interval : type.getInterval()) {
                hours.add(new LocalTimeRange(this.getTime(interval.getStart()), this.getTime(interval.getEnd())));
            }
            result.put(type.getId(), hours);
        }
        return result;
    }

    private void setHours(Map<String, List<LocalTimeRange>> map, ProjectCalendar mpxjCalendar, DayOfWeek mpxjDay, String plannerDay) {
        List<LocalTimeRange> dateRanges = map.get(plannerDay);
        if (dateRanges == null) {
            if (mpxjCalendar.getParent() == null || !plannerDay.equals("2")) {
                mpxjCalendar.setCalendarDayType(mpxjDay, DayType.NON_WORKING);
                mpxjCalendar.addCalendarHours(mpxjDay);
            } else {
                mpxjCalendar.setCalendarDayType(mpxjDay, DayType.DEFAULT);
            }
        } else {
            mpxjCalendar.setCalendarDayType(mpxjDay, DayType.WORKING);
            ProjectCalendarHours hours = mpxjCalendar.addCalendarHours(mpxjDay);
            hours.addAll(dateRanges);
        }
    }

    private void processExceptionDays(Map<String, List<LocalTimeRange>> map, ProjectCalendar mpxjCalendar, Calendar plannerCalendar) {
        Days days = plannerCalendar.getDays();
        if (days != null) {
            List<Day> dayList = days.getDay();
            for (Day day : dayList) {
                if (!day.getType().equals("day-type")) continue;
                LocalDate exceptionDate = LocalDate.parse(day.getDate(), this.m_dateFormat);
                ProjectCalendarException exception = mpxjCalendar.addCalendarException(exceptionDate);
                List<LocalTimeRange> dateRanges = map.get(day.getId());
                if (dateRanges == null) continue;
                exception.addAll(dateRanges);
            }
        }
    }

    private void readResources(Project plannerProject) {
        Resources resources = plannerProject.getResources();
        if (resources != null) {
            for (org.mpxj.planner.schema.Resource res : resources.getResource()) {
                this.readResource(res);
            }
        }
    }

    private void readResource(org.mpxj.planner.schema.Resource plannerResource) {
        Resource mpxjResource = this.m_projectFile.addResource();
        mpxjResource.setEmailAddress(plannerResource.getEmail());
        mpxjResource.setUniqueID(this.getInteger(plannerResource.getId()));
        mpxjResource.setName(plannerResource.getName());
        mpxjResource.setNotes(plannerResource.getNote());
        mpxjResource.setInitials(plannerResource.getShortName());
        mpxjResource.setType(this.getResourceType(plannerResource.getType()));
        mpxjResource.setCalendar(this.m_projectFile.getCalendarByUniqueID(this.getInteger(plannerResource.getCalendar())));
        this.m_eventManager.fireResourceReadEvent(mpxjResource);
    }

    private void readTasks(Project plannerProject) {
        Tasks tasks = plannerProject.getTasks();
        if (tasks != null) {
            for (Task task : tasks.getTask()) {
                this.readTask(null, task);
            }
            for (Task task : tasks.getTask()) {
                this.readPredecessors(task);
            }
        }
        this.m_projectFile.updateStructure();
    }

    private void readTask(org.mpxj.Task parentTask, Task plannerTask) {
        org.mpxj.Task mpxjTask;
        if (parentTask == null) {
            mpxjTask = this.m_projectFile.addTask();
            mpxjTask.setOutlineLevel(1);
        } else {
            mpxjTask = parentTask.addTask();
            mpxjTask.setOutlineLevel(parentTask.getOutlineLevel() + 1);
        }
        Integer percentComplete = this.getPercentComplete(plannerTask.getPercentComplete());
        mpxjTask.setFinish(this.getDateTime(plannerTask.getEnd()));
        mpxjTask.setUniqueID(this.getInteger(plannerTask.getId()));
        mpxjTask.setName(plannerTask.getName());
        mpxjTask.setNotes(plannerTask.getNote());
        mpxjTask.setPercentageComplete(percentComplete);
        mpxjTask.setPercentageWorkComplete(percentComplete);
        mpxjTask.setPriority(this.getPriority(plannerTask.getPriority()));
        mpxjTask.setType(this.getTaskType(plannerTask.getScheduling()));
        mpxjTask.setStart(this.getDateTime(Optional.ofNullable(plannerTask.getWorkStart()).orElse(plannerTask.getStart())));
        mpxjTask.setMilestone(plannerTask.getType().equals("milestone"));
        mpxjTask.setWork(this.getDuration(plannerTask.getWork()));
        String wbs = plannerTask.getWbs();
        if (wbs != null && !wbs.isEmpty()) {
            mpxjTask.setWBS(wbs);
        }
        ConstraintType mpxjConstraintType = ConstraintType.AS_SOON_AS_POSSIBLE;
        Constraint constraint = plannerTask.getConstraint();
        if (constraint != null) {
            if (constraint.getType().equals("start-no-earlier-than")) {
                mpxjConstraintType = ConstraintType.START_NO_EARLIER_THAN;
            } else if (constraint.getType().equals("must-start-on")) {
                mpxjConstraintType = ConstraintType.MUST_START_ON;
            }
            mpxjTask.setConstraintDate(this.getDateTime(constraint.getTime()));
        }
        mpxjTask.setConstraintType(mpxjConstraintType);
        ProjectCalendar calendar = this.m_projectFile.getDefaultCalendar();
        if (calendar != null) {
            Duration duration = calendar.getWork(mpxjTask.getStart(), mpxjTask.getFinish(), TimeUnit.HOURS);
            double durationDays = duration.getDuration() / 8.0;
            if (durationDays > 0.0) {
                duration = Duration.getInstance(durationDays, TimeUnit.DAYS);
            }
            mpxjTask.setDuration(duration);
            if (percentComplete != 0) {
                mpxjTask.setActualStart(mpxjTask.getStart());
                if (percentComplete == 100) {
                    mpxjTask.setActualFinish(mpxjTask.getFinish());
                    mpxjTask.setActualDuration(duration);
                    mpxjTask.setActualWork(mpxjTask.getWork());
                    mpxjTask.setRemainingWork(Duration.getInstance(0, TimeUnit.HOURS));
                } else {
                    Duration work = mpxjTask.getWork();
                    Duration actualWork = Duration.getInstance(work.getDuration() * percentComplete.doubleValue() / 100.0, work.getUnits());
                    mpxjTask.setActualDuration(Duration.getInstance(duration.getDuration() * percentComplete.doubleValue() / 100.0, duration.getUnits()));
                    mpxjTask.setActualWork(actualWork);
                    mpxjTask.setRemainingWork(Duration.getInstance(work.getDuration() - actualWork.getDuration(), work.getUnits()));
                }
            }
        }
        mpxjTask.setEffortDriven(true);
        this.m_eventManager.fireTaskReadEvent(mpxjTask);
        List<Task> childTasks = plannerTask.getTask();
        for (Task childTask : childTasks) {
            this.readTask(mpxjTask, childTask);
        }
    }

    private void readPredecessors(Task plannerTask) {
        org.mpxj.Task mpxjTask = this.m_projectFile.getTaskByUniqueID(this.getInteger(plannerTask.getId()));
        Predecessors predecessors = plannerTask.getPredecessors();
        if (predecessors != null) {
            List<Predecessor> predecessorList = predecessors.getPredecessor();
            for (Predecessor predecessor : predecessorList) {
                Integer predecessorID = this.getInteger(predecessor.getPredecessorId());
                org.mpxj.Task predecessorTask = this.m_projectFile.getTaskByUniqueID(predecessorID);
                if (predecessorTask == null) continue;
                Relation relation = mpxjTask.addPredecessor(new Relation.Builder().predecessorTask(predecessorTask).type(RELATIONSHIP_TYPES.get(predecessor.getType())).lag(this.getLagDuration(predecessor.getLag())));
                this.m_eventManager.fireRelationReadEvent(relation);
            }
        }
        List<Task> childTasks = plannerTask.getTask();
        for (Task childTask : childTasks) {
            this.readPredecessors(childTask);
        }
    }

    private void readAssignments(Project plannerProject) {
        Allocations allocations = plannerProject.getAllocations();
        if (allocations != null) {
            Duration actualWork;
            Duration work;
            List<Allocation> allocationList = allocations.getAllocation();
            HashSet<org.mpxj.Task> tasksWithAssignments = new HashSet<org.mpxj.Task>();
            for (Allocation allocation : allocationList) {
                Integer taskID = this.getInteger(allocation.getTaskId());
                Integer resourceID = this.getInteger(allocation.getResourceId());
                Integer units = this.getResourceAssignmentUnits(allocation.getUnits());
                org.mpxj.Task task = this.m_projectFile.getTaskByUniqueID(taskID);
                Resource resource = this.m_projectFile.getResourceByUniqueID(resourceID);
                if (task == null || resource == null) continue;
                work = task.getWork();
                int percentComplete = NumberHelper.getInt(task.getPercentageComplete());
                ResourceAssignment assignment = task.addResourceAssignment(resource);
                assignment.setUnits(units);
                assignment.setWork(work);
                if (percentComplete != 0) {
                    actualWork = Duration.getInstance(work.getDuration() * (double)percentComplete / 100.0, work.getUnits());
                    assignment.setActualWork(actualWork);
                    assignment.setRemainingWork(Duration.getInstance(work.getDuration() - actualWork.getDuration(), work.getUnits()));
                } else {
                    assignment.setRemainingWork(work);
                }
                assignment.setStart(task.getStart());
                assignment.setFinish(task.getFinish());
                tasksWithAssignments.add(task);
                this.m_eventManager.fireAssignmentReadEvent(assignment);
            }
            for (org.mpxj.Task task : tasksWithAssignments) {
                List<ResourceAssignment> assignments = task.getResourceAssignments();
                if (assignments.size() <= 1) continue;
                double maxUnits = 0.0;
                for (ResourceAssignment assignment : assignments) {
                    maxUnits += assignment.getUnits().doubleValue();
                }
                for (ResourceAssignment assignment : assignments) {
                    Duration remainingWork;
                    work = assignment.getWork();
                    double factor = assignment.getUnits().doubleValue() / maxUnits;
                    work = Duration.getInstance(work.getDuration() * factor, work.getUnits());
                    assignment.setWork(work);
                    actualWork = assignment.getActualWork();
                    if (actualWork != null) {
                        actualWork = Duration.getInstance(actualWork.getDuration() * factor, actualWork.getUnits());
                        assignment.setActualWork(actualWork);
                    }
                    if ((remainingWork = assignment.getRemainingWork()) == null) continue;
                    remainingWork = Duration.getInstance(remainingWork.getDuration() * factor, remainingWork.getUnits());
                    assignment.setRemainingWork(remainingWork);
                }
            }
        }
    }

    private LocalDateTime getDateTime(String value) {
        if (value == null) {
            return null;
        }
        return LocalDateTime.parse(value, this.m_dateTimeFormat);
    }

    private LocalTime getTime(String value) {
        return LocalTime.parse(value, this.m_timeFormat);
    }

    private Integer getInteger(String value) {
        return NumberHelper.getInteger(value);
    }

    private int getInt(String value) {
        return Integer.parseInt(value);
    }

    private long getLong(String value) {
        return Long.parseLong(value);
    }

    private TaskType getTaskType(String value) {
        TaskType result = TaskType.FIXED_UNITS;
        if (value != null && value.equals("fixed-duration")) {
            result = TaskType.FIXED_DURATION;
        }
        return result;
    }

    private Duration getDuration(String value) {
        Duration result = null;
        if (value != null && !value.isEmpty()) {
            double seconds = this.getLong(value);
            double hours = seconds / 3600.0;
            double days = hours / 8.0;
            if (days < 1.0) {
                result = Duration.getInstance(hours, TimeUnit.HOURS);
            } else {
                double durationDays = hours / 8.0;
                result = Duration.getInstance(durationDays, TimeUnit.DAYS);
            }
        }
        return result;
    }

    private Duration getLagDuration(String value) {
        Duration result = null;
        if (value != null && !value.isEmpty()) {
            double seconds = this.getLong(value);
            double hours = seconds / 3600.0;
            result = Duration.getInstance(hours, TimeUnit.ELAPSED_HOURS);
        }
        return result;
    }

    private Priority getPriority(String value) {
        int priority = value == null ? 500 : this.getInt(value) / 10;
        return Priority.getInstance(priority);
    }

    private Integer getPercentComplete(String value) {
        return value == null ? Integer.valueOf(0) : this.getInteger(value);
    }

    private ResourceType getResourceType(String value) {
        return value == null ? ResourceType.WORK : (this.getInt(value) == 2 ? ResourceType.MATERIAL : ResourceType.WORK);
    }

    private Integer getResourceAssignmentUnits(String value) {
        return value == null ? Integer.valueOf(100) : this.getInteger(value);
    }

    static {
        RELATIONSHIP_TYPES.put("FF", RelationType.FINISH_FINISH);
        RELATIONSHIP_TYPES.put("FS", RelationType.FINISH_START);
        RELATIONSHIP_TYPES.put("SF", RelationType.START_FINISH);
        RELATIONSHIP_TYPES.put("SS", RelationType.START_START);
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"org.mpxj.planner.schema", (ClassLoader)PlannerReader.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
    }
}

