/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.planner;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mpxj.ConstraintType;
import org.mpxj.DayType;
import org.mpxj.Duration;
import org.mpxj.EventManager;
import org.mpxj.LocalTimeRange;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Relation;
import org.mpxj.RelationType;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceType;
import org.mpxj.TaskType;
import org.mpxj.TimeUnit;
import org.mpxj.common.DayOfWeekHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.MarshallerHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.planner.Sequence;
import org.mpxj.planner.schema.Allocation;
import org.mpxj.planner.schema.Allocations;
import org.mpxj.planner.schema.Calendar;
import org.mpxj.planner.schema.Calendars;
import org.mpxj.planner.schema.Constraint;
import org.mpxj.planner.schema.Day;
import org.mpxj.planner.schema.DayTypes;
import org.mpxj.planner.schema.Days;
import org.mpxj.planner.schema.DefaultWeek;
import org.mpxj.planner.schema.Interval;
import org.mpxj.planner.schema.ObjectFactory;
import org.mpxj.planner.schema.OverriddenDayType;
import org.mpxj.planner.schema.OverriddenDayTypes;
import org.mpxj.planner.schema.Predecessor;
import org.mpxj.planner.schema.Predecessors;
import org.mpxj.planner.schema.Project;
import org.mpxj.planner.schema.Resources;
import org.mpxj.planner.schema.Task;
import org.mpxj.planner.schema.Tasks;
import org.mpxj.writer.AbstractProjectWriter;

public final class PlannerWriter
extends AbstractProjectWriter {
    private Charset m_charset;
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private ObjectFactory m_factory;
    private Project m_plannerProject;
    private final DateTimeFormatter m_timeFormat = DateTimeFormatter.ofPattern("HHmm");
    private final DateTimeFormatter m_dateFormat = DateTimeFormatter.ofPattern("yyyyMMdd");
    private final DateTimeFormatter m_dateTimeFormat = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'");
    private static final Map<RelationType, String> RELATIONSHIP_TYPES = new HashMap<RelationType, String>();
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;

    @Override
    public void write(ProjectFile projectFile, OutputStream stream) throws IOException {
        try {
            this.m_projectFile = projectFile;
            this.m_eventManager = projectFile.getEventManager();
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            Marshaller marshaller = MarshallerHelper.create(CONTEXT);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            if (this.m_charset != null) {
                marshaller.setProperty("jaxb.encoding", (Object)this.m_charset.name());
            }
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            this.m_factory = new ObjectFactory();
            this.m_plannerProject = this.m_factory.createProject();
            this.writeProjectProperties();
            this.writeCalendars();
            this.writeResources();
            this.writeTasks();
            this.writeAssignments();
            marshaller.marshal((Object)this.m_plannerProject, stream);
        }
        catch (JAXBException ex) {
            throw new IOException(ex.toString());
        }
        finally {
            this.m_projectFile = null;
            this.m_factory = null;
            this.m_plannerProject = null;
        }
    }

    private void writeProjectProperties() {
        ProjectProperties properties = this.m_projectFile.getProjectProperties();
        String projectStart = properties.getStartDate() == null ? "" : this.getDateTimeString(properties.getStartDate());
        this.m_plannerProject.setCompany(properties.getCompany());
        this.m_plannerProject.setManager(properties.getManager());
        this.m_plannerProject.setName(this.getString(properties.getName()));
        this.m_plannerProject.setProjectStart(projectStart);
        this.m_plannerProject.setCalendar(this.getIntegerString(this.m_projectFile.getProjectProperties().getDefaultCalendarUniqueID()));
        this.m_plannerProject.setMrprojectVersion("2");
    }

    private void writeCalendars() {
        Calendars calendars = this.m_factory.createCalendars();
        this.m_plannerProject.setCalendars(calendars);
        this.writeDayTypes(calendars);
        List<Calendar> calendar = calendars.getCalendar();
        List sortedCalendarList = this.m_projectFile.getCalendars().stream().filter(c -> !c.isDerived()).sorted((a, b) -> NumberHelper.compare(a.getUniqueID(), b.getUniqueID())).collect(Collectors.toList());
        for (ProjectCalendar mpxjCalendar : sortedCalendarList) {
            Calendar plannerCalendar = this.m_factory.createCalendar();
            calendar.add(plannerCalendar);
            this.writeCalendar(mpxjCalendar, plannerCalendar);
        }
    }

    private void writeDayTypes(Calendars calendars) {
        DayTypes dayTypes = this.m_factory.createDayTypes();
        calendars.setDayTypes(dayTypes);
        List<org.mpxj.planner.schema.DayType> typeList = dayTypes.getDayType();
        org.mpxj.planner.schema.DayType dayType = this.m_factory.createDayType();
        typeList.add(dayType);
        dayType.setId("0");
        dayType.setName("Working");
        dayType.setDescription("A default working day");
        dayType = this.m_factory.createDayType();
        typeList.add(dayType);
        dayType.setId("1");
        dayType.setName("Nonworking");
        dayType.setDescription("A default non working day");
        dayType = this.m_factory.createDayType();
        typeList.add(dayType);
        dayType.setId("2");
        dayType.setName("Use base");
        dayType.setDescription("Use day from base calendar");
    }

    private void writeCalendar(ProjectCalendar mpxjCalendar, Calendar plannerCalendar) {
        plannerCalendar.setId(this.getIntegerString(mpxjCalendar.getUniqueID()));
        plannerCalendar.setName(this.getString(mpxjCalendar.getName()));
        DefaultWeek dw = this.m_factory.createDefaultWeek();
        plannerCalendar.setDefaultWeek(dw);
        dw.setMon(this.getWorkingDayString(mpxjCalendar, DayOfWeek.MONDAY));
        dw.setTue(this.getWorkingDayString(mpxjCalendar, DayOfWeek.TUESDAY));
        dw.setWed(this.getWorkingDayString(mpxjCalendar, DayOfWeek.WEDNESDAY));
        dw.setThu(this.getWorkingDayString(mpxjCalendar, DayOfWeek.THURSDAY));
        dw.setFri(this.getWorkingDayString(mpxjCalendar, DayOfWeek.FRIDAY));
        dw.setSat(this.getWorkingDayString(mpxjCalendar, DayOfWeek.SATURDAY));
        dw.setSun(this.getWorkingDayString(mpxjCalendar, DayOfWeek.SUNDAY));
        OverriddenDayTypes odt = this.m_factory.createOverriddenDayTypes();
        plannerCalendar.setOverriddenDayTypes(odt);
        List<OverriddenDayType> typeList = odt.getOverriddenDayType();
        Sequence uniqueID = new Sequence(0);
        for (int dayLoop = 1; dayLoop < 8; ++dayLoop) {
            DayOfWeek day = DayOfWeekHelper.getInstance(dayLoop);
            if (!mpxjCalendar.isWorkingDay(day)) continue;
            this.processWorkingHours(mpxjCalendar, uniqueID, day, typeList);
            break;
        }
        Days plannerDays = this.m_factory.createDays();
        plannerCalendar.setDays(plannerDays);
        List<Day> dayList = plannerDays.getDay();
        this.processExceptionDays(mpxjCalendar, dayList);
        this.m_eventManager.fireCalendarWrittenEvent(mpxjCalendar);
        List<Calendar> calendarList = plannerCalendar.getCalendar();
        ArrayList<ProjectCalendar> sortedCalendarList = new ArrayList<ProjectCalendar>(mpxjCalendar.getDerivedCalendars());
        sortedCalendarList.sort((a, b) -> NumberHelper.compare(a.getUniqueID(), b.getUniqueID()));
        for (ProjectCalendar mpxjDerivedCalendar : sortedCalendarList) {
            Calendar plannerDerivedCalendar = this.m_factory.createCalendar();
            calendarList.add(plannerDerivedCalendar);
            this.writeCalendar(mpxjDerivedCalendar, plannerDerivedCalendar);
        }
    }

    private void processWorkingHours(ProjectCalendar mpxjCalendar, Sequence uniqueID, DayOfWeek day, List<OverriddenDayType> typeList) {
        ProjectCalendarHours mpxjHours;
        if (this.isWorkingDay(mpxjCalendar, day) && (mpxjHours = mpxjCalendar.getCalendarHours(day)) != null) {
            OverriddenDayType odt = this.m_factory.createOverriddenDayType();
            typeList.add(odt);
            odt.setId(this.getIntegerString(uniqueID.next()));
            List<Interval> intervalList = odt.getInterval();
            for (LocalTimeRange mpxjRange : mpxjHours) {
                LocalTime rangeStart = mpxjRange.getStart();
                LocalTime rangeEnd = mpxjRange.getEnd();
                if (rangeStart == null || rangeEnd == null) continue;
                Interval interval = this.m_factory.createInterval();
                intervalList.add(interval);
                interval.setStart(this.m_timeFormat.format(rangeStart));
                interval.setEnd(this.m_timeFormat.format(rangeEnd));
            }
        }
    }

    private void processExceptionDays(ProjectCalendar mpxjCalendar, List<Day> dayList) {
        List<ProjectCalendarException> expandedExceptions = mpxjCalendar.getExpandedCalendarExceptionsWithWorkWeeks();
        for (ProjectCalendarException mpxjCalendarException : expandedExceptions) {
            Day day;
            LocalDate rangeEndDay;
            LocalDate rangeStartDay = mpxjCalendarException.getFromDate();
            if (rangeStartDay.equals(rangeEndDay = mpxjCalendarException.getToDate())) {
                day = this.m_factory.createDay();
                dayList.add(day);
                day.setType("day-type");
                day.setDate(this.getDateString(mpxjCalendarException.getFromDate()));
                day.setId(mpxjCalendarException.getWorking() ? "0" : "1");
                continue;
            }
            while (!rangeStartDay.isAfter(rangeEndDay)) {
                day = this.m_factory.createDay();
                dayList.add(day);
                day.setType("day-type");
                day.setDate(this.getDateString(rangeStartDay));
                day.setId(mpxjCalendarException.getWorking() ? "0" : "1");
                rangeStartDay = rangeStartDay.plusDays(1L);
            }
        }
    }

    private void writeResources() {
        Resources resources = this.m_factory.createResources();
        this.m_plannerProject.setResources(resources);
        List<org.mpxj.planner.schema.Resource> resourceList = resources.getResource();
        for (Resource mpxjResource : this.m_projectFile.getResources()) {
            org.mpxj.planner.schema.Resource plannerResource = this.m_factory.createResource();
            resourceList.add(plannerResource);
            this.writeResource(mpxjResource, plannerResource);
        }
    }

    private void writeResource(Resource mpxjResource, org.mpxj.planner.schema.Resource plannerResource) {
        ProjectCalendar resourceCalendar = mpxjResource.getCalendar();
        if (resourceCalendar != null) {
            plannerResource.setCalendar(this.getIntegerString(resourceCalendar.getUniqueID()));
        }
        plannerResource.setEmail(mpxjResource.getEmailAddress());
        plannerResource.setId(this.getIntegerString(mpxjResource.getUniqueID()));
        plannerResource.setName(this.getString(mpxjResource.getName()));
        plannerResource.setNote(mpxjResource.getNotes());
        plannerResource.setShortName(mpxjResource.getInitials());
        plannerResource.setType(mpxjResource.getType() == ResourceType.MATERIAL ? "2" : "1");
        plannerResource.setUnits("0");
        this.m_eventManager.fireResourceWrittenEvent(mpxjResource);
    }

    private void writeTasks() {
        Tasks tasks = this.m_factory.createTasks();
        this.m_plannerProject.setTasks(tasks);
        List<Task> taskList = tasks.getTask();
        for (org.mpxj.Task task : this.m_projectFile.getChildTasks()) {
            this.writeTask(task, taskList);
        }
    }

    private void writeTask(org.mpxj.Task mpxjTask, List<Task> taskList) {
        if (mpxjTask.getNull()) {
            return;
        }
        Task plannerTask = this.m_factory.createTask();
        taskList.add(plannerTask);
        plannerTask.setEnd(this.getDateTimeString(mpxjTask.getFinish()));
        plannerTask.setId(this.getIntegerString(mpxjTask.getUniqueID()));
        plannerTask.setName(this.getString(mpxjTask.getName()));
        plannerTask.setNote(mpxjTask.getNotes());
        plannerTask.setPercentComplete(this.getIntegerString(mpxjTask.getPercentageWorkComplete()));
        plannerTask.setPriority(mpxjTask.getPriority() == null ? null : this.getIntegerString(mpxjTask.getPriority().getValue() * 10));
        plannerTask.setScheduling(this.getScheduling(mpxjTask.getType()));
        plannerTask.setStart(this.getDateTimeString(LocalDateTimeHelper.getDayStartDate(mpxjTask.getStart())));
        plannerTask.setType(mpxjTask.getMilestone() ? "milestone" : "normal");
        plannerTask.setWork(this.getDurationString(this.getWork(mpxjTask)));
        plannerTask.setWorkStart(this.getDateTimeString(mpxjTask.getStart()));
        this.writeConstraint(mpxjTask, plannerTask);
        this.writePredecessors(mpxjTask, plannerTask);
        this.m_eventManager.fireTaskWrittenEvent(mpxjTask);
        List<Task> childTaskList = plannerTask.getTask();
        for (org.mpxj.Task task : mpxjTask.getChildTasks()) {
            this.writeTask(task, childTaskList);
        }
    }

    private void writeConstraint(org.mpxj.Task mpxjTask, Task plannerTask) {
        ConstraintType mpxjConstraintType = mpxjTask.getConstraintType();
        if (mpxjConstraintType != null && mpxjConstraintType != ConstraintType.AS_SOON_AS_POSSIBLE) {
            String plannerConstraintType = null;
            switch (mpxjConstraintType) {
                case MUST_START_ON: 
                case START_ON: {
                    plannerConstraintType = "must-start-on";
                    break;
                }
                case START_NO_EARLIER_THAN: {
                    plannerConstraintType = "start-no-earlier-than";
                    break;
                }
            }
            if (plannerConstraintType != null) {
                Constraint plannerConstraint = this.m_factory.createConstraint();
                plannerTask.setConstraint(plannerConstraint);
                plannerConstraint.setType(plannerConstraintType);
                plannerConstraint.setTime(this.getDateTimeString(mpxjTask.getConstraintDate()));
            }
        }
    }

    private Duration getWork(org.mpxj.Task task) {
        Duration result = task.getWork();
        return result != null && result.getDuration() != 0.0 ? result : task.getDuration();
    }

    private void writePredecessors(org.mpxj.Task mpxjTask, Task plannerTask) {
        List<Relation> predecessors = mpxjTask.getPredecessors();
        if (predecessors.isEmpty()) {
            return;
        }
        Predecessors plannerPredecessors = this.m_factory.createPredecessors();
        plannerTask.setPredecessors(plannerPredecessors);
        List<Predecessor> predecessorList = plannerPredecessors.getPredecessor();
        int id = 0;
        for (Relation rel : predecessors) {
            Integer taskUniqueID = rel.getPredecessorTask().getUniqueID();
            Predecessor plannerPredecessor = this.m_factory.createPredecessor();
            plannerPredecessor.setId(this.getIntegerString(++id));
            plannerPredecessor.setPredecessorId(this.getIntegerString(taskUniqueID));
            plannerPredecessor.setLag(this.getDurationString(this.getLag(rel)));
            plannerPredecessor.setType(RELATIONSHIP_TYPES.get(rel.getType()));
            predecessorList.add(plannerPredecessor);
            this.m_eventManager.fireRelationWrittenEvent(rel);
        }
    }

    private Duration getLag(Relation relation) {
        LocalDateTime successorDate;
        LocalDateTime predecessorDate;
        Duration lag = relation.getLag();
        if (lag == null || lag.getDuration() == 0.0 || lag.getUnits().isElapsed()) {
            return lag;
        }
        if (lag.getUnits() == TimeUnit.PERCENT) {
            Duration targetDuration = relation.getPredecessorTask().getDuration();
            double percentValue = lag.getDuration();
            double durationValue = targetDuration.getDuration();
            durationValue = durationValue * percentValue / 100.0;
            lag = Duration.getInstance(durationValue, targetDuration.getUnits());
        }
        if (lag.getUnits().isElapsed()) {
            return lag;
        }
        switch (relation.getType()) {
            case START_START: {
                predecessorDate = relation.getPredecessorTask().getStart();
                successorDate = relation.getSuccessorTask().getStart();
                break;
            }
            case FINISH_FINISH: {
                predecessorDate = relation.getPredecessorTask().getFinish();
                successorDate = relation.getSuccessorTask().getFinish();
                break;
            }
            case START_FINISH: {
                predecessorDate = relation.getPredecessorTask().getStart();
                successorDate = relation.getSuccessorTask().getFinish();
                break;
            }
            default: {
                predecessorDate = relation.getPredecessorTask().getFinish();
                successorDate = relation.getSuccessorTask().getStart();
            }
        }
        if (successorDate == null || predecessorDate == null) {
            return lag;
        }
        long milliseconds = predecessorDate.until(successorDate, ChronoUnit.MILLIS);
        double minutes = (double)milliseconds / 60000.0;
        return Duration.getInstance(minutes, TimeUnit.ELAPSED_MINUTES);
    }

    private void writeAssignments() {
        Allocations allocations = this.m_factory.createAllocations();
        this.m_plannerProject.setAllocations(allocations);
        List<Allocation> allocationList = allocations.getAllocation();
        Function<ResourceAssignment, String> assignmentKey = a -> a.getTaskUniqueID() + " " + a.getResourceUniqueID();
        Map map = this.m_projectFile.getResourceAssignments().stream().collect(Collectors.toMap(assignmentKey, Function.identity(), (a1, a2) -> a1));
        this.m_projectFile.getResourceAssignments().stream().filter(a -> a.getResourceUniqueID() != null && map.get(assignmentKey.apply((ResourceAssignment)a)) == a).forEach(a -> allocationList.add(this.writeAssignment((ResourceAssignment)a)));
    }

    private Allocation writeAssignment(ResourceAssignment mpxjAssignment) {
        Allocation plannerAllocation = this.m_factory.createAllocation();
        plannerAllocation.setTaskId(this.getIntegerString(mpxjAssignment.getTask().getUniqueID()));
        plannerAllocation.setResourceId(this.getIntegerString(mpxjAssignment.getResourceUniqueID()));
        plannerAllocation.setUnits(this.getIntegerString(mpxjAssignment.getUnits()));
        this.m_eventManager.fireAssignmentWrittenEvent(mpxjAssignment);
        return plannerAllocation;
    }

    private String getIntegerString(Number value) {
        return value == null ? null : Integer.toString(value.intValue());
    }

    private String getIntegerString(int value) {
        return Integer.toString(value);
    }

    private boolean isWorkingDay(ProjectCalendar mpxjCalendar, DayOfWeek day) {
        boolean result = false;
        DayType type = mpxjCalendar.getCalendarDayType(day);
        if (type == null) {
            type = DayType.DEFAULT;
        }
        switch (type) {
            case WORKING: {
                result = true;
                break;
            }
            case NON_WORKING: {
                result = false;
                break;
            }
            case DEFAULT: {
                result = mpxjCalendar.getParent() != null && this.isWorkingDay(mpxjCalendar.getParent(), day);
            }
        }
        return result;
    }

    private String getWorkingDayString(ProjectCalendar mpxjCalendar, DayOfWeek day) {
        String result = null;
        DayType type = mpxjCalendar.getCalendarDayType(day);
        if (type == null) {
            type = DayType.DEFAULT;
        }
        switch (type) {
            case WORKING: {
                result = "0";
                break;
            }
            case NON_WORKING: {
                result = "1";
                break;
            }
            case DEFAULT: {
                result = "2";
            }
        }
        return result;
    }

    private String getDateString(LocalDate value) {
        return this.m_dateFormat.format(value);
    }

    private String getDateTimeString(LocalDateTime value) {
        if (value == null) {
            return null;
        }
        return this.m_dateTimeFormat.format(value);
    }

    private String getDurationString(Duration value) {
        String result = null;
        if (value != null) {
            double seconds = 0.0;
            switch (value.getUnits()) {
                case MINUTES: 
                case ELAPSED_MINUTES: {
                    seconds = value.getDuration() * 60.0;
                    break;
                }
                case HOURS: 
                case ELAPSED_HOURS: {
                    seconds = value.getDuration() * 3600.0;
                    break;
                }
                case DAYS: {
                    double minutesPerDay = this.m_projectFile.getProjectProperties().getMinutesPerDay().doubleValue();
                    seconds = value.getDuration() * (minutesPerDay * 60.0);
                    break;
                }
                case ELAPSED_DAYS: {
                    seconds = value.getDuration() * 86400.0;
                    break;
                }
                case WEEKS: {
                    double minutesPerWeek = this.m_projectFile.getProjectProperties().getMinutesPerWeek().doubleValue();
                    seconds = value.getDuration() * (minutesPerWeek * 60.0);
                    break;
                }
                case ELAPSED_WEEKS: {
                    seconds = value.getDuration() * 604800.0;
                    break;
                }
                case MONTHS: {
                    double minutesPerDay = this.m_projectFile.getProjectProperties().getMinutesPerDay().doubleValue();
                    double daysPerMonth = this.m_projectFile.getProjectProperties().getDaysPerMonth().doubleValue();
                    seconds = value.getDuration() * (daysPerMonth * minutesPerDay * 60.0);
                    break;
                }
                case ELAPSED_MONTHS: {
                    seconds = value.getDuration() * 2592000.0;
                    break;
                }
                case YEARS: {
                    double minutesPerDay = this.m_projectFile.getProjectProperties().getMinutesPerDay().doubleValue();
                    double daysPerMonth = this.m_projectFile.getProjectProperties().getDaysPerMonth().doubleValue();
                    seconds = value.getDuration() * (12.0 * daysPerMonth * minutesPerDay * 60.0);
                    break;
                }
                case ELAPSED_YEARS: {
                    seconds = value.getDuration() * 3.1536E7;
                    break;
                }
            }
            result = Long.toString((long)seconds);
        }
        return result;
    }

    private String getScheduling(TaskType value) {
        String result = "fixed-work";
        if (value == TaskType.FIXED_DURATION || value == TaskType.FIXED_DURATION_AND_UNITS) {
            result = "fixed-duration";
        }
        return result;
    }

    private String getString(String value) {
        return value == null ? "" : value;
    }

    public void setCharset(Charset charset) {
        this.m_charset = charset;
    }

    public Charset getCharset() {
        return this.m_charset;
    }

    static {
        RELATIONSHIP_TYPES.put(RelationType.FINISH_FINISH, "FF");
        RELATIONSHIP_TYPES.put(RelationType.FINISH_START, "FS");
        RELATIONSHIP_TYPES.put(RelationType.START_FINISH, "SF");
        RELATIONSHIP_TYPES.put(RelationType.START_START, "SS");
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"org.mpxj.planner.schema", (ClassLoader)PlannerWriter.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
    }
}

