/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.util.HashMap;
import java.util.Map;
import org.mpxj.CalendarType;

final class CalendarTypeHelper {
    private static final Map<String, CalendarType> XML_TYPE_MAP = new HashMap<String, CalendarType>();
    private static final Map<CalendarType, String> TYPE_XML_MAP;
    private static final Map<String, CalendarType> XER_TYPE_MAP;
    private static final Map<CalendarType, String> TYPE_XER_MAP;

    CalendarTypeHelper() {
    }

    public static CalendarType getInstanceFromXml(String value) {
        return XML_TYPE_MAP.get(value);
    }

    public static CalendarType getInstanceFromXer(String value) {
        return XER_TYPE_MAP.get(value);
    }

    public static String getXmlFromInstance(CalendarType value) {
        return TYPE_XML_MAP.get((Object)value);
    }

    public static String getXerFromInstance(CalendarType value) {
        return TYPE_XER_MAP.get((Object)value);
    }

    static {
        XML_TYPE_MAP.put("Global", CalendarType.GLOBAL);
        XML_TYPE_MAP.put("Project", CalendarType.PROJECT);
        XML_TYPE_MAP.put("Resource", CalendarType.RESOURCE);
        TYPE_XML_MAP = new HashMap<CalendarType, String>();
        TYPE_XML_MAP.put(CalendarType.GLOBAL, "Global");
        TYPE_XML_MAP.put(CalendarType.PROJECT, "Project");
        TYPE_XML_MAP.put(CalendarType.RESOURCE, "Resource");
        XER_TYPE_MAP = new HashMap<String, CalendarType>();
        XER_TYPE_MAP.put("CA_Base", CalendarType.GLOBAL);
        XER_TYPE_MAP.put("CA_Project", CalendarType.PROJECT);
        XER_TYPE_MAP.put("CA_Rsrc", CalendarType.RESOURCE);
        TYPE_XER_MAP = new HashMap<CalendarType, String>();
        TYPE_XER_MAP.put(CalendarType.GLOBAL, "CA_Base");
        TYPE_XER_MAP.put(CalendarType.PROJECT, "CA_Project");
        TYPE_XER_MAP.put(CalendarType.RESOURCE, "CA_Rsrc");
    }
}

