/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.UUID;
import org.mpxj.common.XmlHelper;

public final class DatatypeConverter {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final ThreadLocal<NumberFormat> DOUBLE_FORMAT = ThreadLocal.withInitial(() -> {
        DecimalFormat format = new DecimalFormat("#.###############");
        format.setGroupingUsed(false);
        return format;
    });

    public static final UUID parseUUID(String value) {
        UUID result = null;
        if (value != null && !value.isEmpty()) {
            if (value.charAt(0) == '{') {
                result = UUID.fromString(value.substring(1, value.length() - 1));
            } else if (value.length() == 22) {
                byte[] data = jakarta.xml.bind.DatatypeConverter.parseBase64Binary((String)(value + "=="));
                long msb = data[3] & 0xFF;
                msb = msb << 8 | (long)(data[2] & 0xFF);
                msb = msb << 8 | (long)(data[1] & 0xFF);
                msb = msb << 8 | (long)(data[0] & 0xFF);
                msb = msb << 8 | (long)(data[5] & 0xFF);
                msb = msb << 8 | (long)(data[4] & 0xFF);
                msb = msb << 8 | (long)(data[7] & 0xFF);
                msb = msb << 8 | (long)(data[6] & 0xFF);
                long lsb = 0L;
                for (int i = 8; i < 16; ++i) {
                    lsb = lsb << 8 | (long)(data[i] & 0xFF);
                }
                result = new UUID(msb, lsb);
            } else {
                result = UUID.nameUUIDFromBytes(value.getBytes());
            }
        }
        return result;
    }

    public static String printUUID(UUID guid) {
        return guid == null ? null : "{" + guid.toString().toUpperCase() + "}";
    }

    public static final String printDateTime(LocalDateTime value) {
        return value == null ? null : DATE_FORMAT.format(value);
    }

    public static final LocalDateTime parseDateTime(String value) {
        LocalDateTime result = null;
        if (value != null && !value.isEmpty()) {
            try {
                result = LocalDateTime.parse(value, DATE_FORMAT);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return result;
    }

    public static final String printTime(LocalTime value) {
        return value == null ? null : TIME_FORMAT.format(value);
    }

    public static final LocalTime parseTime(String value) {
        LocalTime result = null;
        if (value != null && !value.isEmpty()) {
            try {
                result = LocalTime.parse(value, TIME_FORMAT);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return result;
    }

    public static final Boolean parseBoolean(String value) {
        Boolean result = value == null ? null : Boolean.valueOf(jakarta.xml.bind.DatatypeConverter.parseBoolean((String)value));
        return result;
    }

    public static final String printBoolean(Boolean value) {
        String result = value == null ? null : (value != false ? "1" : "0");
        return result;
    }

    public static final Double parseDouble(String value) {
        Double result = value == null ? null : Double.valueOf(jakarta.xml.bind.DatatypeConverter.parseDouble((String)value));
        return result;
    }

    public static final String printDouble(Double value) {
        String result = value == null ? null : DOUBLE_FORMAT.get().format(value);
        return result;
    }

    public static final String printString(String value) {
        return XmlHelper.replaceInvalidXmlChars(value);
    }

    public static final String parseString(String value) {
        return value;
    }
}

