/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.mpxj.EPS;
import org.mpxj.EpsNode;
import org.mpxj.EpsProjectNode;
import org.mpxj.FieldType;
import org.mpxj.MPXJException;
import org.mpxj.Notes;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectFileSharedData;
import org.mpxj.ProjectProperties;
import org.mpxj.WorkContour;
import org.mpxj.WorkContourContainer;
import org.mpxj.common.AutoCloseableHelper;
import org.mpxj.common.ConnectionHelper;
import org.mpxj.common.DayOfWeekHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.ResultSetHelper;
import org.mpxj.primavera.MapRow;
import org.mpxj.primavera.PrimaveraReader;
import org.mpxj.primavera.ResultSetRow;
import org.mpxj.primavera.Row;
import org.mpxj.primavera.StructuredTextParser;
import org.mpxj.primavera.StructuredTextRecord;
import org.mpxj.reader.AbstractProjectReader;

public final class PrimaveraDatabaseReader
extends AbstractProjectReader {
    private PrimaveraReader m_reader;
    private Integer m_projectID;
    private String m_schema = "";
    private DataSource m_dataSource;
    private Connection m_connection;
    private boolean m_allocatedConnection;
    private boolean m_matchPrimaveraWBS = true;
    private boolean m_wbsIsFullPath = true;
    private boolean m_ignoreErrors = true;
    private Set<String> m_tableNames;
    private boolean m_readSharedData;
    private final Map<FieldType, String> m_resourceFields = PrimaveraReader.getDefaultResourceFieldMap();
    private final Map<FieldType, String> m_roleFields = PrimaveraReader.getDefaultRoleFieldMap();
    private final Map<FieldType, String> m_wbsFields = PrimaveraReader.getDefaultWbsFieldMap();
    private final Map<FieldType, String> m_taskFields = PrimaveraReader.getDefaultTaskFieldMap();
    private final Map<FieldType, String> m_assignmentFields = PrimaveraReader.getDefaultAssignmentFieldMap();

    public Map<Integer, String> listProjects() throws MPXJException {
        try {
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            List<Row> rows = this.getRows("select proj_id, proj_short_name from " + this.m_schema + "project where delete_date is null");
            for (Row row : rows) {
                Integer id = row.getInteger("proj_id");
                String name = row.getString("proj_short_name");
                result.put(id, name);
            }
            return result;
        }
        catch (SQLException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    public EPS listEps() throws MPXJException {
        try {
            List<Row> rows = this.getRows("select project.project_flag, projwbs.* from " + this.m_schema + "projwbs join " + this.m_schema + "project on project.proj_id = projwbs.proj_id where proj_node_flag='Y' order by seq_num");
            return this.processEps(rows);
        }
        catch (SQLException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    public ProjectFile read() throws MPXJException {
        this.m_readSharedData = true;
        return this.read(new ProjectFileSharedData());
    }

    private ProjectFile read(ProjectFileSharedData shared) throws MPXJException {
        try {
            this.m_reader = new PrimaveraReader(shared, this.m_resourceFields, this.m_roleFields, this.m_wbsFields, this.m_taskFields, this.m_assignmentFields, this.m_matchPrimaveraWBS, this.m_wbsIsFullPath, this.m_ignoreErrors);
            ProjectFile project = this.m_reader.getProject();
            this.addListenersToProject(project);
            this.processTableNames();
            this.processAnalytics();
            project.getProjectProperties().setUniqueID(this.m_projectID);
            if (this.m_readSharedData) {
                this.m_readSharedData = false;
                this.processCurrencies();
                this.processLocations();
                this.processShifts();
                this.processUnitsOfMeasure();
                this.processExpenseCategories();
                this.processCostAccounts();
                this.processWorkContours();
                this.processNotebookTopics();
                this.processUdfDefinitions();
                this.processProjectCodeDefinitions();
                this.processResourceCodeDefinitions();
                this.processRoleCodeDefinitions();
                this.processResourceAssignmentCodeDefinitions();
                this.processActivityCodeDefinitions();
            }
            this.processActivityCodeAssignments();
            this.processResourceCodeAssignments();
            this.processRoleCodeAssignments();
            this.processResourceAssignmentCodeAssignments();
            this.processUdfValues();
            this.processCalendars();
            this.processResources();
            this.processRoles();
            this.processRoleAssignments();
            this.processResourceRates();
            this.processRoleRates();
            this.processRoleAvailability();
            this.processProjectProperties();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            this.processExpenseItems();
            this.processActivitySteps();
            this.m_reader.rollupValues();
            this.m_reader = null;
            project.updateStructure();
            project.readComplete();
            ProjectFile projectFile = project;
            return projectFile;
        }
        catch (SQLException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            if (this.m_allocatedConnection) {
                AutoCloseableHelper.closeQuietly(this.m_connection);
                this.m_connection = null;
            }
        }
    }

    public List<ProjectFile> readAll() throws MPXJException {
        Map<Integer, String> projects = this.listProjects();
        ArrayList<ProjectFile> result = new ArrayList<ProjectFile>(projects.size());
        ProjectFileSharedData shared = new ProjectFileSharedData();
        this.m_readSharedData = true;
        for (Integer id : projects.keySet()) {
            this.setProjectID(id);
            result.add(this.read(shared));
        }
        return result;
    }

    private void processAnalytics() throws SQLException {
        this.allocateConnection();
        DatabaseMetaData meta = this.m_connection.getMetaData();
        String productName = meta.getDatabaseProductName();
        productName = productName == null || productName.isEmpty() ? "DATABASE" : productName.toUpperCase();
        ProjectProperties properties = this.m_reader.getProject().getProjectProperties();
        properties.setFileApplication("Primavera");
        properties.setFileType(productName);
    }

    private void processProjectProperties() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "project where proj_id=?", this.m_projectID);
        this.m_reader.processProjectProperties(rows);
        rows = this.getRows("select * from " + this.m_schema + "projpcat where proj_id=?", this.m_projectID);
        this.m_reader.processProjectCodeAssignments(rows);
        rows = this.getRows("select * from " + this.m_schema + "prefer where prefer.delete_date is null");
        if (!rows.isEmpty()) {
            Row row = rows.get(0);
            ProjectProperties ph = this.m_reader.getProject().getProjectProperties();
            ph.setCreationDate(row.getDate("create_date"));
            ph.setLastSaved(row.getDate("update_date"));
            ph.setMinutesPerDay((int)(row.getDouble("day_hr_cnt") * 60.0));
            ph.setMinutesPerWeek((int)(row.getDouble("week_hr_cnt") * 60.0));
            ph.setMinutesPerMonth((int)(row.getDouble("month_hr_cnt") * 60.0));
            ph.setMinutesPerYear((int)(row.getDouble("year_hr_cnt") * 60.0));
            ph.setWeekStartDay(DayOfWeekHelper.getInstance(row.getInt("week_start_day_num")));
            this.processDefaultCurrency(row.getInteger("curr_id"));
        }
        this.processSchedulingProjectProperties();
    }

    private void processCurrencies() throws SQLException {
        if (this.m_tableNames.contains("CURRTYPE")) {
            this.m_reader.processCurrencies(this.getRows("select * from " + this.m_schema + "currtype"));
        }
    }

    private void processLocations() throws SQLException {
        if (this.m_tableNames.contains("LOCATION")) {
            this.m_reader.processLocations(this.getRows("select * from " + this.m_schema + "location"));
        }
    }

    private void processShifts() throws SQLException {
        if (this.m_tableNames.contains("SHIFT") && this.m_tableNames.contains("SHIFTPER")) {
            this.m_reader.processShifts(this.getRows("select * from " + this.m_schema + "shift"), this.getRows("select * from " + this.m_schema + "shiftper"));
        }
    }

    private void processExpenseCategories() throws SQLException {
        this.m_reader.processExpenseCategories(this.getRows("select * from " + this.m_schema + "costtype"));
    }

    private void processExpenseItems() throws SQLException {
        this.m_reader.processExpenseItems(this.getRows("select * from " + this.m_schema + "projcost where proj_id=?", this.m_projectID));
    }

    private void processActivitySteps() throws SQLException {
        this.m_reader.processActivitySteps(this.getRows("select * from " + this.m_schema + "taskproc where proj_id=?", this.m_projectID));
    }

    private void processCostAccounts() throws SQLException {
        this.m_reader.processCostAccounts(this.getRows("select * from " + this.m_schema + "account"));
    }

    private void processUnitsOfMeasure() throws SQLException {
        this.m_reader.processUnitsOfMeasure(this.getRows("select * from " + this.m_schema + "umeasure"));
    }

    private void processNotebookTopics() throws SQLException {
        this.m_reader.processNotebookTopics(this.getRows("select * from " + this.m_schema + "memotype"));
    }

    private void processActivityCodeDefinitions() throws SQLException {
        if (this.m_tableNames.contains("ACTVTYPE") && this.m_tableNames.contains("ACTVCODE")) {
            List<Row> types = this.getRows("select * from " + this.m_schema + "actvtype where actv_code_type_id in (select distinct actv_code_type_id from taskactv where proj_id=?)", this.m_projectID);
            List<Row> typeValues = this.getRows("select * from " + this.m_schema + "actvcode where actv_code_id in (select distinct actv_code_id from taskactv where proj_id=?)", this.m_projectID);
            this.m_reader.processActivityCodeDefinitions(types, typeValues);
        }
    }

    private void processProjectCodeDefinitions() throws SQLException {
        if (this.m_tableNames.contains("PCATTYPE") && this.m_tableNames.contains("PCATVAL")) {
            List<Row> types = this.getRows("select * from " + this.m_schema + "pcattype where proj_catg_type_id in (select distinct proj_catg_type_id from projpcat where proj_id=?)", this.m_projectID);
            List<Row> typeValues = this.getRows("select * from " + this.m_schema + "pcatval where proj_catg_id in (select distinct proj_catg_id from projpcat where proj_id=?)", this.m_projectID);
            this.m_reader.processProjectCodeDefinitions(types, typeValues);
        }
    }

    private void processResourceCodeDefinitions() throws SQLException {
        if (this.m_tableNames.contains("RCATTYPE") && this.m_tableNames.contains("RCATVAL")) {
            List<Row> types = this.getRows("select * from " + this.m_schema + "rcattype where rsrc_catg_type_id in (select distinct rsrc_catg_type_id from rsrcrcat where rsrc_id in (select distinct rsrc_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null))", this.m_projectID);
            List<Row> typeValues = this.getRows("select * from " + this.m_schema + "rcatval where rsrc_catg_id in (select distinct rsrc_catg_id from rsrcrcat where rsrc_id in (select distinct rsrc_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null))", this.m_projectID);
            this.m_reader.processResourceCodeDefinitions(types, typeValues);
        }
    }

    private void processRoleCodeDefinitions() throws SQLException {
        if (this.m_tableNames.contains("ROLECATTYPE") && this.m_tableNames.contains("ROLECATVAL")) {
            List<Row> types = this.getRows("select * from " + this.m_schema + "rolecattype where role_catg_type_id in (select distinct role_catg_type_id from rolercat where role_id in (select distinct role_id from " + this.m_schema + "rsrcrole where delete_date is null and rsrc_id in (select rsrc_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null)))", this.m_projectID);
            List<Row> typeValues = this.getRows("select * from " + this.m_schema + "rolecatval where role_catg_id in (select distinct role_catg_id from rolercat where role_id in (select distinct role_id from " + this.m_schema + "rsrcrole where delete_date is null and rsrc_id in (select rsrc_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null)))", this.m_projectID);
            this.m_reader.processRoleCodeDefinitions(types, typeValues);
        }
    }

    private void processResourceAssignmentCodeDefinitions() throws SQLException {
        if (this.m_tableNames.contains("ASGNMNTCATTYPE") && this.m_tableNames.contains("ASGNMNTCATVAL")) {
            List<Row> types = this.getRows("select * from " + this.m_schema + "asgnmntcattype where asgnmnt_catg_type_id in (select distinct asgnmnt_catg_type_id from asgnmntacat where proj_id=?)", this.m_projectID);
            List<Row> typeValues = this.getRows("select * from " + this.m_schema + "asgnmntcatval where asgnmnt_catg_id in (select distinct asgnmnt_catg_id from asgnmntacat where proj_id=?)", this.m_projectID);
            this.m_reader.processResourceAssignmentCodeDefinitions(types, typeValues);
        }
    }

    private void processActivityCodeAssignments() throws SQLException {
        if (this.m_tableNames.contains("TASKACTV")) {
            List<Row> assignments = this.getRows("select * from " + this.m_schema + "taskactv where proj_id=?", this.m_projectID);
            this.m_reader.processActivityCodeAssignments(assignments);
        }
    }

    private void processResourceCodeAssignments() throws SQLException {
        if (this.m_tableNames.contains("RSRCRCAT")) {
            List<Row> assignments = this.getRows("select * from " + this.m_schema + "rsrcrcat where rsrc_id in (select distinct rsrc_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null)", this.m_projectID);
            this.m_reader.processResourceCodeAssignments(assignments);
        }
    }

    private void processRoleCodeAssignments() throws SQLException {
        if (this.m_tableNames.contains("ROLERCAT")) {
            List<Row> assignments = this.getRows("select * from " + this.m_schema + "rolercat where role_id in (select distinct role_id from " + this.m_schema + "rsrcrole where delete_date is null and rsrc_id in (select distinct rsrc_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null))", this.m_projectID);
            this.m_reader.processRoleCodeAssignments(assignments);
        }
    }

    private void processResourceAssignmentCodeAssignments() throws SQLException {
        if (this.m_tableNames.contains("ASGNMNTACAT")) {
            List<Row> assignments = this.getRows("select * from " + this.m_schema + "asgnmntacat where proj_id=?", this.m_projectID);
            this.m_reader.processResourceAssignmentCodeAssignments(assignments);
        }
    }

    private void processUdfDefinitions() throws SQLException {
        List<Row> fields = this.getRows("select * from " + this.m_schema + "udftype");
        this.m_reader.processUdfDefinitions(fields);
    }

    private void processUdfValues() throws SQLException {
        List<Row> values = this.getRows("select * from " + this.m_schema + "udfvalue where proj_id=? or proj_id is null", this.m_projectID);
        this.m_reader.processUdfValues(values);
    }

    private void processSchedulingProjectProperties() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "projprop where proj_id=? and prop_name='scheduling'", this.m_projectID);
        if (!rows.isEmpty()) {
            StructuredTextRecord record = new StructuredTextParser().parse(rows.get(0).getString("prop_value"));
            this.m_reader.processScheduleOptions(new MapRow(new HashMap<String, Object>(record.getAttributes()), false));
        }
    }

    private void processDefaultCurrency(Integer currencyID) throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "currtype where curr_id=?", currencyID);
        if (!rows.isEmpty()) {
            Row row = rows.get(0);
            this.m_reader.processDefaultCurrency(row);
        }
    }

    private void processResources() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "rsrc where delete_date is null and rsrc_id in (select rsrc_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null) order by rsrc_seq_num", this.m_projectID);
        this.m_reader.processResources(rows);
    }

    private void processRoles() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "roles where delete_date is null and role_id in (select distinct role_id from " + this.m_schema + "taskrsrc where proj_id=? and delete_date is null union select distinct role_id from " + this.m_schema + "rsrc where delete_date is null and rsrc_id in (select rsrc_id from " + this.m_schema + "taskrsrc where proj_id=? and delete_date is null)) order by seq_num", this.m_projectID, this.m_projectID);
        this.m_reader.processRoles(rows);
    }

    private void processRoleAssignments() throws SQLException {
        if (this.m_tableNames.contains("RSRCROLE")) {
            List<Row> rows = this.getRows("select * from " + this.m_schema + "rsrcrole where delete_date is null and rsrc_id in (select rsrc_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null)", this.m_projectID);
            this.m_reader.processRoleAssignments(rows);
        }
    }

    private void processResourceRates() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "rsrcrate where delete_date is null and rsrc_id in (select rsrc_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null) order by rsrc_rate_id", this.m_projectID);
        this.m_reader.processResourceRates(rows);
    }

    private void processRoleRates() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "rolerate where delete_date is null and role_id in (select role_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null) order by role_rate_id", this.m_projectID);
        this.m_reader.processRoleRates(rows);
    }

    private void processRoleAvailability() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "rolelimit where delete_date is null and role_id in (select role_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null) order by rolelimit_id", this.m_projectID);
        this.m_reader.processRoleAvailability(rows);
    }

    private void processTasks() throws SQLException {
        List<Row> wbs = this.getRows("select * from " + this.m_schema + "projwbs where proj_id=? and delete_date is null order by parent_wbs_id,seq_num", this.m_projectID);
        List<Row> tasks = this.getRows("select * from " + this.m_schema + "task where proj_id=? and delete_date is null", this.m_projectID);
        Map<Integer, Notes> wbsNotes = this.m_reader.getNotes(this.getRows("select * from " + this.m_schema + "wbsmemo where proj_id=?", this.m_projectID), "wbs_memo_id", "wbs_id", "wbs_memo");
        Map<Integer, Notes> taskNotes = this.m_reader.getNotes(this.getRows("select * from " + this.m_schema + "taskmemo where proj_id=?", this.m_projectID), "memo_id", "task_id", "task_memo");
        this.m_reader.processTasks(wbs, tasks, wbsNotes, taskNotes);
    }

    private void processPredecessors() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "taskpred where proj_id=? and delete_date is null", this.m_projectID);
        this.m_reader.processPredecessors(rows);
    }

    private void processCalendars() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "calendar where (proj_id is null or proj_id=?) and delete_date is null", this.m_projectID);
        this.m_reader.processCalendars(rows);
    }

    private void processAssignments() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "taskrsrc where proj_id=? and delete_date is null", this.m_projectID);
        this.m_reader.processAssignments(rows);
    }

    private void processWorkContours() throws SQLException {
        WorkContourContainer contours = this.m_reader.getProject().getWorkContours();
        List<Row> rows = this.getRows("select * from " + this.m_schema + "rsrccurv");
        for (Row row : rows) {
            try {
                Integer id = row.getInteger("curv_id");
                if (contours.getByUniqueID(id) != null) continue;
                double[] values = new StructuredTextParser().parse(row.getString("curv_data")).getChildren().stream().mapToDouble(r -> Double.parseDouble(r.getAttribute("PctUsage"))).toArray();
                contours.add(new WorkContour(id, row.getString("curv_name"), row.getBoolean("default_flag"), values));
            }
            catch (Exception ex) {
                if (this.m_ignoreErrors) {
                    this.m_reader.getProject().addIgnoredError(ex);
                    continue;
                }
                throw ex;
            }
        }
    }

    public void setProjectID(int projectID) {
        this.m_projectID = projectID;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public void setConnection(Connection connection) {
        this.m_connection = connection;
    }

    @Override
    public ProjectFile read(String fileName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ProjectFile> readAll(String fileName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProjectFile read(File file) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ProjectFile> readAll(File file) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProjectFile read(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ProjectFile> readAll(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    private void processTableNames() throws SQLException {
        this.allocateConnection();
        this.m_tableNames = ConnectionHelper.getTableNames(this.m_connection);
    }

    /*
     * Exception decompiling
     */
    private List<Row> getRows(String sql) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, Integer> createIndexFromMetadata(Map<String, Integer> meta) {
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        int index = 0;
        for (Map.Entry<String, Integer> entry : meta.entrySet()) {
            indexMap.put(entry.getKey().toLowerCase(), index++);
        }
        return indexMap;
    }

    private List<Row> getRows(String sql, Integer ... vars) throws SQLException {
        this.allocateConnection();
        ArrayList<Row> result = new ArrayList<Row>();
        try (PreparedStatement ps = this.m_connection.prepareStatement(sql);){
            for (int loop = 0; loop < vars.length; ++loop) {
                ps.setInt(loop + 1, NumberHelper.getInt(vars[loop]));
            }
            try (ResultSet rs = ps.executeQuery();){
                Map<String, Integer> meta = ResultSetHelper.populateMetaData(rs);
                Map<String, Integer> index = this.createIndexFromMetadata(meta);
                while (rs.next()) {
                    result.add(new ResultSetRow(rs, meta, index));
                }
            }
        }
        return result;
    }

    private void allocateConnection() throws SQLException {
        if (this.m_connection == null) {
            this.m_connection = this.m_dataSource.getConnection();
            this.m_allocatedConnection = true;
        }
    }

    public void setSchema(String schema) {
        if (schema == null) {
            schema = "";
        } else if (!schema.isEmpty() && !schema.endsWith(".")) {
            schema = schema + '.';
        }
        this.m_schema = schema;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public Map<FieldType, String> getResourceFieldMap() {
        return this.m_resourceFields;
    }

    public Map<FieldType, String> getRoleFieldMap() {
        return this.m_roleFields;
    }

    public Map<FieldType, String> getWbsFieldMap() {
        return this.m_wbsFields;
    }

    public Map<FieldType, String> getActivityFieldMap() {
        return this.m_taskFields;
    }

    public Map<FieldType, String> getAssignmentFieldMap() {
        return this.m_assignmentFields;
    }

    public boolean getMatchPrimaveraWBS() {
        return this.m_matchPrimaveraWBS;
    }

    public void setMatchPrimaveraWBS(boolean matchPrimaveraWBS) {
        this.m_matchPrimaveraWBS = matchPrimaveraWBS;
    }

    public boolean getWbsIsFullPath() {
        return this.m_wbsIsFullPath;
    }

    public void setWbsIsFullPath(boolean wbsIsFullPath) {
        this.m_wbsIsFullPath = wbsIsFullPath;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.m_ignoreErrors = ignoreErrors;
    }

    public boolean getIgnoreErrors() {
        return this.m_ignoreErrors;
    }

    private EPS processEps(List<Row> rows) {
        EPS eps = new EPS();
        rows.forEach(r -> this.addEpsNode(eps, (Row)r));
        return eps;
    }

    private void addEpsNode(EPS eps, Row row) {
        if (row.getBoolean("project_flag")) {
            this.addEpsProjectNode(eps, row);
        } else {
            this.addEpsChildNode(eps, row);
        }
    }

    private void addEpsChildNode(EPS eps, Row row) {
        new EpsNode(eps, row.getInteger("wbs_id"), row.getInteger("parent_wbs_id"), row.getString("wbs_name"), row.getString("wbs_short_name"));
    }

    private void addEpsProjectNode(EPS eps, Row row) {
        new EpsProjectNode(eps, row.getInteger("proj_id"), row.getInteger("parent_wbs_id"), row.getString("wbs_short_name"), row.getString("wbs_name"));
    }
}

