/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.util.HashMap;
import java.util.Map;
import org.mpxj.Priority;

final class PriorityHelper {
    private static final Map<String, Priority> XML_TYPE_MAP = new HashMap<String, Priority>();
    private static final Map<Priority, String> TYPE_XML_MAP;
    private static final Map<String, Priority> XER_TYPE_MAP;
    private static final Map<Priority, String> TYPE_XER_MAP;

    PriorityHelper() {
    }

    public static Priority getInstanceFromXml(String value) {
        return XML_TYPE_MAP.get(value);
    }

    public static Priority getInstanceFromXer(String value) {
        return XER_TYPE_MAP.get(value);
    }

    public static String getXmlFromInstance(Priority value) {
        return TYPE_XML_MAP.get(PriorityHelper.getNamedInstance(value));
    }

    public static String getXerFromInstance(Priority value) {
        return TYPE_XER_MAP.get(value);
    }

    private static Priority getNamedInstance(Priority priority) {
        if (priority == null) {
            return Priority.getInstance(500);
        }
        int value = (priority.getValue() + 50) / 100 * 100;
        if (value > 900) {
            value = 900;
        }
        return Priority.getInstance(value);
    }

    static {
        XML_TYPE_MAP.put("Top", Priority.getInstance(900));
        XML_TYPE_MAP.put("High", Priority.getInstance(600));
        XML_TYPE_MAP.put("Normal", Priority.getInstance(500));
        XML_TYPE_MAP.put("Low", Priority.getInstance(400));
        XML_TYPE_MAP.put("Lowest", Priority.getInstance(100));
        TYPE_XML_MAP = new HashMap<Priority, String>();
        TYPE_XML_MAP.put(Priority.getInstance(900), "Top");
        TYPE_XML_MAP.put(Priority.getInstance(800), "Top");
        TYPE_XML_MAP.put(Priority.getInstance(700), "High");
        TYPE_XML_MAP.put(Priority.getInstance(600), "High");
        TYPE_XML_MAP.put(Priority.getInstance(500), "Normal");
        TYPE_XML_MAP.put(Priority.getInstance(400), "Low");
        TYPE_XML_MAP.put(Priority.getInstance(300), "Low");
        TYPE_XML_MAP.put(Priority.getInstance(200), "Lowest");
        TYPE_XML_MAP.put(Priority.getInstance(100), "Lowest");
        XER_TYPE_MAP = new HashMap<String, Priority>();
        XER_TYPE_MAP.put("PT_Top", Priority.getInstance(900));
        XER_TYPE_MAP.put("PT_High", Priority.getInstance(600));
        XER_TYPE_MAP.put("PT_Normal", Priority.getInstance(500));
        XER_TYPE_MAP.put("PT_Low", Priority.getInstance(400));
        XER_TYPE_MAP.put("PT_Lowest", Priority.getInstance(100));
        TYPE_XER_MAP = new HashMap<Priority, String>();
        TYPE_XER_MAP.put(Priority.getInstance(900), "PT_Top");
        TYPE_XER_MAP.put(Priority.getInstance(800), "PT_Top");
        TYPE_XER_MAP.put(Priority.getInstance(700), "PT_High");
        TYPE_XER_MAP.put(Priority.getInstance(600), "PT_High");
        TYPE_XER_MAP.put(Priority.getInstance(500), "PT_Normal");
        TYPE_XER_MAP.put(Priority.getInstance(400), "PT_Low");
        TYPE_XER_MAP.put(Priority.getInstance(300), "PT_Low");
        TYPE_XER_MAP.put(Priority.getInstance(200), "PT_Lowest");
        TYPE_XER_MAP.put(Priority.getInstance(100), "PT_Lowest");
    }
}

