/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.util.HashMap;
import java.util.Map;
import org.mpxj.RateSource;

final class RateSourceHelper {
    private static final Map<String, RateSource> XML_TYPE_MAP = new HashMap<String, RateSource>();
    private static final Map<String, RateSource> XER_TYPE_MAP;
    private static final Map<RateSource, String> TYPE_XML_MAP;
    private static final Map<RateSource, String> TYPE_XER_MAP;

    RateSourceHelper() {
    }

    public static RateSource getInstanceFromXml(String value) {
        return XML_TYPE_MAP.getOrDefault(value, RateSource.RESOURCE);
    }

    public static RateSource getInstanceFromXer(String value) {
        return XER_TYPE_MAP.getOrDefault(value, RateSource.RESOURCE);
    }

    public static String getXmlFromInstance(RateSource value) {
        return TYPE_XML_MAP.get((Object)value);
    }

    public static String getXerFromInstance(RateSource value) {
        return TYPE_XER_MAP.get((Object)value);
    }

    static {
        XML_TYPE_MAP.put("Resource", RateSource.RESOURCE);
        XML_TYPE_MAP.put("Role", RateSource.ROLE);
        XML_TYPE_MAP.put("Override", RateSource.OVERRIDE);
        XER_TYPE_MAP = new HashMap<String, RateSource>();
        XER_TYPE_MAP.put("ST_Rsrc", RateSource.RESOURCE);
        XER_TYPE_MAP.put("ST_Role", RateSource.ROLE);
        XER_TYPE_MAP.put("ST_Custom", RateSource.OVERRIDE);
        TYPE_XML_MAP = new HashMap<RateSource, String>();
        TYPE_XML_MAP.put(RateSource.RESOURCE, "Resource");
        TYPE_XML_MAP.put(RateSource.OVERRIDE, "Override");
        TYPE_XML_MAP.put(RateSource.ROLE, "Role");
        TYPE_XER_MAP = new HashMap<RateSource, String>();
        TYPE_XER_MAP.put(RateSource.RESOURCE, "ST_Rsrc");
        TYPE_XER_MAP.put(RateSource.ROLE, "ST_Role");
        TYPE_XER_MAP.put(RateSource.OVERRIDE, "ST_Custom");
    }
}

