/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.util.HashMap;
import java.util.Map;
import org.mpxj.SkillLevel;

final class SkillLevelHelper {
    private static final SkillLevel DEFAULT_VALUE = SkillLevel.SKILLED;
    private static final SkillLevel[] XER_TYPE_ARRAY = new SkillLevel[]{null, SkillLevel.MASTER, SkillLevel.EXPERT, SkillLevel.SKILLED, SkillLevel.PROFICIENT, SkillLevel.INEXPERIENCED};
    private static final Map<SkillLevel, String> TYPE_XER_MAP = new HashMap<SkillLevel, String>();
    private static final Map<String, SkillLevel> XML_TYPE_MAP;
    private static final Map<SkillLevel, String> TYPE_XML_MAP;

    SkillLevelHelper() {
    }

    public static SkillLevel getInstanceFromXml(String value) {
        return XML_TYPE_MAP.getOrDefault(value, DEFAULT_VALUE);
    }

    public static SkillLevel getInstanceFromXer(Integer value) {
        if (value == null || value < 0 || value >= XER_TYPE_ARRAY.length) {
            return DEFAULT_VALUE;
        }
        return XER_TYPE_ARRAY[value];
    }

    public static String getXmlFromInstance(SkillLevel value) {
        if (value == null) {
            value = DEFAULT_VALUE;
        }
        return TYPE_XML_MAP.get((Object)value);
    }

    public static String getXerFromInstance(SkillLevel value) {
        return TYPE_XER_MAP.get((Object)value);
    }

    static {
        TYPE_XER_MAP.put(SkillLevel.MASTER, "1");
        TYPE_XER_MAP.put(SkillLevel.EXPERT, "2");
        TYPE_XER_MAP.put(SkillLevel.SKILLED, "3");
        TYPE_XER_MAP.put(SkillLevel.PROFICIENT, "4");
        TYPE_XER_MAP.put(SkillLevel.INEXPERIENCED, "5");
        XML_TYPE_MAP = new HashMap<String, SkillLevel>();
        XML_TYPE_MAP.put("1 - Master", SkillLevel.MASTER);
        XML_TYPE_MAP.put("2 - Expert", SkillLevel.EXPERT);
        XML_TYPE_MAP.put("3 - Skilled", SkillLevel.SKILLED);
        XML_TYPE_MAP.put("4 - Proficient", SkillLevel.PROFICIENT);
        XML_TYPE_MAP.put("5 - Inexperienced", SkillLevel.INEXPERIENCED);
        TYPE_XML_MAP = new HashMap<SkillLevel, String>();
        TYPE_XML_MAP.put(SkillLevel.MASTER, "1 - Master");
        TYPE_XML_MAP.put(SkillLevel.EXPERT, "2 - Expert");
        TYPE_XML_MAP.put(SkillLevel.SKILLED, "3 - Skilled");
        TYPE_XML_MAP.put(SkillLevel.PROFICIENT, "4 - Proficient");
        TYPE_XML_MAP.put(SkillLevel.INEXPERIENCED, "5 - Inexperienced");
    }
}

