/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import org.mpxj.Task;

final class TaskHelper {
    private static final String DEFAULT_WBS_CODE = "WBS";

    TaskHelper() {
    }

    public static String getWbsCode(Task task) {
        String code = task.getWBS();
        if (code == null || code.isEmpty()) {
            code = DEFAULT_WBS_CODE;
        } else {
            String prefix = null;
            String projectID = task.getParentFile().getProjectProperties().getProjectID();
            String separator = task.getParentFile().getProjectProperties().getWbsCodeSeparator();
            if (task.getParentTask() == null && projectID != null) {
                prefix = projectID + separator;
            } else if (task.getParentTask() != null) {
                prefix = task.getParentTask().getWBS() + separator;
            }
            if (prefix != null && code.startsWith(prefix)) {
                code = code.substring(prefix.length());
            }
        }
        return code;
    }
}

