/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.util.HashMap;
import java.util.Map;
import org.mpxj.TaskType;

final class TaskTypeHelper {
    private static final Map<String, TaskType> XML_TYPE_MAP = new HashMap<String, TaskType>();
    private static final Map<String, TaskType> XER_TYPE_MAP;
    private static final Map<TaskType, String> TYPE_XML_MAP;
    private static final Map<TaskType, String> TYPE_XER_MAP;

    TaskTypeHelper() {
    }

    public static TaskType getInstanceFromXml(String value) {
        return XML_TYPE_MAP.get(value);
    }

    public static TaskType getInstanceFromXer(String value) {
        return XER_TYPE_MAP.get(value);
    }

    public static String getXmlFromInstance(TaskType value) {
        return TYPE_XML_MAP.get((Object)value);
    }

    public static String getXerFromInstance(TaskType value) {
        return TYPE_XER_MAP.get((Object)value);
    }

    static {
        XML_TYPE_MAP.put("Fixed Units/Time", TaskType.FIXED_UNITS);
        XML_TYPE_MAP.put("Fixed Duration and Units/Time", TaskType.FIXED_DURATION);
        XML_TYPE_MAP.put("Fixed Units", TaskType.FIXED_WORK);
        XML_TYPE_MAP.put("Fixed Duration and Units", TaskType.FIXED_DURATION_AND_UNITS);
        XER_TYPE_MAP = new HashMap<String, TaskType>();
        XER_TYPE_MAP.put("DT_FixedRate", TaskType.FIXED_UNITS);
        XER_TYPE_MAP.put("DT_FixedDrtn", TaskType.FIXED_DURATION);
        XER_TYPE_MAP.put("DT_FixedQty", TaskType.FIXED_WORK);
        XER_TYPE_MAP.put("DT_FixedDUR2", TaskType.FIXED_DURATION_AND_UNITS);
        TYPE_XML_MAP = new HashMap<TaskType, String>();
        TYPE_XML_MAP.put(TaskType.FIXED_UNITS, "Fixed Units/Time");
        TYPE_XML_MAP.put(TaskType.FIXED_DURATION, "Fixed Duration and Units/Time");
        TYPE_XML_MAP.put(TaskType.FIXED_WORK, "Fixed Units");
        TYPE_XML_MAP.put(TaskType.FIXED_DURATION_AND_UNITS, "Fixed Duration and Units");
        TYPE_XER_MAP = new HashMap<TaskType, String>();
        TYPE_XER_MAP.put(TaskType.FIXED_UNITS, "DT_FixedRate");
        TYPE_XER_MAP.put(TaskType.FIXED_DURATION, "DT_FixedDrtn");
        TYPE_XER_MAP.put(TaskType.FIXED_WORK, "DT_FixedQty");
        TYPE_XER_MAP.put(TaskType.FIXED_DURATION_AND_UNITS, "DT_FixedDUR2");
    }
}

