/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.mpxj.CustomField;
import org.mpxj.DataType;
import org.mpxj.FieldType;
import org.mpxj.ProjectFile;
import org.mpxj.common.FieldLists;
import org.mpxj.common.FieldTypeHelper;

final class UdfHelper {
    private static final Map<String, DataType> DATA_TYPE_FROM_XER = new HashMap<String, DataType>();
    private static final Map<String, DataType> DATA_TYPE_FROM_XML;
    private static final Map<DataType, String> XML_FROM_DATA_TYPE;
    private static final Map<DataType, String> XER_FROM_DATA_TYPE;

    UdfHelper() {
    }

    public static Set<FieldType> getUserDefinedFieldsSet(ProjectFile file) {
        Set<FieldType> set = file.getCustomFields().stream().map(CustomField::getFieldType).filter(Objects::nonNull).collect(Collectors.toSet());
        set.addAll(file.getUserDefinedFields());
        set.addAll(file.getPopulatedFields().stream().filter(FieldLists.CUSTOM_FIELDS_SET::contains).collect(Collectors.toSet()));
        set.removeIf(f -> FieldTypeHelper.getFieldID(f) == -1);
        return set;
    }

    public static DataType getDataTypeFromXml(String value) {
        return DATA_TYPE_FROM_XML.get(value);
    }

    public static DataType getDataTypeFromXer(String value) {
        return DATA_TYPE_FROM_XER.get(value);
    }

    public static String getXmlFromDataType(DataType value) {
        String result = XML_FROM_DATA_TYPE.get(value);
        if (result == null) {
            throw new RuntimeException("Unconvertible data type: " + value);
        }
        return result;
    }

    public static String getXerFromDataType(DataType value) {
        String result = XER_FROM_DATA_TYPE.get(value);
        if (result == null) {
            throw new RuntimeException("Unconvertible data type: " + value);
        }
        return result;
    }

    static {
        DATA_TYPE_FROM_XER.put("FT_TEXT", DataType.STRING);
        DATA_TYPE_FROM_XER.put("FT_MONEY", DataType.CURRENCY);
        DATA_TYPE_FROM_XER.put("FT_END_DATE", DataType.DATE);
        DATA_TYPE_FROM_XER.put("FT_STATICTYPE", DataType.STRING);
        DATA_TYPE_FROM_XER.put("FT_INT", DataType.INTEGER);
        DATA_TYPE_FROM_XER.put("FT_FLOAT", DataType.NUMERIC);
        DATA_TYPE_FROM_XER.put("FT_FLOAT_2_DECIMALS", DataType.NUMERIC);
        DATA_TYPE_FROM_XER.put("FT_START_DATE", DataType.DATE);
        DATA_TYPE_FROM_XML = new HashMap<String, DataType>();
        DATA_TYPE_FROM_XML.put("Text", DataType.STRING);
        DATA_TYPE_FROM_XML.put("Cost", DataType.CURRENCY);
        DATA_TYPE_FROM_XML.put("Finish Date", DataType.DATE);
        DATA_TYPE_FROM_XML.put("Indicator", DataType.STRING);
        DATA_TYPE_FROM_XML.put("Integer", DataType.INTEGER);
        DATA_TYPE_FROM_XML.put("Double", DataType.NUMERIC);
        DATA_TYPE_FROM_XML.put("Start Date", DataType.DATE);
        XML_FROM_DATA_TYPE = new HashMap<DataType, String>();
        XML_FROM_DATA_TYPE.put(DataType.BINARY, "Text");
        XML_FROM_DATA_TYPE.put(DataType.STRING, "Text");
        XML_FROM_DATA_TYPE.put(DataType.DURATION, "Text");
        XML_FROM_DATA_TYPE.put(DataType.DATE, "Start Date");
        XML_FROM_DATA_TYPE.put(DataType.NUMERIC, "Double");
        XML_FROM_DATA_TYPE.put(DataType.BOOLEAN, "Integer");
        XML_FROM_DATA_TYPE.put(DataType.INTEGER, "Integer");
        XML_FROM_DATA_TYPE.put(DataType.SHORT, "Integer");
        XML_FROM_DATA_TYPE.put(DataType.CURRENCY, "Cost");
        XER_FROM_DATA_TYPE = new HashMap<DataType, String>();
        XER_FROM_DATA_TYPE.put(DataType.CUSTOM, "FT_TEXT");
        XER_FROM_DATA_TYPE.put(DataType.BINARY, "FT_TEXT");
        XER_FROM_DATA_TYPE.put(DataType.STRING, "FT_TEXT");
        XER_FROM_DATA_TYPE.put(DataType.DURATION, "FT_TEXT");
        XER_FROM_DATA_TYPE.put(DataType.DATE, "FT_START_DATE");
        XER_FROM_DATA_TYPE.put(DataType.NUMERIC, "FT_FLOAT");
        XER_FROM_DATA_TYPE.put(DataType.BOOLEAN, "FT_INT");
        XER_FROM_DATA_TYPE.put(DataType.INTEGER, "FT_INT");
        XER_FROM_DATA_TYPE.put(DataType.SHORT, "FT_INT");
        XER_FROM_DATA_TYPE.put(DataType.CURRENCY, "FT_MONEY");
    }
}

