/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import java.util.Arrays;
import java.util.Objects;
import org.mpxj.Duration;
import org.mpxj.Task;
import org.mpxj.TimeUnit;

class WorkHelper {
    WorkHelper() {
    }

    public static Duration addWork(Duration ... values) {
        return Duration.getInstance(Arrays.stream(values).filter(Objects::nonNull).mapToDouble(Duration::getDuration).sum(), TimeUnit.HOURS);
    }

    public static Duration zeroIfNull(Duration value) {
        return value == null ? Duration.getInstance(0, TimeUnit.HOURS) : value;
    }

    public static Duration getActualWorkLabor(Task task) {
        return WorkHelper.getWork(task.getActualWork(), task.getActualWorkLabor(), task.getActualWorkNonlabor());
    }

    public static Duration getPlannedWorkLabor(Task task) {
        return WorkHelper.getWork(task.getPlannedWork(), task.getPlannedWorkLabor(), task.getPlannedWorkNonlabor());
    }

    public static Duration getRemainingWorkLabor(Task task) {
        return WorkHelper.getWork(task.getRemainingWork(), task.getRemainingWorkLabor(), task.getRemainingWorkNonlabor());
    }

    private static Duration getWork(Duration total, Duration labor, Duration nonlabor) {
        if (total == null && labor == null && nonlabor == null) {
            return Duration.getInstance(0, TimeUnit.HOURS);
        }
        if (total != null && labor == null && nonlabor == null) {
            return total;
        }
        return WorkHelper.zeroIfNull(labor);
    }
}

