/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera;

import jakarta.xml.bind.DatatypeConverter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mpxj.AccrueType;
import org.mpxj.ActivityCodeScope;
import org.mpxj.ActivityStatus;
import org.mpxj.ActivityType;
import org.mpxj.CalendarType;
import org.mpxj.ConstraintType;
import org.mpxj.CriticalActivityType;
import org.mpxj.DataType;
import org.mpxj.Duration;
import org.mpxj.HtmlNotes;
import org.mpxj.Notes;
import org.mpxj.PercentCompleteType;
import org.mpxj.Priority;
import org.mpxj.ProjectFile;
import org.mpxj.Rate;
import org.mpxj.RateSource;
import org.mpxj.RelationType;
import org.mpxj.ResourceType;
import org.mpxj.SkillLevel;
import org.mpxj.TaskType;
import org.mpxj.TimeUnit;
import org.mpxj.common.ColorHelper;
import org.mpxj.common.HtmlHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.primavera.AccrueTypeHelper;
import org.mpxj.primavera.ActivityCodeScopeHelper;
import org.mpxj.primavera.ActivityStatusHelper;
import org.mpxj.primavera.ActivityTypeHelper;
import org.mpxj.primavera.CalendarTypeHelper;
import org.mpxj.primavera.ConstraintTypeHelper;
import org.mpxj.primavera.CriticalActivityTypeHelper;
import org.mpxj.primavera.CurrencyValue;
import org.mpxj.primavera.DateOnly;
import org.mpxj.primavera.MaxUnits;
import org.mpxj.primavera.PercentCompleteTypeHelper;
import org.mpxj.primavera.PrimaveraXERFileWriter;
import org.mpxj.primavera.PriorityHelper;
import org.mpxj.primavera.RateSourceHelper;
import org.mpxj.primavera.RelationTypeHelper;
import org.mpxj.primavera.ResourceTypeHelper;
import org.mpxj.primavera.SkillLevelHelper;
import org.mpxj.primavera.TaskTypeHelper;
import org.mpxj.primavera.UdfHelper;

final class XerWriter {
    private final ProjectFile m_file;
    private final OutputStreamWriter m_writer;
    private final DateTimeFormatter m_dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final DateTimeFormatter m_timestampFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private final DecimalFormat m_doubleFormat = new DecimalFormat("0.######");
    private final DecimalFormat m_currencyFormat = new DecimalFormat("0.0000");
    private final DecimalFormat m_maxUnitsFormat = new DecimalFormat("0.####");
    private static final Map<Class<?>, FormatFunction> FORMAT_MAP = new HashMap();

    public XerWriter(ProjectFile file, OutputStreamWriter writer) {
        this.m_file = file;
        this.m_writer = writer;
    }

    public void writeHeader(Object[] data) {
        try {
            this.m_writer.write(Arrays.stream(data).map(this::format).collect(Collectors.joining("\t")));
            this.m_writer.write("\n");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void writeTable(String name, Map<String, ?> map) {
        try {
            this.m_writer.write("%T\t" + name + "\n");
            this.m_writer.write("%F\t");
            this.m_writer.write(String.join((CharSequence)"\t", map.keySet()));
            this.m_writer.write("\n");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T> void writeRecord(Map<String, PrimaveraXERFileWriter.ExportFunction<T>> columns, T object) {
        this.writeRecord(columns.values().stream().map(f -> f.apply(object)));
    }

    public void writeRecord(Stream<Object> data) {
        try {
            this.m_writer.write("%R\t");
            this.m_writer.write(data.map(this::format).collect(Collectors.joining("\t")));
            this.m_writer.write("\n");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void writeTrailer() {
        try {
            this.m_writer.write("%E\n");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void flush() throws IOException {
        this.m_writer.flush();
    }

    private String format(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Notes) {
            return this.formatNotes((Notes)object);
        }
        FormatFunction f = FORMAT_MAP.get(object.getClass());
        return f == null ? object.toString() : f.apply(this, object);
    }

    private String formatNotes(Notes notes) {
        String result;
        if (notes == null || notes.isEmpty()) {
            result = "";
        } else {
            result = notes instanceof HtmlNotes ? ((HtmlNotes)notes).getHtml() : HtmlHelper.getHtmlFromPlainText(notes.toString());
            result = result.replace("\n", "\u007f\u007f");
        }
        return this.formatString(result);
    }

    private String formatUUID(UUID value) {
        byte[] data = new byte[16];
        long lsb = value.getLeastSignificantBits();
        long msb = value.getMostSignificantBits();
        data[15] = (byte)(lsb & 0xFFL);
        data[14] = (byte)(lsb >> 8 & 0xFFL);
        data[13] = (byte)(lsb >> 16 & 0xFFL);
        data[12] = (byte)(lsb >> 24 & 0xFFL);
        data[11] = (byte)(lsb >> 32 & 0xFFL);
        data[10] = (byte)(lsb >> 40 & 0xFFL);
        data[9] = (byte)(lsb >> 48 & 0xFFL);
        data[8] = (byte)(lsb >> 56 & 0xFFL);
        data[6] = (byte)(msb & 0xFFL);
        data[7] = (byte)(msb >> 8 & 0xFFL);
        data[4] = (byte)(msb >> 16 & 0xFFL);
        data[5] = (byte)(msb >> 24 & 0xFFL);
        data[0] = (byte)(msb >> 32 & 0xFFL);
        data[1] = (byte)(msb >> 40 & 0xFFL);
        data[2] = (byte)(msb >> 48 & 0xFFL);
        data[3] = (byte)(msb >> 56 & 0xFFL);
        String result = DatatypeConverter.printBase64Binary((byte[])data);
        return result.substring(0, result.length() - 2);
    }

    private String formatDuration(Duration duration) {
        if (duration == null) {
            return "";
        }
        return this.m_doubleFormat.format(duration.convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration());
    }

    private String formatString(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        if (value.indexOf(34) == -1) {
            return value;
        }
        return value.replace("\"", "\"\"");
    }

    static {
        FORMAT_MAP.put(DateOnly.class, (w, o) -> w.m_dateFormat.format(((DateOnly)o).toDate()));
        FORMAT_MAP.put(LocalDateTime.class, (w, o) -> w.m_timestampFormat.format((LocalDateTime)o));
        FORMAT_MAP.put(Double.class, (w, o) -> w.m_doubleFormat.format(o));
        FORMAT_MAP.put(Boolean.class, (w, o) -> (Boolean)o != false ? "Y" : "N");
        FORMAT_MAP.put(Rate.class, (w, o) -> w.m_currencyFormat.format(((Rate)o).getAmount()));
        FORMAT_MAP.put(UUID.class, (w, o) -> w.formatUUID((UUID)o));
        FORMAT_MAP.put(ResourceType.class, (w, o) -> ResourceTypeHelper.getXerFromInstance((ResourceType)o));
        FORMAT_MAP.put(CriticalActivityType.class, (w, o) -> CriticalActivityTypeHelper.getXerFromInstance((CriticalActivityType)((Object)((Object)o))));
        FORMAT_MAP.put(TaskType.class, (w, o) -> TaskTypeHelper.getXerFromInstance((TaskType)((Object)((Object)o))));
        FORMAT_MAP.put(CalendarType.class, (w, o) -> CalendarTypeHelper.getXerFromInstance((CalendarType)((Object)((Object)o))));
        FORMAT_MAP.put(ActivityType.class, (w, o) -> ActivityTypeHelper.getXerFromInstance((ActivityType)((Object)((Object)o))));
        FORMAT_MAP.put(PercentCompleteType.class, (w, o) -> PercentCompleteTypeHelper.getXerFromInstance((PercentCompleteType)((Object)((Object)o))));
        FORMAT_MAP.put(ActivityStatus.class, (w, o) -> ActivityStatusHelper.getXerFromInstance((ActivityStatus)((Object)((Object)o))));
        FORMAT_MAP.put(Duration.class, (w, o) -> w.formatDuration((Duration)o));
        FORMAT_MAP.put(ConstraintType.class, (w, o) -> ConstraintTypeHelper.getXerFromInstance((ConstraintType)o));
        FORMAT_MAP.put(Priority.class, (w, o) -> PriorityHelper.getXerFromInstance((Priority)o));
        FORMAT_MAP.put(RelationType.class, (w, o) -> RelationTypeHelper.getXerFromInstance((RelationType)o));
        FORMAT_MAP.put(AccrueType.class, (w, o) -> AccrueTypeHelper.getXerFromInstance((AccrueType)o));
        FORMAT_MAP.put(ActivityCodeScope.class, (w, o) -> ActivityCodeScopeHelper.getXerFromInstance((ActivityCodeScope)((Object)((Object)o))));
        FORMAT_MAP.put(Color.class, (w, o) -> ColorHelper.getHexColor((Color)o));
        FORMAT_MAP.put(RateSource.class, (w, o) -> RateSourceHelper.getXerFromInstance((RateSource)((Object)((Object)o))));
        FORMAT_MAP.put(DataType.class, (w, o) -> UdfHelper.getXerFromDataType((DataType)o));
        FORMAT_MAP.put(MaxUnits.class, (w, o) -> w.m_maxUnitsFormat.format(NumberHelper.getDouble(((MaxUnits)o).toNumber()) / 100.0));
        FORMAT_MAP.put(CurrencyValue.class, (w, o) -> w.m_currencyFormat.format(((CurrencyValue)o).toNumber()));
        FORMAT_MAP.put(SkillLevel.class, (w, o) -> SkillLevelHelper.getXerFromInstance((SkillLevel)((Object)((Object)o))));
        FORMAT_MAP.put(String.class, (w, o) -> w.formatString((String)o));
    }

    private static interface FormatFunction {
        public String apply(XerWriter var1, Object var2);
    }
}

