/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera.common;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.mpxj.primavera.common.MapRow;

public class Table
implements Iterable<MapRow> {
    private final Map<Object, MapRow> m_rows = new TreeMap<Object, MapRow>();
    private int m_rowNumber = 1;

    @Override
    public Iterator<MapRow> iterator() {
        return this.m_rows.values().iterator();
    }

    public MapRow find(Object uniqueID) {
        return this.m_rows.get(uniqueID);
    }

    public void addRow(String primaryKeyColumnName, Map<String, Object> map) {
        Integer rowNumber = this.m_rowNumber++;
        map.put("ROW_NUMBER", rowNumber);
        Object primaryKey = null;
        if (primaryKeyColumnName != null) {
            primaryKey = map.get(primaryKeyColumnName);
        }
        if (primaryKey == null) {
            primaryKey = rowNumber;
        }
        MapRow newRow = new MapRow(map);
        MapRow oldRow = this.m_rows.get(primaryKey);
        if (oldRow == null) {
            this.m_rows.put(primaryKey, newRow);
        } else {
            int oldVersion = oldRow.getInteger("ROW_VERSION");
            int newVersion = newRow.getInteger("ROW_VERSION");
            if (newVersion > oldVersion) {
                this.m_rows.put(primaryKey, newRow);
            }
        }
    }
}

