/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera.p3;

import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mpxj.ChildTaskContainer;
import org.mpxj.ConstraintType;
import org.mpxj.EventManager;
import org.mpxj.FieldContainer;
import org.mpxj.FieldType;
import org.mpxj.MPXJException;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectConfig;
import org.mpxj.ProjectField;
import org.mpxj.ProjectFile;
import org.mpxj.Relation;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceField;
import org.mpxj.Task;
import org.mpxj.TaskField;
import org.mpxj.common.AlphanumComparator;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.SlackHelper;
import org.mpxj.primavera.common.MapRow;
import org.mpxj.primavera.common.Table;
import org.mpxj.primavera.p3.DatabaseReader;
import org.mpxj.primavera.p3.P3WbsFormat;
import org.mpxj.reader.AbstractProjectFileReader;

public final class P3DatabaseReader
extends AbstractProjectFileReader {
    private String m_projectName;
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private Map<String, Table> m_tables;
    private P3WbsFormat m_wbsFormat;
    private Map<String, Resource> m_resourceMap;
    private Map<String, Task> m_wbsMap;
    private Map<String, Task> m_activityMap;
    private static final Map<String, FieldType> PROJECT_FIELDS = new LinkedHashMap<String, FieldType>();
    private static final Map<String, FieldType> RESOURCE_FIELDS = new LinkedHashMap<String, FieldType>();
    private static final Map<String, FieldType> TASK_FIELDS = new LinkedHashMap<String, FieldType>();

    public static final ProjectFile setProjectNameAndRead(File directory) throws MPXJException {
        List<String> projects = P3DatabaseReader.listProjectNames(directory);
        if (projects.isEmpty()) {
            return null;
        }
        P3DatabaseReader reader = new P3DatabaseReader();
        reader.setProjectName(projects.get(0));
        return reader.read(directory);
    }

    public static final List<String> listProjectNames(String directory) {
        return P3DatabaseReader.listProjectNames(new File(directory));
    }

    public static final List<String> listProjectNames(File directory) {
        ArrayList<String> result = new ArrayList<String>();
        File[] files = directory.listFiles((dir, name) -> name.toUpperCase().endsWith("STR.P3"));
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName();
                String prefix = fileName.substring(0, fileName.length() - 6);
                result.add(prefix);
            }
        }
        Collections.sort(result);
        return result;
    }

    public void setProjectName(String projectName) {
        this.m_projectName = projectName;
    }

    @Override
    public ProjectFile read(File directory) throws MPXJException {
        if (!directory.isDirectory()) {
            throw new MPXJException("Directory expected");
        }
        try {
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoResourceID(true);
            config.setAutoResourceUniqueID(true);
            config.setAutoTaskID(true);
            config.setAutoTaskUniqueID(true);
            config.setAutoOutlineLevel(true);
            config.setAutoOutlineNumber(true);
            config.setAutoWBS(false);
            this.m_projectFile.getProjectProperties().setFileApplication("P3");
            this.m_projectFile.getProjectProperties().setFileType("BTRIEVE");
            this.addListenersToProject(this.m_projectFile);
            this.m_tables = new DatabaseReader().process(directory, this.m_projectName);
            this.m_resourceMap = new HashMap<String, Resource>();
            this.m_wbsMap = new HashMap<String, Task>();
            this.m_activityMap = new HashMap<String, Task>();
            this.readProjectHeader();
            this.readCalendars();
            this.readResources();
            this.readTasks();
            this.readRelationships();
            this.readResourceAssignments();
            this.m_projectFile.readComplete();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (IOException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        finally {
            this.m_projectFile = null;
            this.m_eventManager = null;
            this.m_tables = null;
            this.m_resourceMap = null;
            this.m_wbsFormat = null;
            this.m_wbsMap = null;
            this.m_activityMap = null;
        }
    }

    @Override
    public List<ProjectFile> readAll(File directory) throws MPXJException {
        ArrayList<ProjectFile> projects = new ArrayList<ProjectFile>();
        for (String name : P3DatabaseReader.listProjectNames(directory)) {
            P3DatabaseReader reader = new P3DatabaseReader();
            reader.setProjectName(name);
            projects.add(reader.read(directory));
        }
        return projects;
    }

    private void readProjectHeader() {
        Table table = this.m_tables.get("DIR");
        MapRow row = table.find("");
        if (row != null) {
            this.setFields(PROJECT_FIELDS, row, this.m_projectFile.getProjectProperties());
            this.m_wbsFormat = new P3WbsFormat(row);
        }
    }

    private void readCalendars() {
        ProjectCalendar defaultCalendar = this.m_projectFile.addDefaultBaseCalendar();
        this.m_projectFile.getProjectProperties().setDefaultCalendar(defaultCalendar);
    }

    private void readResources() {
        for (MapRow row : this.m_tables.get("RLB")) {
            Resource resource = this.m_projectFile.addResource();
            this.setFields(RESOURCE_FIELDS, row, resource);
            this.m_resourceMap.put(resource.getCode(), resource);
        }
    }

    private void readTasks() {
        this.readWBS();
        this.readActivities();
        this.updateDates();
    }

    private void readWBS() {
        List items;
        HashMap<Integer, List> levelMap = new HashMap<Integer, List>();
        for (MapRow row : this.m_tables.get("STR")) {
            Integer level = row.getInteger("LEVEL_NUMBER");
            List items2 = levelMap.computeIfAbsent(level, k -> new ArrayList());
            items2.add(row);
        }
        int level = 1;
        while ((items = (List)levelMap.get(level++)) != null) {
            for (MapRow row : items) {
                this.m_wbsFormat.parseRawValue(row.getString("CODE_VALUE"));
                String parentWbsValue = this.m_wbsFormat.getFormattedParentValue();
                String wbsValue = this.m_wbsFormat.getFormattedValue();
                row.setObject("WBS", wbsValue);
                row.setObject("PARENT_WBS", parentWbsValue);
            }
            AlphanumComparator comparator = new AlphanumComparator();
            items.sort((o1, o2) -> comparator.compare(o1.getString("WBS"), o2.getString("WBS")));
            for (MapRow row : items) {
                String wbs = row.getString("WBS");
                if (wbs == null || wbs.isEmpty()) continue;
                ChildTaskContainer parent = this.m_wbsMap.get(row.getString("PARENT_WBS"));
                if (parent == null) {
                    parent = this.m_projectFile;
                }
                Task task = parent.addTask();
                String name = row.getString("CODE_TITLE");
                if (name == null || name.isEmpty()) {
                    name = wbs;
                }
                task.setName(name);
                task.setWBS(wbs);
                task.setSummary(true);
                this.m_wbsMap.put(wbs, task);
                this.m_eventManager.fireTaskReadEvent(task);
            }
        }
    }

    private void readActivities() {
        HashMap<String, ChildTaskContainer> parentMap = new HashMap<String, ChildTaskContainer>();
        for (Object row : this.m_tables.get("WBS")) {
            String activityID = ((MapRow)row).getString("ACTIVITY_ID");
            this.m_wbsFormat.parseRawValue(((MapRow)row).getString("CODE_VALUE"));
            String parentWBS = this.m_wbsFormat.getFormattedValue();
            ChildTaskContainer parent = this.m_wbsMap.get(parentWBS);
            if (parent == null) continue;
            parentMap.put(activityID, parent);
        }
        ArrayList<MapRow> items = new ArrayList<MapRow>();
        for (MapRow row : this.m_tables.get("ACT")) {
            items.add(row);
        }
        AlphanumComparator comparator = new AlphanumComparator();
        items.sort((o1, o2) -> comparator.compare(o1.getString("ACTIVITY_ID"), o2.getString("ACTIVITY_ID")));
        for (MapRow row : items) {
            LocalDateTime date;
            int percentComplete;
            String activityID = row.getString("ACTIVITY_ID");
            ChildTaskContainer parent = (ChildTaskContainer)parentMap.get(activityID);
            if (parent == null) {
                parent = this.m_projectFile;
            }
            Task task = parent.addTask();
            this.setFields(TASK_FIELDS, row, task);
            task.setStart(task.getEarlyStart());
            task.setFinish(task.getEarlyFinish());
            task.setMilestone(task.getDuration().getDuration() == 0.0);
            if (parent instanceof Task) {
                task.setWBS(((Task)parent).getWBS());
            }
            if ((percentComplete = task.getPercentageComplete().intValue()) < 0) {
                task.setPercentageComplete(0);
            } else if (percentComplete > 100) {
                task.setPercentageComplete(100);
            }
            int flag = row.getInteger("ACTUAL_START_OR_CONSTRAINT_FLAG");
            if (flag != 0) {
                date = row.getDate("AS_OR_ED_CONSTRAINT");
                switch (flag) {
                    case 1: {
                        task.setConstraintType(ConstraintType.START_NO_EARLIER_THAN);
                        task.setConstraintDate(date);
                        break;
                    }
                    case 3: {
                        task.setConstraintType(ConstraintType.FINISH_NO_EARLIER_THAN);
                        task.setConstraintDate(date);
                        break;
                    }
                    case 99: {
                        task.setActualStart(date);
                    }
                }
            }
            if ((flag = row.getInteger("ACTUAL_FINISH_OR_CONSTRAINT_FLAG").intValue()) != 0) {
                date = row.getDate("AF_OR_LD_CONSTRAINT");
                switch (flag) {
                    case 2: {
                        task.setConstraintType(ConstraintType.START_NO_LATER_THAN);
                        task.setConstraintDate(date);
                        break;
                    }
                    case 4: {
                        task.setConstraintType(ConstraintType.FINISH_NO_LATER_THAN);
                        task.setConstraintDate(date);
                        break;
                    }
                    case 99: {
                        task.setActualFinish(date);
                    }
                }
            }
            SlackHelper.inferSlack(task);
            this.m_activityMap.put(activityID, task);
            this.m_eventManager.fireTaskReadEvent(task);
        }
    }

    private void readRelationships() {
        for (MapRow row : this.m_tables.get("REL")) {
            Task predecessor = this.m_activityMap.get(row.getString("PREDECESSOR_ACTIVITY_ID"));
            Task successor = this.m_activityMap.get(row.getString("SUCCESSOR_ACTIVITY_ID"));
            if (predecessor == null || successor == null) continue;
            Relation relation = successor.addPredecessor(new Relation.Builder().predecessorTask(predecessor).type(row.getRelationType("LAG_TYPE")).lag(row.getDuration("LAG_VALUE")));
            this.m_eventManager.fireRelationReadEvent(relation);
        }
    }

    private void readResourceAssignments() {
        for (MapRow row : this.m_tables.get("RES")) {
            Task task = this.m_activityMap.get(row.getString("ACTIVITY_ID"));
            Resource resource = this.m_resourceMap.get(row.getString("RESOURCE_ID"));
            if (task == null || resource == null) continue;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            this.m_eventManager.fireAssignmentReadEvent(assignment);
        }
    }

    private void updateDates() {
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.updateDates(task);
        }
    }

    private void updateDates(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            int finished = 0;
            LocalDateTime startDate = parentTask.getStart();
            LocalDateTime finishDate = parentTask.getFinish();
            LocalDateTime actualStartDate = parentTask.getActualStart();
            LocalDateTime actualFinishDate = parentTask.getActualFinish();
            LocalDateTime earlyStartDate = parentTask.getEarlyStart();
            LocalDateTime earlyFinishDate = parentTask.getEarlyFinish();
            LocalDateTime lateStartDate = parentTask.getLateStart();
            LocalDateTime lateFinishDate = parentTask.getLateFinish();
            for (Task task : parentTask.getChildTasks()) {
                this.updateDates(task);
                startDate = LocalDateTimeHelper.min(startDate, task.getStart());
                finishDate = LocalDateTimeHelper.max(finishDate, task.getFinish());
                actualStartDate = LocalDateTimeHelper.min(actualStartDate, task.getActualStart());
                actualFinishDate = LocalDateTimeHelper.max(actualFinishDate, task.getActualFinish());
                earlyStartDate = LocalDateTimeHelper.min(earlyStartDate, task.getEarlyStart());
                earlyFinishDate = LocalDateTimeHelper.max(earlyFinishDate, task.getEarlyFinish());
                lateStartDate = LocalDateTimeHelper.min(lateStartDate, task.getLateStart());
                lateFinishDate = LocalDateTimeHelper.max(lateFinishDate, task.getLateFinish());
                if (task.getActualFinish() == null) continue;
                ++finished;
            }
            parentTask.setStart(startDate);
            parentTask.setFinish(finishDate);
            parentTask.setActualStart(actualStartDate);
            parentTask.setEarlyStart(earlyStartDate);
            parentTask.setEarlyFinish(earlyFinishDate);
            parentTask.setLateStart(lateStartDate);
            parentTask.setLateFinish(lateFinishDate);
            if (finished == parentTask.getChildTasks().size()) {
                parentTask.setActualFinish(actualFinishDate);
            }
        }
    }

    private void setFields(Map<String, FieldType> map, MapRow row, FieldContainer container) {
        if (row != null) {
            for (Map.Entry<String, FieldType> entry : map.entrySet()) {
                container.set(entry.getValue(), row.getObject(entry.getKey()));
            }
        }
    }

    private static void defineField(Map<String, FieldType> container, String name, FieldType type) {
        container.put(name, type);
    }

    static {
        P3DatabaseReader.defineField(PROJECT_FIELDS, "PROJECT_START_DATE", ProjectField.START_DATE);
        P3DatabaseReader.defineField(PROJECT_FIELDS, "PROJECT_FINISH_DATE", ProjectField.FINISH_DATE);
        P3DatabaseReader.defineField(PROJECT_FIELDS, "CURRENT_DATA_DATE", ProjectField.STATUS_DATE);
        P3DatabaseReader.defineField(PROJECT_FIELDS, "COMPANY_TITLE", ProjectField.COMPANY);
        P3DatabaseReader.defineField(PROJECT_FIELDS, "PROJECT_TITLE", ProjectField.NAME);
        P3DatabaseReader.defineField(RESOURCE_FIELDS, "RES_TITLE", ResourceField.NAME);
        P3DatabaseReader.defineField(RESOURCE_FIELDS, "RES_ID", ResourceField.CODE);
        P3DatabaseReader.defineField(TASK_FIELDS, "ACTIVITY_TITLE", TaskField.NAME);
        P3DatabaseReader.defineField(TASK_FIELDS, "ACTIVITY_ID", TaskField.ACTIVITY_ID);
        P3DatabaseReader.defineField(TASK_FIELDS, "ORIGINAL_DURATION", TaskField.DURATION);
        P3DatabaseReader.defineField(TASK_FIELDS, "REMAINING_DURATION", TaskField.REMAINING_DURATION);
        P3DatabaseReader.defineField(TASK_FIELDS, "PERCENT_COMPLETE", TaskField.PERCENT_COMPLETE);
        P3DatabaseReader.defineField(TASK_FIELDS, "EARLY_START", TaskField.EARLY_START);
        P3DatabaseReader.defineField(TASK_FIELDS, "LATE_START", TaskField.LATE_START);
        P3DatabaseReader.defineField(TASK_FIELDS, "EARLY_FINISH", TaskField.EARLY_FINISH);
        P3DatabaseReader.defineField(TASK_FIELDS, "LATE_FINISH", TaskField.LATE_FINISH);
        P3DatabaseReader.defineField(TASK_FIELDS, "FREE_FLOAT", TaskField.FREE_SLACK);
        P3DatabaseReader.defineField(TASK_FIELDS, "TOTAL_FLOAT", TaskField.TOTAL_SLACK);
    }
}

