/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera.suretrak;

import java.io.File;
import java.io.IOException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mpxj.ChildTaskContainer;
import org.mpxj.Duration;
import org.mpxj.EventManager;
import org.mpxj.FieldContainer;
import org.mpxj.FieldType;
import org.mpxj.LocalTimeRange;
import org.mpxj.MPXJException;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectConfig;
import org.mpxj.ProjectFile;
import org.mpxj.RecurrenceType;
import org.mpxj.RecurringData;
import org.mpxj.Relation;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceField;
import org.mpxj.Task;
import org.mpxj.TaskField;
import org.mpxj.TimeUnit;
import org.mpxj.common.AlphanumComparator;
import org.mpxj.common.LocalDateHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.primavera.common.MapRow;
import org.mpxj.primavera.common.Table;
import org.mpxj.primavera.suretrak.DatabaseReader;
import org.mpxj.primavera.suretrak.SureTrakWbsFormat;
import org.mpxj.reader.AbstractProjectFileReader;

public final class SureTrakDatabaseReader
extends AbstractProjectFileReader {
    private String m_projectName;
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private Map<String, Table> m_tables;
    private SureTrakWbsFormat m_wbsFormat;
    private Map<Integer, List<MapRow>> m_definitions;
    private Map<Integer, ProjectCalendar> m_calendarMap;
    private Map<String, Resource> m_resourceMap;
    private Map<String, Task> m_wbsMap;
    private Map<String, Task> m_activityMap;
    private static final Integer WBS_FORMAT_ID = 121;
    private static final Integer WBS_ENTRIES_ID = 122;
    private static final Map<String, FieldType> RESOURCE_FIELDS = new LinkedHashMap<String, FieldType>();
    private static final Map<String, FieldType> TASK_FIELDS = new LinkedHashMap<String, FieldType>();

    public static final ProjectFile setProjectNameAndRead(File directory) throws MPXJException {
        List<String> projects = SureTrakDatabaseReader.listProjectNames(directory);
        if (projects.isEmpty()) {
            return null;
        }
        SureTrakDatabaseReader reader = new SureTrakDatabaseReader();
        reader.setProjectName(projects.get(0));
        return reader.read(directory);
    }

    public static final List<String> listProjectNames(String directory) {
        return SureTrakDatabaseReader.listProjectNames(new File(directory));
    }

    public static final List<String> listProjectNames(File directory) {
        ArrayList<String> result = new ArrayList<String>();
        File[] files = directory.listFiles((dir, name) -> name.toUpperCase().endsWith(".DIR"));
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName();
                String prefix = fileName.substring(0, fileName.length() - 4);
                result.add(prefix);
            }
        }
        Collections.sort(result);
        return result;
    }

    public void setProjectName(String projectName) {
        this.m_projectName = projectName;
    }

    @Override
    public ProjectFile read(File directory) throws MPXJException {
        if (!directory.isDirectory()) {
            throw new MPXJException("Directory expected");
        }
        try {
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoResourceID(true);
            config.setAutoResourceUniqueID(true);
            config.setAutoTaskID(true);
            config.setAutoTaskUniqueID(true);
            config.setAutoOutlineLevel(true);
            config.setAutoOutlineNumber(true);
            config.setAutoWBS(false);
            this.m_projectFile.getProjectProperties().setFileApplication("SureTrak");
            this.m_projectFile.getProjectProperties().setFileType("STW");
            this.addListenersToProject(this.m_projectFile);
            this.m_tables = new DatabaseReader().process(directory, this.m_projectName);
            this.m_definitions = new HashMap<Integer, List<MapRow>>();
            this.m_calendarMap = new HashMap<Integer, ProjectCalendar>();
            this.m_resourceMap = new HashMap<String, Resource>();
            this.m_wbsMap = new HashMap<String, Task>();
            this.m_activityMap = new HashMap<String, Task>();
            this.readProjectHeader();
            this.readDefinitions();
            this.readCalendars();
            this.readHolidays();
            this.readResources();
            this.readTasks();
            this.readRelationships();
            this.readResourceAssignments();
            this.m_projectFile.readComplete();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (IOException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        finally {
            this.m_projectFile = null;
            this.m_eventManager = null;
            this.m_tables = null;
            this.m_definitions = null;
            this.m_wbsFormat = null;
            this.m_calendarMap = null;
            this.m_resourceMap = null;
            this.m_wbsMap = null;
            this.m_activityMap = null;
        }
    }

    @Override
    public List<ProjectFile> readAll(File directory) throws MPXJException {
        ArrayList<ProjectFile> projects = new ArrayList<ProjectFile>();
        for (String name : SureTrakDatabaseReader.listProjectNames(directory)) {
            SureTrakDatabaseReader reader = new SureTrakDatabaseReader();
            reader.setProjectName(name);
            projects.add(reader.read(directory));
        }
        return projects;
    }

    private void readProjectHeader() {
    }

    private void readDefinitions() {
        for (MapRow row : this.m_tables.get("TTL")) {
            Integer id = row.getInteger("DEFINITION_ID");
            List list = this.m_definitions.computeIfAbsent(id, k -> new ArrayList());
            list.add(row);
        }
        List<MapRow> rows = this.m_definitions.get(WBS_FORMAT_ID);
        if (rows != null) {
            this.m_wbsFormat = new SureTrakWbsFormat(rows.get(0));
        }
    }

    private void readCalendars() {
        Table cal = this.m_tables.get("CAL");
        for (MapRow row : cal) {
            ProjectCalendar calendar = this.m_projectFile.addCalendar();
            this.m_calendarMap.put(row.getInteger("CALENDAR_ID"), calendar);
            Integer[] days = new Integer[]{row.getInteger("SUNDAY_HOURS"), row.getInteger("MONDAY_HOURS"), row.getInteger("TUESDAY_HOURS"), row.getInteger("WEDNESDAY_HOURS"), row.getInteger("THURSDAY_HOURS"), row.getInteger("FRIDAY_HOURS"), row.getInteger("SATURDAY_HOURS")};
            calendar.setName(row.getString("NAME"));
            this.readHours(calendar, DayOfWeek.SUNDAY, days[0]);
            this.readHours(calendar, DayOfWeek.MONDAY, days[1]);
            this.readHours(calendar, DayOfWeek.TUESDAY, days[2]);
            this.readHours(calendar, DayOfWeek.WEDNESDAY, days[3]);
            this.readHours(calendar, DayOfWeek.THURSDAY, days[4]);
            this.readHours(calendar, DayOfWeek.FRIDAY, days[5]);
            this.readHours(calendar, DayOfWeek.SATURDAY, days[6]);
            int workingDaysPerWeek = 0;
            for (DayOfWeek day : DayOfWeek.values()) {
                if (!calendar.isWorkingDay(day)) continue;
                ++workingDaysPerWeek;
            }
            Integer workingHours = null;
            for (int index = 0; index < 7; ++index) {
                if (days[index] == 0) continue;
                workingHours = days[index];
                break;
            }
            if (workingHours != null) {
                int workingHoursPerDay = this.countHours(workingHours);
                int minutesPerDay = workingHoursPerDay * 60;
                int minutesPerWeek = minutesPerDay * workingDaysPerWeek;
                int minutesPerMonth = 4 * minutesPerWeek;
                int minutesPerYear = 52 * minutesPerWeek;
                calendar.setCalendarMinutesPerDay(minutesPerDay);
                calendar.setCalendarMinutesPerWeek(minutesPerWeek);
                calendar.setCalendarMinutesPerMonth(minutesPerMonth);
                calendar.setCalendarMinutesPerYear(minutesPerYear);
            }
            this.m_eventManager.fireCalendarReadEvent(calendar);
        }
        this.m_projectFile.setDefaultCalendar(this.m_projectFile.getCalendars().findOrCreateDefaultCalendar());
    }

    private void readHours(ProjectCalendar calendar, DayOfWeek day, Integer hours) {
        int value = hours;
        int startHour = 0;
        ProjectCalendarHours calendarHours = calendar.addCalendarHours(day);
        calendar.setWorkingDay(day, false);
        while (value != 0) {
            int endHour;
            while (startHour < 24 && (value & 1) == 0) {
                value >>= 1;
                ++startHour;
            }
            if (startHour >= 24) break;
            for (endHour = startHour; endHour < 24 && (value & 1) != 0; ++endHour) {
                value >>= 1;
            }
            calendar.setWorkingDay(day, true);
            calendarHours.add(new LocalTimeRange(LocalTime.of(startHour, 0), LocalTime.of(endHour == 24 ? 0 : endHour, 0)));
            startHour = endHour;
        }
    }

    private int countHours(Integer hours) {
        int value = hours;
        int hoursPerDay = 0;
        int hour = 0;
        while (value > 0) {
            while (hour < 24) {
                if ((value & 1) != 0) {
                    ++hoursPerDay;
                }
                value >>= 1;
                ++hour;
            }
        }
        return hoursPerDay;
    }

    private void readHolidays() {
        for (MapRow row : this.m_tables.get("HOL")) {
            ProjectCalendar calendar = this.m_calendarMap.get(row.getInteger("CALENDAR_ID"));
            if (calendar == null) continue;
            LocalDate date = LocalDateHelper.getLocalDate(row.getDate("DATE"));
            if (row.getBoolean("ANNUAL")) {
                RecurringData recurring = new RecurringData();
                recurring.setRecurrenceType(RecurrenceType.YEARLY);
                recurring.setYearlyAbsoluteFromDate(date);
                recurring.setStartDate(date);
                calendar.addCalendarException(recurring);
                continue;
            }
            calendar.addCalendarException(date);
        }
    }

    private void readResources() {
        this.m_resourceMap = new HashMap<String, Resource>();
        for (MapRow row : this.m_tables.get("RLB")) {
            Resource resource = this.m_projectFile.addResource();
            this.setFields(RESOURCE_FIELDS, row, resource);
            ProjectCalendar calendar = this.m_calendarMap.get(row.getInteger("CALENDAR_ID"));
            if (calendar != null) {
                ProjectCalendar baseCalendar = this.m_calendarMap.get(row.getInteger("BASE_CALENDAR_ID"));
                calendar.setParent(baseCalendar);
                resource.setCalendar(calendar);
            }
            this.m_resourceMap.put(resource.getCode(), resource);
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void readTasks() {
        this.readWbs();
        this.readActivities();
        this.updateDates();
    }

    private void readWbs() {
        HashMap<Integer, List> levelMap = new HashMap<Integer, List>();
        List<MapRow> table = this.m_definitions.get(WBS_ENTRIES_ID);
        if (table != null && this.m_wbsFormat != null) {
            List items;
            for (MapRow row : table) {
                this.m_wbsFormat.parseRawValue(row.getString("TEXT1"));
                Integer level = this.m_wbsFormat.getLevel();
                List items2 = levelMap.computeIfAbsent(level, k -> new ArrayList());
                items2.add(row);
            }
            int level = 1;
            while ((items = (List)levelMap.get(level++)) != null) {
                for (MapRow row : items) {
                    this.m_wbsFormat.parseRawValue(row.getString("TEXT1"));
                    String parentWbsValue = this.m_wbsFormat.getFormattedParentValue();
                    String wbsValue = this.m_wbsFormat.getFormattedValue();
                    row.setObject("WBS", wbsValue);
                    row.setObject("PARENT_WBS", parentWbsValue);
                }
                AlphanumComparator comparator = new AlphanumComparator();
                items.sort((o1, o2) -> comparator.compare(o1.getString("WBS"), o2.getString("WBS")));
                for (MapRow row : items) {
                    String wbs = row.getString("WBS");
                    ChildTaskContainer parent = this.m_wbsMap.get(row.getString("PARENT_WBS"));
                    if (parent == null) {
                        parent = this.m_projectFile;
                    }
                    Task task = parent.addTask();
                    String name = row.getString("TEXT2");
                    if (name == null || name.isEmpty()) {
                        name = wbs;
                    }
                    task.setName(name);
                    task.setWBS(wbs);
                    task.setSummary(true);
                    this.m_wbsMap.put(wbs, task);
                    this.m_eventManager.fireTaskReadEvent(task);
                }
            }
        }
    }

    private void readActivities() {
        ArrayList<MapRow> items = new ArrayList<MapRow>();
        for (MapRow row : this.m_tables.get("ACT")) {
            items.add(row);
        }
        AlphanumComparator comparator = new AlphanumComparator();
        items.sort((o1, o2) -> comparator.compare(o1.getString("ACTIVITY_ID"), o2.getString("ACTIVITY_ID")));
        for (MapRow row : items) {
            String wbs;
            String activityID = row.getString("ACTIVITY_ID");
            if (this.m_wbsFormat == null) {
                wbs = null;
            } else {
                this.m_wbsFormat.parseRawValue(row.getString("WBS"));
                wbs = this.m_wbsFormat.getFormattedValue();
            }
            ChildTaskContainer parent = this.m_wbsMap.get(wbs);
            if (parent == null) {
                parent = this.m_projectFile;
            }
            Task task = parent.addTask();
            this.setFields(TASK_FIELDS, row, task);
            task.setStart(task.getEarlyStart());
            task.setFinish(task.getEarlyFinish());
            task.setMilestone(task.getDuration().getDuration() == 0.0);
            task.setWBS(wbs);
            Duration duration = task.getDuration();
            Duration remainingDuration = task.getRemainingDuration();
            task.setActualDuration(Duration.getInstance(duration.getDuration() - remainingDuration.getDuration(), TimeUnit.HOURS));
            this.m_activityMap.put(activityID, task);
            this.m_eventManager.fireTaskReadEvent(task);
        }
    }

    private void readRelationships() {
        for (MapRow row : this.m_tables.get("REL")) {
            Task predecessor = this.m_activityMap.get(row.getString("PREDECESSOR_ACTIVITY_ID"));
            Task successor = this.m_activityMap.get(row.getString("SUCCESSOR_ACTIVITY_ID"));
            if (predecessor == null || successor == null) continue;
            Relation relation = successor.addPredecessor(new Relation.Builder().predecessorTask(predecessor).type(row.getRelationType("TYPE")).lag(row.getDuration("LAG")));
            this.m_eventManager.fireRelationReadEvent(relation);
        }
    }

    private void readResourceAssignments() {
        for (MapRow row : this.m_tables.get("RES")) {
            Task task = this.m_activityMap.get(row.getString("ACTIVITY_ID"));
            Resource resource = this.m_resourceMap.get(row.getString("RESOURCE_ID"));
            if (task == null || resource == null) continue;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            this.m_eventManager.fireAssignmentReadEvent(assignment);
        }
    }

    private void updateDates() {
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.updateDates(task);
        }
    }

    private void updateDates(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            int finished = 0;
            LocalDateTime startDate = parentTask.getStart();
            LocalDateTime finishDate = parentTask.getFinish();
            LocalDateTime actualStartDate = parentTask.getActualStart();
            LocalDateTime actualFinishDate = parentTask.getActualFinish();
            LocalDateTime earlyStartDate = parentTask.getEarlyStart();
            LocalDateTime earlyFinishDate = parentTask.getEarlyFinish();
            LocalDateTime lateStartDate = parentTask.getLateStart();
            LocalDateTime lateFinishDate = parentTask.getLateFinish();
            for (Task task : parentTask.getChildTasks()) {
                this.updateDates(task);
                startDate = LocalDateTimeHelper.min(startDate, task.getStart());
                finishDate = LocalDateTimeHelper.max(finishDate, task.getFinish());
                actualStartDate = LocalDateTimeHelper.min(actualStartDate, task.getActualStart());
                actualFinishDate = LocalDateTimeHelper.max(actualFinishDate, task.getActualFinish());
                earlyStartDate = LocalDateTimeHelper.min(earlyStartDate, task.getEarlyStart());
                earlyFinishDate = LocalDateTimeHelper.max(earlyFinishDate, task.getEarlyFinish());
                lateStartDate = LocalDateTimeHelper.min(lateStartDate, task.getLateStart());
                lateFinishDate = LocalDateTimeHelper.max(lateFinishDate, task.getLateFinish());
                if (task.getActualFinish() == null) continue;
                ++finished;
            }
            parentTask.setStart(startDate);
            parentTask.setFinish(finishDate);
            parentTask.setActualStart(actualStartDate);
            parentTask.setEarlyStart(earlyStartDate);
            parentTask.setEarlyFinish(earlyFinishDate);
            parentTask.setLateStart(lateStartDate);
            parentTask.setLateFinish(lateFinishDate);
            if (finished == parentTask.getChildTasks().size()) {
                parentTask.setActualFinish(actualFinishDate);
            }
        }
    }

    private void setFields(Map<String, FieldType> map, MapRow row, FieldContainer container) {
        if (row != null) {
            for (Map.Entry<String, FieldType> entry : map.entrySet()) {
                container.set(entry.getValue(), row.getObject(entry.getKey()));
            }
        }
    }

    private static void defineField(Map<String, FieldType> container, String name, FieldType type) {
        container.put(name, type);
    }

    static {
        SureTrakDatabaseReader.defineField(RESOURCE_FIELDS, "NAME", ResourceField.NAME);
        SureTrakDatabaseReader.defineField(RESOURCE_FIELDS, "CODE", ResourceField.CODE);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "NAME", TaskField.NAME);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "ACTIVITY_ID", TaskField.ACTIVITY_ID);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "DEPARTMENT", TaskField.DEPARTMENT);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "MANAGER", TaskField.MANAGER);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "SECTION", TaskField.SECTION);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "MAIL", TaskField.MAIL);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "PERCENT_COMPLETE", TaskField.PERCENT_COMPLETE);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "EARLY_START", TaskField.EARLY_START);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "LATE_START", TaskField.LATE_START);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "EARLY_FINISH", TaskField.EARLY_FINISH);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "LATE_FINISH", TaskField.LATE_FINISH);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "ACTUAL_START", TaskField.ACTUAL_START);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "ACTUAL_FINISH", TaskField.ACTUAL_FINISH);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "ORIGINAL_DURATION", TaskField.DURATION);
        SureTrakDatabaseReader.defineField(TASK_FIELDS, "REMAINING_DURATION", TaskField.REMAINING_DURATION);
    }
}

