/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.primavera.webservices;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64;
import org.mpxj.MPXJException;
import org.mpxj.ProjectFile;
import org.mpxj.common.InputStreamHelper;
import org.mpxj.primavera.webservices.ExportRequest;
import org.mpxj.primavera.webservices.WebServicesAuthenticationException;
import org.mpxj.primavera.webservices.WebServicesException;
import org.mpxj.primavera.webservices.WebServicesExportType;
import org.mpxj.primavera.webservices.WebServicesProject;
import org.mpxj.primavera.webservices.XmlExportRequest;
import org.mpxj.reader.UniversalProjectReader;

public class WebServicesReader {
    private final String m_url;
    private String m_databaseName;
    private String m_user;
    private String m_password;
    private String m_cookies;
    private String m_bearerToken;
    private final ObjectMapper m_mapper;

    public WebServicesReader(String url, String databaseName, String user, String password) {
        this(url);
        this.m_databaseName = databaseName;
        this.m_user = user;
        this.m_password = password;
    }

    public WebServicesReader(String url, String bearerToken) {
        this(url);
        this.m_bearerToken = bearerToken;
    }

    private WebServicesReader(String url) {
        this.m_url = url;
        this.m_mapper = new ObjectMapper();
        this.m_mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public List<WebServicesProject> getProjects() {
        this.authenticate();
        HttpURLConnection connection = this.performGetRequest("project?Fields=ObjectId,Id,Name,DataDate,CurrentBaselineProjectObjectId");
        int code = this.getResponseCode(connection);
        if (code != 200) {
            throw new WebServicesException(this.getExceptionMessage(connection, code, "List projects request failed"));
        }
        return this.readValue(connection, new TypeReference<List<WebServicesProject>>(){});
    }

    public void exportProject(WebServicesProject project, String filename, WebServicesExportType type, boolean includeBaseline, boolean compressed) throws IOException {
        try (OutputStream os = Files.newOutputStream(Paths.get(filename, new String[0]), new OpenOption[0]);){
            this.exportProject(project, os, type, includeBaseline, compressed);
        }
    }

    public void exportProject(WebServicesProject project, OutputStream stream, WebServicesExportType type, boolean includeBaseline, boolean compressed) throws IOException {
        InputStreamHelper.writeInputStreamToOutputStream(this.getInputStreamForProject(project, type, includeBaseline, compressed), stream);
    }

    public ProjectFile readProject(WebServicesProject project) throws MPXJException {
        return this.readProject(project, true);
    }

    public ProjectFile readProject(WebServicesProject project, boolean includeBaseline) throws MPXJException {
        return new UniversalProjectReader().read(this.getInputStreamForProject(project, WebServicesExportType.XML, includeBaseline, false));
    }

    private InputStream getInputStreamForProject(WebServicesProject project, WebServicesExportType type, boolean includeBaseline, boolean compressed) {
        String path;
        ExportRequest request;
        this.authenticate();
        if (type == WebServicesExportType.XML) {
            request = new XmlExportRequest();
            path = "export/exportProjects";
            request.setFileType(compressed ? "ZIP" : "XML");
            if (includeBaseline && project.getCurrentBaselineProjectObjectId() != null) {
                request.setProjectObjectId(Arrays.asList(project.getObjectId(), project.getCurrentBaselineProjectObjectId()));
            } else {
                request.setProjectObjectId(Collections.singletonList(project.getObjectId()));
            }
        } else {
            request = new ExportRequest();
            path = "export/exportXERProject";
            request.setFileType(compressed ? "ZIP" : "XER");
            request.setProjectObjectId(Collections.singletonList(project.getObjectId()));
        }
        HttpURLConnection connection = this.performPostRequest(path, request);
        int code = this.getResponseCode(connection);
        if (code != 200) {
            throw new WebServicesException(this.getExceptionMessage(connection, code, "Export project request failed"));
        }
        return this.getInputStream(connection);
    }

    private void authenticate() {
        if (this.m_cookies != null || this.m_bearerToken != null) {
            return;
        }
        try {
            URL url = new URL(this.m_url + "/restapi/login?DatabaseName=" + this.m_databaseName);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            String auth = this.m_user + ":" + this.m_password;
            byte[] authToken = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.UTF_8));
            connection.setRequestProperty("authToken", new String(authToken));
            connection.connect();
            int code = connection.getResponseCode();
            if (code != 200) {
                throw new WebServicesAuthenticationException(this.getExceptionMessage(connection, code, "Authentication request failed"));
            }
            List<String> cookiesHeader = connection.getHeaderFields().get("Set-Cookie");
            if (cookiesHeader == null) {
                throw new WebServicesAuthenticationException("No cookies received");
            }
            this.m_cookies = cookiesHeader.stream().flatMap(c -> HttpCookie.parse(c).stream()).map(HttpCookie::toString).collect(Collectors.joining(";"));
        }
        catch (Exception ex) {
            throw new WebServicesAuthenticationException(ex);
        }
    }

    private String getExceptionMessage(HttpURLConnection connection, int code, String message) {
        String responseBody = "";
        try {
            InputStream stream = connection.getErrorStream();
            if (stream == null) {
                stream = connection.getInputStream();
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(stream));){
                responseBody = br.lines().collect(Collectors.joining(System.lineSeparator()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return message + "\nresponseCode=" + code + "\nresponseBody=" + responseBody;
    }

    private HttpURLConnection performGetRequest(String path) {
        return this.performGetRequest(path, "application/json");
    }

    private HttpURLConnection performGetRequest(String path, String accept) {
        try {
            HttpURLConnection connection = this.createConnection(path, accept);
            connection.setRequestMethod("GET");
            connection.connect();
            return connection;
        }
        catch (IOException ex) {
            throw new WebServicesException(ex);
        }
    }

    private HttpURLConnection performPostRequest(String path, Object body) {
        try {
            HttpURLConnection connection = this.createConnection(path, "application/json");
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            this.m_mapper.writeValue(connection.getOutputStream(), body);
            connection.connect();
            return connection;
        }
        catch (IOException ex) {
            throw new WebServicesException(ex);
        }
    }

    private HttpURLConnection createConnection(String path, String accept) throws IOException {
        URL url = new URL(this.m_url + "/restapi/" + path);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Accept", accept);
        connection.setRequestProperty("Accept-Encoding", "gzip");
        if (this.m_bearerToken == null) {
            connection.setRequestProperty("Cookie", this.m_cookies);
        } else {
            connection.setRequestProperty("Authorization", "Bearer " + this.m_bearerToken);
        }
        return connection;
    }

    private int getResponseCode(HttpURLConnection connection) {
        try {
            return connection.getResponseCode();
        }
        catch (IOException ex) {
            throw new WebServicesException(ex);
        }
    }

    private <T> T readValue(HttpURLConnection connection, TypeReference<T> valueTypeRef) {
        try {
            return (T)this.m_mapper.readValue(this.getInputStream(connection), valueTypeRef);
        }
        catch (IOException ex) {
            throw new WebServicesException(ex);
        }
    }

    private InputStream getInputStream(HttpURLConnection connection) {
        try {
            if ("gzip".equals(connection.getContentEncoding())) {
                return new GZIPInputStream(connection.getInputStream());
            }
            return connection.getInputStream();
        }
        catch (IOException ex) {
            throw new WebServicesException(ex);
        }
    }
}

