/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.pwa;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.mpxj.AssignmentField;
import org.mpxj.CustomFieldValueDataType;
import org.mpxj.Duration;
import org.mpxj.FieldContainer;
import org.mpxj.FieldType;
import org.mpxj.FieldTypeClass;
import org.mpxj.LocalTimeRange;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectField;
import org.mpxj.ProjectFile;
import org.mpxj.Relation;
import org.mpxj.RelationType;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceField;
import org.mpxj.Task;
import org.mpxj.TaskField;
import org.mpxj.TimeUnit;
import org.mpxj.UserDefinedField;
import org.mpxj.common.FieldTypeHelper;
import org.mpxj.pwa.MapRow;
import org.mpxj.pwa.PwaException;
import org.mpxj.pwa.PwaProject;

public class PwaReader {
    private final String m_host;
    private final String m_token;
    private final ObjectMapper m_mapper;
    private UUID m_projectID;
    private ProjectFile m_project;
    private MapRow m_data;
    private Map<UUID, Task> m_taskMap;
    private Map<UUID, Resource> m_resourceMap;
    private Map<String, FieldType> m_customFields;
    private Map<String, Object> m_lookupEntries;
    private static final Map<String, ProjectField> PROJECT_DATA_PROJECT_FIELDS = new HashMap<String, ProjectField>();
    private static final Map<String, ProjectField> PROJECT_SERVER_PROJECT_FIELDS;
    private static final Map<String, ResourceField> RESOURCE_FIELDS;
    private static final Map<String, TaskField> TASK_FIELDS;
    private static final Map<String, AssignmentField> ASSIGNMENT_FIELDS;

    public PwaReader(String host, String token) {
        this.m_host = host;
        this.m_token = token;
        this.m_mapper = new ObjectMapper();
        this.m_mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.m_mapper.registerModule((Module)new SimpleModule().addDeserializer(Map.class, (JsonDeserializer)new JsonDeserializer<MapRow>(){

            public MapRow deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                return (MapRow)ctxt.readValue(p, MapRow.class);
            }
        }));
    }

    public List<PwaProject> getProjects() {
        HttpURLConnection connection = this.createConnection("ProjectServer/Projects?$select=Id,Name");
        int code = this.getResponseCode(connection);
        if (code != 200) {
            throw new PwaException(this.getExceptionMessage(connection, code));
        }
        MapRow data = this.getMapRow(connection);
        return data.getList("value").stream().map(d -> new PwaProject(d.getUUID("Id"), d.getString("Name"))).collect(Collectors.toList());
    }

    public ProjectFile readProject(UUID id) {
        try {
            this.m_projectID = id;
            this.m_project = new ProjectFile();
            this.m_data = this.readData();
            this.m_resourceMap = new HashMap<UUID, Resource>();
            this.m_taskMap = new HashMap<UUID, Task>();
            this.m_customFields = new HashMap<String, FieldType>();
            this.m_lookupEntries = new HashMap<String, Object>();
            this.readProjectProperties();
            this.readCalendars();
            this.readResources();
            this.readTasks();
            this.readTaskLinks();
            ProjectFile projectFile = this.m_project;
            return projectFile;
        }
        finally {
            this.m_projectID = null;
            this.m_project = null;
            this.m_data = null;
            this.m_resourceMap = null;
            this.m_taskMap = null;
            this.m_customFields = null;
            this.m_lookupEntries = null;
        }
    }

    private MapRow readData() {
        String query = "ProjectServer/Projects(guid'" + this.m_projectID + "')?$expand=" + String.join((CharSequence)",", "ProjectResources", "ProjectResources/CustomFields", "ProjectResources/CustomFields/LookupEntries", "Tasks", "TaskLinks", "Tasks/Parent", "Tasks/CustomFields", "Tasks/CustomFields/LookupEntries", "Tasks/Assignments", "Tasks/Assignments/Resource") + "&$select=" + String.join((CharSequence)",", "*", "ProjectResources/*", "ProjectResources/CustomFields/Id", "ProjectResources/CustomFields/Name", "ProjectResources/CustomFields/InternalName", "ProjectResources/CustomFields/FieldType", "ProjectResources/CustomFields/LookupEntries/InternalName", "ProjectResources/CustomFields/LookupEntries/Value", "Tasks/*", "Tasks/Parent/Id", "Tasks/Assignments/*", "Tasks/CustomFields/Id", "Tasks/CustomFields/Name", "Tasks/CustomFields/InternalName", "Tasks/CustomFields/FieldType", "Tasks/CustomFields/LookupEntries/InternalName", "Tasks/CustomFields/LookupEntries/Value", "Tasks/Assignments/Resource/Id");
        HttpURLConnection connection = this.createConnection(query);
        int code = this.getResponseCode(connection);
        if (code != 200) {
            throw new PwaException(this.getExceptionMessage(connection, code));
        }
        return this.getMapRow(connection);
    }

    private void readProjectProperties() {
        HttpURLConnection connection = this.createConnection("ProjectData/Projects(guid'" + this.m_projectID + "')");
        int code = this.getResponseCode(connection);
        if (code != 200) {
            throw new PwaException(this.getExceptionMessage(connection, code));
        }
        this.populateFieldContainer(this.m_project.getProjectProperties(), PROJECT_DATA_PROJECT_FIELDS, this.getMapRow(connection));
        this.populateFieldContainer(this.m_project.getProjectProperties(), PROJECT_SERVER_PROJECT_FIELDS, this.m_data);
    }

    private void readCalendars() {
        HttpURLConnection connection = this.createConnection("ProjectServer/Calendars?$expand=BaseCalendarExceptions");
        int code = this.getResponseCode(connection);
        if (code != 200) {
            throw new PwaException(this.getExceptionMessage(connection, code));
        }
        this.getMapRow(connection).getList("value").forEach(this::readCalendar);
    }

    private void readCalendar(MapRow data) {
        ProjectCalendar calendar = this.m_project.addDefaultBaseCalendar();
        calendar.setGUID(data.getUUID("Id"));
        calendar.setName(data.getString("Name"));
        data.getList("BaseCalendarExceptions").forEach(item -> this.readCalendarException(calendar, (MapRow)item));
        if (data.getBool("IsStandardCalendar")) {
            this.m_project.setDefaultCalendar(calendar);
        }
    }

    private void readCalendarException(ProjectCalendar calendar, MapRow data) {
        ProjectCalendarException exception = calendar.addCalendarException(data.getLocalDate("Start"), data.getLocalDate("Finish"));
        exception.setName(data.getString("Name"));
        this.addRange(exception, data, 1);
        this.addRange(exception, data, 2);
        this.addRange(exception, data, 3);
        this.addRange(exception, data, 4);
        this.addRange(exception, data, 5);
    }

    private void addRange(ProjectCalendarException exception, MapRow data, int index) {
        int finish;
        String shift = "Shift" + index;
        int start = data.getInt(shift + "Start");
        if (start == (finish = data.getInt(shift + "Finish"))) {
            return;
        }
        exception.add(new LocalTimeRange(LocalTime.MIDNIGHT.plusMinutes(start), LocalTime.MIDNIGHT.plusMinutes(finish)));
    }

    private void readResources() {
        this.m_data.getList("ProjectResources").forEach(this::readResource);
    }

    private void readResource(MapRow data) {
        Resource resource = this.m_project.addResource();
        this.populateFieldContainer(resource, RESOURCE_FIELDS, data);
        this.readCustomFields(data, resource, FieldTypeClass.RESOURCE);
        this.m_resourceMap.put(resource.getGUID(), resource);
    }

    private void readTasks() {
        this.m_data.getList("Tasks").forEach(this::readTask);
    }

    private void readTask(MapRow data) {
        Task parentTask = this.m_taskMap.get(this.getParentID(data));
        Task task = (parentTask == null ? this.m_project : parentTask).addTask();
        this.populateFieldContainer(task, TASK_FIELDS, data);
        this.readCustomFields(data, task, FieldTypeClass.TASK);
        this.readResourceAssignments(data, task);
        this.m_taskMap.put(task.getGUID(), task);
    }

    private UUID getParentID(MapRow data) {
        MapRow parent = data.getMapRow("Parent");
        if (parent == null) {
            return null;
        }
        return parent.getUUID("Id");
    }

    private void readCustomFields(MapRow data, FieldContainer container, FieldTypeClass fieldTypeClass) {
        data.keySet().stream().filter(key -> key.startsWith("LocalCustom")).forEach(key -> this.readLocalCustomField(data, (String)key, container));
        data.keySet().stream().filter(key -> key.startsWith("Custom_")).forEach(key -> this.readEnterpriseCustomField(data, (String)key, container, fieldTypeClass));
    }

    private void readLocalCustomField(MapRow data, String internalName, FieldContainer container) {
        List list;
        Object value = data.get(internalName);
        if (value == null) {
            return;
        }
        FieldType type = this.m_customFields.get(internalName);
        if (type == null) {
            type = this.getFieldTypeFromIdentifier(internalName);
            if (type == null) {
                return;
            }
            this.m_customFields.put(internalName, type);
            FieldType t = type;
            MapRow customField = data.getList("CustomFields").stream().filter(f -> t.equals(this.getFieldTypeFromIdentifier(f.getString("Id")))).findFirst().orElse(null);
            if (customField != null) {
                this.m_project.getCustomFields().getOrCreate(type).setAlias(customField.getString("Name"));
                customField.getList("LookupEntries").forEach(e -> this.m_lookupEntries.put(e.getString("InternalName"), e.getObject("Value", t.getDataType())));
            }
        }
        value = value instanceof List ? ((list = (List)value).isEmpty() ? null : this.m_lookupEntries.get(list.get(0))) : data.getObject(internalName, type.getDataType());
        container.set(type, value);
    }

    private void readEnterpriseCustomField(MapRow data, String internalName, FieldContainer container, FieldTypeClass fieldTypeClass) {
        List list;
        Object value = data.get(internalName);
        if (value == null) {
            return;
        }
        FieldType type = this.m_customFields.get(internalName);
        if (type == null) {
            MapRow customField = data.getList("CustomFields").stream().filter(f -> internalName.endsWith(f.getString("InternalName").substring(7))).findFirst().orElse(null);
            if (customField == null) {
                return;
            }
            UserDefinedField field = new UserDefinedField.Builder(this.m_project).fieldTypeClass(fieldTypeClass).dataType(CustomFieldValueDataType.getInstance(customField.getInt("FieldType")).getDataType()).internalName(customField.getString("InternalName")).externalName(customField.getString("Name")).build();
            type = field;
            this.m_project.getUserDefinedFields().add(field);
            this.m_project.getCustomFields().add(field).setAlias(field.getName());
            this.m_customFields.put(internalName, type);
            customField.getList("LookupEntries").forEach(e -> this.m_lookupEntries.put(e.getString("InternalName"), e.getObject("Value", field.getDataType())));
        }
        value = value instanceof List ? ((list = (List)value).isEmpty() ? null : this.m_lookupEntries.get(list.get(0))) : data.getObject(internalName, type.getDataType());
        container.set(type, value);
    }

    private FieldType getFieldTypeFromIdentifier(String internalName) {
        String fieldID = internalName.substring(internalName.length() - 8);
        return FieldTypeHelper.getInstance(this.m_project, Integer.parseInt(fieldID, 16));
    }

    private void readResourceAssignments(MapRow data, Task task) {
        data.getList("Assignments").forEach(d -> this.readResourceAssignment((MapRow)d, task));
    }

    private void readResourceAssignment(MapRow data, Task task) {
        MapRow resourceData = data.getMapRow("Resource");
        if (resourceData == null) {
            return;
        }
        Resource resource = this.m_resourceMap.get(resourceData.getUUID("Id"));
        if (resource == null) {
            return;
        }
        ResourceAssignment assignment = task.addResourceAssignment(resource);
        this.populateFieldContainer(assignment, ASSIGNMENT_FIELDS, data);
    }

    private void readTaskLinks() {
        this.m_data.getList("TaskLinks").forEach(this::readTaskLink);
    }

    private void readTaskLink(MapRow data) {
        Task predecessor = this.m_taskMap.get(data.getUUID("PredecessorTaskId"));
        Task successor = this.m_taskMap.get(data.getUUID("SuccessorTaskId"));
        if (predecessor == null || successor == null) {
            return;
        }
        RelationType type = RelationType.getInstance(data.getInt("DependencyType"));
        double lag = (double)data.getInt("LinkLag") / 600.0;
        successor.addPredecessor(new Relation.Builder().lag(Duration.getInstance(lag, TimeUnit.HOURS)).type(type).predecessorTask(predecessor));
    }

    private HttpURLConnection createConnection(String path) {
        try {
            URL url = new URL(this.m_host + "/_api/" + path);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Accept-Encoding", "gzip");
            connection.setRequestProperty("Authorization", "Bearer " + this.m_token);
            connection.setRequestMethod("GET");
            connection.connect();
            return connection;
        }
        catch (IOException ex) {
            throw new PwaException(ex);
        }
    }

    private int getResponseCode(HttpURLConnection connection) {
        try {
            return connection.getResponseCode();
        }
        catch (IOException ex) {
            throw new PwaException(ex);
        }
    }

    private String getExceptionMessage(HttpURLConnection connection, int code) {
        String responseBody = "";
        try {
            InputStream stream = connection.getErrorStream();
            if (stream == null) {
                stream = connection.getInputStream();
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(stream));){
                responseBody = br.lines().collect(Collectors.joining(System.lineSeparator()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return connection.getRequestMethod() + " " + connection.getURL() + " failed: \nresponseCode=" + code + "\nresponseBody=" + responseBody;
    }

    private MapRow getMapRow(HttpURLConnection connection) {
        try {
            return (MapRow)this.m_mapper.readValue(this.getInputStream(connection), MapRow.class);
        }
        catch (IOException ex) {
            throw new PwaException(ex);
        }
    }

    private InputStream getInputStream(HttpURLConnection connection) {
        try {
            if ("gzip".equals(connection.getContentEncoding())) {
                return new GZIPInputStream(connection.getInputStream());
            }
            return connection.getInputStream();
        }
        catch (IOException ex) {
            throw new PwaException(ex);
        }
    }

    private void populateFieldContainer(FieldContainer container, Map<String, ? extends FieldType> index, MapRow data) {
        data.setProject(this.m_project);
        for (Map.Entry<String, ? extends FieldType> entry : index.entrySet()) {
            container.set(entry.getValue(), data.getObject(entry.getKey(), entry.getValue().getDataType()));
        }
    }

    static {
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectId", ProjectField.GUID);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectActualCost", ProjectField.ACTUAL_COST);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectActualDuration", ProjectField.ACTUAL_DURATION);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectActualFinishDate", ProjectField.ACTUAL_FINISH);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectActualStartDate", ProjectField.ACTUAL_START);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectActualWork", ProjectField.ACTUAL_WORK);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectCategoryName", ProjectField.CATEGORY);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectCompanyName", ProjectField.COMPANY);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectCost", ProjectField.COST);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectCreatedDate", ProjectField.CREATION_DATE);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectCurrency", ProjectField.CURRENCY_CODE);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectDuration", ProjectField.DURATION);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectFinishDate", ProjectField.FINISH_DATE);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectFinishVariance", ProjectField.FINISH_VARIANCE);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectIdentifier", ProjectField.PROJECT_ID);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectKeywords", ProjectField.KEYWORDS);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectManagerName", ProjectField.MANAGER);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectModifiedDate", ProjectField.LAST_SAVED);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectName", ProjectField.NAME);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectPercentCompleted", ProjectField.PERCENTAGE_COMPLETE);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectStartDate", ProjectField.START_DATE);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectStartVariance", ProjectField.START_VARIANCE);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectStatusDate", ProjectField.STATUS_DATE);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectSubject", ProjectField.SUBJECT);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectTitle", ProjectField.PROJECT_TITLE);
        PROJECT_DATA_PROJECT_FIELDS.put("ProjectWork", ProjectField.WORK);
        PROJECT_SERVER_PROJECT_FIELDS = new HashMap<String, ProjectField>();
        PROJECT_SERVER_PROJECT_FIELDS.put("CriticalSlackLimit", ProjectField.CRITICAL_SLACK_LIMIT);
        PROJECT_SERVER_PROJECT_FIELDS.put("DefaultFinishTime", ProjectField.DEFAULT_END_TIME);
        PROJECT_SERVER_PROJECT_FIELDS.put("DefaultStartTime", ProjectField.DEFAULT_START_TIME);
        PROJECT_SERVER_PROJECT_FIELDS.put("HonorConstraints", ProjectField.HONOR_CONSTRAINTS);
        PROJECT_SERVER_PROJECT_FIELDS.put("MultipleCriticalPaths", ProjectField.MULTIPLE_CRITICAL_PATHS);
        PROJECT_SERVER_PROJECT_FIELDS.put("SplitInProgress", ProjectField.SPLIT_IN_PROGRESS_TASKS);
        PROJECT_SERVER_PROJECT_FIELDS.put("SpreadActualCostsToStatus", ProjectField.SPREAD_ACTUAL_COST);
        PROJECT_SERVER_PROJECT_FIELDS.put("SpreadPercentCompleteToStatus", ProjectField.SPREAD_PERCENT_COMPLETE);
        PROJECT_SERVER_PROJECT_FIELDS.put("CurrencyDigits", ProjectField.CURRENCY_DIGITS);
        PROJECT_SERVER_PROJECT_FIELDS.put("CurrencyPosition", ProjectField.CURRENCY_SYMBOL_POSITION);
        PROJECT_SERVER_PROJECT_FIELDS.put("CurrencySymbol", ProjectField.CURRENCY_SYMBOL);
        PROJECT_SERVER_PROJECT_FIELDS.put("CurrentDate", ProjectField.CURRENT_DATE);
        PROJECT_SERVER_PROJECT_FIELDS.put("DaysPerMonth", ProjectField.DAYS_PER_MONTH);
        PROJECT_SERVER_PROJECT_FIELDS.put("DefaultEffortDriven", ProjectField.NEW_TASKS_EFFORT_DRIVEN);
        PROJECT_SERVER_PROJECT_FIELDS.put("DefaultEstimatedDuration", ProjectField.NEW_TASKS_ESTIMATED);
        PROJECT_SERVER_PROJECT_FIELDS.put("DefaultFixedCostAccrual", ProjectField.DEFAULT_FIXED_COST_ACCRUAL);
        PROJECT_SERVER_PROJECT_FIELDS.put("DefaultOvertimeRate", ProjectField.DEFAULT_OVERTIME_RATE);
        PROJECT_SERVER_PROJECT_FIELDS.put("DefaultStandardRate", ProjectField.DEFAULT_STANDARD_RATE);
        PROJECT_SERVER_PROJECT_FIELDS.put("DefaultTaskType", ProjectField.DEFAULT_TASK_TYPE);
        PROJECT_SERVER_PROJECT_FIELDS.put("FiscalYearStartMonth", ProjectField.FISCAL_YEAR_START_MONTH);
        PROJECT_SERVER_PROJECT_FIELDS.put("MinutesPerDay", ProjectField.MINUTES_PER_DAY);
        PROJECT_SERVER_PROJECT_FIELDS.put("MinutesPerWeek", ProjectField.MINUTES_PER_WEEK);
        PROJECT_SERVER_PROJECT_FIELDS.put("NewTasksAreManual", ProjectField.NEW_TASKS_ARE_MANUAL);
        PROJECT_SERVER_PROJECT_FIELDS.put("NumberFiscalYearFromStart", ProjectField.FISCAL_YEAR_START);
        PROJECT_SERVER_PROJECT_FIELDS.put("ProtectedActualsSynch", ProjectField.ACTUALS_IN_SYNC);
        PROJECT_SERVER_PROJECT_FIELDS.put("ScheduledFromStart", ProjectField.SCHEDULE_FROM);
        PROJECT_SERVER_PROJECT_FIELDS.put("WeekStartDay", ProjectField.WEEK_START_DAY);
        RESOURCE_FIELDS = new HashMap<String, ResourceField>();
        RESOURCE_FIELDS.put("ActualCost", ResourceField.ACTUAL_COST);
        RESOURCE_FIELDS.put("ActualCostWorkPerformedMilliseconds", ResourceField.ACWP);
        RESOURCE_FIELDS.put("ActualOvertimeCost", ResourceField.ACTUAL_OVERTIME_COST);
        RESOURCE_FIELDS.put("ActualOvertimeWorkMilliseconds", ResourceField.ACTUAL_OVERTIME_WORK);
        RESOURCE_FIELDS.put("ActualWorkMilliseconds", ResourceField.ACTUAL_WORK);
        RESOURCE_FIELDS.put("AvailableFrom", ResourceField.AVAILABLE_FROM);
        RESOURCE_FIELDS.put("AvailableTo", ResourceField.AVAILABLE_TO);
        RESOURCE_FIELDS.put("BaselineCost", ResourceField.BASELINE_COST);
        RESOURCE_FIELDS.put("BaselineWorkMilliseconds", ResourceField.BASELINE_WORK);
        RESOURCE_FIELDS.put("BudetCostWorkPerformed", ResourceField.BCWP);
        RESOURCE_FIELDS.put("BudgetedCost", ResourceField.BUDGET_COST);
        RESOURCE_FIELDS.put("BudgetedCostWorkScheduled", ResourceField.BCWS);
        RESOURCE_FIELDS.put("BudgetedWorkMilliseconds", ResourceField.BUDGET_WORK);
        RESOURCE_FIELDS.put("Cost", ResourceField.COST);
        RESOURCE_FIELDS.put("CostVariance", ResourceField.COST_VARIANCE);
        RESOURCE_FIELDS.put("Created", ResourceField.CREATED);
        RESOURCE_FIELDS.put("Finish", ResourceField.FINISH);
        RESOURCE_FIELDS.put("Id", ResourceField.GUID);
        RESOURCE_FIELDS.put("IsBudgeted", ResourceField.BUDGET);
        RESOURCE_FIELDS.put("IsGenericResource", ResourceField.GENERIC);
        RESOURCE_FIELDS.put("IsOverAllocated", ResourceField.OVERALLOCATED);
        RESOURCE_FIELDS.put("Notes", ResourceField.NOTES);
        RESOURCE_FIELDS.put("OvertimeCost", ResourceField.OVERTIME_COST);
        RESOURCE_FIELDS.put("OvertimeWorkMilliseconds", ResourceField.OVERTIME_WORK);
        RESOURCE_FIELDS.put("PercentWorkComplete", ResourceField.PERCENT_WORK_COMPLETE);
        RESOURCE_FIELDS.put("RegularWorkMilliseconds", ResourceField.REGULAR_WORK);
        RESOURCE_FIELDS.put("RemainingCost", ResourceField.REMAINING_COST);
        RESOURCE_FIELDS.put("RemainingOvertimeCost", ResourceField.REMAINING_OVERTIME_COST);
        RESOURCE_FIELDS.put("RemainingOvertimeWorkMilliseconds", ResourceField.REMAINING_OVERTIME_WORK);
        RESOURCE_FIELDS.put("RemainingWorkMilliseconds", ResourceField.REMAINING_WORK);
        RESOURCE_FIELDS.put("Start", ResourceField.START);
        RESOURCE_FIELDS.put("WorkMilliseconds", ResourceField.WORK);
        RESOURCE_FIELDS.put("WorkVarianceMilliseconds", ResourceField.WORK_VARIANCE);
        RESOURCE_FIELDS.put("CanLevel", ResourceField.CAN_LEVEL);
        RESOURCE_FIELDS.put("Code", ResourceField.CODE);
        RESOURCE_FIELDS.put("CostAccrual", ResourceField.ACCRUE_AT);
        RESOURCE_FIELDS.put("CostCenter", ResourceField.COST_CENTER);
        RESOURCE_FIELDS.put("CostPerUse", ResourceField.COST_PER_USE);
        RESOURCE_FIELDS.put("DefaultBookingType", ResourceField.BOOKING_TYPE);
        RESOURCE_FIELDS.put("Email", ResourceField.EMAIL_ADDRESS);
        RESOURCE_FIELDS.put("Group", ResourceField.GROUP);
        RESOURCE_FIELDS.put("Initials", ResourceField.INITIALS);
        RESOURCE_FIELDS.put("MaterialLabel", ResourceField.MATERIAL_LABEL);
        RESOURCE_FIELDS.put("MaximumCapacity", ResourceField.MAX_UNITS);
        RESOURCE_FIELDS.put("Name", ResourceField.NAME);
        RESOURCE_FIELDS.put("OvertimeRate", ResourceField.OVERTIME_RATE);
        RESOURCE_FIELDS.put("OvertimeRateUnits", ResourceField.OVERTIME_RATE_UNITS);
        RESOURCE_FIELDS.put("Phonetics", ResourceField.PHONETICS);
        RESOURCE_FIELDS.put("StandardRate", ResourceField.STANDARD_RATE);
        RESOURCE_FIELDS.put("StandardRateUnits", ResourceField.STANDARD_RATE_UNITS);
        TASK_FIELDS = new HashMap<String, TaskField>();
        TASK_FIELDS.put("ActualCostWorkPerformed", TaskField.ACWP);
        TASK_FIELDS.put("ActualDurationMilliseconds", TaskField.ACTUAL_DURATION);
        TASK_FIELDS.put("ActualOvertimeCost", TaskField.ACTUAL_OVERTIME_COST);
        TASK_FIELDS.put("ActualOvertimeWorkMilliseconds", TaskField.ACTUAL_OVERTIME_WORK);
        TASK_FIELDS.put("BaselineCost", TaskField.BASELINE_COST);
        TASK_FIELDS.put("BaselineDurationMilliseconds", TaskField.BASELINE_DURATION);
        TASK_FIELDS.put("BaselineFinish", TaskField.BASELINE_FINISH);
        TASK_FIELDS.put("BaselineStart", TaskField.BASELINE_START);
        TASK_FIELDS.put("BaselineWorkMilliseconds", TaskField.BASELINE_WORK);
        TASK_FIELDS.put("BudgetCost", TaskField.BUDGET_COST);
        TASK_FIELDS.put("BudgetedCostWorkPerformed", TaskField.BCWP);
        TASK_FIELDS.put("BudgetedCostWorkScheduled", TaskField.BCWS);
        TASK_FIELDS.put("Contact", TaskField.CONTACT);
        TASK_FIELDS.put("CostPerformanceIndex", TaskField.CPI);
        TASK_FIELDS.put("CostVariance", TaskField.COST_VARIANCE);
        TASK_FIELDS.put("Created", TaskField.CREATED);
        TASK_FIELDS.put("DurationVarianceMilliseconds", TaskField.DURATION_VARIANCE);
        TASK_FIELDS.put("EarliestFinish", TaskField.EARLY_FINISH);
        TASK_FIELDS.put("EarliestStart", TaskField.EARLY_START);
        TASK_FIELDS.put("EstimateAtCompletion", TaskField.EAC);
        TASK_FIELDS.put("FinishSlackMilliseconds", TaskField.FINISH_SLACK);
        TASK_FIELDS.put("FinishVarianceMilliseconds", TaskField.FINISH_VARIANCE);
        TASK_FIELDS.put("FreeSlackMilliseconds", TaskField.FREE_SLACK);
        TASK_FIELDS.put("Id", TaskField.GUID);
        TASK_FIELDS.put("IgnoreResourceCalendar", TaskField.IGNORE_RESOURCE_CALENDAR);
        TASK_FIELDS.put("IsCritical", TaskField.CRITICAL);
        TASK_FIELDS.put("IsDurationEstimate", TaskField.ESTIMATED);
        TASK_FIELDS.put("IsExternalTask", TaskField.EXTERNAL_TASK);
        TASK_FIELDS.put("IsOverAllocated", TaskField.OVERALLOCATED);
        TASK_FIELDS.put("IsRecurring", TaskField.RECURRING);
        TASK_FIELDS.put("IsRolledUp", TaskField.ROLLUP);
        TASK_FIELDS.put("IsSubProjectReadOnly", TaskField.SUBPROJECT_READ_ONLY);
        TASK_FIELDS.put("IsSummary", TaskField.SUMMARY);
        TASK_FIELDS.put("LatestFinish", TaskField.LATE_FINISH);
        TASK_FIELDS.put("LatestStart", TaskField.LATE_START);
        TASK_FIELDS.put("LevelingDelayMilliseconds", TaskField.LEVELING_DELAY);
        TASK_FIELDS.put("Notes", TaskField.NOTES);
        TASK_FIELDS.put("OutlinePosition", TaskField.OUTLINE_NUMBER);
        TASK_FIELDS.put("OvertimeCost", TaskField.OVERTIME_COST);
        TASK_FIELDS.put("OvertimeWorkMilliseconds", TaskField.OVERTIME_WORK);
        TASK_FIELDS.put("PercentWorkComplete", TaskField.PERCENT_WORK_COMPLETE);
        TASK_FIELDS.put("PreLevelingFinish", TaskField.PRELEVELED_FINISH);
        TASK_FIELDS.put("PreLevelingStart", TaskField.PRELEVELED_START);
        TASK_FIELDS.put("RegularWorkMilliseconds", TaskField.REGULAR_WORK);
        TASK_FIELDS.put("RemainingCost", TaskField.REMAINING_COST);
        TASK_FIELDS.put("RemainingOvertimeCost", TaskField.REMAINING_OVERTIME_COST);
        TASK_FIELDS.put("RemainingOvertimeWorkMilliseconds", TaskField.REMAINING_OVERTIME_WORK);
        TASK_FIELDS.put("RemainingWorkMilliseconds", TaskField.REMAINING_WORK);
        TASK_FIELDS.put("Resume", TaskField.RESUME);
        TASK_FIELDS.put("ScheduledDurationMilliseconds", TaskField.SCHEDULED_DURATION);
        TASK_FIELDS.put("ScheduledFinish", TaskField.SCHEDULED_FINISH);
        TASK_FIELDS.put("ScheduledStart", TaskField.SCHEDULED_START);
        TASK_FIELDS.put("SchedulePerformanceIndex", TaskField.SPI);
        TASK_FIELDS.put("ScheduleVariancePercentage", TaskField.SVPERCENT);
        TASK_FIELDS.put("StartSlackMilliseconds", TaskField.START_SLACK);
        TASK_FIELDS.put("StartVarianceMilliseconds", TaskField.START_VARIANCE);
        TASK_FIELDS.put("Stop", TaskField.STOP);
        TASK_FIELDS.put("ToCompletePerformanceIndex", TaskField.TCPI);
        TASK_FIELDS.put("TotalSlackMilliseconds", TaskField.TOTAL_SLACK);
        TASK_FIELDS.put("WorkBreakdownStructure", TaskField.WBS);
        TASK_FIELDS.put("WorkVarianceMilliseconds", TaskField.WORK_VARIANCE);
        TASK_FIELDS.put("ActualCost", TaskField.ACTUAL_COST);
        TASK_FIELDS.put("ActualFinish", TaskField.ACTUAL_FINISH);
        TASK_FIELDS.put("ActualStart", TaskField.ACTUAL_START);
        TASK_FIELDS.put("ActualWorkMilliseconds", TaskField.ACTUAL_WORK);
        TASK_FIELDS.put("BudgetWorkMilliseconds", TaskField.BUDGET_WORK);
        TASK_FIELDS.put("ConstraintStartEnd", TaskField.CONSTRAINT_DATE);
        TASK_FIELDS.put("ConstraintType", TaskField.CONSTRAINT_TYPE);
        TASK_FIELDS.put("Cost", TaskField.COST);
        TASK_FIELDS.put("Deadline", TaskField.DEADLINE);
        TASK_FIELDS.put("DurationMilliseconds", TaskField.DURATION);
        TASK_FIELDS.put("Finish", TaskField.FINISH);
        TASK_FIELDS.put("FinishText", TaskField.FINISH_TEXT);
        TASK_FIELDS.put("FixedCost", TaskField.FIXED_COST);
        TASK_FIELDS.put("FixedCostAccrual", TaskField.FIXED_COST_ACCRUAL);
        TASK_FIELDS.put("IsActive", TaskField.ACTIVE);
        TASK_FIELDS.put("IsEffortDriven", TaskField.EFFORT_DRIVEN);
        TASK_FIELDS.put("IsManual", TaskField.TASK_MODE);
        TASK_FIELDS.put("IsMarked", TaskField.MARKED);
        TASK_FIELDS.put("IsMilestone", TaskField.MILESTONE);
        TASK_FIELDS.put("LevelingAdjustsAssignments", TaskField.LEVEL_ASSIGNMENTS);
        TASK_FIELDS.put("LevelingCanSplit", TaskField.LEVELING_CAN_SPLIT);
        TASK_FIELDS.put("Name", TaskField.NAME);
        TASK_FIELDS.put("OutlineLevel", TaskField.OUTLINE_LEVEL);
        TASK_FIELDS.put("PercentComplete", TaskField.PERCENT_COMPLETE);
        TASK_FIELDS.put("PercentPhysicalWorkComplete", TaskField.PHYSICAL_PERCENT_COMPLETE);
        TASK_FIELDS.put("Priority", TaskField.PRIORITY);
        TASK_FIELDS.put("RemainingDurationMilliseconds", TaskField.REMAINING_DURATION);
        TASK_FIELDS.put("Start", TaskField.START);
        TASK_FIELDS.put("StartText", TaskField.START_TEXT);
        TASK_FIELDS.put("TaskType", TaskField.TYPE);
        TASK_FIELDS.put("WorkMilliseconds", TaskField.WORK);
        ASSIGNMENT_FIELDS = new HashMap<String, AssignmentField>();
        ASSIGNMENT_FIELDS.put("ActualCostWorkPerformed", AssignmentField.ACWP);
        ASSIGNMENT_FIELDS.put("ActualOvertimeCost", AssignmentField.ACTUAL_OVERTIME_COST);
        ASSIGNMENT_FIELDS.put("BaselineCost", AssignmentField.BASELINE_COST);
        ASSIGNMENT_FIELDS.put("BaselineFinish", AssignmentField.BASELINE_FINISH);
        ASSIGNMENT_FIELDS.put("BaselineStart", AssignmentField.BASELINE_START);
        ASSIGNMENT_FIELDS.put("BaselineWorkMilliseconds", AssignmentField.BASELINE_WORK);
        ASSIGNMENT_FIELDS.put("BudgetedCostWorkPerformed", AssignmentField.BCWP);
        ASSIGNMENT_FIELDS.put("BudgetedCostWorkScheduled", AssignmentField.BCWS);
        ASSIGNMENT_FIELDS.put("CostVariance", AssignmentField.COST_VARIANCE);
        ASSIGNMENT_FIELDS.put("Created", AssignmentField.CREATED);
        ASSIGNMENT_FIELDS.put("Finish", AssignmentField.FINISH);
        ASSIGNMENT_FIELDS.put("FinishVarianceMilliseconds", AssignmentField.FINISH_VARIANCE);
        ASSIGNMENT_FIELDS.put("Id", AssignmentField.GUID);
        ASSIGNMENT_FIELDS.put("IsConfirmed", AssignmentField.CONFIRMED);
        ASSIGNMENT_FIELDS.put("IsOverAllocated", AssignmentField.OVERALLOCATED);
        ASSIGNMENT_FIELDS.put("IsResponsePending", AssignmentField.RESPONSE_PENDING);
        ASSIGNMENT_FIELDS.put("IsUpdateNeeded", AssignmentField.UPDATE_NEEDED);
        ASSIGNMENT_FIELDS.put("LevelingDelayMilliseconds", AssignmentField.LEVELING_DELAY);
        ASSIGNMENT_FIELDS.put("Notes", AssignmentField.NOTES);
        ASSIGNMENT_FIELDS.put("OvertimeCost", AssignmentField.OVERTIME_COST);
        ASSIGNMENT_FIELDS.put("RemainingCost", AssignmentField.REMAINING_COST);
        ASSIGNMENT_FIELDS.put("RemainingOvertimeCost", AssignmentField.REMAINING_OVERTIME_COST);
        ASSIGNMENT_FIELDS.put("Resume", AssignmentField.RESUME);
        ASSIGNMENT_FIELDS.put("Start", AssignmentField.START);
        ASSIGNMENT_FIELDS.put("StartVarianceMilliseconds", AssignmentField.START_VARIANCE);
        ASSIGNMENT_FIELDS.put("WorkContourType", AssignmentField.WORK_CONTOUR);
        ASSIGNMENT_FIELDS.put("WorkVarianceMilliseconds", AssignmentField.WORK_VARIANCE);
        ASSIGNMENT_FIELDS.put("ActualCost", AssignmentField.ACTUAL_COST);
        ASSIGNMENT_FIELDS.put("ActualFinish", AssignmentField.ACTUAL_FINISH);
        ASSIGNMENT_FIELDS.put("ActualOvertimeWorkMilliseconds", AssignmentField.ACTUAL_OVERTIME_WORK);
        ASSIGNMENT_FIELDS.put("ActualStart", AssignmentField.ACTUAL_START);
        ASSIGNMENT_FIELDS.put("ActualWorkMilliseconds", AssignmentField.ACTUAL_WORK);
        ASSIGNMENT_FIELDS.put("BudgetedCost", AssignmentField.BUDGET_COST);
        ASSIGNMENT_FIELDS.put("BudgetedWorkMilliseconds", AssignmentField.BUDGET_WORK);
        ASSIGNMENT_FIELDS.put("Cost", AssignmentField.COST);
        ASSIGNMENT_FIELDS.put("CostRateTable", AssignmentField.COST_RATE_TABLE);
        ASSIGNMENT_FIELDS.put("DelayMilliseconds", AssignmentField.ASSIGNMENT_DELAY);
        ASSIGNMENT_FIELDS.put("OvertimeWorkMilliseconds", AssignmentField.OVERTIME_WORK);
        ASSIGNMENT_FIELDS.put("PercentWorkComplete", AssignmentField.PERCENT_WORK_COMPLETE);
        ASSIGNMENT_FIELDS.put("RegularWorkMilliseconds", AssignmentField.REGULAR_WORK);
        ASSIGNMENT_FIELDS.put("RemainingOvertimeWorkMilliseconds", AssignmentField.REMAINING_OVERTIME_WORK);
        ASSIGNMENT_FIELDS.put("RemainingWorkMilliseconds", AssignmentField.REMAINING_WORK);
        ASSIGNMENT_FIELDS.put("ResourceCapacity", AssignmentField.ASSIGNMENT_UNITS);
        ASSIGNMENT_FIELDS.put("WorkMilliseconds", AssignmentField.WORK);
    }
}

