/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.ruby;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.mpxj.AssignmentField;
import org.mpxj.DataType;
import org.mpxj.FieldType;
import org.mpxj.ProjectField;
import org.mpxj.ResourceField;
import org.mpxj.TaskField;

public class MethodGenerator {
    public static void main(String[] argv) throws IOException {
        if (argv.length != 1) {
            System.out.println("Usage: MethodGenerator <directory>");
        } else {
            MethodGenerator generator = new MethodGenerator();
            generator.process(new File(argv[0]));
        }
    }

    public void process(File directory) throws IOException {
        this.writeAttributeMethods(directory, "Property", ProjectField.values());
        this.writeAttributeMethods(directory, "Resource", ResourceField.values());
        this.writeAttributeMethods(directory, "Task", TaskField.values());
        this.writeAttributeMethods(directory, "Assignment", AssignmentField.values());
    }

    private void writeAttributeMethods(File directory, String name, FieldType[] types) throws IOException {
        List<FieldType> list = Arrays.asList(types);
        list.sort(Comparator.comparing(FieldType::name));
        String filename = name.toLowerCase() + "_methods.rb";
        try (FileWriter writer = new FileWriter(new File(directory, filename));){
            writer.write("module MPXJ\r\n");
            writer.write("  module " + name + "Methods\r\n");
            writer.write("    def self.included(base)\r\n");
            writer.write("      base.extend(" + name + "ClassMethods)\r\n");
            writer.write("    end\r\n");
            writer.write("\r\n");
            for (FieldType type : list) {
                this.writeMethod(writer, type);
            }
            this.writeAttributeTypes(writer, name, list);
            writer.write("  end\r\n");
            writer.write("end\r\n");
        }
    }

    private void writeMethod(Writer writer, FieldType field) throws IOException {
        String methodName = this.getMethodName(field.getDataType());
        String attributeName = field.name().toLowerCase();
        writer.write("    # Retrieve the " + field.getName() + " value\r\n");
        writer.write("    #\r\n");
        writer.write("    # @return " + field.getName() + " value\r\n");
        writer.write("    def " + attributeName);
        writer.write("\r\n");
        if (methodName == null) {
            writer.write("      attribute_values['" + attributeName + "']\r\n");
        } else {
            writer.write("      " + methodName + "(attribute_values['" + attributeName + "'])\r\n");
        }
        writer.write("    end\r\n");
        writer.write("\r\n");
    }

    private void writeAttributeTypes(Writer writer, String name, List<FieldType> list) throws IOException {
        writer.write("    ATTRIBUTE_TYPES = {\r\n");
        for (FieldType type : list) {
            writer.write("      '" + type.name().toLowerCase() + "' => :" + type.getDataType().name().toLowerCase() + ",\r\n");
        }
        writer.write("    }.freeze\r\n");
        writer.write("\r\n");
        writer.write("    def attribute_types\r\n");
        writer.write("      ATTRIBUTE_TYPES\r\n");
        writer.write("    end\r\n");
        writer.write("\r\n");
        writer.write("    module " + name + "ClassMethods\r\n");
        writer.write("      def attribute_types\r\n");
        writer.write("        ATTRIBUTE_TYPES\r\n");
        writer.write("      end\r\n");
        writer.write("    end\r\n");
    }

    private String getMethodName(DataType type) {
        String methodName;
        switch (type) {
            case PRIORITY: 
            case INTEGER: 
            case SHORT: {
                methodName = "get_integer_value";
                break;
            }
            case CURRENCY: 
            case NUMERIC: 
            case UNITS: 
            case PERCENTAGE: {
                methodName = "get_float_value";
                break;
            }
            case DATE: {
                methodName = "get_date_value";
                break;
            }
            case DURATION: 
            case WORK: 
            case DELAY: {
                methodName = "get_duration_value";
                break;
            }
            case BOOLEAN: {
                methodName = "get_boolean_value";
                break;
            }
            default: {
                methodName = null;
            }
        }
        return methodName;
    }
}

