/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.sage;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mpxj.ConstraintType;
import org.mpxj.Duration;
import org.mpxj.EventManager;
import org.mpxj.MPXJException;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectFile;
import org.mpxj.Relation;
import org.mpxj.RelationType;
import org.mpxj.Task;
import org.mpxj.TimeUnit;
import org.mpxj.common.SlackHelper;
import org.mpxj.reader.AbstractProjectStreamReader;

public final class SageReader
extends AbstractProjectStreamReader {
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private Map<String, Task> m_taskMap;
    private boolean m_ignoreErrors = true;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("MM/dd/yyyy");
    private static final Map<String, RelationType> RELATION_TYPE_MAP = new HashMap<String, RelationType>();

    @Override
    public ProjectFile read(InputStream is) throws MPXJException {
        try {
            String line;
            this.m_projectFile = new ProjectFile();
            this.m_projectFile.getProjectProperties().setFileApplication("Sage");
            this.m_projectFile.getProjectProperties().setFileType("SCHEDULE_GRID");
            this.m_eventManager = this.m_projectFile.getEventManager();
            this.m_taskMap = new HashMap<String, Task>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            this.processCalendars();
            this.processTasks(lines);
            this.processPredecessors(lines);
            this.m_projectFile.readComplete();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (IOException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            this.m_eventManager = null;
            this.m_taskMap = null;
        }
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.m_ignoreErrors = ignoreErrors;
    }

    public boolean getIgnoreErrors() {
        return this.m_ignoreErrors;
    }

    private void processCalendars() {
        ProjectCalendar defaultCalendar = this.m_projectFile.addDefaultBaseCalendar();
        this.m_projectFile.getProjectProperties().setDefaultCalendar(defaultCalendar);
    }

    private void processTasks(List<String> lines) {
        int index = this.skipToSection(lines, "**** Schedule Grid ****");
        if (index == lines.size()) {
            return;
        }
        while (index < lines.size()) {
            String line;
            if ((line = lines.get(index++)).isEmpty()) {
                return;
            }
            this.processTask(line);
        }
    }

    private void processPredecessors(List<String> lines) {
        int index = this.skipToSection(lines, "**** Predecessors ****");
        if (index == lines.size()) {
            return;
        }
        while (index < lines.size()) {
            String line;
            if ((line = lines.get(index++)).isEmpty()) {
                return;
            }
            this.processPredecessor(line);
        }
    }

    private int skipToSection(List<String> lines, String section) {
        String line;
        int index = 0;
        while (index < lines.size() && !(line = lines.get(index++)).equals(section)) {
        }
        return index;
    }

    private void processTask(String line) {
        String[] columns = line.split("\t");
        Task task = this.m_projectFile.addTask();
        task.setText(1, this.parseID(columns, 0));
        task.setName(this.getText(columns, 1));
        task.setDuration(this.parseDuration(columns, 2));
        this.setConstraint(task, ConstraintType.MUST_START_ON, columns, 4);
        this.setConstraint(task, ConstraintType.START_NO_EARLIER_THAN, columns, 5);
        this.setConstraint(task, ConstraintType.FINISH_NO_LATER_THAN, columns, 6);
        task.setStart(this.parseDate(columns, 7));
        task.setFinish(this.parseDate(columns, 8));
        task.setLateStart(this.parseDate(columns, 9));
        task.setLateFinish(this.parseDate(columns, 10));
        task.setBaselineDuration(this.parseDuration(columns, 12));
        task.setBaselineStart(this.parseDate(columns, 13));
        task.setBaselineFinish(this.parseDate(columns, 14));
        task.setText(2, this.getText(columns, 16));
        task.setNotes(this.getText(columns, 17));
        task.setTotalSlack(this.parseDuration(columns, 11));
        SlackHelper.inferSlack(task);
        this.m_taskMap.put(task.getText(1), task);
        this.m_eventManager.fireTaskReadEvent(task);
    }

    private void processPredecessor(String line) {
        String[] columns = line.split("\t");
        Task task = this.m_taskMap.get(this.parseID(columns, 0));
        if (task == null) {
            return;
        }
        Task predecessor = this.m_taskMap.get(this.parseID(columns, 1));
        if (predecessor == null) {
            return;
        }
        task.addPredecessor(new Relation.Builder().predecessorTask(predecessor).type(this.parseRelationType(columns, 2)).lag(this.parseDuration(columns, 3)));
    }

    private String parseID(String[] columns, int index) {
        String id = this.getText(columns, index);
        if (id != null && id.indexOf(46) == -1) {
            id = id + ".000";
        }
        return id;
    }

    private String getText(String[] columns, int index) {
        String result = null;
        if (index < columns.length) {
            result = columns[index];
        }
        return result;
    }

    private LocalDateTime parseDate(String[] columns, int index) {
        LocalDateTime result;
        String date = this.getText(columns, index);
        if (date == null || date.isEmpty()) {
            result = null;
        } else {
            try {
                result = LocalDate.parse(date, DATE_FORMAT).atStartOfDay();
            }
            catch (DateTimeParseException ex) {
                if (this.m_ignoreErrors) {
                    result = null;
                    this.m_projectFile.addIgnoredError(ex);
                }
                throw ex;
            }
        }
        return result;
    }

    private Duration parseDuration(String[] columns, int index) {
        Duration result = null;
        String duration = this.getText(columns, index);
        if (duration != null && !duration.isEmpty()) {
            result = Duration.getInstance(Integer.parseInt(duration), TimeUnit.DAYS);
        }
        return result;
    }

    private RelationType parseRelationType(String[] columns, int index) {
        RelationType result = null;
        String text = this.getText(columns, index);
        if (text != null) {
            result = RELATION_TYPE_MAP.get(text);
        }
        if (result == null) {
            result = RelationType.FINISH_START;
        }
        return result;
    }

    private void setConstraint(Task task, ConstraintType type, String[] columns, int index) {
        LocalDateTime date = this.parseDate(columns, index);
        if (date != null) {
            task.setConstraintType(type);
            task.setConstraintDate(date);
        }
    }

    static {
        RELATION_TYPE_MAP.put("1", RelationType.FINISH_START);
        RELATION_TYPE_MAP.put("2", RelationType.START_START);
        RELATION_TYPE_MAP.put("3", RelationType.START_FINISH);
        RELATION_TYPE_MAP.put("4", RelationType.FINISH_FINISH);
    }
}

