/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.sample;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.InputStreamHelper;

public class HexDump {
    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("Usage: HexDump <input file name> <output text file name>");
            } else {
                System.out.println("Dump started.");
                long start = System.currentTimeMillis();
                HexDump.process(args[0], args[1]);
                long elapsed = System.currentTimeMillis() - start;
                System.out.println("Dump completed in " + elapsed + "ms");
            }
        }
        catch (Exception ex) {
            System.out.println("Caught " + ex);
        }
    }

    private static void process(String input, String output) throws Exception {
        FileInputStream is = new FileInputStream(input);
        PrintWriter pw = new PrintWriter(new FileWriter(output));
        byte[] buffer = InputStreamHelper.readAvailable(is);
        pw.println(ByteArrayHelper.hexdump(buffer, 0, buffer.length, true, 16, ""));
        is.close();
        pw.flush();
        pw.close();
    }
}

