/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.sample;

import java.util.HashMap;
import java.util.Map;
import org.mpxj.ProjectFile;
import org.mpxj.reader.UniversalProjectReader;
import org.mpxj.writer.FileFormat;
import org.mpxj.writer.UniversalProjectWriter;

public final class MpxjConvert {
    private static final Map<String, FileFormat> FILE_FORMAT_MAP = new HashMap<String, FileFormat>();

    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("Usage: MpxjConvert <input file name> <output file name>");
            } else {
                MpxjConvert convert = new MpxjConvert();
                convert.process(args[0], args[1]);
            }
            System.exit(0);
        }
        catch (Exception ex) {
            System.out.println();
            System.out.print("Conversion Error: ");
            ex.printStackTrace(System.out);
            System.out.println();
            System.exit(1);
        }
    }

    public void process(String inputFile, String outputFile) throws Exception {
        System.out.println("Reading input file started.");
        long start = System.currentTimeMillis();
        ProjectFile projectFile = new UniversalProjectReader().read(inputFile);
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("Reading input file completed in " + elapsed + "ms.");
        if (projectFile == null) {
            throw new IllegalArgumentException("Unsupported file type");
        }
        int index = outputFile.lastIndexOf(46);
        if (index == -1) {
            throw new IllegalArgumentException("Filename has no extension: " + outputFile);
        }
        String extension = outputFile.substring(index + 1).toUpperCase();
        FileFormat outputFormat = FILE_FORMAT_MAP.get(extension);
        if (outputFormat == null) {
            throw new IllegalArgumentException("Cannot write files of type: " + extension);
        }
        System.out.println("Writing output file started.");
        start = System.currentTimeMillis();
        new UniversalProjectWriter(outputFormat).write(projectFile, outputFile);
        elapsed = System.currentTimeMillis() - start;
        System.out.println("Writing output completed in " + elapsed + "ms.");
    }

    static {
        FILE_FORMAT_MAP.put("MPX", FileFormat.MPX);
        FILE_FORMAT_MAP.put("XML", FileFormat.MSPDI);
        FILE_FORMAT_MAP.put("PMXML", FileFormat.PMXML);
        FILE_FORMAT_MAP.put("PLANNER", FileFormat.PLANNER);
        FILE_FORMAT_MAP.put("JSON", FileFormat.JSON);
        FILE_FORMAT_MAP.put("SDEF", FileFormat.SDEF);
        FILE_FORMAT_MAP.put("XER", FileFormat.XER);
    }
}

