/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.sample;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mpxj.AssignmentField;
import org.mpxj.ChildResourceContainer;
import org.mpxj.ChildTaskContainer;
import org.mpxj.Duration;
import org.mpxj.FieldType;
import org.mpxj.LocalDateTimeRange;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Relation;
import org.mpxj.RelationType;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceField;
import org.mpxj.Task;
import org.mpxj.TaskField;
import org.mpxj.mpp.TimescaleUnits;
import org.mpxj.reader.UniversalProjectReader;
import org.mpxj.utility.TimephasedUtility;
import org.mpxj.utility.TimescaleUtility;

public class MpxjQuery {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.out.println("Usage: MpxQuery <input file name>");
            } else {
                MpxjQuery.query(args[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    private static void query(String filename) throws Exception {
        ProjectFile mpx = new UniversalProjectReader().read(filename);
        if (mpx == null) {
            throw new Exception("Unable to read file");
        }
        MpxjQuery.listProjectProperties(mpx);
        MpxjQuery.listResources(mpx);
        MpxjQuery.listTasks(mpx);
        MpxjQuery.listAssignments(mpx);
        MpxjQuery.listAssignmentsByTask(mpx);
        MpxjQuery.listAssignmentsByResource(mpx);
        MpxjQuery.listTaskHierarchy(mpx, "");
        MpxjQuery.listResourceHierarchy(mpx, "");
        MpxjQuery.listTaskNotes(mpx);
        MpxjQuery.listResourceNotes(mpx);
        MpxjQuery.listRelationships(mpx);
        MpxjQuery.listSlack(mpx);
        MpxjQuery.listCalendars(mpx);
        MpxjQuery.listPopulatedFields(mpx);
        MpxjQuery.listTasksPercentComplete(mpx);
    }

    private static void listProjectProperties(ProjectFile file) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm");
        ProjectProperties properties = file.getProjectProperties();
        LocalDateTime startDate = properties.getStartDate();
        LocalDateTime finishDate = properties.getFinishDate();
        String formattedStartDate = startDate == null ? "(none)" : df.format(startDate);
        String formattedFinishDate = finishDate == null ? "(none)" : df.format(finishDate);
        System.out.println("MPP file type: " + properties.getMppFileType());
        System.out.println("Project Properties: StartDate=" + formattedStartDate + " FinishDate=" + formattedFinishDate);
        System.out.println();
    }

    private static void listResources(ProjectFile file) {
        for (Resource resource : file.getResources()) {
            System.out.println("Resource: " + resource.getName() + " (Unique ID=" + resource.getUniqueID() + ") Start=" + resource.getStart() + " Finish=" + resource.getFinish());
        }
        System.out.println();
    }

    private static void listTasks(ProjectFile file) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm");
        for (Task task : file.getTasks()) {
            LocalDateTime date = task.getStart();
            String text = task.getStartText();
            String startDate = text != null ? text : (date != null ? df.format(date) : "(no start date supplied)");
            date = task.getFinish();
            text = task.getFinishText();
            String finishDate = text != null ? text : (date != null ? df.format(date) : "(no finish date supplied)");
            Duration dur = task.getDuration();
            text = task.getDurationText();
            String duration = text != null ? text : (dur != null ? dur.toString() : "(no duration supplied)");
            dur = task.getActualDuration();
            String actualDuration = dur != null ? dur.toString() : "(no actual duration supplied)";
            String baselineDuration = task.getBaselineDurationText();
            if (baselineDuration == null) {
                dur = task.getBaselineDuration();
                baselineDuration = dur != null ? dur.toString() : "(no duration supplied)";
            }
            System.out.println("Task: " + task.getName() + " ID=" + task.getID() + " Unique ID=" + task.getUniqueID() + " (Start Date=" + startDate + " Finish Date=" + finishDate + " Duration=" + duration + " Actual Duration" + actualDuration + " Baseline Duration=" + baselineDuration + " Outline Level=" + task.getOutlineLevel() + " Outline Number=" + task.getOutlineNumber() + " Recurring=" + task.getRecurring() + ")");
        }
        System.out.println();
    }

    private static void listTasksPercentComplete(ProjectFile file) {
        System.out.println("ID\tUniqueID\tActivity ID\tName\t%Complete Type\tDuration % Complete\tWork % Complete\tPhysical % Complete");
        for (Task task : file.getTasks()) {
            List<Object> values = Arrays.asList(new Object[]{task.getID(), task.getUniqueID(), task.getActivityID(), task.getName(), task.getPercentCompleteType(), task.getPercentageComplete(), task.getPercentageWorkComplete(), task.getPhysicalPercentComplete()});
            System.out.println(values.stream().map(String::valueOf).collect(Collectors.joining("\t")));
        }
        System.out.println();
    }

    private static void listTaskHierarchy(ChildTaskContainer container, String indent) {
        for (Task task : container.getChildTasks()) {
            System.out.println(indent + "Task: " + task.getName() + "\t" + task.getStart() + "\t" + task.getFinish());
            MpxjQuery.listTaskHierarchy(task, indent + " ");
        }
        if (indent.isEmpty()) {
            System.out.println();
        }
    }

    private static void listResourceHierarchy(ChildResourceContainer container, String indent) {
        for (Resource resource : container.getChildResources()) {
            System.out.println(indent + "Resource: " + resource.getName());
            MpxjQuery.listResourceHierarchy(resource, indent + " ");
        }
        if (indent.isEmpty()) {
            System.out.println();
        }
    }

    private static void listAssignments(ProjectFile file) {
        for (ResourceAssignment assignment : file.getResourceAssignments()) {
            Task task = assignment.getTask();
            String taskName = task == null ? "(null task)" : task.getName();
            Resource resource = assignment.getResource();
            String resourceName = resource == null ? "(null resource)" : resource.getName();
            System.out.println("Assignment: Task=" + taskName + " Resource=" + resourceName);
            if (task == null) continue;
            MpxjQuery.listTimephasedWork(assignment);
        }
        System.out.println();
    }

    private static void listTimephasedWork(ResourceAssignment assignment) {
        Task task = assignment.getTask();
        int days = (int)(task.getStart().until(task.getFinish(), ChronoUnit.MILLIS) / 86400000L) + 1;
        if (days > 1) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("dd/MM/yy");
            TimescaleUtility timescale = new TimescaleUtility();
            ArrayList<LocalDateTimeRange> dates = timescale.createTimescale(task.getStart(), TimescaleUnits.DAYS, days);
            TimephasedUtility timephased = new TimephasedUtility();
            ArrayList<Duration> durations = timephased.segmentWork(assignment.getEffectiveCalendar(), assignment.getTimephasedWork(), TimescaleUnits.DAYS, dates);
            for (LocalDateTimeRange range : dates) {
                System.out.print(df.format(range.getStart()) + "\t");
            }
            System.out.println();
            for (Duration duration : durations) {
                System.out.print(duration.toString() + "        ".substring(0, 7) + "\t");
            }
            System.out.println();
        }
    }

    private static void listAssignmentsByTask(ProjectFile file) {
        for (Task task : file.getTasks()) {
            System.out.println("Assignments for task " + task.getName() + ":");
            for (ResourceAssignment assignment : task.getResourceAssignments()) {
                Resource resource = assignment.getResource();
                String resourceName = resource == null ? "(null resource)" : resource.getName();
                System.out.println("   " + resourceName);
            }
        }
        System.out.println();
    }

    private static void listAssignmentsByResource(ProjectFile file) {
        for (Resource resource : file.getResources()) {
            System.out.println("Assignments for resource " + resource.getName() + ":");
            for (ResourceAssignment assignment : resource.getTaskAssignments()) {
                Task task = assignment.getTask();
                System.out.println("   " + task.getName());
            }
        }
        System.out.println();
    }

    private static void listTaskNotes(ProjectFile file) {
        for (Task task : file.getTasks()) {
            String notes = task.getNotes();
            if (notes.isEmpty()) continue;
            System.out.println("Notes for " + task.getName() + ": " + notes);
        }
        System.out.println();
    }

    private static void listResourceNotes(ProjectFile file) {
        for (Resource resource : file.getResources()) {
            String notes = resource.getNotes();
            if (notes.isEmpty()) continue;
            System.out.println("Notes for " + resource.getName() + ": " + notes);
        }
        System.out.println();
    }

    private static void listRelationships(ProjectFile file) {
        for (Task task : file.getTasks()) {
            System.out.print(task.getID());
            System.out.print('\t');
            System.out.print(task.getName());
            System.out.print('\t');
            MpxjQuery.dumpRelationList(task.getPredecessors());
            System.out.print('\t');
            MpxjQuery.dumpRelationList(task.getSuccessors());
            System.out.println();
        }
    }

    private static void dumpRelationList(List<Relation> relations) {
        if (relations != null && !relations.isEmpty()) {
            if (relations.size() > 1) {
                System.out.print('\"');
            }
            boolean first = true;
            for (Relation relation : relations) {
                if (!first) {
                    System.out.print(',');
                }
                first = false;
                System.out.print(relation.getPredecessorTask().getID());
                Duration lag = relation.getLag();
                if (relation.getType() != RelationType.FINISH_START || lag.getDuration() != 0.0) {
                    System.out.print(relation.getType());
                }
                if (lag.getDuration() == 0.0) continue;
                if (lag.getDuration() > 0.0) {
                    System.out.print("+");
                }
                System.out.print(lag);
            }
            if (relations.size() > 1) {
                System.out.print('\"');
            }
        }
    }

    private static void listSlack(ProjectFile file) {
        for (Task task : file.getTasks()) {
            System.out.println(task.getName() + " Total Slack=" + task.getTotalSlack() + " Start Slack=" + task.getStartSlack() + " Finish Slack=" + task.getFinishSlack());
        }
    }

    private static void listCalendars(ProjectFile file) {
        for (ProjectCalendar cal : file.getCalendars()) {
            System.out.println(cal.toString());
        }
    }

    private static void listPopulatedFields(ProjectFile file) {
        Set<FieldType> tasks = file.getTasks().getPopulatedFields();
        Set<FieldType> resources = file.getResources().getPopulatedFields();
        Set<FieldType> assignments = file.getResourceAssignments().getPopulatedFields();
        System.out.println("Populated task fields: " + tasks.size() + "/" + TaskField.values().length);
        System.out.println("Populated resource fields: " + resources.size() + "/" + ResourceField.values().length);
        System.out.println("Populated assignment fields: " + assignments.size() + "/" + AssignmentField.values().length);
        System.out.println();
        System.out.println("Populated task fields:");
        tasks.forEach(System.out::println);
        System.out.println();
        System.out.println("Populated resource fields:");
        resources.forEach(System.out::println);
        System.out.println();
        System.out.println("Populated assignment fields:");
        assignments.forEach(System.out::println);
        System.out.println();
    }
}

