/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.sample;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Collectors;
import org.mpxj.ProjectFile;
import org.mpxj.primavera.PrimaveraDatabaseReader;
import org.mpxj.writer.FileFormat;
import org.mpxj.writer.UniversalProjectWriter;

public final class PrimaveraConvert {
    public static void main(String[] args) {
        try {
            if (args.length != 5) {
                System.out.println("Usage: PrimaveraConvert <JDBC Driver Class> <JDBC connection string> <project ID> <output format> <output file name>");
                System.out.println("(valid output format values: " + Arrays.stream(FileFormat.values()).map(Enum::name).collect(Collectors.joining(", ")) + ")");
            } else {
                PrimaveraConvert convert = new PrimaveraConvert();
                convert.process(args[0], args[1], args[2], FileFormat.valueOf(args[3]), args[4]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    public void process(String driverClass, String connectionString, String projectID, FileFormat outputFormat, String outputFile) throws Exception {
        Class.forName(driverClass);
        Properties props = new Properties();
        if (driverClass.equals("org.sqlite.JDBC")) {
            props.setProperty("date_string_format", "yyyy-MM-dd HH:mm:ss");
        }
        Connection c = DriverManager.getConnection(connectionString, props);
        PrimaveraDatabaseReader reader = new PrimaveraDatabaseReader();
        reader.setConnection(c);
        PrimaveraDatabaseReader baselineReader = new PrimaveraDatabaseReader();
        baselineReader.setConnection(c);
        this.processProject(reader, baselineReader, Integer.parseInt(projectID), outputFormat, outputFile);
    }

    private void processProject(PrimaveraDatabaseReader reader, PrimaveraDatabaseReader baselineReader, int projectID, FileFormat outputFormat, String outputFile) throws Exception {
        System.out.println("Reading Primavera database started.");
        long start = System.currentTimeMillis();
        reader.setProjectID(projectID);
        ProjectFile projectFile = reader.read();
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("Reading database completed in " + elapsed + "ms.");
        Integer baselineProjectID = projectFile.getProjectProperties().getBaselineProjectUniqueID();
        if (baselineProjectID != null) {
            System.out.println("Reading baseline started.");
            start = System.currentTimeMillis();
            baselineReader.setProjectID(baselineProjectID);
            ProjectFile baselineProjectFile = baselineReader.read();
            projectFile.setBaseline(baselineProjectFile);
            elapsed = System.currentTimeMillis() - start;
            System.out.println("Reading baseline completed in " + elapsed + "ms.");
        }
        System.out.println("Writing output file started.");
        start = System.currentTimeMillis();
        new UniversalProjectWriter(outputFormat).write(projectFile, outputFile);
        elapsed = System.currentTimeMillis() - start;
        System.out.println("Writing output completed in " + elapsed + "ms.");
    }
}

