/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.sdef;

import java.util.UUID;
import org.mpxj.Task;
import org.mpxj.sdef.AbstractSDEFRecord;
import org.mpxj.sdef.ConstraintTypeField;
import org.mpxj.sdef.Context;
import org.mpxj.sdef.DateField;
import org.mpxj.sdef.DurationField;
import org.mpxj.sdef.IntegerField;
import org.mpxj.sdef.SDEFField;
import org.mpxj.sdef.StringField;

class ActivityRecord
extends AbstractSDEFRecord {
    private static final SDEFField[] FIELDS = new SDEFField[]{new StringField("Activity ID", 10), new StringField("Activity Description", 30), new DurationField("Activity Duration", 3), new DateField("Constraint Date"), new ConstraintTypeField("Constraint Type"), new StringField("Calendar Code", 1), new StringField("Hammock Code", 1), new IntegerField("Workers Per Day", 3), new StringField("Responsibility Code", 4), new StringField("Work Area Code", 4), new StringField("Mod of Claim No", 6), new StringField("Bid Item", 6), new StringField("Phase of Work", 2), new StringField("Category of Work", 1), new StringField("Feature of Work", 10)};

    ActivityRecord() {
    }

    @Override
    protected SDEFField[] getFieldDefinitions() {
        return FIELDS;
    }

    @Override
    public void process(Context context) {
        String activityID = this.getString(0);
        Task task = context.addTask(activityID);
        task.setActivityID(activityID);
        task.setName(this.getString(1));
        task.setDuration(this.getDuration(2));
        task.setConstraintDate(this.getDate(3));
        task.setConstraintType(this.getConstraintType(4));
        task.setCalendar(context.getCalendar(this.getString(5)));
        task.setHammockCode("Y".equals(this.getString(6)));
        task.setWorkersPerDay(this.getInteger(7));
        task.setResponsibilityCode(this.getString(8));
        task.setWorkAreaCode(this.getString(9));
        task.setModOrClaimNumber(this.getString(10));
        task.setBidItem(this.getString(11));
        task.setPhaseOfWork(this.getString(12));
        task.setCategoryOfWork(this.getString(13));
        task.setFeatureOfWork(this.getString(14));
        task.setGUID(UUID.nameUUIDFromBytes(activityID.getBytes()));
        task.setMilestone(task.getDuration() != null && task.getDuration().getDuration() == 0.0);
        context.getEventManager().fireTaskReadEvent(task);
    }
}

