/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.sdef;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Locale;
import org.mpxj.common.LocalDateHelper;
import org.mpxj.sdef.StringField;

class DateField
extends StringField {
    private static final DateTimeFormatter DATE_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("ddMMM").appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, LocalDateHelper.TWO_DIGIT_YEAR_BASE_DATE).toFormatter(Locale.ENGLISH);

    public DateField(String name) {
        super(name, 7);
    }

    @Override
    public Object read(String line, int offset) {
        String value = (String)super.read(line, offset);
        LocalDateTime result = value == null || value.isEmpty() ? null : LocalDate.parse(value, DATE_FORMAT).atStartOfDay();
        return result;
    }
}

