/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.sdef;

import java.time.LocalDateTime;
import org.mpxj.Duration;
import org.mpxj.Task;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.SlackHelper;
import org.mpxj.sdef.AbstractSDEFRecord;
import org.mpxj.sdef.Context;
import org.mpxj.sdef.DateField;
import org.mpxj.sdef.DoubleField;
import org.mpxj.sdef.DurationField;
import org.mpxj.sdef.SDEFField;
import org.mpxj.sdef.StringField;

class ProgressRecord
extends AbstractSDEFRecord {
    private static final SDEFField[] FIELDS = new SDEFField[]{new StringField("Activity ID", 10), new DateField("Actual Start Date"), new DateField("Actual Finish Date"), new DurationField("Remaining Duration", 3), new DoubleField("Activity Cost", 12), new DoubleField("Cost to Date", 12), new DoubleField("Stored Material", 12), new DateField("Early Start Date"), new DateField("Early Finish Date"), new DateField("Late Start Date"), new DateField("Late Finish Date"), new StringField("Float Sign", 1), new DurationField("Total Float", 3)};

    ProgressRecord() {
    }

    @Override
    protected SDEFField[] getFieldDefinitions() {
        return FIELDS;
    }

    @Override
    public void process(Context context) {
        Double totalCost = this.getDouble(4);
        Double costToDate = this.getDouble(5);
        Double remainingCost = NumberHelper.getDouble(totalCost) - NumberHelper.getDouble(costToDate);
        Duration totalFloat = this.getDuration(12);
        if ("-".equals(this.getString(11))) {
            totalFloat = totalFloat.negate();
        }
        Task task = context.getTask(this.getString(0));
        task.setActualStart(this.getDate(1));
        task.setActualFinish(this.getDate(2));
        task.setRemainingDuration(this.getDuration(3));
        task.setCost(totalCost);
        task.setActualCost(costToDate);
        task.setRemainingCost(remainingCost);
        task.setStoredMaterial(this.getDouble(6));
        task.setEarlyStart(this.getDate(7));
        task.setEarlyFinish(this.getDate(8));
        task.setLateStart(this.getDate(9));
        task.setLateFinish(this.getDate(10));
        task.setTotalSlack(totalFloat);
        LocalDateTime start = task.getActualStart() == null ? task.getEarlyStart() : task.getActualStart();
        LocalDateTime finish = task.getActualFinish() == null ? task.getEarlyFinish() : task.getActualFinish();
        double percentComplete = 0.0;
        if (task.getActualFinish() == null) {
            Duration duration = task.getDuration();
            Duration remainingDuration = task.getRemainingDuration();
            if (duration != null && remainingDuration != null) {
                double durationValue = duration.getDuration();
                double remainingDurationValue = remainingDuration.getDuration();
                if (durationValue != 0.0 && remainingDurationValue < durationValue) {
                    percentComplete = (durationValue - remainingDurationValue) * 100.0 / durationValue;
                }
            }
        } else {
            percentComplete = 100.0;
        }
        task.setStart(start);
        task.setFinish(finish);
        task.setPercentageComplete(percentComplete);
        SlackHelper.inferSlack(task);
    }
}

