/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.sdef;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.mpxj.HasCharset;
import org.mpxj.MPXJException;
import org.mpxj.ProjectFile;
import org.mpxj.reader.AbstractProjectStreamReader;
import org.mpxj.sdef.ActivityRecord;
import org.mpxj.sdef.CalendarRecord;
import org.mpxj.sdef.Context;
import org.mpxj.sdef.HolidayRecord;
import org.mpxj.sdef.PrecedenceRecord;
import org.mpxj.sdef.ProgressRecord;
import org.mpxj.sdef.ProjectRecord;
import org.mpxj.sdef.SDEFRecord;
import org.mpxj.sdef.UnitCostRecord;
import org.mpxj.sdef.VolumeRecord;

public final class SDEFReader
extends AbstractProjectStreamReader
implements HasCharset {
    private Charset m_charset;
    private boolean m_ignoreErrors = true;
    private static final Map<String, Class<? extends SDEFRecord>> RECORD_MAP = new HashMap<String, Class<? extends SDEFRecord>>();

    @Override
    public void setCharset(Charset charset) {
        this.m_charset = charset;
    }

    @Override
    public Charset getCharset() {
        return this.m_charset == null ? StandardCharsets.US_ASCII : this.m_charset;
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        Context context = new Context();
        ProjectFile project = context.getProject();
        project.getProjectProperties().setFileApplication("SDEF");
        project.getProjectProperties().setFileType("SDEF");
        this.addListenersToProject(project);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, this.getCharset()));
        try {
            while (this.processLine(context, reader.readLine())) {
            }
        }
        catch (IOException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        project.setDefaultCalendar(project.getCalendars().findOrCreateDefaultCalendar());
        project.readComplete();
        return project;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.m_ignoreErrors = ignoreErrors;
    }

    public boolean getIgnoreErrors() {
        return this.m_ignoreErrors;
    }

    private boolean processLine(Context context, String line) throws MPXJException {
        SDEFRecord record;
        if (line == null || line.startsWith("END")) {
            return false;
        }
        String recordID = line.substring(0, 4);
        Class<? extends SDEFRecord> klass = RECORD_MAP.get(recordID);
        if (klass == null) {
            throw new MPXJException("Unknown record type: " + recordID);
        }
        try {
            record = klass.newInstance();
        }
        catch (Exception e) {
            throw new MPXJException("Error reading file", e);
        }
        record.read(context.getProject(), line, this.m_ignoreErrors);
        record.process(context);
        return true;
    }

    static {
        RECORD_MAP.put("VOLM", VolumeRecord.class);
        RECORD_MAP.put("PROJ", ProjectRecord.class);
        RECORD_MAP.put("CLDR", CalendarRecord.class);
        RECORD_MAP.put("HOLI", HolidayRecord.class);
        RECORD_MAP.put("ACTV", ActivityRecord.class);
        RECORD_MAP.put("PRED", PrecedenceRecord.class);
        RECORD_MAP.put("UNIT", UnitCostRecord.class);
        RECORD_MAP.put("PROG", ProgressRecord.class);
    }
}

