/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.synchro;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.mpxj.Duration;
import org.mpxj.TimeUnit;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.CharsetHelper;
import org.mpxj.common.InputStreamHelper;

final class DatatypeConverter {
    private static final long NULL_SECONDS = -1824493569L;
    private static final LocalDateTime EPOCH = LocalDateTime.of(1970, 1, 1, 0, 0);

    DatatypeConverter() {
    }

    public static String getSimpleString(byte[] data, int offset) {
        char c;
        StringBuilder buffer = new StringBuilder();
        int loop = 0;
        while (offset + loop < data.length && (c = (char)data[offset + loop]) != '\u0000') {
            buffer.append(c);
            ++loop;
        }
        return buffer.toString();
    }

    public static final int getInt(byte[] data, int offset) {
        return ByteArrayHelper.getInt(data, offset);
    }

    public static final int getShort(byte[] data, int offset) {
        return ByteArrayHelper.getShort(data, offset);
    }

    public static final long getLong(byte[] data, int offset) {
        return ByteArrayHelper.getLong(data, offset);
    }

    public static final int getInt(InputStream is) throws IOException {
        return DatatypeConverter.getInt(InputStreamHelper.read(is, 4), 0);
    }

    public static final Integer getInteger(InputStream is) throws IOException {
        return DatatypeConverter.getInt(is);
    }

    public static final int getShort(InputStream is) throws IOException {
        return DatatypeConverter.getShort(InputStreamHelper.read(is, 2), 0);
    }

    public static final long getLong(InputStream is) throws IOException {
        return DatatypeConverter.getLong(InputStreamHelper.read(is, 8), 0);
    }

    public static final String getString(InputStream is) throws IOException {
        int length;
        int type = is.read();
        if (type == 255) {
            length = 255;
        } else {
            if (type != 1) {
                throw new IllegalArgumentException("Unexpected string format");
            }
            length = is.read();
        }
        Charset charset = CharsetHelper.UTF8;
        if (length == 255 && (length = DatatypeConverter.getShort(is)) == 65534) {
            charset = CharsetHelper.UTF16LE;
            length = is.read() * 2;
        }
        String result = length == 0 ? null : new String(InputStreamHelper.read(is, length), charset);
        return result;
    }

    public static boolean getBoolean(InputStream is) throws IOException {
        int value = is.read();
        return value != 0;
    }

    public static final UUID getUUID(InputStream is) throws IOException {
        byte[] data = InputStreamHelper.read(is, 16);
        long long1 = 0L;
        long1 |= (long)(data[3] & 0xFF) << 56;
        long1 |= (long)(data[2] & 0xFF) << 48;
        long1 |= (long)(data[1] & 0xFF) << 40;
        long1 |= (long)(data[0] & 0xFF) << 32;
        long1 |= (long)(data[5] & 0xFF) << 24;
        long1 |= (long)(data[4] & 0xFF) << 16;
        long1 |= (long)(data[7] & 0xFF) << 8;
        long1 |= (long)(data[6] & 0xFF);
        long long2 = 0L;
        long2 |= (long)(data[8] & 0xFF) << 56;
        long2 |= (long)(data[9] & 0xFF) << 48;
        long2 |= (long)(data[10] & 0xFF) << 40;
        long2 |= (long)(data[11] & 0xFF) << 32;
        long2 |= (long)(data[12] & 0xFF) << 24;
        long2 |= (long)(data[13] & 0xFF) << 16;
        long2 |= (long)(data[14] & 0xFF) << 8;
        return new UUID(long1, long2 |= (long)(data[15] & 0xFF));
    }

    public static final LocalDateTime getDate(InputStream is) throws IOException {
        long timeInSeconds = DatatypeConverter.getInt(is);
        if (timeInSeconds == -1824493569L) {
            return null;
        }
        return EPOCH.plusSeconds(timeInSeconds);
    }

    public static final LocalTime getTime(InputStream is) throws IOException {
        int timeValue = DatatypeConverter.getInt(is);
        if ((timeValue -= 86400) == 86400) {
            timeValue = 0;
        }
        return LocalTime.ofSecondOfDay(timeValue);
    }

    public static final Duration getDuration(InputStream is) throws IOException {
        return DatatypeConverter.getDurationFromSeconds(DatatypeConverter.getInt(is));
    }

    public static final Duration getDurationFromLong(InputStream is) throws IOException {
        return DatatypeConverter.getDurationFromSeconds((int)DatatypeConverter.getLong(is));
    }

    private static Duration getDurationFromSeconds(int durationInSeconds) {
        if ((long)durationInSeconds == -1824493569L) {
            return null;
        }
        double durationInHours = durationInSeconds;
        return Duration.getInstance(durationInHours /= 3600.0, TimeUnit.HOURS);
    }

    public static final Double getDouble(InputStream is) throws IOException {
        double result = Double.longBitsToDouble(DatatypeConverter.getLong(is));
        if (Double.isNaN(result)) {
            result = 0.0;
        }
        return result;
    }
}

