/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.synchro;

import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.mpxj.Duration;
import org.mpxj.common.ByteArray;
import org.mpxj.common.InputStreamHelper;
import org.mpxj.common.SemVer;
import org.mpxj.synchro.BlockReader;
import org.mpxj.synchro.DatatypeConverter;
import org.mpxj.synchro.MapRow;
import org.mpxj.synchro.TableReader;
import org.mpxj.synchro.UnknownBlockReader;
import org.mpxj.synchro.UnknownTableReader;

class StreamReader {
    private final SemVer m_version;
    private final InputStream m_stream;

    public StreamReader(SemVer version, InputStream stream) {
        this.m_version = version;
        this.m_stream = stream;
    }

    public Integer readByte() throws IOException {
        return this.m_stream.read();
    }

    public Boolean readBoolean() throws IOException {
        return DatatypeConverter.getBoolean(this.m_stream);
    }

    public List<MapRow> readTable(TableReader reader) throws IOException {
        reader.read();
        return reader.getRows();
    }

    public List<MapRow> readUnknownTable(int rowSize, int rowMagicNumber) throws IOException {
        UnknownTableReader reader = new UnknownTableReader(this, rowSize, rowMagicNumber);
        reader.read();
        return reader.getRows();
    }

    public List<MapRow> readTable(Class<? extends TableReader> readerClass) throws IOException {
        TableReader reader;
        try {
            reader = readerClass.getConstructor(StreamReader.class).newInstance(this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return this.readTable(reader);
    }

    public List<MapRow> readTableConditional(Class<? extends TableReader> readerClass) throws IOException {
        List<MapRow> result = DatatypeConverter.getBoolean(this.m_stream) ? this.readTable(readerClass) : Collections.emptyList();
        return result;
    }

    public List<MapRow> readUnknownTableConditional(int rowSize, int rowMagicNumber) throws IOException {
        List<MapRow> result = DatatypeConverter.getBoolean(this.m_stream) ? this.readUnknownTable(rowSize, rowMagicNumber) : Collections.emptyList();
        return result;
    }

    public ByteArray readBytes(int size) throws IOException {
        return new ByteArray(InputStreamHelper.read(this.m_stream, size));
    }

    public UUID readUUID() throws IOException {
        return DatatypeConverter.getUUID(this.m_stream);
    }

    public String readString() throws IOException {
        return DatatypeConverter.getString(this.m_stream);
    }

    public LocalDateTime readDate() throws IOException {
        return DatatypeConverter.getDate(this.m_stream);
    }

    public LocalTime readTime() throws IOException {
        return DatatypeConverter.getTime(this.m_stream);
    }

    public Duration readDuration() throws IOException {
        return DatatypeConverter.getDuration(this.m_stream);
    }

    public Duration readDurationFromLong() throws IOException {
        return DatatypeConverter.getDurationFromLong(this.m_stream);
    }

    public int readInt() throws IOException {
        return DatatypeConverter.getInt(this.m_stream);
    }

    public Integer readInteger() throws IOException {
        return DatatypeConverter.getInteger(this.m_stream);
    }

    public Double readDouble() throws IOException {
        return DatatypeConverter.getDouble(this.m_stream);
    }

    public List<MapRow> readUnknownBlocks(int size) throws IOException {
        return new UnknownBlockReader(this, size).read();
    }

    public List<MapRow> readBlocks(Class<? extends BlockReader> readerClass) throws IOException {
        BlockReader reader;
        try {
            reader = readerClass.getConstructor(StreamReader.class).newInstance(this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return reader.read();
    }

    public SemVer getVersion() {
        return this.m_version;
    }

    public InputStream getStream() {
        return this.m_stream;
    }
}

