/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.synchro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.mpxj.common.InputStreamHelper;
import org.mpxj.common.SemVer;
import org.mpxj.synchro.BytesReadInputStream;
import org.mpxj.synchro.DatatypeConverter;
import org.mpxj.synchro.StreamReader;
import org.mpxj.synchro.Synchro;
import org.mpxj.synchro.SynchroLogger;
import org.mpxj.synchro.SynchroTable;

class SynchroData {
    private SemVer m_version;
    private int m_offset;
    private final Map<String, byte[]> m_tableData = new HashMap<String, byte[]>();
    private static final Set<String> REQUIRED_TABLES = new HashSet<String>(Arrays.asList("Tasks", "Calendars", "Companies", "Resources"));

    SynchroData() {
    }

    public void process(InputStream is) throws Exception {
        this.readHeader(is);
        this.readVersion(is);
        this.readTableData(this.readTableHeaders(is), is);
    }

    public SemVer getVersion() {
        return this.m_version;
    }

    public StreamReader getTableData(String name) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.m_tableData.get(name));
        if (this.m_version.atLeast(Synchro.VERSION_6_0_0)) {
            SynchroLogger.log("TABLE HEADER", InputStreamHelper.read((InputStream)stream, 24));
        }
        return new StreamReader(this.m_version, stream);
    }

    private List<SynchroTable> readTableHeaders(InputStream is) throws IOException {
        ArrayList<SynchroTable> tables = new ArrayList<SynchroTable>();
        byte[] header = new byte[48];
        while (true) {
            InputStreamHelper.read(is, header);
            this.m_offset += 48;
            SynchroTable table = this.readTableHeader(header);
            if (table == null) break;
            tables.add(table);
        }
        tables.sort(Comparator.comparingInt(SynchroTable::getOffset));
        SynchroTable previousTable = null;
        for (SynchroTable table : tables) {
            if (previousTable != null) {
                previousTable.setLength(table.getOffset() - previousTable.getOffset());
            }
            previousTable = table;
        }
        for (SynchroTable table : tables) {
            SynchroLogger.log("TABLE", table);
        }
        return tables;
    }

    private SynchroTable readTableHeader(byte[] header) {
        SynchroTable result = null;
        String tableName = DatatypeConverter.getSimpleString(header, 0);
        if (!tableName.isEmpty()) {
            int offset = DatatypeConverter.getInt(header, 40);
            result = new SynchroTable(tableName, offset);
        }
        return result;
    }

    private void readTableData(List<SynchroTable> tables, InputStream is) throws IOException {
        for (SynchroTable table : tables) {
            if (!REQUIRED_TABLES.contains(table.getName())) continue;
            this.readTable(is, table);
        }
    }

    private void readTable(InputStream is, SynchroTable table) throws IOException {
        int skip = table.getOffset() - this.m_offset;
        if (skip != 0) {
            InputStreamHelper.skip(is, skip);
            this.m_offset += skip;
        }
        String tableName = DatatypeConverter.getString(is);
        int tableNameLength = 2 + tableName.length();
        this.m_offset += tableNameLength;
        int dataLength = table.getLength() == -1 ? is.available() : table.getLength() - tableNameLength;
        SynchroLogger.log("READ", tableName);
        byte[] compressedTableData = InputStreamHelper.read(is, dataLength);
        this.m_offset += dataLength;
        Inflater inflater = new Inflater();
        inflater.setInput(compressedTableData);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(compressedTableData.length);
        byte[] buffer = new byte[1024];
        while (!inflater.finished()) {
            int count;
            try {
                count = inflater.inflate(buffer);
            }
            catch (DataFormatException ex) {
                throw new IOException(ex);
            }
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] uncompressedTableData = outputStream.toByteArray();
        SynchroLogger.log(uncompressedTableData);
        this.m_tableData.put(table.getName(), uncompressedTableData);
    }

    private void readHeader(InputStream is) throws IOException {
        byte[] header = InputStreamHelper.read(is, 20);
        this.m_offset += 20;
        SynchroLogger.log("HEADER", header);
    }

    private void readVersion(InputStream is) throws IOException {
        BytesReadInputStream bytesReadStream = new BytesReadInputStream(is);
        String version = DatatypeConverter.getString(bytesReadStream);
        this.m_offset += bytesReadStream.getBytesRead();
        SynchroLogger.log("VERSION", version);
        this.m_version = new SemVer(version);
    }
}

