/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.utility;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.mpxj.Duration;
import org.mpxj.LocalDateTimeRange;
import org.mpxj.ProjectCalendar;
import org.mpxj.TimeUnit;
import org.mpxj.TimephasedCost;
import org.mpxj.TimephasedItem;
import org.mpxj.TimephasedWork;
import org.mpxj.common.LocalDateHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.mpp.TimescaleUnits;

public final class TimephasedUtility {
    public ArrayList<Duration> segmentWork(ProjectCalendar projectCalendar, List<TimephasedWork> work, TimescaleUnits rangeUnits, List<LocalDateTimeRange> dateList) {
        ArrayList<Duration> result = new ArrayList<Duration>(dateList.size());
        int lastStartIndex = 0;
        for (LocalDateTimeRange range : dateList) {
            int startIndex;
            int n = startIndex = lastStartIndex == -1 ? -1 : this.getStartIndex(range, work, lastStartIndex);
            if (startIndex == -1) {
                result.add(Duration.getInstance(0, TimeUnit.HOURS));
                continue;
            }
            result.add(this.getRangeDuration(projectCalendar, rangeUnits, range, work, startIndex));
            lastStartIndex = startIndex;
        }
        return result;
    }

    public ArrayList<Duration> segmentBaselineWork(ProjectCalendar calendar, List<TimephasedWork> work, TimescaleUnits rangeUnits, ArrayList<LocalDateTimeRange> dateList) {
        return this.segmentWork(calendar, work, rangeUnits, dateList);
    }

    public ArrayList<Double> segmentCost(ProjectCalendar projectCalendar, List<TimephasedCost> cost, TimescaleUnits rangeUnits, ArrayList<LocalDateTimeRange> dateList) {
        ArrayList<Double> result = new ArrayList<Double>(dateList.size());
        int lastStartIndex = 0;
        for (LocalDateTimeRange range : dateList) {
            int startIndex;
            int n = startIndex = lastStartIndex == -1 ? -1 : this.getStartIndex(range, cost, lastStartIndex);
            if (startIndex == -1) {
                result.add(NumberHelper.DOUBLE_ZERO);
                continue;
            }
            result.add(this.getRangeCost(projectCalendar, rangeUnits, range, cost, startIndex));
            lastStartIndex = startIndex;
        }
        return result;
    }

    public ArrayList<Double> segmentBaselineCost(ProjectCalendar calendar, List<TimephasedCost> cost, TimescaleUnits rangeUnits, ArrayList<LocalDateTimeRange> dateList) {
        return this.segmentCost(calendar, cost, rangeUnits, dateList);
    }

    private <T extends TimephasedItem<?>> int getStartIndex(LocalDateTimeRange range, List<T> assignments, int startIndex) {
        int result = -1;
        if (assignments != null) {
            LocalDateTime rangeStart = range.getStart();
            LocalDateTime rangeEnd = range.getEnd();
            for (int loop = startIndex; loop < assignments.size(); ++loop) {
                TimephasedItem assignment = (TimephasedItem)assignments.get(loop);
                int compareResult = LocalDateTimeHelper.compare(assignment.getStart(), assignment.getFinish(), rangeStart);
                if (compareResult > 0) continue;
                if (compareResult == 0) {
                    result = loop;
                    break;
                }
                compareResult = LocalDateTimeHelper.compare(assignment.getStart(), assignment.getFinish(), rangeEnd);
                if (compareResult < 0) continue;
                result = loop;
                break;
            }
        }
        return result;
    }

    private Duration getRangeDuration(ProjectCalendar projectCalendar, TimescaleUnits rangeUnits, LocalDateTimeRange range, List<TimephasedWork> assignments, int startIndex) {
        Duration result;
        switch (rangeUnits) {
            case MINUTES: 
            case HOURS: {
                result = this.getRangeDurationSubDay(projectCalendar, rangeUnits, range, assignments, startIndex);
                break;
            }
            default: {
                result = this.getRangeDurationWholeDay(projectCalendar, rangeUnits, range, assignments, startIndex);
            }
        }
        return result;
    }

    private Duration getRangeDurationSubDay(ProjectCalendar projectCalendar, TimescaleUnits rangeUnits, LocalDateTimeRange range, List<TimephasedWork> assignments, int startIndex) {
        throw new UnsupportedOperationException("Please request this functionality from the MPXJ maintainer");
    }

    private Duration getRangeDurationWholeDay(ProjectCalendar projectCalendar, TimescaleUnits rangeUnits, LocalDateTimeRange range, List<TimephasedWork> assignments, int startIndex) {
        boolean done;
        int totalDays = 0;
        double totalWork = 0.0;
        TimephasedWork assignment = assignments.get(startIndex);
        do {
            LocalDateTime assignmentStart;
            LocalDateTime startDate;
            if ((startDate = range.getStart()).isBefore(assignmentStart = assignment.getStart())) {
                startDate = assignmentStart;
            }
            LocalDateTime rangeEndDate = range.getEnd();
            LocalDateTime traEndDate = assignment.getFinish();
            LocalDateTime calendarDate = startDate;
            while (startDate.isBefore(rangeEndDate) && startDate.isBefore(traEndDate)) {
                if (projectCalendar == null || projectCalendar.isWorkingDate(LocalDateHelper.getLocalDate(calendarDate))) {
                    ++totalDays;
                }
                calendarDate = startDate = startDate.plusDays(1L);
            }
            done = true;
            totalWork += ((Duration)assignment.getAmountPerDay()).getDuration() * (double)totalDays;
            if (!startDate.isBefore(rangeEndDate) || ++startIndex >= assignments.size()) continue;
            assignment = assignments.get(startIndex);
            totalDays = 0;
            done = false;
        } while (!done);
        return Duration.getInstance(totalWork, ((Duration)assignment.getAmountPerDay()).getUnits());
    }

    private Double getRangeCost(ProjectCalendar projectCalendar, TimescaleUnits rangeUnits, LocalDateTimeRange range, List<TimephasedCost> assignments, int startIndex) {
        Double result;
        switch (rangeUnits) {
            case MINUTES: 
            case HOURS: {
                result = this.getRangeCostSubDay(projectCalendar, rangeUnits, range, assignments, startIndex);
                break;
            }
            default: {
                result = this.getRangeCostWholeDay(projectCalendar, rangeUnits, range, assignments, startIndex);
            }
        }
        return result;
    }

    private Double getRangeCostWholeDay(ProjectCalendar projectCalendar, TimescaleUnits rangeUnits, LocalDateTimeRange range, List<TimephasedCost> assignments, int startIndex) {
        boolean done;
        int totalDays = 0;
        double totalCost = 0.0;
        TimephasedCost assignment = assignments.get(startIndex);
        do {
            LocalDateTime assignmentStart;
            LocalDateTime startDate;
            if ((startDate = range.getStart()).isBefore(assignmentStart = assignment.getStart())) {
                startDate = assignmentStart;
            }
            LocalDateTime rangeEndDate = range.getEnd();
            LocalDateTime traEndDate = assignment.getFinish();
            LocalDateTime calendarDate = startDate;
            while (startDate.isBefore(rangeEndDate) && startDate.isBefore(traEndDate)) {
                if (projectCalendar == null || projectCalendar.isWorkingDate(LocalDateHelper.getLocalDate(calendarDate))) {
                    ++totalDays;
                }
                calendarDate = startDate = startDate.plusDays(1L);
            }
            done = true;
            totalCost += ((Number)assignment.getAmountPerDay()).doubleValue() * (double)totalDays;
            if (!startDate.isBefore(rangeEndDate) || ++startIndex >= assignments.size()) continue;
            assignment = assignments.get(startIndex);
            totalDays = 0;
            done = false;
        } while (!done);
        return totalCost;
    }

    private Double getRangeCostSubDay(ProjectCalendar projectCalendar, TimescaleUnits rangeUnits, LocalDateTimeRange range, List<TimephasedCost> assignments, int startIndex) {
        throw new UnsupportedOperationException("Please request this functionality from the MPXJ maintainer");
    }
}

