# Contributing to Artifex

Thanks for your interest in contributing to **Artifex**!
This project is in its early stages, and **we welcome ideas, issues, and pull requests** of all kinds.

## What To Contribute On

We welcome contributions of any kind, **both in the form of [new issues](https://github.com/tanaos/artifex/issues)** and **new code**. Typical contributions are done in one of two ways:

1. When using the library you **come across a problem or come up with a possible improvement**. First of all, you should check the [Issues Tab](https://github.com/tanaos/artifex/issues) to see if an issue that addresses the same shortcoming is already present. If that is the case, you can jump to option number 2, otherwise you can either:
    - [Open a new issue](https://github.com/tanaos/artifex/issues/new) for the shortcoming you have identified (opening issue, without necessarily working on them, is a productive way of contributing to open source code!)
    - [Open a new issue](https://github.com/tanaos/artifex/issues/new) **and** start working on it. You can indicate that you will take care of the newly opened issue by either assigning it to yourself or stating it in the comments.

2. You visit the [Issues Tab](https://github.com/tanaos/artifex/issues) and **look for a known issue you are interested in working on**. Simple issues, perfect for developers who have never / very seldom contributed to open source code, are marked with a badge. Once you have found an issue that you like, indicate that you will be working on it by either assigning it to yourself or stating so in the comments.

## How To Contribute New Code

Direct pushes to the `master` branch are not permitted. In order to contribute new code, please **follow the standard fork --> push --> pull request workflow**:

1. Fork the repository
2. Create a new branch (`git checkout -b feature/my-feature`)
3. Make your changes
4. Commit your changes (`git commit -m "Add feature"`)
5. Push to your fork (`git push origin feature/my-feature`)
6. Open a pull request

## Guidelines

- Keep your code clean and consistent with existing style.
- Add or update docstrings and comments where helpful.
- If applicable, write or update tests.
- Be constructive in discussions.

## Questions?

Feel free to open an issue or start a discussion if you're not sure where to begin. We're happy to help!
