<p align="center">
    <a href="https://github.com/tanaos/artifex">
        <img src="https://raw.githubusercontent.com/tanaos/artifex/master/assets/hero.png" width="400px" alt="Artifex - Train small, private AI models without data">
    </a>
</p>

<p align="center">
    <a href="https://github.com/tanaos/artifex">
        <img src="https://raw.githubusercontent.com/tanaos/artifex/master/assets/banner.png" width="600px" alt="Artifex - Train small, private AI models without data">
    </a>
</p>

<p align="center">
    <a href="https://docs.tanaos.com/artifex/intro">Documentation</a>
    ·
    <a href="https://docs.tanaos.com/artifex/tutorials">Tutorial</a>
</p>

<p align="center">
    <a href="https://pypi.org/project/artifex/">
        <img src="https://img.shields.io/pypi/v/artifex?logo=pypi&logoColor=%23fff&color=%23006dad&label=Pypi"
        alt="Latest PyPi package version">
    </a>
    <a href="https://github.com/tanaos/artifex/actions/workflows/python-publish.yml">
        <img src="https://img.shields.io/github/actions/workflow/status/tanaos/artifex/python-publish.yml?logo=github&logoColor=%23fff&label=Tests"
        alt="Tests status">
    </a>
    <a href="https://huggingface.co/models?sort=trending&search=tanaos">
        <img src="https://img.shields.io/badge/_-Sample Models_on_HuggingFace-red?logo=huggingface&labelColor=grey"
        alt="Sample Models on HuggingFace">
    </a>
    <a href="https://github.com/tanaos/artifex/commits/">
        <img src="https://img.shields.io/github/commit-activity/m/tanaos/artifex?style=flat&color=purple&label=Commit%20Activity" alt="GitHub commit activity">
    </a>
    <a href="https://docs.tanaos.com/artifex/intro">
        <img src="https://img.shields.io/badge/%20Docs-Read%20the%20docs-orange?logo=docusaurus&logoColor=white"
        alt="Artifex Documentation">
    </a>
</p>

<p align="center">
  <strong>📊 100% less training data needed • 💸 100% cheaper than third-party APIs • 🔒 Keep exclusive ownership of your models • 🌱 No GPU needed</strong>
</p>

## 🔥 Highlights

- **📊 100% less training data needed**: you don't need *any training data at all*, as synthetic data is generated under the hood.
- **💸 100% cheaper than third-party APIs**: Artifex allows you to generate your own production-ready models, so you can stop paying for third-party APIs.
- **🔒 Keep ownership of your models**: Tired of using third-party APIs? Artifex will generate the training data and model folder locally, so you can keep exclusive ownership of the models you generate.
- **🌱 No GPU needed**: Artifex is designed to run on a regular CPU, so you can train models and run inference with them on your laptop.
- **⏳ Coming soon — Model Hosting**: Unsure how to handle the generated models in production? Deploy your models as a private web service hosted on our servers, and perform inference through a simple REST API endpoint. **[Find out more and join the waitlist](#-coming-soon-model-hosting--join-the-waitlist)**.

## Introduction

Artifex is a Python library for generating a range of small **AI models proprietary to you, without training data**. How is it even possible, you might ask? Because synthetic training data is automatically generated under the hood through our [Synthex library](https://github.com/tanaos/synthex-python).

## Use Cases

Artifex is perfect for you if you are looking to use a small AI model, but you:

- **Don't have enough training data**: Artifex generates synthetic training data for you, so you don't need to worry about collecting or curating it.
- **Don't want to keep paying for third-party APIs**: generate your own model you can use in production, so you can stop paying for third-party APIs.
- **Want to keep model ownership**: generate models that are exclusively yours, so you can keep ownership of both the model and the data it was trained on.
- **Want to run training/inference on your own hardware**: Artifex is designed to run both training and inference on a regular CPU, so you don't need a GPU to use it.

## Available Models (more coming soon) — [suggest one](https://github.com/tanaos/artifex/discussions/categories/model-suggestions)

We continue to add new models to Artifex, so stay tuned for updates! Currently, you can generate the following models:

- **🛡️ Chatbot Guardrail**: describe what your chatbot is not allowed to talk about; Artifex will automatically train a Guardrail model for you.
- **🗂️ Intent Classifier**: train a model to classify user intents into a set of categories of your choice, such as *"product_inquiry"*, *"send_email"*, *"schedule_meeting"* or anything else.
- **📝 <ins>Got Suggestions?</ins>** We highly value our users' opinions. If there is a specific model you'd like to see on Artifex, **[write it in the discussion!](https://github.com/tanaos/artifex/discussions/categories/model-suggestions)**

## 🚀 Quickstart Guide

Install the library via pip

```bash
pip install artifex
```

### 🛡️ Guardrail Model — [try the tutorial](https://colab.research.google.com/github/tanaos/artifex-blueprints/blob/master/notebooks/guardrail.ipynb):

Train the model:

```python
from artifex import Artifex

gr = Artifex().guardrail

gr.train(
    instructions=[
        "Soft medical advice is allowed, but it should be general and not specific to any individual.",
        "Anything that is about cosmetic products, including available products or their usage, is allowed.",
        "Anything else, including hard medical advice, is not allowed under any circumstances.",
    ]
)
```

once training is complete, perform inference:

```python
# Hard medical advice, should be classified as unsafe
print(gr("Take 500mg of vitamin C daily to boost your immune system during cold season."))
# >>> "unsafe"

# Cosmetic product usage, should be classified as safe
print(gr("This facial scrub exfoliates the skin, removing dead skin cells."))
# >>> "safe"
```

### 🗂️ Intent Classifier Model — [try the tutorial](https://colab.research.google.com/github/tanaos/artifex-blueprints/blob/master/notebooks/intent-classifier.ipynb):

Train the model:

```python
from artifex import Artifex

ic = Artifex().intent_classifier

ic.train(
    classes={
        "send_email": "Intent to send an email to someone",
        "reply_email": "Intent to reply to an email that was received",
        "schedule_meeting": "Intent to schedule a meeting with someone",
        "cancel_meeting": "Intent to cancel a meeting which was previously scheduled",
        "reschedule_meeting": "Intent to reschedule a meeting which was previously scheduled",
    }
)
```
once training is complete, perform inference:

```python
print(ic("I forgot to send that email to John, could you do that for me?"))
# >>> "send_email"

print(ic("I need to set up a meeting with Sarah to discuss the upcoming delivery. Can you help me do that?"))
# >>> "schedule_meeting"

print(ic("I fell ill and I'll have to cancel my meeting with the team. Please go ahead and do it for me."))
# >>> "cancel_meeting"

print(ic("I fell ill and I'll have to postpone my meeting with the team. Please go ahead and do it for me."))
# >>> "reschedule_meeting"
```

## ⏳ Coming soon: <ins>model hosting</ins> — [Join the waitlist!](https://forms.gle/yZc6PKDjnFL4vGao9)

We are working on a `.deploy()` method that will allow you to deploy your models as a **private** web service **hosted on our servers**, and perform inference through a simple **REST API endpoint**, so you can use your models **in production** without having to think about the underlying infrastructure. 

See the example below:

```python
from artifex import Artifex

gr = Artifex().guardrail

gr.train(
    instructions=[
        "Soft medical advice is allowed, but it should be general and not specific to any individual.",
        "Anything that is about cosmetic products, including available products or their usage, is allowed.",
        "Anything else, including hard medical advice, is not allowed under any circumstances.",
    ]
)

gr.deploy()

# >>> "Your service is now running on https://model.tanaos.com/hya13ki7"
```

Perform inference on the deployed model:

```python
import requests

response = requests.post(
    "https://model.tanaos.com/hya13ki7",
    headers={"Authorization": "Bearer <your-token-here>"},
    json={"text": "Take 500mg of vitamin C daily to boost your immune system during cold season."}
)

print(response.json())

# >>> {"result": "unsafe"}
```

**Want to join the waitlist** to get early access? Click on the button below:

[<img src="https://img.shields.io/badge/-Join%20the%20Model%20Hosting%20Waitlist-FF3668?style=flat" height="30">](https://forms.gle/yZc6PKDjnFL4vGao9)

## 🔗 Tutorials & Demos

### Guardrail Model 
1. [Tutorial](https://colab.research.google.com/github/tanaos/artifex-blueprints/blob/master/notebooks/guardrail.ipynb) — create a Guardrail Model with Artifex
2. [Demo](https://huggingface.co/spaces/tanaos/online-store-chatbot-guardrail-demo) — try a Guardrail Model trained with Artifex
3. [HF page](https://huggingface.co/tanaos/online-store-chatbot-guardrail-model-100M) — see a Guardrail Model trained with Artifex

### Intent Classifier Model
1. [Tutorial](https://colab.research.google.com/github/tanaos/artifex-blueprints/blob/master/notebooks/intent-classifier.ipynb) — create an Intent Classifier Model with Artifex

## 📚 Documentation & Support

- Full documentation: https://docs.tanaos.com/artifex/intro
- Contact: info@tanaos.com
