# mfoutparser
by Arthur G. Palmer, III and Michelle L. Gill

A series of python subroutines to read and extract information from the STAR format mfout file generated by the program ModelFree.

Unlike the BMRB STAR format, the format used by ModelFree uses the data_name field, rather than the save_name field and also allows nested loops. (The mfout file has loops nested to a depth of two only).

## Local Demo

Once `mfoutparser` has been installed, the `examples` directory can be copied to the current path using the following shell command:

```
python -c 'import mfoutparser as mf; mf.copy_examples()'
```

## Compatibility

`mfoutparser` has been tested on python 3.12. It requires the
Numpy (tested on version 1.26.4) and Pandas (tested on version 2.2.2)
libraries. IPython notebook (tested on version 8.27.0) is required to run the
demonstration notebook located in the `examples` directory. Matplotlib
is required if plotting of the data is desired.

## Installation

`mfoutparser` can be installed with the [pip](https://pypi.python.org/pypi/mfoutparser) package managers or using python's `setuptools`. See the [installation instructions](https://github.com/agpalmeriii/mfoutparser/blob/master/INSTALL.md) for more information.
