# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AclRoleArgs', 'AclRole']

@pulumi.input_type
class AclRoleArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 node_identities: Optional[pulumi.Input[Sequence[pulumi.Input['AclRoleNodeIdentityArgs']]]] = None,
                 partition: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_identities: Optional[pulumi.Input[Sequence[pulumi.Input['AclRoleServiceIdentityArgs']]]] = None,
                 templated_policies: Optional[pulumi.Input[Sequence[pulumi.Input['AclRoleTemplatedPolicyArgs']]]] = None):
        """
        The set of arguments for constructing a AclRole resource.
        :param pulumi.Input[str] description: A free form human readable description of the role.
        :param pulumi.Input[str] name: The name of the ACL role.
        :param pulumi.Input[str] namespace: The namespace to create the role within.
        :param pulumi.Input[Sequence[pulumi.Input['AclRoleNodeIdentityArgs']]] node_identities: The list of node identities that should be applied to the role.
        :param pulumi.Input[str] partition: The partition the ACL role is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: The list of policies that should be applied to the role. Both the policy ID or its name can be used.
        :param pulumi.Input[Sequence[pulumi.Input['AclRoleServiceIdentityArgs']]] service_identities: The list of service identities that should be applied to the role.
        :param pulumi.Input[Sequence[pulumi.Input['AclRoleTemplatedPolicyArgs']]] templated_policies: The list of templated policies that should be applied to the token.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if node_identities is not None:
            pulumi.set(__self__, "node_identities", node_identities)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if service_identities is not None:
            pulumi.set(__self__, "service_identities", service_identities)
        if templated_policies is not None:
            pulumi.set(__self__, "templated_policies", templated_policies)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A free form human readable description of the role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ACL role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to create the role within.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="nodeIdentities")
    def node_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclRoleNodeIdentityArgs']]]]:
        """
        The list of node identities that should be applied to the role.
        """
        return pulumi.get(self, "node_identities")

    @node_identities.setter
    def node_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclRoleNodeIdentityArgs']]]]):
        pulumi.set(self, "node_identities", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[str]]:
        """
        The partition the ACL role is associated with.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partition", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of policies that should be applied to the role. Both the policy ID or its name can be used.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="serviceIdentities")
    def service_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclRoleServiceIdentityArgs']]]]:
        """
        The list of service identities that should be applied to the role.
        """
        return pulumi.get(self, "service_identities")

    @service_identities.setter
    def service_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclRoleServiceIdentityArgs']]]]):
        pulumi.set(self, "service_identities", value)

    @property
    @pulumi.getter(name="templatedPolicies")
    def templated_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclRoleTemplatedPolicyArgs']]]]:
        """
        The list of templated policies that should be applied to the token.
        """
        return pulumi.get(self, "templated_policies")

    @templated_policies.setter
    def templated_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclRoleTemplatedPolicyArgs']]]]):
        pulumi.set(self, "templated_policies", value)


@pulumi.input_type
class _AclRoleState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 node_identities: Optional[pulumi.Input[Sequence[pulumi.Input['AclRoleNodeIdentityArgs']]]] = None,
                 partition: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_identities: Optional[pulumi.Input[Sequence[pulumi.Input['AclRoleServiceIdentityArgs']]]] = None,
                 templated_policies: Optional[pulumi.Input[Sequence[pulumi.Input['AclRoleTemplatedPolicyArgs']]]] = None):
        """
        Input properties used for looking up and filtering AclRole resources.
        :param pulumi.Input[str] description: A free form human readable description of the role.
        :param pulumi.Input[str] name: The name of the ACL role.
        :param pulumi.Input[str] namespace: The namespace to create the role within.
        :param pulumi.Input[Sequence[pulumi.Input['AclRoleNodeIdentityArgs']]] node_identities: The list of node identities that should be applied to the role.
        :param pulumi.Input[str] partition: The partition the ACL role is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: The list of policies that should be applied to the role. Both the policy ID or its name can be used.
        :param pulumi.Input[Sequence[pulumi.Input['AclRoleServiceIdentityArgs']]] service_identities: The list of service identities that should be applied to the role.
        :param pulumi.Input[Sequence[pulumi.Input['AclRoleTemplatedPolicyArgs']]] templated_policies: The list of templated policies that should be applied to the token.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if node_identities is not None:
            pulumi.set(__self__, "node_identities", node_identities)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if service_identities is not None:
            pulumi.set(__self__, "service_identities", service_identities)
        if templated_policies is not None:
            pulumi.set(__self__, "templated_policies", templated_policies)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A free form human readable description of the role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ACL role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to create the role within.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="nodeIdentities")
    def node_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclRoleNodeIdentityArgs']]]]:
        """
        The list of node identities that should be applied to the role.
        """
        return pulumi.get(self, "node_identities")

    @node_identities.setter
    def node_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclRoleNodeIdentityArgs']]]]):
        pulumi.set(self, "node_identities", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[str]]:
        """
        The partition the ACL role is associated with.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partition", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of policies that should be applied to the role. Both the policy ID or its name can be used.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="serviceIdentities")
    def service_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclRoleServiceIdentityArgs']]]]:
        """
        The list of service identities that should be applied to the role.
        """
        return pulumi.get(self, "service_identities")

    @service_identities.setter
    def service_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclRoleServiceIdentityArgs']]]]):
        pulumi.set(self, "service_identities", value)

    @property
    @pulumi.getter(name="templatedPolicies")
    def templated_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclRoleTemplatedPolicyArgs']]]]:
        """
        The list of templated policies that should be applied to the token.
        """
        return pulumi.get(self, "templated_policies")

    @templated_policies.setter
    def templated_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclRoleTemplatedPolicyArgs']]]]):
        pulumi.set(self, "templated_policies", value)


class AclRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 node_identities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclRoleNodeIdentityArgs']]]]] = None,
                 partition: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_identities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclRoleServiceIdentityArgs']]]]] = None,
                 templated_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclRoleTemplatedPolicyArgs']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul

        read_policy = consul.AclPolicy("read-policy",
            name="read-policy",
            rules="node \\"\\" { policy = \\"read\\" }",
            datacenters=["dc1"])
        read = consul.AclRole("read",
            name="foo",
            description="bar",
            policies=[read_policy.id],
            service_identities=[consul.AclRoleServiceIdentityArgs(
                service_name="foo",
            )])
        ```

        ## Import

        ```sh
        $ pulumi import consul:index/aclRole:AclRole read 816a195f-6cb1-2e8d-92af-3011ae706318
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A free form human readable description of the role.
        :param pulumi.Input[str] name: The name of the ACL role.
        :param pulumi.Input[str] namespace: The namespace to create the role within.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclRoleNodeIdentityArgs']]]] node_identities: The list of node identities that should be applied to the role.
        :param pulumi.Input[str] partition: The partition the ACL role is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: The list of policies that should be applied to the role. Both the policy ID or its name can be used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclRoleServiceIdentityArgs']]]] service_identities: The list of service identities that should be applied to the role.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclRoleTemplatedPolicyArgs']]]] templated_policies: The list of templated policies that should be applied to the token.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AclRoleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul

        read_policy = consul.AclPolicy("read-policy",
            name="read-policy",
            rules="node \\"\\" { policy = \\"read\\" }",
            datacenters=["dc1"])
        read = consul.AclRole("read",
            name="foo",
            description="bar",
            policies=[read_policy.id],
            service_identities=[consul.AclRoleServiceIdentityArgs(
                service_name="foo",
            )])
        ```

        ## Import

        ```sh
        $ pulumi import consul:index/aclRole:AclRole read 816a195f-6cb1-2e8d-92af-3011ae706318
        ```

        :param str resource_name: The name of the resource.
        :param AclRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 node_identities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclRoleNodeIdentityArgs']]]]] = None,
                 partition: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_identities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclRoleServiceIdentityArgs']]]]] = None,
                 templated_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclRoleTemplatedPolicyArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclRoleArgs.__new__(AclRoleArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["node_identities"] = node_identities
            __props__.__dict__["partition"] = partition
            __props__.__dict__["policies"] = policies
            __props__.__dict__["service_identities"] = service_identities
            __props__.__dict__["templated_policies"] = templated_policies
        super(AclRole, __self__).__init__(
            'consul:index/aclRole:AclRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            node_identities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclRoleNodeIdentityArgs']]]]] = None,
            partition: Optional[pulumi.Input[str]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            service_identities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclRoleServiceIdentityArgs']]]]] = None,
            templated_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclRoleTemplatedPolicyArgs']]]]] = None) -> 'AclRole':
        """
        Get an existing AclRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A free form human readable description of the role.
        :param pulumi.Input[str] name: The name of the ACL role.
        :param pulumi.Input[str] namespace: The namespace to create the role within.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclRoleNodeIdentityArgs']]]] node_identities: The list of node identities that should be applied to the role.
        :param pulumi.Input[str] partition: The partition the ACL role is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: The list of policies that should be applied to the role. Both the policy ID or its name can be used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclRoleServiceIdentityArgs']]]] service_identities: The list of service identities that should be applied to the role.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclRoleTemplatedPolicyArgs']]]] templated_policies: The list of templated policies that should be applied to the token.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclRoleState.__new__(_AclRoleState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["node_identities"] = node_identities
        __props__.__dict__["partition"] = partition
        __props__.__dict__["policies"] = policies
        __props__.__dict__["service_identities"] = service_identities
        __props__.__dict__["templated_policies"] = templated_policies
        return AclRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A free form human readable description of the role.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the ACL role.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to create the role within.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="nodeIdentities")
    def node_identities(self) -> pulumi.Output[Optional[Sequence['outputs.AclRoleNodeIdentity']]]:
        """
        The list of node identities that should be applied to the role.
        """
        return pulumi.get(self, "node_identities")

    @property
    @pulumi.getter
    def partition(self) -> pulumi.Output[Optional[str]]:
        """
        The partition the ACL role is associated with.
        """
        return pulumi.get(self, "partition")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of policies that should be applied to the role. Both the policy ID or its name can be used.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="serviceIdentities")
    def service_identities(self) -> pulumi.Output[Optional[Sequence['outputs.AclRoleServiceIdentity']]]:
        """
        The list of service identities that should be applied to the role.
        """
        return pulumi.get(self, "service_identities")

    @property
    @pulumi.getter(name="templatedPolicies")
    def templated_policies(self) -> pulumi.Output[Optional[Sequence['outputs.AclRoleTemplatedPolicy']]]:
        """
        The list of templated policies that should be applied to the token.
        """
        return pulumi.get(self, "templated_policies")

