# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AclTokenArgs', 'AclToken']

@pulumi.input_type
class AclTokenArgs:
    def __init__(__self__, *,
                 accessor_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 local: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 node_identities: Optional[pulumi.Input[Sequence[pulumi.Input['AclTokenNodeIdentityArgs']]]] = None,
                 partition: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_identities: Optional[pulumi.Input[Sequence[pulumi.Input['AclTokenServiceIdentityArgs']]]] = None,
                 templated_policies: Optional[pulumi.Input[Sequence[pulumi.Input['AclTokenTemplatedPolicyArgs']]]] = None):
        """
        The set of arguments for constructing a AclToken resource.
        :param pulumi.Input[str] accessor_id: The uuid of the token. If omitted, Consul will generate a random uuid.
        :param pulumi.Input[str] description: The description of the token.
        :param pulumi.Input[str] expiration_time: If set this represents the point after which a token should be considered revoked and is eligible for destruction.
        :param pulumi.Input[bool] local: The flag to set the token local to the current datacenter.
        :param pulumi.Input[str] namespace: The namespace to create the token within.
        :param pulumi.Input[Sequence[pulumi.Input['AclTokenNodeIdentityArgs']]] node_identities: The list of node identities that should be applied to the token.
        :param pulumi.Input[str] partition: The partition the ACL token is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: The list of policies attached to the token.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The list of roles attached to the token.
        :param pulumi.Input[Sequence[pulumi.Input['AclTokenServiceIdentityArgs']]] service_identities: The list of service identities that should be applied to the token.
        :param pulumi.Input[Sequence[pulumi.Input['AclTokenTemplatedPolicyArgs']]] templated_policies: The list of templated policies that should be applied to the token.
        """
        if accessor_id is not None:
            pulumi.set(__self__, "accessor_id", accessor_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if node_identities is not None:
            pulumi.set(__self__, "node_identities", node_identities)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if service_identities is not None:
            pulumi.set(__self__, "service_identities", service_identities)
        if templated_policies is not None:
            pulumi.set(__self__, "templated_policies", templated_policies)

    @property
    @pulumi.getter(name="accessorId")
    def accessor_id(self) -> Optional[pulumi.Input[str]]:
        """
        The uuid of the token. If omitted, Consul will generate a random uuid.
        """
        return pulumi.get(self, "accessor_id")

    @accessor_id.setter
    def accessor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessor_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the token.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        If set this represents the point after which a token should be considered revoked and is eligible for destruction.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to set the token local to the current datacenter.
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "local", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to create the token within.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="nodeIdentities")
    def node_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclTokenNodeIdentityArgs']]]]:
        """
        The list of node identities that should be applied to the token.
        """
        return pulumi.get(self, "node_identities")

    @node_identities.setter
    def node_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclTokenNodeIdentityArgs']]]]):
        pulumi.set(self, "node_identities", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[str]]:
        """
        The partition the ACL token is associated with.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partition", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of policies attached to the token.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of roles attached to the token.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter(name="serviceIdentities")
    def service_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclTokenServiceIdentityArgs']]]]:
        """
        The list of service identities that should be applied to the token.
        """
        return pulumi.get(self, "service_identities")

    @service_identities.setter
    def service_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclTokenServiceIdentityArgs']]]]):
        pulumi.set(self, "service_identities", value)

    @property
    @pulumi.getter(name="templatedPolicies")
    def templated_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclTokenTemplatedPolicyArgs']]]]:
        """
        The list of templated policies that should be applied to the token.
        """
        return pulumi.get(self, "templated_policies")

    @templated_policies.setter
    def templated_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclTokenTemplatedPolicyArgs']]]]):
        pulumi.set(self, "templated_policies", value)


@pulumi.input_type
class _AclTokenState:
    def __init__(__self__, *,
                 accessor_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 local: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 node_identities: Optional[pulumi.Input[Sequence[pulumi.Input['AclTokenNodeIdentityArgs']]]] = None,
                 partition: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_identities: Optional[pulumi.Input[Sequence[pulumi.Input['AclTokenServiceIdentityArgs']]]] = None,
                 templated_policies: Optional[pulumi.Input[Sequence[pulumi.Input['AclTokenTemplatedPolicyArgs']]]] = None):
        """
        Input properties used for looking up and filtering AclToken resources.
        :param pulumi.Input[str] accessor_id: The uuid of the token. If omitted, Consul will generate a random uuid.
        :param pulumi.Input[str] description: The description of the token.
        :param pulumi.Input[str] expiration_time: If set this represents the point after which a token should be considered revoked and is eligible for destruction.
        :param pulumi.Input[bool] local: The flag to set the token local to the current datacenter.
        :param pulumi.Input[str] namespace: The namespace to create the token within.
        :param pulumi.Input[Sequence[pulumi.Input['AclTokenNodeIdentityArgs']]] node_identities: The list of node identities that should be applied to the token.
        :param pulumi.Input[str] partition: The partition the ACL token is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: The list of policies attached to the token.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The list of roles attached to the token.
        :param pulumi.Input[Sequence[pulumi.Input['AclTokenServiceIdentityArgs']]] service_identities: The list of service identities that should be applied to the token.
        :param pulumi.Input[Sequence[pulumi.Input['AclTokenTemplatedPolicyArgs']]] templated_policies: The list of templated policies that should be applied to the token.
        """
        if accessor_id is not None:
            pulumi.set(__self__, "accessor_id", accessor_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if node_identities is not None:
            pulumi.set(__self__, "node_identities", node_identities)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if service_identities is not None:
            pulumi.set(__self__, "service_identities", service_identities)
        if templated_policies is not None:
            pulumi.set(__self__, "templated_policies", templated_policies)

    @property
    @pulumi.getter(name="accessorId")
    def accessor_id(self) -> Optional[pulumi.Input[str]]:
        """
        The uuid of the token. If omitted, Consul will generate a random uuid.
        """
        return pulumi.get(self, "accessor_id")

    @accessor_id.setter
    def accessor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessor_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the token.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        If set this represents the point after which a token should be considered revoked and is eligible for destruction.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag to set the token local to the current datacenter.
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "local", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to create the token within.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="nodeIdentities")
    def node_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclTokenNodeIdentityArgs']]]]:
        """
        The list of node identities that should be applied to the token.
        """
        return pulumi.get(self, "node_identities")

    @node_identities.setter
    def node_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclTokenNodeIdentityArgs']]]]):
        pulumi.set(self, "node_identities", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[str]]:
        """
        The partition the ACL token is associated with.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partition", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of policies attached to the token.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of roles attached to the token.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter(name="serviceIdentities")
    def service_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclTokenServiceIdentityArgs']]]]:
        """
        The list of service identities that should be applied to the token.
        """
        return pulumi.get(self, "service_identities")

    @service_identities.setter
    def service_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclTokenServiceIdentityArgs']]]]):
        pulumi.set(self, "service_identities", value)

    @property
    @pulumi.getter(name="templatedPolicies")
    def templated_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclTokenTemplatedPolicyArgs']]]]:
        """
        The list of templated policies that should be applied to the token.
        """
        return pulumi.get(self, "templated_policies")

    @templated_policies.setter
    def templated_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclTokenTemplatedPolicyArgs']]]]):
        pulumi.set(self, "templated_policies", value)


class AclToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessor_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 local: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 node_identities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclTokenNodeIdentityArgs']]]]] = None,
                 partition: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_identities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclTokenServiceIdentityArgs']]]]] = None,
                 templated_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclTokenTemplatedPolicyArgs']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul
        import pulumi_random as random

        # Basic usage
        agent = consul.AclPolicy("agent",
            name="agent",
            rules=\"\"\"node_prefix "" {
          policy = "read"
        }
        \"\"\")
        test = consul.AclToken("test",
            description="my test token",
            policies=[agent.name],
            local=True)
        # Explicitly set the `accessor_id`
        test_random_uuid = random.RandomUuid("test")
        test_predefined_id = consul.AclToken("test_predefined_id",
            accessor_id=test_uuid["result"],
            description="my test uuid token",
            policies=[agent.name],
            local=True)
        ```

        ## Import

        ```sh
        $ pulumi import consul:index/aclToken:AclToken anonymous 00000000-0000-0000-0000-000000000002
        ```

        ```sh
        $ pulumi import consul:index/aclToken:AclToken master-token 624d94ca-bc5c-f960-4e83-0a609cf588be
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accessor_id: The uuid of the token. If omitted, Consul will generate a random uuid.
        :param pulumi.Input[str] description: The description of the token.
        :param pulumi.Input[str] expiration_time: If set this represents the point after which a token should be considered revoked and is eligible for destruction.
        :param pulumi.Input[bool] local: The flag to set the token local to the current datacenter.
        :param pulumi.Input[str] namespace: The namespace to create the token within.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclTokenNodeIdentityArgs']]]] node_identities: The list of node identities that should be applied to the token.
        :param pulumi.Input[str] partition: The partition the ACL token is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: The list of policies attached to the token.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The list of roles attached to the token.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclTokenServiceIdentityArgs']]]] service_identities: The list of service identities that should be applied to the token.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclTokenTemplatedPolicyArgs']]]] templated_policies: The list of templated policies that should be applied to the token.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AclTokenArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul
        import pulumi_random as random

        # Basic usage
        agent = consul.AclPolicy("agent",
            name="agent",
            rules=\"\"\"node_prefix "" {
          policy = "read"
        }
        \"\"\")
        test = consul.AclToken("test",
            description="my test token",
            policies=[agent.name],
            local=True)
        # Explicitly set the `accessor_id`
        test_random_uuid = random.RandomUuid("test")
        test_predefined_id = consul.AclToken("test_predefined_id",
            accessor_id=test_uuid["result"],
            description="my test uuid token",
            policies=[agent.name],
            local=True)
        ```

        ## Import

        ```sh
        $ pulumi import consul:index/aclToken:AclToken anonymous 00000000-0000-0000-0000-000000000002
        ```

        ```sh
        $ pulumi import consul:index/aclToken:AclToken master-token 624d94ca-bc5c-f960-4e83-0a609cf588be
        ```

        :param str resource_name: The name of the resource.
        :param AclTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessor_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 local: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 node_identities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclTokenNodeIdentityArgs']]]]] = None,
                 partition: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_identities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclTokenServiceIdentityArgs']]]]] = None,
                 templated_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclTokenTemplatedPolicyArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclTokenArgs.__new__(AclTokenArgs)

            __props__.__dict__["accessor_id"] = accessor_id
            __props__.__dict__["description"] = description
            __props__.__dict__["expiration_time"] = expiration_time
            __props__.__dict__["local"] = local
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["node_identities"] = node_identities
            __props__.__dict__["partition"] = partition
            __props__.__dict__["policies"] = policies
            __props__.__dict__["roles"] = roles
            __props__.__dict__["service_identities"] = service_identities
            __props__.__dict__["templated_policies"] = templated_policies
        super(AclToken, __self__).__init__(
            'consul:index/aclToken:AclToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessor_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            expiration_time: Optional[pulumi.Input[str]] = None,
            local: Optional[pulumi.Input[bool]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            node_identities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclTokenNodeIdentityArgs']]]]] = None,
            partition: Optional[pulumi.Input[str]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            service_identities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclTokenServiceIdentityArgs']]]]] = None,
            templated_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclTokenTemplatedPolicyArgs']]]]] = None) -> 'AclToken':
        """
        Get an existing AclToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accessor_id: The uuid of the token. If omitted, Consul will generate a random uuid.
        :param pulumi.Input[str] description: The description of the token.
        :param pulumi.Input[str] expiration_time: If set this represents the point after which a token should be considered revoked and is eligible for destruction.
        :param pulumi.Input[bool] local: The flag to set the token local to the current datacenter.
        :param pulumi.Input[str] namespace: The namespace to create the token within.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclTokenNodeIdentityArgs']]]] node_identities: The list of node identities that should be applied to the token.
        :param pulumi.Input[str] partition: The partition the ACL token is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: The list of policies attached to the token.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The list of roles attached to the token.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclTokenServiceIdentityArgs']]]] service_identities: The list of service identities that should be applied to the token.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AclTokenTemplatedPolicyArgs']]]] templated_policies: The list of templated policies that should be applied to the token.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclTokenState.__new__(_AclTokenState)

        __props__.__dict__["accessor_id"] = accessor_id
        __props__.__dict__["description"] = description
        __props__.__dict__["expiration_time"] = expiration_time
        __props__.__dict__["local"] = local
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["node_identities"] = node_identities
        __props__.__dict__["partition"] = partition
        __props__.__dict__["policies"] = policies
        __props__.__dict__["roles"] = roles
        __props__.__dict__["service_identities"] = service_identities
        __props__.__dict__["templated_policies"] = templated_policies
        return AclToken(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessorId")
    def accessor_id(self) -> pulumi.Output[str]:
        """
        The uuid of the token. If omitted, Consul will generate a random uuid.
        """
        return pulumi.get(self, "accessor_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the token.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> pulumi.Output[Optional[str]]:
        """
        If set this represents the point after which a token should be considered revoked and is eligible for destruction.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def local(self) -> pulumi.Output[Optional[bool]]:
        """
        The flag to set the token local to the current datacenter.
        """
        return pulumi.get(self, "local")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to create the token within.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="nodeIdentities")
    def node_identities(self) -> pulumi.Output[Optional[Sequence['outputs.AclTokenNodeIdentity']]]:
        """
        The list of node identities that should be applied to the token.
        """
        return pulumi.get(self, "node_identities")

    @property
    @pulumi.getter
    def partition(self) -> pulumi.Output[Optional[str]]:
        """
        The partition the ACL token is associated with.
        """
        return pulumi.get(self, "partition")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of policies attached to the token.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of roles attached to the token.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter(name="serviceIdentities")
    def service_identities(self) -> pulumi.Output[Optional[Sequence['outputs.AclTokenServiceIdentity']]]:
        """
        The list of service identities that should be applied to the token.
        """
        return pulumi.get(self, "service_identities")

    @property
    @pulumi.getter(name="templatedPolicies")
    def templated_policies(self) -> pulumi.Output[Optional[Sequence['outputs.AclTokenTemplatedPolicy']]]:
        """
        The list of templated policies that should be applied to the token.
        """
        return pulumi.get(self, "templated_policies")

