# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AclTokenPolicyAttachmentArgs', 'AclTokenPolicyAttachment']

@pulumi.input_type
class AclTokenPolicyAttachmentArgs:
    def __init__(__self__, *,
                 policy: pulumi.Input[str],
                 token_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a AclTokenPolicyAttachment resource.
        :param pulumi.Input[str] policy: The name of the policy attached to the token.
        :param pulumi.Input[str] token_id: The id of the token.
        """
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "token_id", token_id)

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Input[str]:
        """
        The name of the policy attached to the token.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> pulumi.Input[str]:
        """
        The id of the token.
        """
        return pulumi.get(self, "token_id")

    @token_id.setter
    def token_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "token_id", value)


@pulumi.input_type
class _AclTokenPolicyAttachmentState:
    def __init__(__self__, *,
                 policy: Optional[pulumi.Input[str]] = None,
                 token_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AclTokenPolicyAttachment resources.
        :param pulumi.Input[str] policy: The name of the policy attached to the token.
        :param pulumi.Input[str] token_id: The id of the token.
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if token_id is not None:
            pulumi.set(__self__, "token_id", token_id)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy attached to the token.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the token.
        """
        return pulumi.get(self, "token_id")

    @token_id.setter
    def token_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_id", value)


class AclTokenPolicyAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 token_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        `consul_acl_token_policy_attachment` can be imported. This is especially useful to manage the

        policies attached to the anonymous and the master tokens with Terraform:

        ```sh
        $ pulumi import consul:index/aclTokenPolicyAttachment:AclTokenPolicyAttachment anonymous 00000000-0000-0000-0000-000000000002:policy_name
        ```

        ```sh
        $ pulumi import consul:index/aclTokenPolicyAttachment:AclTokenPolicyAttachment master-token 624d94ca-bc5c-f960-4e83-0a609cf588be:policy_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] policy: The name of the policy attached to the token.
        :param pulumi.Input[str] token_id: The id of the token.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AclTokenPolicyAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        `consul_acl_token_policy_attachment` can be imported. This is especially useful to manage the

        policies attached to the anonymous and the master tokens with Terraform:

        ```sh
        $ pulumi import consul:index/aclTokenPolicyAttachment:AclTokenPolicyAttachment anonymous 00000000-0000-0000-0000-000000000002:policy_name
        ```

        ```sh
        $ pulumi import consul:index/aclTokenPolicyAttachment:AclTokenPolicyAttachment master-token 624d94ca-bc5c-f960-4e83-0a609cf588be:policy_name
        ```

        :param str resource_name: The name of the resource.
        :param AclTokenPolicyAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclTokenPolicyAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 token_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclTokenPolicyAttachmentArgs.__new__(AclTokenPolicyAttachmentArgs)

            if policy is None and not opts.urn:
                raise TypeError("Missing required property 'policy'")
            __props__.__dict__["policy"] = policy
            if token_id is None and not opts.urn:
                raise TypeError("Missing required property 'token_id'")
            __props__.__dict__["token_id"] = token_id
        super(AclTokenPolicyAttachment, __self__).__init__(
            'consul:index/aclTokenPolicyAttachment:AclTokenPolicyAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            policy: Optional[pulumi.Input[str]] = None,
            token_id: Optional[pulumi.Input[str]] = None) -> 'AclTokenPolicyAttachment':
        """
        Get an existing AclTokenPolicyAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] policy: The name of the policy attached to the token.
        :param pulumi.Input[str] token_id: The id of the token.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclTokenPolicyAttachmentState.__new__(_AclTokenPolicyAttachmentState)

        __props__.__dict__["policy"] = policy
        __props__.__dict__["token_id"] = token_id
        return AclTokenPolicyAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Output[str]:
        """
        The name of the policy attached to the token.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> pulumi.Output[str]:
        """
        The id of the token.
        """
        return pulumi.get(self, "token_id")

